//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _NETWORK_H_
#define _NETWORK_H_

#include "Itana.h"
#include "PacketConsts.h"
class Packet;
class NetPeer;

const int         DEFAULT_PORT     = 58152;
const char* const DEFAULT_PORT_STR = "58152";

class NetworkDrivers;

//Base class for Server and Client
class Network {
public:
  //functionaly insignifcant, so it can be public for everyone to see stats
  int dataIn;
  int dataOut;

  Network(); //DOES NOT PROPERLY INTIALIZE CLASS
  virtual ~Network();

  bool init(); //Returns true if network could not be initalized
  void loadConfig(); //loads vars from config file
  void saveConfig(); //saves vars to config file
  void setRates(int inRate2, int outRate2);
  void setDriver(int driver);

  virtual PlayerId whoIsThis(void* other) = 0;
    //Trys to find what player id this object is bound to
  virtual const char* getName(PlayerId id) = 0;
    //Returns the player name associated with this PlayerId
  virtual const char* getOurName() const = 0;
    //Returns this player's name, or "Server" in case of the server
  virtual const NetPeer** getPeers() = 0;
    //For Console -- returns an NEWLY ALLOCATED array of NetPeer*
    //pointing to objects to display which won't be deleted.
    //The last pointer is NULL to signify the end of the array.

  virtual void sendPacket(Packet* packet, bool reliable) = 0;
    //Sends a packet.
    //Network handles memory allocation of packet, and will delete it.

  const char* getLastError() const { return lastError; }
    //returns the latest error generated by a Network operation
  NetworkDrivers* getDrivers();
    //gets all acceptable drivers, do not delete or modify pointer

  virtual bool isConnected();
    //Are we connected to the network (always true for server)

  virtual bool update() = 0;
    //returns true only on an unrecoverable error which would require
    //termination of the network connection

protected:
  NetworkDrivers* drivers;

  int netDriver;//current network driver

  int inRate; //max bandwith usages
  int outRate;

  char* lastError;  //the last error generated
};

#endif