//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _INTRECT_H_
#define _INTRECT_H_

#include "Itana.h"
#include "Rect.h"
#include "IntPoint.h"

//Rectange class.  To be consistant with Allegro bitmap functions the corners
// are x, y, x+w-1, and y+h-1.  So a single pixel has w == h == 1.
//This one uses integers only to be quicker with video drawing.
class IntRect {
public:
  int x, y, w, h;

  IntRect() {}
  IntRect(int x2, int y2, int w2, int h2) : x(x2), y(y2), w(w2), h(h2) {}
  IntRect(const Rect& rect) 
    : x((int)rect.x), y((int)rect.y), w((int)rect.w), h((int)rect.h) {}

  void init(int x2, int y2, int w2, int h2) {
    x = x2; y = y2; w = w2; h = h2;
  }

  int getRight() const {  //inclusive point
    return x+w-1;
  }

  int getBottom() const { //inclusive point
    return y+h-1;
  }

  IntPoint getCenter() const {
    return Point(x+w/2, y+h/2);
  }

  void combineWith(const IntRect& other) {
    //this rect will include the area of this rect plus the area of other
    //Get least x and y
    int newx = MIN(x, other.x);
    int newy = MIN(y, other.y);
    w = MAX(x+w, other.x+other.w) - newx;
    h = MAX(y+h, other.y+other.h) - newy;
    x = newx;
    y = newy;
  }

  bool isCollision(const IntPoint& other) const {
    return ((other.x < x+w) && (other.y < y+h) &&
      (other.x >= x) && (other.y >= y));
  }

  bool isCollision(const IntRect& other) const {
    return ((other.x < x+w) && (other.y < y+h) &&
      (other.x+other.w-1 >= x) && (other.y+other.h-1 >= y));
  }

protected:
private:
};

#endif