//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#include "HumanBullet.h"
#include "Video.h"
#include "itanadat.h"
#include "EntityConsts.h"

HumanBullet::HumanBullet(const Point& p, const Vector& rel, double theta)
: Bullet(p, rel, theta, ID_HUMANBULLET) {
}

HumanBullet::HumanBullet() : Bullet( ID_HUMANBULLET ) {
}

void HumanBullet::init(const Point& p, const Vector& rel, double theta) {
  Bullet::init(p, rel, theta, ID_HUMANBULLET);
}

void HumanBullet::draw() {
  Video::drawSprite(GRFX_DAT_HUMBULL_BMP, loc, scrLoc, radToFix(theta));
}
