//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _BULLET_H_
#define _BULLET_H_

#include "Itana.h"
#include "MovingEntity.h"

class Bullet : public MovingEntity {
public:
  Bullet(const Point& p, const Vector& rel, double theta, int type2);

  void init(const Point& p, const Vector& rel, double theta, int type2);

  int getDamage();

  void doCollision(Entity* other);

  //Networking functions
  Packet* makePacket(); //Makes a packet of an appropriate type
  void    usePacket(Packet* packet); //Uses a packet if it is of appropriate type

  void input() {}
  bool update();
  virtual void draw() = 0;
protected:
  Bullet(int type2);

  int type;
  int life;
};

#endif