//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#include "Itana.h"
#include "NetPlayer.h"
#include "Packet.h"
#include "Game.h"
#include "PacketConsts.h"
#include "AlsettiShip.h"
#include "HumanShip.h"
#include "ZylexShip.h"
#include "OrnonShip.h"
#include "Base.h"

NetPlayer::NetPlayer() {
  tempBuf = new char[512];
  tempBufLen = 0;
  UDP = NULL;
  TCP = NULL;
  gotData = false;
  lastPing = lastTime = lastPosUpdate = 0;
}

NetPlayer::~NetPlayer() {
  delete[] tempBuf;
}

NetPlayer* NetPlayer::makePartialClone() const {
  //makes a new NetPlayer, everything is copied but the queues
  NetPlayer* ret = new NetPlayer();
  ret->base = base;
  ret->data = data;
  ret->gotData = gotData;
  ret->lastPing = lastPing;
  ret->lastTime = lastTime;
  ret->lastPosUpdate = lastPosUpdate;
  ret->latency = latency;
  ret->ship = ship;
  ret->TCP = TCP;
  ret->UDP = UDP;
  return ret;
}

void NetPlayer::shutDown() {
  if (TCP)
    net_closeconn(TCP);
  if (UDP)
    net_closechannel(UDP);
}

int NetPlayer::getLatency() {
  return latency;
}

StatsPacket* NetPlayer::getStats() {
  //CREATES a new StatsPacket based on this player's stats
  StatsPacket* stats = new StatsPacket();
  stats->playerId = data.playerId;
  stats->frame = Game::getFrame();
  stats->latency = getLatency();
  return stats;
}

bool NetPlayer::initPlayerData(const PlayerPacket& packet) {
  data = packet;
  base = NULL;
  ship = NULL;
  //Create and send player's base and ship
  switch(data.shipType) {
  case ID_ALSETTI_SHIP:
    ship = new AlsettiShip();
    break;
  case ID_ORNON_SHIP:
    ship = new OrnonShip();
    break;
  case ID_HUMAN_SHIP:
    ship = new HumanShip();
    break;
  case ID_ZYLEX_SHIP:
    ship = new ZylexShip();
    break;
  };
  al_trace("Server: Creating base of type %i\n", data.shipType - MIN_ID_SHIP + MIN_ID_BASE);
  base = new Base(getrndd(5000.0, 1500.0), getrndd(2*PI, 0), data.shipType - MIN_ID_SHIP + MIN_ID_BASE);
  if (!ship || !base) {
    delete ship; //delete if there was any allocation
    delete base;
    return true; //There was an error
  }

  ship->bindBase(base);
  ship->bind(CTRL_SERVER);
  ship->respawn();
  base->bindShip(ship);
  Game::moveEntity(ship);
  Game::moveEntity(base);
  return false;
}

int NetPlayer::sendTCPPacket() {
  int dataOut = 0;
  if (tempBufLen) {
    if (net_send_rdm(TCP, tempBuf, tempBufLen) == 0) {
      dataOut = tempBufLen;
      tempBufLen = 0;
    }
  } else {
    if (!TCPqueue.isEmpty()) {
      while (!TCPqueue.isEmpty() && tempBufLen < PACKETMAX) {
        //try to send as many game packets as possible in thie network packet.
        Packet* nextPacket = TCPqueue.pop();
        tempBufLen = nextPacket->createPacket(tempBuf, tempBufLen);
        delete nextPacket;
      }
      tempBuf[tempBufLen++] = ENDOFPACKET;
      if (net_send_rdm(TCP, tempBuf, tempBufLen) == 0) {
        dataOut = tempBufLen;
        tempBufLen = 0;
      } //else tempBufLen != 0 and will be saved for later resend
    }
  }
  return dataOut;
}

int NetPlayer::sendUDPPacket() {
  int dataOut = 0;  
  if (!UDPqueue.isEmpty() && tempBufLen == 0) {
    //check tempBufLen as to not overflood the client when RDMs are waiting
    while (!UDPqueue.isEmpty() && tempBufLen < PACKETMAX) {
      //try to send as many game packets as possible in thie network packet.
      Packet* nextPacket = UDPqueue.pop();
      tempBufLen = nextPacket->createPacket(tempBuf, tempBufLen);
      delete nextPacket;
    }
    
    tempBuf[tempBufLen++] = ENDOFPACKET;
    net_send(UDP, tempBuf, tempBufLen);
    dataOut = tempBufLen;
    tempBufLen = 0;
  }
  return dataOut;
}

int NetPlayer::getNextPacket(char* buf, int bufSize) {
  int recv = 0;
  recv = net_receive_rdm(TCP, buf, bufSize);
  if (recv == 0) //if nothing on RDM, try UDP
    recv = net_receive(UDP, buf, bufSize, NULL);
  return recv;
}