//******************************************************************************
// texto.c
// Funciones de escritura de texto.
// Por Ignacio Prez Gil 11/09/2004.
//******************************************************************************

//******************************************************************************
// Includes.
//******************************************************************************
#include <allegro.h>
#include "texto.h"

//******************************************************************************
// Definiciones y variables globales.
//******************************************************************************
DATAFILE *f_abc;
#define ANCHO_LETRA 32
#define fm_letra(_N_) ((BITMAP *)f_abc[_N_-'a'].dat)
#define PRIMER_NUM 26
#define fm_numero(_N_) ((BITMAP *)f_abc[PRIMER_NUM+(_N_)].dat)
#define fm_numero_txt(_N_) ((BITMAP *)f_abc[PRIMER_NUM+(_N_-'0')].dat)
#define PRIMER_ESP 36
unsigned char idioma=2;

//******************************************************************************
// Funcin ini_texto()
//    Carga el dichero .dat con los dibujos de las letras.
//******************************************************************************
void ini_texto(void)
{
 f_abc=load_datafile("abc.dat");
}

//******************************************************************************
// Funcin fin_texto()
//    Descarga el dichero .dat con los dibujos de las letras.
//******************************************************************************
void fin_texto(void)
{
 unload_datafile(f_abc);
}

//******************************************************************************
// Funcin escribir_texto(...)
//    Escribe el texto dado en el mapa, en las coordenadas x e y, y con el
//    nivel de transparencia indicado.
//******************************************************************************
void escribir_texto(BITMAP *mapa, char *txt, int x, int y, unsigned char transp)
{
 BITMAP *letra=NULL;

 if(transp)
   set_trans_blender(0,0,0,256-transp);

 while(txt[0])
  {
   if(txt[0]==' ')
     x+=ANCHO_LETRA/2;
   else 
    {
     if(txt[0]=='E')
      {
       txt++;
       if(txt[0]<='9')
         letra=(BITMAP *)(f_abc[PRIMER_ESP+txt[0]-'0'].dat);
       else
         letra=(BITMAP *)(f_abc[PRIMER_ESP+txt[0]-'a'+10].dat);
      }
     else if(txt[0]>='0' && txt[0]<='9')
       letra=fm_numero_txt(txt[0]);
     else
       letra=fm_letra(txt[0]);

     (transp?draw_trans_sprite:draw_sprite)(mapa,letra,x,y);

     x+=ANCHO_LETRA;
    }
   txt++;
  }
}

//******************************************************************************
// Funcin escribir_numero(...)
//    Escribe el nmero dado en el mapa, en las coordenadas x e y, y con el
//    nmero de decimales y nivel de transparencia indicados.
//******************************************************************************
void escribir_numero(BITMAP *mapa, int n, int d, int x, int y, unsigned char transp)
{
 int exp=1;

 if(n<0) n=0;

 while(--d)
   exp*=10;
 
 if(transp)
   set_trans_blender(0,0,0,256-transp);

 while(exp)
  {
   if(transp)
     draw_trans_sprite(mapa,fm_numero(n/exp),x,y);
   else
     draw_sprite(mapa,fm_numero(n/exp),x,y);
   x+=ANCHO_LETRA;
   n=n%exp;
   exp/=10;
  }
}

