//******************************************************************************
// audio.c
// Funciones genricas de sonido.
// Por Ignacio Prez Gil 29/03/2004.
//******************************************************************************

//******************************************************************************
// Includes.
//******************************************************************************
#include <allegro.h>
#include <aldumb.h>
#include "audio.h"

//******************************************************************************
// Declaracin de estructuras de datos y variables globales.
//******************************************************************************
DATAFILE *f_msc = NULL;
DATAFILE *f_audio = NULL;
AL_DUH_PLAYER *dp = NULL;
unsigned char vol_son;
float vol_mus;
struct _voz // Estructura para almacenar los datos de los enemigos
   {char activa; // Indica si la voz est activa
    int v;       // Voz
   } voz[8]={{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}}; 

//******************************************************************************
// Funcin iniciar_audio()
//   Inicializa el sistema de audio y carga los ficheros de sonidos y msica.
//******************************************************************************
void ini_audio(void)
{
 atexit(&dumb_exit);
 dumb_register_dat_it(DUMB_DAT_IT);
 reserve_voices(8,0);

 install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);
 f_msc = load_datafile("msc.dat");
 f_audio = load_datafile("snd.dat");
}

//******************************************************************************
// Funcin finalizar_audio()
//   Descarga los ficheros de sonidos y msica.
//******************************************************************************
void fin_audio(void)
{
 unload_datafile(f_msc);
 unload_datafile(f_audio);
}

//******************************************************************************
// Funcin reproducir_musica(...)
//   Inicia la reproduccin del fichero de msica n o le hace un poll si ya hay
//   alguno en marcha.
//******************************************************************************
void reproducir_musica(char n)
{
 if(vol_mus)
  {
   if(!dp)
    {float vol=vol_mus;
     if(n==0)vol+=0.3;
     if(n==1)vol+=0.6;
     dp=al_start_duh((DUH *)f_msc[n].dat, 2, 0, vol, 4096, 44100);
    }
   al_poll_duh(dp);
  }
}

//******************************************************************************
// Funcin modificar_volmus(...)
//   Modifica el volmen de la msica.
//******************************************************************************
void modificar_volmus(unsigned char vol)
{
 vol_mus=vol;
 vol_mus/=100;
 if(!vol_mus)
  {
   al_stop_duh(dp);
   dp=NULL;
  }
 else
   al_duh_set_volume(dp, vol_mus);
}

//******************************************************************************
// Funcin parar_musica()
//   Detiene la msica que se est reproduciendo.
//******************************************************************************
void parar_musica(void)
{
 al_stop_duh(dp);
 dp=NULL;
}

//******************************************************************************
// Funcin reproducir_sonido(...)
//   Reproduce el sonido indicado, con la opcin de buclearlo.
//******************************************************************************
char reproducir_sonido(char sonido, char bucle)
{
 char f = -1; 
 
 if(!vol_son) return -1;

 do // Busco la primera voz que no se est usando
  {
   f++;
   if(voz[f].activa)
     if(voice_get_position(voz[f].v) == -1)
      {
       deallocate_voice(voz[f].v);
       voz[f].activa = 0;
      }
  }while(voz[f].activa && f<7);
 
 if(voz[f].activa) return -1; // Las 8 voces estn siendo usadas.

 // Ahora f apunta a la voz que vamos a usar para el sonido.
 voz[f].v = allocate_voice((SAMPLE *)f_audio[sonido].dat);
 if(voz[f].v == -1) return -1;
 voice_set_volume(voz[f].v, vol_son);
 // Si, ya se que esto es una chapuza, pero me voy a permitir ese lujo ;)
 if(sonido==30)voice_set_frequency(voz[f].v, 17000); // 11025
 if(bucle) voice_set_playmode(voz[f].v, bucle);
 voice_start(voz[f].v);
 voz[f].activa = 1;
  
 return f;  
}

//******************************************************************************
// Funcin reiniciar_sonido(...)
//   Vuelve a colocar un sonido al principio.
//******************************************************************************
void reiniciar_sonido(char vz)
{
 if(vz>=0)
 if(voz[vz].activa)
   voice_set_position(voz[vz].v, 0);
}

//******************************************************************************
// Funcin modificar_volson(...)
//   Modifica el volmen mximo de los sonidos.
//******************************************************************************
void modificar_volson(unsigned char vol, char vz)
{
 float fvol=vol*2.55;
 vol_son=(unsigned char)fvol;
 if(vz>=0) voice_set_volume(voz[vz].v, vol_son);
}

//******************************************************************************
// Funcin detener_sonido(...)
//   Detiene un sonido determinado.
//******************************************************************************
void detener_sonido(char vz)
{
 if(vz>=0)
 if(voz[vz].activa)
  {
   deallocate_voice(voz[vz].v);
   voz[vz].activa = 0;
  }
}

//******************************************************************************
// Funcin detener_sonidos()
//   Detiene todos los sonidos que se estn reproduciendo.
//******************************************************************************
void detener_sonidos(void)
{
 char f;
 for(f=0;f<7;f++)
   if(voz[f].activa)
    {
     deallocate_voice(voz[f].v);
     voz[f].activa = 0;
    }
}

