//******************************************************************************
// mapa.h
// Fichero de definicin del mapa del jusgo
// Por Ignacio Prez Gil 11/09/2004.
//******************************************************************************

//******************************************************************************
// Estructura de datos para el mapeado de las fases
//******************************************************************************
struct {
  unsigned short nl;       // Nmero de losetas
  unsigned short ne;       // Nmero de enemigos
  unsigned char cintas;    // Direcciones de las cintas
 }fase[40]={
 { 98, 6, 0x0f}, {112, 8, 0x0f}, {105, 6, 0x00}, {119, 6, 0x00}, {133, 7, 0x00},
 {144, 8, 0x00}, {154,12, 0x00}, {147, 9, 0x0f}, {175, 9, 0x00}, {133, 5, 0x00},
 {175, 5, 0x00}, {140,12, 0x00}, { 98, 6, 0x00}, {147, 6, 0x00}, {168,11, 0x00},
 {175, 9, 0x00}, {203,10, 0x00}, {140, 6, 0x0f}, {140,14, 0x00}, {140,10, 0x00},
 {144, 7, 0x00}, {175,13, 0x00}, {140, 8, 0x0c}, {151,10, 0x00}, {140,10, 0x00},
 {175, 8, 0x00}, {140,11, 0x3f}, {140, 8, 0x00}, {140, 8, 0x00}, {175,16, 0x00},
 {175,10, 0x00}, {175, 9, 0x0f}, {189, 9, 0x00}, {105,10, 0x00}, {189,15, 0x00},
 {168, 8, 0x00}, {175, 9, 0x00}, {154,10, 0x00}, {203,16, 0x0f}, {154,16, 0x00}};

unsigned char loseta[]={
// fase 01 (098)
 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2, 0x23, 0x22, 0x2f, 0x22, 0x22, 0x22, 0xf2,
 0x21, 0x22, 0x21, 0x22, 0x12, 0x22, 0x12, 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x41, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x22, 0x21, 0x11, 0x21, 0x31, 0x21, 0x21, 0x13, 0x11, 0x21, 0x12, 0x22, 0x11,
 0x55, 0x26, 0x25, 0x51, 0x12, 0x22, 0x11, 0x21, 0x13, 0x11, 0x22, 0x21, 0x31, 0x22,
// fase 02 (112)
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01,
 0x10, 0x11, 0x10, 0x11, 0x12, 0x27, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22, 0x12, 0x22,
 0x22, 0x11, 0x12, 0x22, 0x11, 0x01, 0x12, 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22,
 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x01, 0x15, 0x11, 0x00, 0x11, 0x51, 0x00,
 0x11, 0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0x11, 0x22, 0x14, 0x11, 0x12, 0x21, 0x11,
 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2, 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11, 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11,
 0x11, 0x1a, 0x13, 0x31, 0x11, 0x01, 0x33, 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11,
// fase 03 (105)
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x11, 0x11, 0x11, 0x12, 0x11, 0x72, 0x12, 0x22, 0x12,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x12, 0x22, 0x22, 0x1a, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x32, 0x22, 0x22, 0x33, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x12, 0x22, 0x22, 0x11, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x11, 0x12, 0x21, 0x10, 0x11, 0x11,
 0x11, 0x11, 0x21, 0x21, 0x11, 0x12, 0x11, 0x21, 0x01, 0x21, 0x22, 0x21, 0x11, 0x11,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
// fase 04 (119)
 0xb5, 0x55, 0x55, 0xc2, 0x22, 0x72, 0x22, 0x22, 0x21, 0x12, 0x22, 0x22, 0x11, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01,
 0x11, 0x1a, 0x13, 0x31, 0x11, 0x01, 0x33, 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11,
 0x11, 0x41, 0x11, 0x11, 0x01, 0x01, 0x01, 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01,
 0x11, 0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0x22, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22, 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
// fase 05 (133)
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x10, 0x10, 0xe1, 0x00, 0x01, 0x01,
 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01, 0x10, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11,
 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01, 0x10, 0x1d, 0x10, 0x11, 0x00, 0x00, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x12, 0x22, 0x22, 0x12, 0x22, 0x12, 0x22, 0x00, 0x05, 0x00, 0x00, 0x12, 0x12, 0x10,
 0x01, 0x21, 0x51, 0x00, 0x15, 0x12, 0x10, 0x01, 0x21, 0x21, 0x00, 0x00, 0x50, 0x00,
 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22, 0x11, 0x10, 0x10, 0xe1, 0x00, 0x01, 0x01,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11,
// fase 06 (144)
 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
 0x10, 0x11, 0x10, 0x11, 0x12, 0x27, 0x11, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x11, 0x55, 0x21, 0x11, 0x22, 0x22, 0x22, 0x52, 0x11, 0x25, 0x25, 0x21, 0x12, 0x52,
 0x12, 0x22, 0x21, 0x21, 0x15, 0x51, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x72, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x10, 0x00, 0x32,
 0x11, 0x11, 0x03, 0x31, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x12, 0xf2, 0x22, 0xf2,
 0x2f, 0x22, 0x2f, 0x22, 0x11, 0x11, 0x12, 0x11, 0x2c, 0x21, 0x11, 0x12, 0x12, 0x11,
 0x11, 0x21, 0x21, 0x11, 0x22, 0x22, 0x21, 0x22, 0x21, 0x22, 0x22, 0x21, 0x11, 0x22,
 0x22, 0x21, 0x22, 0x20,
// fase 07 (154)
 0xe1, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x11, 0x10, 0x10, 0xe1, 0x00, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x10, 0x1a, 0x11, 0x11, 0x01, 0x11, 0x21, 0x00, 0x03, 0x21, 0x11, 0x10, 0x33,
 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11, 0x11, 0x10, 0x1a, 0x11, 0x11, 0x01, 0x11,
 0x01, 0x00, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x00, 0x10,
 0x11, 0x10, 0x1a, 0x11, 0x11, 0x01, 0x11, 0x21, 0x00, 0x03, 0x21, 0x11, 0x10, 0x33,
 0x18, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11, 0x11, 0x10, 0x1a, 0x11, 0x11, 0x01, 0x11,
 0xe1, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x10, 0x10, 0xe1, 0x00, 0x01, 0x01, 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22,
// fase 08 (147)
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11, 0x21, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x01, 0x00, 0x11, 0x11, 0x11, 0x00, 0x00,
 0x22, 0x11, 0x12, 0x22, 0x11, 0x01, 0x12, 0x01, 0x21, 0x21, 0x00, 0x00, 0x50, 0x00,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11, 0x10, 0x1d, 0x10, 0x11, 0x00, 0x00, 0x01,
 0x11, 0x41, 0x11, 0x11, 0x01, 0x01, 0x01, 0x21, 0x11, 0x11, 0x21, 0x12, 0xc2, 0x11,
 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2, 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2,
 0x11, 0x10, 0x1a, 0x11, 0x11, 0x01, 0x11, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22, 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x33, 0x32, 0x33, 0x33, 0x33, 0x23, 0x33, 0x32, 0x22, 0x33, 0x33, 0xc3, 0x22, 0x23,
 0x12, 0x22, 0x37, 0x33, 0x33, 0x23, 0x33,
// fase 09 (175)
 0x11, 0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0xe1, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11,
 0x12, 0x22, 0x22, 0x12, 0x22, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12, 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11, 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x01, 0x00, 0x11, 0x11, 0x11, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x10, 0x1d, 0x10, 0x11, 0x00, 0x00, 0x01, 0xe1, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11,
 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12, 0x11, 0x22, 0x21, 0x11, 0x21, 0x31, 0x21,
 0x21, 0x13, 0x11, 0x22, 0x21, 0x31, 0x22, 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x23, 0x32, 0x22, 0x22, 0x33, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x12, 0x22, 0x22, 0x12, 0x22, 0x12, 0x22,
// fase 10 (133)
 0x22, 0x25, 0x22, 0x22, 0x25, 0x05, 0x22, 0x02, 0x50, 0x52, 0x00, 0x11, 0x11, 0x10,
 0x01, 0x10, 0x11, 0x00, 0x10, 0x00, 0x10, 0x21, 0x10, 0x11, 0x22, 0x21, 0x11, 0x22,
 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22, 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x25, 0x21, 0x12, 0x22, 0x21, 0x31, 0x12, 0x22, 0x11, 0x12, 0x12, 0x21, 0x11, 0x21,
 0x22, 0x13, 0x11, 0x22, 0x52, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0xb5, 0x55, 0x55, 0xc2, 0x22, 0x72, 0x22,
// fase 11 (175)
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x21, 0x13, 0x11, 0x21, 0x12, 0x22, 0x11,
 0x55, 0x26, 0x25, 0x51, 0x12, 0x22, 0x11, 0x21, 0x13, 0x11, 0x22, 0x21, 0x31, 0x22,
 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22, 0x00, 0x05, 0x00, 0x00, 0x12, 0x12, 0x10,
 0x01, 0x21, 0x21, 0x00, 0x00, 0x50, 0x00, 0x21, 0x11, 0x11, 0x21, 0x12, 0xc2, 0x11,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11, 0x10, 0x11, 0x10, 0x11, 0x12, 0x27, 0x11,
 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x22, 0x21, 0x11, 0x22, 0x22, 0x22,
 0x33, 0x32, 0x33, 0x33, 0x33, 0x23, 0x33, 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x12, 0x23, 0x13, 0x23, 0x13,
 0x22, 0x12, 0x23, 0x22, 0x23, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x12, 0x22, 0x21, 0x21, 0x15, 0x51, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x21, 0x00, 0x03, 0x21, 0x11, 0x10, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
// fase 12 (140)
 0x11, 0x11, 0x11, 0x11, 0x22, 0x22, 0x22, 0x11, 0x11, 0x11, 0x12, 0x22, 0x22, 0x21,
 0x11, 0x11, 0x11, 0x11, 0x22, 0x22, 0x22, 0x11, 0x11, 0x11, 0x12, 0x22, 0x22, 0x21,
 0x11, 0x11, 0x11, 0x11, 0x22, 0x22, 0x22, 0x11, 0x11, 0x11, 0x12, 0x22, 0x22, 0x21,
 0x10, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22, 0x12, 0x22,
 0x22, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22,
 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12,
 0x21, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12, 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11,
 0x33, 0x32, 0x33, 0x33, 0x33, 0x23, 0x33, 0x01, 0x21, 0x51, 0x00, 0x15, 0x12, 0x10,
// fase 13 (98)
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01,
 0x11, 0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11,
 0x01, 0x15, 0x11, 0x00, 0x11, 0x51, 0x00, 0x21, 0x00, 0x03, 0x21, 0x11, 0x10, 0x33,
 0x11, 0x1a, 0x13, 0x31, 0x11, 0x01, 0x33, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11,
 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x01, 0x00, 0x11, 0x11, 0x11, 0x00, 0x00,
 0x22, 0x11, 0x12, 0x22, 0x11, 0x01, 0x12, 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11,
// fase 14 (147)
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x11, 0x11, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22, 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11, 0x21, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12,
 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2, 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2,
 0x55, 0x26, 0x25, 0x51, 0x12, 0x22, 0x11, 0x22, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x23, 0x32, 0x33, 0x23, 0x33, 0x13, 0x33, 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22,
 0x33, 0x32, 0x33, 0x33, 0x33, 0x23, 0x33, 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
// fase 15 (168)
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x11, 0x11, 0x11, 0x11, 0x22, 0x22, 0x22,
 0x33, 0x32, 0x33, 0x33, 0x33, 0x23, 0x33, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x21, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12, 0x12, 0x22, 0x22, 0x12, 0x22, 0x12, 0x22,
 0x22, 0x11, 0x12, 0x22, 0x11, 0x01, 0x12, 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11, 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x11, 0x12, 0x22, 0x11, 0x01, 0x12, 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12,
 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
// fase 16 (175)
 0x11, 0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0xe1, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x11, 0x10, 0x1a, 0x11, 0x11, 0x01, 0x11,
 0x01, 0x00, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x00, 0x10,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x10, 0x10, 0xe1, 0x00, 0x01, 0x01,
 0x11, 0x12, 0x11, 0x72, 0x12, 0x22, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x12, 0x22, 0x22, 0x11, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12, 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11,
 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0xe1, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11,
 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x11, 0x10, 0x10, 0xe1, 0x00, 0x01, 0x01,
 0x11, 0x10, 0x1a, 0x11, 0x11, 0x01, 0x11,
// fase 17 (203)
 0x23, 0x32, 0x33, 0x23, 0x33, 0x13, 0x33, 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22, 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x12, 0x23, 0x22, 0x23, 0x12, 0x22,
 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11, 0x11, 0x55, 0x21, 0x11, 0x22, 0x22, 0x22,
 0x12, 0x22, 0x21, 0x21, 0x15, 0x51, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x22, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11, 0x11, 0x55, 0x21, 0x11, 0x22, 0x22, 0x22,
 0x11, 0x11, 0x11, 0x12, 0x22, 0x22, 0x21, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x11, 0x11, 0x11, 0x12, 0x22, 0x22, 0x21,
// fase 18 (140)
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2, 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2,
 0x55, 0x26, 0x25, 0x51, 0x12, 0x22, 0x11, 0x00, 0x05, 0x00, 0x00, 0x12, 0x12, 0x10,
 0x01, 0x21, 0x51, 0x00, 0x15, 0x12, 0x10, 0x01, 0x21, 0x21, 0x00, 0x00, 0x50, 0x00,
 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12,
 0x11, 0x10, 0x1a, 0x11, 0x11, 0x01, 0x11, 0x33, 0x32, 0x33, 0x33, 0x33, 0x23, 0x33,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x01, 0x00, 0x11, 0x11, 0x11, 0x00, 0x00, 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11,
 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12, 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11,
// fase 19 (140)
 0x33, 0x32, 0x33, 0x33, 0x33, 0x23, 0x33, 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12,
 0x21, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12, 0x21, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12,
 0x21, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x21, 0x11, 0x11, 0x22, 0x22, 0x12, 0x22, 0x22, 0x21, 0x22, 0x22, 0x11, 0x11, 0x12,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x11, 0x21, 0x22, 0x22, 0x22, 0x22,
 0x21, 0x11, 0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x21, 0x11, 0x12, 0x21, 0x10, 0x11, 0x11, 0x11, 0x11, 0x21, 0x21, 0x11, 0x12, 0x11,
 0x21, 0x01, 0x21, 0x22, 0x21, 0x11, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
// fase 20 (140)
 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x10, 0x10, 0xe1, 0x00, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01,
 0x10, 0x1d, 0x10, 0x11, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x55, 0x26, 0x25, 0x51, 0x12, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11,
 0x00, 0x00, 0x10, 0x11, 0x11, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01,
 0x08, 0x00, 0x11, 0x11, 0x11, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x10, 0x10, 0xe1, 0x00, 0x01, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
// fase 21 (144)
 0x3a, 0x30, 0x12, 0x11, 0x31, 0x01, 0x01, 0x3a, 0x30, 0x12, 0x11, 0x31, 0x01, 0x01,
 0x3a, 0x30, 0x12, 0x11, 0x31, 0x01, 0x01, 0x3a, 0x30, 0x12, 0x11, 0x31, 0x01, 0x01,
 0x3a, 0x30, 0x12, 0x11, 0x31, 0x01, 0x01, 0x3a, 0x30, 0x12, 0x11, 0x31, 0x01, 0x01,
 0x11, 0x10, 0x1a, 0x11, 0x11, 0x01, 0x11, 0x33, 0x32, 0x33, 0x33, 0x33, 0x23, 0x33,
 0x10, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x21, 0x12, 0x11, 0x22, 0x21, 0x11, 0x22, 0x22, 0x12, 0x12, 0x22, 0x21, 0x21, 0x22,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x11, 0x10, 0x11, 0x12, 0x27, 0x11,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x21, 0x22, 0x22, 0x21, 0x22, 0x21, 0x22, 0x23, 0x33, 0x23, 0x33,
 0x33, 0x32, 0x33, 0x30,
// fase 22 (175)
 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12, 0x21, 0x12, 0x11, 0x22, 0x21, 0x11, 0x22,
 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12, 0x21, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11, 0x21, 0x12, 0x11, 0x22, 0x21, 0x11, 0x22,
 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12, 0x21, 0x11, 0x11, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x21, 0x22, 0x22, 0x11, 0x11, 0x12, 0x22, 0x12, 0x12, 0x22, 0x21, 0x21, 0x22,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x12, 0x12, 0x22, 0x21, 0x21, 0x22,
 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12, 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11,
 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22,
 0x11, 0x11, 0x11, 0x11, 0x22, 0x22, 0x22, 0x11, 0x11, 0x11, 0x12, 0x22, 0x22, 0x21,
 0x11, 0x11, 0x11, 0x11, 0x22, 0x22, 0x22, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x21, 0x12, 0x11, 0x22, 0x21, 0x11, 0x22, 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22,
// fase 23 (140)
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11, 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x41, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x41, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x22, 0x14, 0x11, 0x12, 0x21, 0x11,
 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
// fase 24 (151)
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x11, 0x11, 0x12,
 0x22, 0x11, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x11, 0x11, 0x12,
 0x22, 0x11, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x11, 0x11, 0x12,
 0x22, 0x11, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x11, 0x11, 0x12,
 0x22, 0x11, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x2b, 0x55, 0x55, 0x5c, 0x22, 0x27, 0x22, 0x20,
// fase 25 (140)
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11,
 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11, 0x00, 0x00, 0x11, 0x11, 0x11, 0x00, 0x10,
 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11, 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11,
 0x01, 0x00, 0x11, 0x11, 0x11, 0x00, 0x00, 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11,
 0x11, 0x1a, 0x13, 0x31, 0x11, 0x01, 0x33, 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11,
 0x00, 0x00, 0x11, 0x11, 0x11, 0x00, 0x10, 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11,
 0x11, 0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11,
 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11, 0x01, 0x00, 0x11, 0x11, 0x11, 0x00, 0x00,
 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01,
// fase 26 (175)
 0x3a, 0x30, 0x12, 0x11, 0x31, 0x01, 0x01, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
 0x10, 0x11, 0x10, 0x11, 0x12, 0x27, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x12, 0x22, 0x22, 0x1a, 0x22,
 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12, 0x21, 0x27, 0x21, 0x22, 0x12, 0x22, 0x12,
 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x23, 0x32, 0x22, 0x22, 0x33, 0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x21, 0x12, 0x22, 0x22, 0x11, 0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x21, 0x12, 0x22, 0x22, 0x11, 0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x21, 0x12, 0x22, 0x22, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x11, 0x10, 0x11, 0x11, 0x00, 0x00, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x10, 0x11, 0x11, 0x00, 0x00, 0x01,
// fase 27 (140)
 0x21, 0x11, 0x11, 0x22, 0x12, 0x12, 0x12, 0x21, 0x11, 0x11, 0x22, 0x12, 0x12, 0x12,
 0x21, 0x11, 0x11, 0x22, 0x12, 0x12, 0x12, 0x21, 0x11, 0x11, 0x22, 0x12, 0x12, 0x12,
 0x21, 0x11, 0x11, 0x22, 0x12, 0x12, 0x12, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x21, 0x27, 0x21, 0x22, 0x12, 0x22, 0x12, 0x22, 0x12, 0x12, 0x22, 0x21, 0x21, 0x22,
 0x22, 0x12, 0x23, 0x22, 0x23, 0x12, 0x22, 0x22, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12,
 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11, 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x21, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12, 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2,
 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2, 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12,
 0x23, 0x22, 0x2f, 0x22, 0x22, 0x22, 0xf2, 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11,
 0x22, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
// fase 28 (140)
 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
 0x22, 0x21, 0x12, 0x22, 0x22, 0x11, 0x22, 0x22, 0x21, 0x12, 0x22, 0x22, 0x11, 0x22,
 0x22, 0x21, 0x12, 0x22, 0x22, 0x11, 0x22, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
// fase 29 (140)
 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12, 0x01, 0x10, 0x11, 0x00, 0x10, 0x00, 0x10,
 0x01, 0x10, 0x11, 0x00, 0x10, 0x00, 0x10, 0x01, 0x10, 0x11, 0x00, 0x10, 0x00, 0x10,
 0x21, 0x10, 0x11, 0x22, 0x21, 0x11, 0x22, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
 0x01, 0x10, 0x11, 0x00, 0x10, 0x00, 0x10, 0x01, 0x10, 0x11, 0x00, 0x10, 0x00, 0x10,
 0x21, 0x10, 0x11, 0x22, 0x21, 0x11, 0x22, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x1d, 0x10, 0x11, 0x00, 0x00, 0x01, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x55, 0x55, 0x55, 0x51, 0x11, 0x11, 0x11, 0x55, 0x55, 0x55, 0x51, 0x11, 0x11, 0x11,
 0x55, 0x55, 0x55, 0x51, 0x11, 0x11, 0x11, 0x55, 0x55, 0x55, 0x51, 0x11, 0x11, 0x11,
// fase 30 (175)
 0xe1, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11, 0x01, 0x10, 0x11, 0x00, 0x10, 0x00, 0x10,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x11, 0x10, 0x10, 0xe1, 0x00, 0x01, 0x01,
 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11, 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01,
 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x1d, 0x10, 0x11, 0x00, 0x00, 0x01,
 0xe1, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x00, 0x00, 0x11, 0x11, 0x11, 0x00, 0x10, 0x12, 0x22, 0x37, 0x33, 0x33, 0x23, 0x33,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x10, 0x10, 0xe1, 0x00, 0x01, 0x01,
 0x11, 0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
// fase 31 (175)
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x11, 0x72, 0x12, 0x22, 0x12,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x12, 0x22, 0x21, 0x21, 0x15, 0x51, 0x12,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x23, 0x32, 0x33, 0x23, 0x33, 0x13, 0x33, 0x10, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11,
 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x11, 0x11, 0x00, 0x00, 0x01,
 0x18, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11, 0x01, 0x10, 0x11, 0x00, 0x10, 0x00, 0x10,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01,
 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01, 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11,
 0x55, 0x55, 0x55, 0x51, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11,
 0x55, 0x26, 0x25, 0x51, 0x12, 0x22, 0x11,
// fase 32 (175)
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2,
 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2, 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2, 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
// fase 33 (189)
 0x11, 0x10, 0x11, 0x11, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01, 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01,
 0x11, 0x10, 0x1a, 0x11, 0x11, 0x01, 0x11, 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22, 0x21, 0x11, 0x11, 0x22, 0x12, 0x12, 0x12,
 0x21, 0x11, 0x11, 0x21, 0x12, 0xc2, 0x11, 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11,
 0x22, 0x21, 0x12, 0x22, 0x22, 0x11, 0x22, 0x22, 0x21, 0x12, 0x22, 0x22, 0x11, 0x22,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x22, 0x22, 0x21,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x21, 0x12, 0x11, 0x22, 0x21, 0x11, 0x22, 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x21, 0x27, 0x21, 0x22, 0x12, 0x22, 0x12, 0x22, 0x12, 0x12, 0x22, 0x21, 0x21, 0x22,
 0x22, 0x12, 0x12, 0x22, 0x21, 0x21, 0x22, 0x33, 0x32, 0x33, 0x33, 0x33, 0x23, 0x33,
 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22,
// fase 34 (105)
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
// fase 35 (189)
 0x11, 0x10, 0x11, 0x11, 0x00, 0x00, 0x01, 0x11, 0x10, 0x11, 0x11, 0x00, 0x00, 0x01,
 0x11, 0x10, 0x11, 0x11, 0x00, 0x00, 0x01, 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x21, 0x22, 0x21, 0x22, 0x11, 0x11, 0x12,
 0x22, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22,
 0x21, 0x27, 0x21, 0x22, 0x12, 0x22, 0x12, 0x21, 0x27, 0x21, 0x22, 0x12, 0x22, 0x12,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11,
 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11,
 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11,
 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x12, 0x11, 0x22, 0x21, 0x11, 0x22,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
// fase 36 (168)
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11, 0x11, 0x22, 0x21, 0x11, 0x21, 0x31, 0x21,
 0x00, 0x05, 0x00, 0x00, 0x12, 0x12, 0x10, 0x01, 0x21, 0x21, 0x00, 0x00, 0x50, 0x00,
 0x33, 0x32, 0x33, 0x33, 0x33, 0x23, 0x33, 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x23, 0x32, 0x33, 0x23, 0x33, 0x13, 0x33, 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22,
 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12, 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12,
 0x22, 0x11, 0x12, 0x22, 0x11, 0x01, 0x12, 0x22, 0x11, 0x12, 0x22, 0x11, 0x01, 0x12,
 0x22, 0x11, 0x12, 0x22, 0x22, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x21, 0x22, 0x22, 0x22, 0x12, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
// fase 37 (175)
 0x11, 0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0x01, 0x15, 0x11, 0x00, 0x11, 0x51, 0x00,
 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11,
 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11, 0x11, 0x1a, 0x13, 0x31, 0x11, 0x01, 0x33,
 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x01, 0x11, 0x11, 0x11,
 0x10, 0x10, 0x10, 0x11, 0x01, 0x01, 0x01, 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11,
 0x11, 0x10, 0x11, 0x11, 0x11, 0x01, 0x11, 0x00, 0x00, 0x11, 0x11, 0x11, 0x00, 0x10,
 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2, 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2,
 0xb5, 0x55, 0x55, 0xc2, 0x22, 0x72, 0x22, 0x21, 0x27, 0x21, 0x22, 0x12, 0x22, 0x12,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11,
 0x21, 0x12, 0x11, 0x22, 0x21, 0x11, 0x22, 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12,
 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11, 0x21, 0x11, 0x11, 0x22, 0x12, 0x12, 0x12,
 0x21, 0x11, 0x11, 0x22, 0x12, 0x12, 0x12, 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x11,
 0x21, 0x11, 0x11, 0x22, 0x12, 0x12, 0x12,
// fase 38 (154)
 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x11, 0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01,
 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01, 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01,
 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01, 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01,
 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01, 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01,
 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01, 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01,
 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01, 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01,
 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01,
// fase 39 (203)
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x11, 0x41, 0x11, 0x11, 0x01, 0x01, 0x01,
 0x10, 0x11, 0x10, 0x11, 0x01, 0x11, 0x01, 0x11, 0x00, 0x00, 0x81, 0x11, 0x11, 0x11,
 0x19, 0x00, 0x03, 0x31, 0x11, 0x01, 0x11, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
 0x55, 0x55, 0x55, 0x51, 0x11, 0x11, 0x11, 0x11, 0x1a, 0x13, 0x31, 0x11, 0x01, 0x33,
 0x33, 0x32, 0x33, 0x33, 0x33, 0x23, 0x33, 0x55, 0x26, 0x25, 0x51, 0x12, 0x22, 0x11,
 0x22, 0x27, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x12, 0x23, 0x22, 0x21, 0x12, 0x22,
 0x11, 0x55, 0x21, 0x11, 0x22, 0x22, 0x22, 0x52, 0x11, 0x25, 0x25, 0x21, 0x12, 0x52,
 0x12, 0x22, 0x22, 0x12, 0x22, 0x12, 0x22, 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12,
 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22, 0x22, 0x23, 0x22, 0x22, 0x22, 0x32, 0x22,
 0x21, 0x27, 0x21, 0x22, 0x12, 0x22, 0x12, 0x21, 0x22, 0x21, 0x21, 0x12, 0x22, 0x11,
 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2, 0x2f, 0x22, 0x2f, 0x22, 0xf2, 0x22, 0xf2,
 0x11, 0x11, 0x11, 0x11, 0x01, 0x01, 0x01, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x01,
 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
 0x22, 0x11, 0x12, 0x22, 0x11, 0x11, 0x12, 0x11, 0x11, 0x11, 0x12, 0x11, 0x11, 0x12,
 0x10, 0x1d, 0x10, 0x11, 0x00, 0x00, 0x01,
// fase 40 (154)
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xb5, 0x55, 0x55, 0xc2, 0x22, 0x72, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x12, 0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x11, 0x11, 0x12,
 0x21, 0x22, 0x22, 0x22, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x21, 0x11, 0x11, 0x22, 0x22, 0x12, 0x22, 0x22, 0x21, 0x22, 0x22, 0x11, 0x11, 0x12,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x11, 0x11, 0x22, 0x12, 0x12, 0x12,
 0x21, 0x27, 0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x11, 0x11, 0x12, 0x21, 0x21, 0x21, 0x22, 0x12, 0x72, 0x12,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x11, 0x11, 0x22, 0x21, 0x12, 0x22,
 0x22, 0x21, 0x12, 0x22, 0x11, 0x11, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
 0x21, 0x11, 0x11, 0x22, 0x12, 0x22, 0x12, 0x21, 0x12, 0x11, 0x22, 0x21, 0x11, 0x22,
 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x32, 0x33, 0x33, 0x33, 0x23, 0x33
};

//******************************************************************************
// Estructura de datos con los enemigos de cada fase
//******************************************************************************
struct{
  unsigned char fg;  
  unsigned char x;
  unsigned char yc;
  }enemigo[] = {
// fase 01
{ 22, 5,0x60},{102, 7,0x32},{ 22, 7,0x00},{ 27,15,0x32},{120,17,0x02},{ 20,23,0x52},
// fase 02
{ 13, 5,0x61},{ 13, 7,0x01},{103, 9,0x32},{ 10,20,0x42},
{  8,26,0x54},{  3,32,0x42},{ 10,18,0x14},{108,15,0x14},
// fase 03
{109, 7,0x02},{129, 7,0x22},{ 16, 7,0x54},{ 29,25,0x02},{  9,25,0x12},{112,25,0x24},
// fase 04
{ 24,14,0x01},{104,12,0x22},{104, 7,0x62},{ 18,19,0x44},{118,33,0x32},{  6,34,0x25},
// fase 05
{  1, 5,0x22},{125, 7,0x02},{  5,14,0x35},{126,17,0x32},
{ 26,29,0x52},{101,29,0x12},{ 25,29,0x32},
// fase 06
{  9, 3,0x02},{121, 7,0x64},{ 11,14,0x52},{111,27,0x02},
{107,36,0x03},{ 21,36,0x62},{109,27,0x12},{  7,27,0x23},
// fase 07
{ 19, 5,0x62},{119,12,0x02},{ 19,31,0x12},{ 28,13,0x41},{ 28,43,0x41},{ 28,41,0x01},
{ 15,19,0x52},{115,20,0x12},{ 15,33,0x12},{ 23,16,0x14},{ 23,33,0x54},{123,25,0x14},
// fase 08
{105, 5,0x15},{ 17, 7,0x52},{117,14,0x42},{ 14,14,0x12},{ 14,18,0x62},
{  5,21,0x35},{114,30,0x42},{  2,30,0x62},{  2,18,0x02},
// fase 09
{  9, 1,0x04},{107, 7,0x34},{ 22,13,0x31},{ 12,14,0x32},{ 12,41,0x22},
{109,28,0x42},{  7,28,0x54},{ 22,29,0x11},{112,36,0x52},
// fase 10
{120, 5,0x12},{110, 9,0x32},{  6, 7,0x24},{120,31,0x32},{ 29,32,0x34},
// fase 11
{ 16, 1,0x04},{116,47,0x04},{119,19,0x04},{ 27,11,0x32},{ 18, 7,0x12},
// fase 12
{  3, 1,0x02},{103, 7,0x02},{  3,31,0x52},{ 23, 7,0x63},{123, 1,0x63},{ 23,14,0x35},
{  4, 5,0x02},{104, 9,0x02},{104,31,0x34},{ 26, 9,0x62},{126, 5,0x62},{ 26,31,0x12},
// fase 13
{121, 1,0x04},{  8, 9,0x52},{ 25,10,0x22},{108,16,0x53},{ 10,16,0x52},{ 21,28,0x54},
// fase 14                       
{101, 9,0x22},{  1,41,0x02},{ 15,13,0x04},{115,39,0x64},{ 13, 7,0x31},{ 11,13,0x62},
// fase 15
{ 23,13,0x12},{123,21,0x52},{ 23,31,0x34},{  7, 9,0x14},{107,17,0x54},{107,37,0x34},
{  2, 9,0x52},{102,17,0x12},{  2,34,0x34},{ 19,13,0x52},{119,21,0x12},
// fase 16
{ 22, 7,0x61},{ 18, 9,0x62},{109, 5,0x24},{109,13,0x04},{ 12,15,0x02},
{112,49,0x02},{118,39,0x42},{ 22,43,0x41},{  9,31,0x14},
// fase 17
{110,25,0x02},{ 10,34,0x12},{110,48,0x02},{ 14,24,0x02},{114,34,0x42},
{  8,45,0x34},{108,49,0x04},{ 24,45,0x61},{ 24,50,0x01},{ 14,45,0x22},
// fase 18
{105, 7,0x05},{  1,17,0x12},{101,33,0x62},{ 17,34,0x02},{117,25,0x02},{ 29,31,0x04},
// fase 19
{  3, 5,0x12},{  3,11,0x12},{103,17,0x12},{103,24,0x12},{ 23, 5,0x52},
{123, 9,0x12},{ 20,11,0x52},{120,17,0x52},{120,24,0x52},{ 20,36,0x52},
{ 27,21,0x52},{127,38,0x52},{ 27,15,0x52},{ 23,34,0x52},
// fase 20
{  7,19,0x34},{107, 1,0x04},{  4, 9,0x22},{  4,25,0x42},{104,35,0x02},
{121,29,0x22},{ 22, 7,0x61},{ 22,15,0x61},{ 22,31,0x61},{ 21,39,0x02},
// fase 21                       
{ 26, 3,0x12},{126,18,0x32},{  2, 9,0x42},{102,14,0x22},
{112,24,0x44},{ 16,14,0x65},{ 12,24,0x24},
// fase 22
{ 10, 1,0x12},{105, 7,0x14},{ 18, 9,0x32},{110,12,0x34},{ 29,14,0x12},
{  5,18,0x12},{129,18,0x54},{ 29,21,0x22},{118,21,0x42},{ 10,28,0x12},
{ 18,46,0x34},{105,28,0x52},{118,14,0x52},
// fase 23
{  8, 9,0x15},{127,26,0x32},{ 27,24,0x32},{106,22,0x32},
{123,37,0x24},{ 27,37,0x42},{  6,20,0x32},{ 23,19,0x34},
// fase 24
{  2, 7,0x05},{110,14,0x22},{ 25,14,0x42},{ 10,22,0x12},{125,22,0x32},
{110,30,0x02},{ 15,30,0x22},{115,30,0x42},{ 25,30,0x62},{ 15,22,0x52},
// fase 25
{ 20, 5,0x04},{109, 7,0x42},{120,12,0x62},{ 21,14,0x14},{ 19,21,0x12},
{119,33,0x12},{ 20,39,0x62},{121,34,0x52},{109,40,0x02},{  9,25,0x44},
// fase 26
{ 12, 5,0x02},{ 29,11,0x32},{  1,25,0x34},{127,29,0x32},
{101,49,0x24},{ 27,49,0x42},{112,43,0x22},{ 29,43,0x42},
// fase 26
{  7, 9,0x54},{105,13,0x15},{107,20,0x12},{ 18,20,0x52},{118,25,0x12},{ 17,25,0x52},
{ 18,32,0x12},{117,32,0x52},{ 18,40,0x12},{ 17,40,0x32},{107,40,0x54},
// fase 28
{ 24, 9,0x40},{113,11,0x40},{ 28,13,0x40},{122,15,0x41},
{128,28,0x40},{ 22,30,0x41},{124,24,0x40},{ 13,26,0x40},
// fase 29
{123, 9,0x14},{ 14, 7,0x52},{  6,15,0x12},{ 23,23,0x04},
{114,34,0x32},{ 16,36,0x02},{116,23,0x62},{106,32,0x62},
// fase 30
{104, 7,0x02},{  8, 7,0x24},{109, 7,0x42},{110, 7,0x62},
{  4,30,0x02},{108,30,0x24},{  9,30,0x42},{ 10,30,0x62},
{104,46,0x02},{  8,46,0x24},{109,46,0x42},{110,46,0x62},
{  4,17,0x02},{108,17,0x24},{  9,17,0x42},{ 10,17,0x62},
// fase 31
{ 29, 5,0x02},{103, 7,0x22},{ 11, 7,0x02},{129,48,0x02},{103,30,0x22},
{111,28,0x12},{ 29,48,0x62},{  3,30,0x42},{ 11,28,0x52},{116,34,0x25},
// fase 32
{  7,14,0x15},{123,14,0x55},{ 23,19,0x15},{ 12,19,0x52},{105,19,0x15},
{123,37,0x15},{ 12,37,0x52},{  5,37,0x35},{107,50,0x35},
// fase 33
{ 19, 1,0x22},{ 25, 9,0x32},{115, 5,0x62},{121,12,0x04},{ 21,20,0x34},
{ 15,30,0x62},{125,30,0x32},{119,30,0x02},{ 19,35,0x32},
// fase 34
{105, 1,0x04},{  5,28,0x04},{ 12, 9,0x52},{112,13,0x62},{  1,22,0x12},
{101,26,0x52},{ 24, 7,0x61},{ 24, 9,0x21},{124,14,0x41},{124,16,0x01},
// fase 35
{118, 9,0x04},{ 27, 9,0x22},{120, 9,0x42},{  2, 9,0x62},{ 18,53,0x14},
{ 18,46,0x02},{127,33,0x02},{ 20,37,0x02},{102,41,0x02},{127,53,0x32},
{118,46,0x62},{ 27,33,0x62},{120,37,0x62},{  2,41,0x62},{120,53,0x52},
// fase 36
{119, 1,0x04},{ 19, 7,0x62},{ 16, 5,0x02},{112, 7,0x52},
{ 19,32,0x14},{116,32,0x32},{112,32,0x52},{ 10,48,0x35},
// fase 37
{  9, 1,0x02},{109,11,0x02},{  8,13,0x62},{106,21,0x02},{ 14,19,0x52},
{  6,39,0x32},{108,41,0x32},{  9,45,0x32},{ 14,49,0x32},
// fase 38
{  4, 3,0x02},{ 26, 7,0x32},{ 22, 9,0x41},{ 22,19,0x21},{122,14,0x31},
{104,13,0x62},{126,33,0x62},{ 26,39,0x22},{ 25,33,0x05},{  4,44,0x02},
// fase 39
{ 18, 1,0x02},{118, 1,0x62},{  7, 5,0x24},{  5, 7,0x05},{116, 9,0x02},{107,15,0x54},
{ 16,26,0x02},{118,30,0x32},{  5,36,0x13},{  5,38,0x53},{118,44,0x04},
{  7,46,0x42},{ 16,51,0x42},{ 16,51,0x22},{105,51,0x35},{  7,46,0x22},
// fase 40
{ 20, 7,0x14},{103, 9,0x14},{  3,13,0x14},{123,16,0x54},{ 29,16,0x14},{129,20,0x14},
{ 23,20,0x34},{120,20,0x54},{ 20,27,0x14},{ 29,27,0x34},{103,27,0x54},
{ 23,32,0x34},{  3,34,0x54},{ 20,39,0x12},{ 23,39,0x52},{129,31,0x14}
};

