//******************************************************************************
// juego.c
// Funciones directamente relacionadas con el juego.
// Por Ignacio Prez Gil 11/09/2004.
//******************************************************************************

//******************************************************************************
// Includes.
//******************************************************************************
#include <allegro.h>
#include <time.h>
#include "juego.h"
#include "hump.h"
#include "mapa.h"
#include "tcj.h"
#include "tiempo.h"
#include "audio.h"

//******************************************************************************
// Definiciones, variables globales y funciones.
//******************************************************************************
#define PAREDES 13
#define SUELOS_C 14
#define SUELOS_G 15
#define PRIMER_VACIO 16
#define PRIMER_BRILLO 50
#define PRIMERA_SOMBRA_H 48
#define PRIMERA_SOMBRA_E 66

#define ANCHO_CELDA   48
#define ANCHO_VENTANA 12
#define ALTO_VENTANA   7

#define fm_pulsado_salto() (tcj_estado[TCJ_AC0]||tcj_estado[TCJ_AC2]||\
                            tcj_estado[TCJ_AC3]||tcj_estado[TCJ_AC4]||tcj_estado[TCJ_AC5])
#define fm_mapasalto()     (BITMAP *)(f_obj[dt_humphrey.temp%16>7?39:40].dat)
#define fm_expl(_N_)       (BITMAP *)(f_obj[41+_N_].dat)
#define fm_boom(_N_)       (BITMAP *)(f_obj[71+_N_].dat)
#define fm_aspiradora(_N_) (BITMAP *)(f_obj[74+(_N_)].dat)
#define fm_marcador(_N_)   (BITMAP *)(f_obj[80+(_N_)].dat)

extern DATAFILE *f_obj;
BITMAP *buffer=NULL;
BITMAP *buffer_juego=NULL;
BITMAP *buffer_mapa=NULL;
BITMAP *mp_suelo[2]={NULL,NULL};
BITMAP *m_enemigo[60];
unsigned char *mapa=NULL;
unsigned short tam=0, tamreal=0;
int num_suelo;
int desp;
int max_desp;
char reiniciar;
extern unsigned char idioma;
extern char modo_truecolor;
extern char modo_pc;
void cargar_fase(char fs);
char juego_facil;
char trampas;
char llamar_present_fase=0;

void sombrear_mapa(int pos, char sec);
void dibujar_sombra(char sombra, int x, int y);
void mover_cintas(void);
void mover_rayos(void);
void mover_plataformas(void);
void reiniciar_moviles(char fs);
void comprobar_pintadas(char todas);
void pintar(unsigned short nlst, char dir);
void pintar_losetas(void);
void pintar_brillos(void);
void mover_enemigos(void);
char colision_15_16(BITMAP *mp0, int x0, int y0, BITMAP *mp1, int x1, int y1, char invertir);
char colision_24_32(BITMAP *mp0, int x0, int y0, BITMAP *mp1, int x1, int y1, char invertir);
char (*detec_colis[2])(BITMAP *,int,int,BITMAP *,int,int,char)={colision_15_16,colision_24_32};
void mover_mojcas(char sombra);
void reventar_loseta(char f);
void game_over(void);
void present_fase(char fs);

// Funciones de movimiento de enemigos.
void enem_mov_x(char f);    // Movimiento en x normal
void enem_mov_x_a(char f);  // Movimiento en x acelerado
void enem_mov_xy(char f);   // Movimiento aleatorio en x e y
void enem_mov_xy_b(char f); // Movimiento buscador en x e y
void enem_mov_xy_a(char f); // Movimiento acelerado en x e y (tanto aleatorio como buscador)
char enem_no_puede_mover(short pos,char dir);

// Definiciones y funciones de los estados posibles de Humphrey.
#define MH_NORMAL 0
char mh_normal(void);
#define MH_DESPEGUE 1
char mh_despegue(void);
#define MH_VUELO 2
char mh_vuelo(void);
#define MH_ATERRIZAJE 3
char mh_aterrizaje(void);
#define MH_CAIDA_VACIO 4
char mh_caida_vacio(void);
#define MH_REVENTANDO 5
char mh_reventando(void);
#define MH_TELETRANS 6
char mh_teletrans(void);

char puede_mover_h(char dir);
void mov_inducido(void);
void mov_normal(void);
void colocar_brillos(unsigned short lst);

extern volatile char tic_reloj;
int ciclos;

#define ANIMO_NORMAL  0
#define ANIMO_PARALIZ 1
#define ANIMO_TROMPA  2
#define ANIMO_TRANQUI 3
// Estructura para los datos de Humphrey.
struct{
  char estado;
  char dir;  
  char fot; 
  char dirfot;
  int x;
  int y;
  char andando;
  unsigned char temp;
  unsigned char mov_inducido;
  unsigned short pisando[4];
  char animo;
  short contanimo;
  char vasbot;
  char vidas;
  int puntos;
  char envenenado;
  }dt_humphrey;

#define fm_sumar_puntos(_P_) if(!trampas) dt_humphrey.puntos+=(_P_/(1+juego_facil));
#define fm_restar_puntos() if(!trampas && dt_humphrey.puntos>4) dt_humphrey.puntos-=(5/(1+juego_facil));

// Datos de los enemigos.
#define CAMBIAR_FOT 7
#define MAX_ENEMS 20
#define E_ESTADO_NORMAL 0
#define E_ESTADO_REVENT 1
#define E_ESTADO_MUERTO 2
struct{
  char sec;
  char num;
  char estado[MAX_ENEMS];
  char dir[MAX_ENEMS];  
  char fot[MAX_ENEMS];
  char invertir[MAX_ENEMS];
  char comportamiento[MAX_ENEMS];
  int x[MAX_ENEMS];
  int y[MAX_ENEMS];
  unsigned char temp[MAX_ENEMS];
  }dt_enemigos;

// Datos de las mojcas.
#define CAMBIAR_FMOJCA 4
#define NUM_MOJCAS 2
struct{
  char fot[NUM_MOJCAS];
  int x[NUM_MOJCAS];
  int y[NUM_MOJCAS];
  int xd[NUM_MOJCAS];
  int yd[NUM_MOJCAS];
  unsigned char temp[NUM_MOJCAS];
  }dt_mojcas;

// Datos de las losetas explosivas.
#define NUM_BOOMS 3
struct{
  unsigned short pos[NUM_BOOMS];
  unsigned char temp[NUM_BOOMS];
  }dt_booms;

// Datos de las cintas transportadoras.
struct{
  char num;  
  char fot;
  char dirfot[16];
  }dt_cintas;

// Datos de los suelos electrificados (rayos).
struct{
  char num;  
  short fot; 
  char dir; 
  }dt_rayos = {0,0,0};

// Datos de las plataformas mviles.
struct{
  char num;
  int  x[3];
  int  y[3];
  int  xi[3];
  int  yi[3];
  char dir[3];
  char voz[3];
  char mover;
  }dt_plataformas;

// Datos del scroll prallax.
#define FACTOR_PARALLAX 4
unsigned char parallax_activo=1;
struct{
  BITMAP *mapa;
  unsigned short xi;
  unsigned short yi;
  }dt_parallax={NULL,0,0};

// Estructura para la lista de losetas en proceso de pintado.
typedef struct _tp_lst
  {unsigned short lst;
   char fot, dir;
   struct _tp_lst *sig;
  } tp_lst;

tp_lst *primera_loseta=NULL;

// Estructura para la lista de brillos en las losetas recin pintadas.
#define NUM_BRILLOS 6
typedef struct _tp_brillos
 {char fot[NUM_BRILLOS];
  char tipo[NUM_BRILLOS];
  unsigned char temp[NUM_BRILLOS];
  int x[NUM_BRILLOS];
  int y[NUM_BRILLOS];
  struct _tp_brillos *sig;
 } tp_brillos;

tp_brillos *primer_brillos=NULL;

//******************************************************************************
// Funcin ini_juego()
//    Inicializa el juego.
//******************************************************************************
void ini_juego(void)
{
 short dx,dy;
 char f;
 DATAFILE *f_enems=load_datafile("enemigos.dat");
 BITMAP *g_e=(BITMAP *)(f_enems[0].dat);

 for(f=0,dy=2;dy<=252;dy+=50)
   for(dx=2;dx<=452;dx+=50)
     blit(g_e,(m_enemigo[f++]=create_bitmap(ANCHO_CELDA,ANCHO_CELDA)),dx,dy,0,0,ANCHO_CELDA,ANCHO_CELDA);
 unload_datafile(f_enems);

 for(f=1;f<40;f++)
  {
   fase[f].nl+=fase[f-1].nl;
   fase[f].ne+=fase[f-1].ne;
  }

 f_obj=load_datafile("obj.dat");
 set_trans_blender(0,0,0,180);
}

//******************************************************************************
// Funcin fin_juego()
//    Desinicializa el juego.
//******************************************************************************
void fin_juego(void)
{
 char f;
 
 for(f=0;f<60;f++)
   destroy_bitmap(m_enemigo[f]);

 if(buffer_mapa) destroy_bitmap(buffer_mapa);
 if(buffer_juego) destroy_bitmap(buffer_juego);
 if(buffer) destroy_bitmap(buffer);
 if(mapa) free(mapa);
 if(mp_suelo[0])
  {
   destroy_bitmap(mp_suelo[0]);
   destroy_bitmap(mp_suelo[1]);
  }
 while(primera_loseta)
  {tp_lst *lst=primera_loseta;
   primera_loseta=lst->sig;
   free(lst);
  }
 while(primer_brillos)
  {tp_brillos *brillos=primer_brillos;
   primer_brillos=brillos->sig;
   free(brillos);
  }
 unload_datafile(f_obj);
}

//******************************************************************************
// Funcin juego(...)
//    Controla el juego, empezando en la fase fs.
//******************************************************************************
char juego(char fs, int *puntos)
{
 int t;
 int cambiando_fase=1;
 char f;
 char (*mover_humphrey[7])(void)=
  {mh_normal,mh_despegue,mh_vuelo,mh_aterrizaje,mh_caida_vacio,mh_reventando,mh_teletrans};

 trampas=0;
 buffer=create_bitmap(640,480);
 buffer_juego=create_sub_bitmap(buffer,32,44,ANCHO_CELDA*ANCHO_VENTANA,ANCHO_CELDA*ALTO_VENTANA);
 clear_bitmap(buffer);
 cargar_fase(fs);
 if(dt_parallax.mapa)
  {
   blit(dt_parallax.mapa,buffer_juego,0,0,dt_parallax.xi,dt_parallax.yi,ANCHO_CELDA*ANCHO_VENTANA,ANCHO_CELDA*ALTO_VENTANA);
   draw_sprite(buffer_juego,buffer_mapa,0,0);
  }
 else
   blit(buffer_mapa,buffer_juego,0,0,0,0,ANCHO_CELDA*ANCHO_VENTANA,ANCHO_CELDA*ALTO_VENTANA);
 dt_humphrey.puntos=0;
 dt_humphrey.vidas=5;

 do
  {
   if(llamar_present_fase==2)
     llamar_present_fase=1;

   tcj_comprobar();
   // Este es el truco :)
   if(key[KEY_F7] && key[KEY_F12] && !trampas)
    {
     trampas=1;
     textprintf(buffer, font, 5, 5, -1,"T");
    }

   if(!cambiando_fase)
    {
     if(trampas)
      {
       t=fs;
       if(key[KEY_F1] && fs<39) t++;
       if(key[KEY_F2] && fs) t--;
       if(fs!=t)
        {
         parar_musica();
         desp=0;
         cargar_fase(fs=t);
         cambiando_fase=1;
        }
      }
    }
   else
     if(!key[KEY_F1] && !key[KEY_F2]) cambiando_fase=0;

   // Se actualiza la barra del tiempo restante de la ltima loseta especial
   // que se haya pisado (stop, cruz roja, etc.)
   if(dt_humphrey.contanimo && num_suelo>0)
    {
     dt_humphrey.contanimo--;
     if(!dt_humphrey.contanimo)
      {
       dt_humphrey.animo=ANIMO_NORMAL;
       rectfill(buffer,193,406,256,455,0);
      }
     else
      {
       if(dt_humphrey.contanimo%110==0 && dt_humphrey.contanimo<1320)
        {int xb=193+50+15*dt_humphrey.contanimo/110;
         rectfill(buffer,xb,408,xb+14,455,0);
        }
      }
    }

   if(reiniciar)
    {
     if(dt_humphrey.vidas<0)
      {
       game_over();
       if(dt_parallax.mapa)
        {
         destroy_bitmap(dt_parallax.mapa);
         dt_parallax.mapa=NULL;
        }
       destroy_bitmap(buffer_juego);
       destroy_bitmap(buffer);
       buffer_juego=buffer=NULL;
       *puntos=dt_humphrey.puntos;
       return fs;
      }
     reiniciar_moviles(fs);
    }

   if(num_suelo>0)
    {
     if(primera_loseta) pintar_losetas();
     if(dt_parallax.mapa)
      {unsigned short l=(unsigned short)((desp/ANCHO_CELDA)*ALTO_VENTANA);
       short xf=desp+(ANCHO_CELDA*ANCHO_VENTANA);
       short x,x0,x1,y0,y1;
       char encontrado_espacio=0,y;
       for(x=desp;x<=xf;x+=ANCHO_CELDA)
         for(y=0;y<ALTO_VENTANA;y++,l++)
           if(mapa[l]==2)
            {
             if(encontrado_espacio)
              {
               if(l>x1) x1=l;
               if(y<y0) y0=y;
               if(y>y1) y1=y;
              }
             else
              {
               encontrado_espacio=1;
               x0=x;
               x1=l;
               y1=y0=y;
              }
            }
       x0=x0-desp-desp%ANCHO_CELDA;
       x1=(x1/ALTO_VENTANA)*ANCHO_CELDA+ANCHO_CELDA-1-desp;
       if(x0<0) x0=0;
       if(x1>=ANCHO_CELDA*ANCHO_VENTANA) x1=ANCHO_CELDA*ANCHO_VENTANA-1;
       if(encontrado_espacio && x0<=x1)
        {
         set_clip(buffer_juego,x0,y0*=ANCHO_CELDA,x1,y1=(y1+1)*ANCHO_CELDA-1);
         blit(dt_parallax.mapa,buffer_juego,0,0,dt_parallax.xi-desp/FACTOR_PARALLAX,dt_parallax.yi,
              dt_parallax.mapa->w,dt_parallax.mapa->h);
         set_clip(buffer_juego,0,0,ANCHO_CELDA*12-1,ANCHO_CELDA*7-1);
         draw_sprite(buffer_juego,buffer_mapa,-desp,0);
        }
       else
         blit(buffer_mapa,buffer_juego,desp,0,0,0,ANCHO_CELDA*ANCHO_VENTANA,ANCHO_CELDA*ALTO_VENTANA);
      }
     else
       blit(buffer_mapa,buffer_juego,desp,0,0,0,ANCHO_CELDA*ANCHO_VENTANA,ANCHO_CELDA*ALTO_VENTANA);
     if(dt_cintas.num) mover_cintas();
     for(f=0;f<NUM_BOOMS;f++)
       if(dt_booms.temp[f])
         reventar_loseta(f);
     if(primer_brillos) pintar_brillos();
     if(dt_rayos.num) mover_rayos();
     dt_plataformas.mover=1;
     mover_enemigos();
     if(dt_humphrey.estado!=MH_CAIDA_VACIO)
       mover_plataformas();
     if(dt_humphrey.estado==MH_DESPEGUE ||
        dt_humphrey.estado==MH_VUELO    ||
        dt_humphrey.estado==MH_ATERRIZAJE)
       mover_mojcas(1);
     while(mover_humphrey[dt_humphrey.estado]());
     if(dt_humphrey.estado==MH_CAIDA_VACIO || dt_plataformas.mover==1)
       mover_plataformas();
     mover_mojcas(0);
     if(dt_humphrey.x-desp<ANCHO_CELDA*3 && desp) desp-=2;
     if(dt_humphrey.x-desp>ANCHO_CELDA*8 && desp<max_desp) desp+=2;
     if(dt_humphrey.estado!=MH_CAIDA_VACIO && dt_humphrey.estado!=MH_REVENTANDO)
       reproducir_musica(fs&1);
    }
   else
    {
     if(!num_suelo)
      {
       // Se ha pintado toda la fase
       parar_musica();
       detener_sonidos();
       reproducir_sonido(9,0);
      }
     num_suelo--;
     if(num_suelo<=-450)
      {
       fm_sumar_puntos(1000);
       if(fs==39)
        {
         if(dt_parallax.mapa)
          {
           destroy_bitmap(dt_parallax.mapa);
           dt_parallax.mapa=NULL;
          }
         destroy_bitmap(buffer_juego);
         destroy_bitmap(buffer);
         buffer_juego=buffer=NULL;
         parar_musica();
         if(trampas) return 0;
         *puntos=dt_humphrey.puntos;
         return 40;
        }
       else
         cargar_fase(++fs);
      }
    }

   rectfill(buffer,432,6,623,38,0);
   escribir_numero(buffer,dt_humphrey.puntos,6,432,6,0);
   rectfill(buffer,117,414,180,445,0);
   escribir_numero(buffer,dt_humphrey.vidas,2,117,414,0);
   rectfill(buffer,512,414,607,445,0);
   escribir_numero(buffer,num_suelo,3,512,414,0);
   if(llamar_present_fase==1)
     present_fase(fs);


   while(!tic_reloj);
   tic_reloj=0;
   if(modo_pc) vsync();
   acquire_screen();
   blit(buffer,screen,0,0,0,0,640,480);
   release_screen();

  }while(tcj_estado[TCJ_AC1]?pausa(buffer,(dt_humphrey.estado==MH_CAIDA_VACIO ||
                                           dt_humphrey.estado==MH_REVENTANDO  ||
                                           num_suelo<0 ? 100 : fs&1),&num_suelo)
                             :1);
 parar_musica();
 if(dt_parallax.mapa)
  {
   destroy_bitmap(dt_parallax.mapa);
   dt_parallax.mapa=NULL;
  }
 destroy_bitmap(buffer_juego);
 destroy_bitmap(buffer);
 buffer_juego=buffer=NULL;

 return 0;
}

//******************************************************************************
// Funcin present_fase(...)
//    Se muestra el rtulo del inicio de fase.
//******************************************************************************
#define PASOS 50
void present_fase(char fs)
{
 BITMAP *bmp_fase;
 BITMAP *bmp_buffer;
 unsigned char f;
 short x[2], y[2], ex[2], ey[2], rx[2], ry[2], rxa[2], rya[2];
 int ct=makecol(255,0,255);

 llamar_present_fase=0;

 reproducir_sonido(8,0);
 if(idioma==0)
  {
   bmp_fase=create_bitmap(224,32);
   clear_to_color(bmp_fase,ct);
   escribir_texto(bmp_fase,"faseE0",0,0,0);
   escribir_numero(bmp_fase,fs+1,2,5*32,0,0);
   bmp_buffer=create_bitmap(544,238);
   blit(buffer,bmp_buffer,16,6,0,0,544,238);
   stretch_sprite(buffer,bmp_fase,x[0]=96,y[0]=180,x[1]=448,y[1]=64);
   ex[0]=(16-96)/PASOS; ex[1]=(224-448)/PASOS;
   rx[0]=(16-96)%PASOS; rx[1]=(224-448)%PASOS;
   ey[0]=(6-180)/PASOS; ey[1]=(32-64)/PASOS;
   ry[0]=(6-180)%PASOS; ry[1]=(32-64)%PASOS;
   rxa[0]=rxa[1]=rya[0]=rya[1]=0;

   for(f=0;f<50;f++)
    {
     while(!tic_reloj);
     tic_reloj=0;
     if(modo_pc) vsync();
     acquire_screen();
     blit(buffer,screen,0,0,0,0,640,480);
     release_screen();
    }

   for(f=0;f<PASOS;f++)
   {
    blit(bmp_buffer,buffer,x[0]-16,y[0]-6,x[0],y[0],x[1],y[1]);
    x[0]+=ex[0]; x[1]+=ex[1];
    y[0]+=ey[0]; y[1]+=ey[1];
    rxa[0]+=rx[0]; rxa[1]+=rx[1]; 
    rya[0]+=ry[0]; rya[1]+=ry[1]; 
    if(rxa[0]>=PASOS)
     {
      x[0]++;
      rxa[0]-=PASOS;
     }
    if(rxa[0]<= -PASOS)
     {
      x[0]--;
      rxa[0]+=PASOS;
     }

    if(rxa[1]>=PASOS)
     {
      x[1]++;
      rxa[1]-=PASOS;
     }
    if(rxa[1]<= -PASOS)
     {
      x[1]--;
      rxa[1]+=PASOS;
     }

    if(rya[0]>=PASOS)
     {
      y[0]++;
      rya[0]-=PASOS;
     }
    if(rya[0]<= -PASOS)
     {
      y[0]--;
      rya[0]+=PASOS;
     }

    if(rya[1]>=PASOS)
     {
      y[1]++;
      rya[1]-=PASOS;
     }
    if(rya[1]<= -PASOS)
     {
      y[1]--;
      rya[1]+=PASOS;
     }

    stretch_sprite(buffer,bmp_fase,x[0],y[0],x[1],y[1]);
    while(!tic_reloj);
    tic_reloj=0;
    if(modo_pc) vsync();
    acquire_screen();
    blit(buffer,screen,0,0,0,0,640,480);
    release_screen();
   }
   blit(bmp_buffer,buffer,0,0,16,6,544,238);
  }
 else
  {
   bmp_fase=create_bitmap(8*32,32);
   clear_to_color(bmp_fase,ct);
   escribir_texto(bmp_fase,"stageE0",0,0,0);
   escribir_numero(bmp_fase,fs+1,2,6*32,0,0);
   bmp_buffer=create_bitmap(592,238);
   blit(buffer,bmp_buffer,16,6,0,0,592,238);
   stretch_sprite(buffer,bmp_fase,x[0]=64,y[0]=180,x[1]=512,y[1]=64);
   ex[0]=(16-64)/PASOS; ex[1]=(256-512)/PASOS;
   rx[0]=(16-64)%PASOS; rx[1]=(256-512)%PASOS;
   ey[0]=(6-180)/PASOS; ey[1]=(32-64)/PASOS;
   ry[0]=(6-180)%PASOS; ry[1]=(32-64)%PASOS;
   rxa[0]=rxa[1]=rya[0]=rya[1]=0;
   for(f=0;f<50;f++)
    {
     while(!tic_reloj);
     tic_reloj=0;
     if(modo_pc) vsync();
     acquire_screen();
     blit(buffer,screen,0,0,0,0,640,480);
     release_screen();
    }

   for(f=0;f<PASOS;f++)
   {
    blit(bmp_buffer,buffer,x[0]-16,y[0]-6,x[0],y[0],x[1],y[1]);
    x[0]+=ex[0]; x[1]+=ex[1];
    y[0]+=ey[0]; y[1]+=ey[1];
    rxa[0]+=rx[0]; rxa[1]+=rx[1]; 
    rya[0]+=ry[0]; rya[1]+=ry[1]; 

    if(rxa[0]>=PASOS)
     {
      x[0]++;
      rxa[0]-=PASOS;
     }
    if(rxa[0]<= -PASOS)
     {
      x[0]--;
      rxa[0]+=PASOS;
     }

    if(rxa[1]>=PASOS)
     {
      x[1]++;
      rxa[1]-=PASOS;
     }
    if(rxa[1]<= -PASOS)
     {
      x[1]--;
      rxa[1]+=PASOS;
     }

    if(rya[0]>=PASOS)
     {
      y[0]++;
      rya[0]-=PASOS;
     }
    if(rya[0]<= -PASOS)
     {
      y[0]--;
      rya[0]+=PASOS;
     }

    if(rya[1]>=PASOS)
     {
      y[1]++;
      rya[1]-=PASOS;
     }
    if(rya[1]<= -PASOS)
     {
      y[1]--;
      rya[1]+=PASOS;
     }

    stretch_sprite(buffer,bmp_fase,x[0],y[0],x[1],y[1]);
    while(!tic_reloj);
    tic_reloj=0;
    if(modo_pc) vsync();
    acquire_screen();
    blit(buffer,screen,0,0,0,0,640,480);
    release_screen();
   }
   blit(bmp_buffer,buffer,0,0,16,6,592,238);
  }

 draw_sprite(buffer,bmp_fase,16,6);
 destroy_bitmap(bmp_fase);
 destroy_bitmap(bmp_buffer);
}
#undef PASOS

//******************************************************************************
// Funcin game_over(...)
//    Se muestra el rtulo de "game over".
//******************************************************************************
void game_over(void)
{
 BITMAP *buffer2=create_bitmap(552,72);
 unsigned char f, cont=8, transp=255;
 int x[8],y[8], ct=makecol(255,0,255);
 BITMAP *gameover[8];

 {char letras[8]={'g','a','m','e','o','v','e','r'};
  char texto[2]={0,0};
  BITMAP *t=create_bitmap(32,32);
  for(f=0;f<8;f++)
   {
    clear_to_color(t,ct);
    texto[0]=letras[f];
    escribir_texto(t,texto,0,0,0);
    gameover[f]=create_bitmap(64,64);
    clear_to_color(gameover[f],ct);
    stretch_sprite(gameover[f],t,0,0,64,64);
   }
  destroy_bitmap(t);
 }

 blit(buffer,buffer2,44,177,0,0,552,72);
 reproducir_sonido(10,0);

 do
  {
   if(cont==8)
    {
     cont=0;
     if(transp)
      {
       for(f=0;f<8;f++)
        {
         x[f]=(f>3?80:48)+f*64;
         y[f]=181;
        }
      }
     else
      {
       for(f=0;f<8;f++)
        {
         x[f]=4*(rand()%3)+(f>3?76:44)+f*64;
         y[f]=4*(rand()%3)+177;
        }
      }
    }
   else
     cont++;

   blit(buffer2,buffer,0,0,44,177,552,72);
   if(transp)
     set_trans_blender(0,0,0,255-transp);
   for(f=0;f<8;f++)
     if(transp)
       draw_trans_sprite(buffer,gameover[f],x[f],y[f]);
     else
       draw_sprite(buffer,gameover[f],x[f],y[f]);
 
   if(transp>11)
     transp-=12;
   else
     transp=0;
   
   while(!tic_reloj);
   tic_reloj=0;
   if(modo_pc) vsync();
   acquire_screen();
   blit(buffer,screen,0,0,0,0,640,480);
   release_screen();
   tcj_comprobar();
  }while(!tcj_estado[TCJ_AC0] && !tcj_estado[TCJ_AC1] && !tcj_estado[TCJ_AC2] &&
         !tcj_estado[TCJ_AC3] && !tcj_estado[TCJ_AC4] && !tcj_estado[TCJ_AC5]);
 
 destroy_bitmap(buffer2);
 for(f=0;f<8;destroy_bitmap(gameover[f++]));
 detener_sonidos();
}

//******************************************************************************
// Funcin cargar_fase(...)
//    Se carga una fase determinada, y se dibuja en buffer_mapa.
//******************************************************************************
void cargar_fase(char fs)
{
 unsigned short n, f, l, i=(fs?fase[fs-1].nl:0), tamreal2=2*(fase[fs].nl-i)+14, xf, yf;
 unsigned char mv_cintas, num_booms=0;
 char encontrado_primer_espacio=0;
 BITMAP *pared=create_sub_bitmap((BITMAP *)(f_obj[PAREDES].dat),(fs%10)*ANCHO_CELDA,
                                 (fs/10)*ANCHO_CELDA,ANCHO_CELDA,ANCHO_CELDA);

 if(tamreal2%7)
   tam=tamreal2-1;
 else
   tam=tamreal2;
 if(tamreal!=tamreal2) //Se redimensiona el mapa y el buffer.
  {
   if(mapa)
     mapa=realloc(mapa,(tamreal=tamreal2)*sizeof(unsigned char));
   else
	 mapa=malloc((tamreal=tamreal2)*sizeof(unsigned char));
   if(buffer_mapa)
     destroy_bitmap(buffer_mapa);
   buffer_mapa=create_bitmap((tam/7)*ANCHO_CELDA,7*ANCHO_CELDA);
  }
 clear_bitmap(buffer_mapa);

 num_suelo=0;
 for(n=0;n<7;mapa[n++]=0);
 for(;n<tam-7;n+=2,i++) // Se informa el mapa descomprimiendo loseta[], y se cuenta el nmero de suelos.
  {
   if((mapa[n] = loseta[i] >> 4)==1) num_suelo++;
   if((mapa[n+1] = loseta[i] & 0x0f) == 1) num_suelo++;
  }
 for(;n<tam;mapa[n++]=0);

 // Informamos los datos de las cintas
 dt_cintas.num=dt_cintas.fot=0;
 for(f=0;f<16;dt_cintas.dirfot[f++]=0); // Inicialmente se colocan todas las cintas de izquierda a derecha
 mv_cintas=fase[fs].cintas;
 for(n=8;n<tam-7;n+=7)
  {
   if(mapa[n]==15) dt_cintas.num++;
   if(mapa[n+4]==15)
    {
     if(mv_cintas&1)
      {
       dt_cintas.dirfot[dt_cintas.num]=1;
      }
     else
      {
       if(mapa[n]==15) dt_cintas.dirfot[dt_cintas.num-1]=1;
      }
     dt_cintas.num++;
     mv_cintas=mv_cintas>>1;
    }
  }

 // Informamos los datos de los rayos y losetas explosivas
 dt_rayos.fot=dt_rayos.num=0;
 for(n=7;n<tam-7;n++)
  {
   if(mapa[n]==3) // Es un rayo
    {
     dt_rayos.num++;
    }
   else if(mapa[n]==4)
    {
     dt_booms.pos[num_booms]=n;
     dt_booms.temp[num_booms]=0;
     num_booms++;
    }
  }

 // Se informa la tabla de mapas del suelo
 if(mp_suelo[0])
  {
   destroy_bitmap(mp_suelo[0]);
   destroy_bitmap(mp_suelo[1]);
  }
 mp_suelo[0]=create_sub_bitmap((BITMAP *)(f_obj[SUELOS_G].dat),(fs%10)*ANCHO_CELDA,
                               (fs/10)*ANCHO_CELDA,ANCHO_CELDA,ANCHO_CELDA);
 mp_suelo[1]=create_sub_bitmap((BITMAP *)(f_obj[SUELOS_C].dat),(fs%10)*ANCHO_CELDA,
                               (fs/10)*ANCHO_CELDA,ANCHO_CELDA,ANCHO_CELDA);

 if(parallax_activo) // Se crea el mapa de estrellas del parallax
  {
   if(dt_parallax.mapa)
    {
     destroy_bitmap(dt_parallax.mapa);
     dt_parallax.mapa=NULL;
    }

   // Calculamos los datos necesarios para el mapa de estrellas del parallax
   for(l=n=0;n<buffer_mapa->w;n+=ANCHO_CELDA)
    {char espacio_derecha=0;
     for(f=0;f<ANCHO_CELDA*ALTO_VENTANA;f+=ANCHO_CELDA,l++)
      {
       if(mapa[l]==2 || mapa[l]==7)
        {
         if(!encontrado_primer_espacio)
          {
           encontrado_primer_espacio=1;
           dt_parallax.xi=n/FACTOR_PARALLAX;
           dt_parallax.yi=f;
           yf=f;
           // No hay ninguna fase en la que el espacio ms a la izquierda comience
           // en la zona C del prallax, por lo que esto ni se tiene en cuenta al
           // calcular la xi. En caso de que lo hubiera, sera
           // n+(1-FACTOR_PARALLAX)*((buffer_mapa->w-ANCHO_CELDA*ANCHO_VENTANA)/FACTOR_PARALLAX)
          }
         else
          {
           if(f<(dt_parallax.yi)) dt_parallax.yi=f;
           if(f>yf) yf=f;
          }

         if(!espacio_derecha)
          {
           espacio_derecha=1;
           xf=ANCHO_CELDA*ANCHO_VENTANA+(n-(ANCHO_VENTANA-1)*ANCHO_CELDA)/FACTOR_PARALLAX;
           // No hay ninguna fase en la que el espacio ms a la derecha comience
           // en la zona A del prallax, por lo que esto ni se tiene en cuenta al
           // calcular la xi. En caso de que lo hubiera, sera x+ANCHO_CELDA
          }
        }
      }
    }

   if(encontrado_primer_espacio)
    {
     // Se crea el mapa de estrellas del prallax.
     dt_parallax.mapa=create_bitmap(xf-dt_parallax.xi,yf-dt_parallax.yi+ANCHO_CELDA);
     clear_bitmap(dt_parallax.mapa);

     // Se pintan las estrellas.
     for(n=0;n<dt_parallax.mapa->w;n+=ANCHO_CELDA)
       for(f=0;f<dt_parallax.mapa->h;f+=ANCHO_CELDA)
        {char e;
         for(e=0;e<10;e++)
           putpixel(dt_parallax.mapa,n+rand()%ANCHO_CELDA,f+rand()%ANCHO_CELDA,
                    makecol(180+rand()%76,180+rand()%76,180+rand()%76));
         if(!(rand()%3))
          {BITMAP *m_estrella=(BITMAP *)(f_obj[(rand()%10)+PRIMER_VACIO].dat);
           draw_sprite(dt_parallax.mapa,m_estrella,
                     n+rand()%ANCHO_CELDA-(m_estrella->w/2),f+rand()%ANCHO_CELDA-(m_estrella->h/2));
          }
        }
    }
  }

 dt_plataformas.num=0;
 srand(fs);
 // Se dibujan las estrellas y se colocan las plataformas.
 for(l=n=0; n<(tam/7)*ANCHO_CELDA; n+=ANCHO_CELDA)
   for(f=0; f<7*ANCHO_CELDA; f+=ANCHO_CELDA,l++)
    {
     if(mapa[l]==2 || mapa[l]==7)
      {
       if(parallax_activo)
        {
         rectfill(buffer_mapa,n,f,n+47,f+47,makecol(255,0,255));
        }
       else
        {char e;
         for(e=0;e<10;e++)
           putpixel(buffer_mapa,n+rand()%ANCHO_CELDA,f+rand()%ANCHO_CELDA,
                    makecol(180+rand()%76,180+rand()%76,180+rand()%76));
         if(!(rand()%3))
          {BITMAP *m_estrella=(BITMAP *)(f_obj[(rand()%10)+PRIMER_VACIO].dat);
           draw_sprite(buffer_mapa,m_estrella,
                       n+rand()%ANCHO_CELDA-(m_estrella->w/2),f+rand()%ANCHO_CELDA-(m_estrella->h/2));
          }
        }
       if(mapa[l]==7)
        {
         mapa[l]=2;
         dt_plataformas.xi[dt_plataformas.num]=dt_plataformas.x[dt_plataformas.num]=n;
         dt_plataformas.yi[dt_plataformas.num]=dt_plataformas.y[dt_plataformas.num]=f;
         dt_plataformas.dir[dt_plataformas.num]=4;
         dt_plataformas.voz[dt_plataformas.num]=-1;
         dt_plataformas.num++;
        }
      }
    }

 l=0;
 set_trans_blender(0,0,0,128);
 for(n=0; n<(tam/7)*ANCHO_CELDA; n+=ANCHO_CELDA) // Se dibuja el mapa en el buffer.
   for(f=0; f<7*ANCHO_CELDA; f+=ANCHO_CELDA)
    {BITMAP *loseta=NULL;
     switch(mapa[l])
      {
       case 0: // Pared
         loseta=pared;
         break;
       case 1: // Suelo
         mapa[l]=20;
         loseta=mp_suelo[0];
         break;
       case 2:
         loseta=NULL;
         break;
       default:
         loseta=(BITMAP *)(f_obj[mapa[l]-3].dat);
         break;
      }
     if(loseta) blit(loseta,buffer_mapa,0,0,n,f,ANCHO_CELDA,ANCHO_CELDA);
     if(mapa[l]>2) sombrear_mapa(l,0);
     l++;
    }
 set_trans_blender(0,0,0,180);

 destroy_bitmap(pared);

 // Se reinicia el estado de los enemigos
 srand(time(NULL));
 for(f=0;f<MAX_ENEMS;dt_enemigos.estado[f++]=E_ESTADO_NORMAL);
 for(f=juego_facil;f<NUM_MOJCAS;f++)
  {
   dt_mojcas.fot[f]=rand()%2;
   dt_mojcas.x[f]=rand()%(buffer_mapa->w-2*ANCHO_CELDA)+ANCHO_CELDA;
   dt_mojcas.xd[f]=(rand()%(8*ANCHO_CELDA)+2*ANCHO_CELDA);
   dt_mojcas.xd[f]=dt_mojcas.x[f]+dt_mojcas.xd[f]*(rand()%2?-1:1);
   if(dt_mojcas.xd[f]<0)dt_mojcas.xd[f]=0;
   if(dt_mojcas.xd[f]>buffer_mapa->w-ANCHO_CELDA)dt_mojcas.xd[f]=buffer_mapa->w-ANCHO_CELDA;
   dt_mojcas.y[f]=dt_mojcas.yd[f]=rand()%((ALTO_VENTANA-1)*ANCHO_CELDA);
   dt_mojcas.x[f]-=dt_mojcas.x[f]%2;
   dt_mojcas.xd[f]-=dt_mojcas.xd[f]%2;
   dt_mojcas.y[f]-=dt_mojcas.y[f]%2;
   dt_mojcas.yd[f]-=dt_mojcas.yd[f]%2;
   dt_mojcas.temp[f]=rand()%CAMBIAR_FMOJCA;
  }

 reiniciar=1;
 max_desp=buffer_mapa->w-ANCHO_VENTANA*ANCHO_CELDA;
 while(primera_loseta)
  {tp_lst *lst=primera_loseta;
   primera_loseta=primera_loseta->sig;
   free(lst);
  }
 while(primer_brillos)
  {tp_brillos *brillos=primer_brillos;
   primer_brillos=brillos->sig;
   free(brillos);
  }

 dt_humphrey.animo=ANIMO_NORMAL;
 dt_humphrey.contanimo=dt_humphrey.vasbot=0;
 clear_bitmap(buffer);
 if(trampas)
  {
   textprintf(buffer, font, 5, 5, -1,"T");
   if(idioma==0)
    {
     escribir_texto(buffer,"faseE0",16,6,0);
     escribir_numero(buffer,fs+1,2,176,6,0);
    }
   else
    {
     escribir_texto(buffer,"stageE0",16,6,0);
     escribir_numero(buffer,fs+1,2,208,6,0);
    }
   llamar_present_fase=0;
  }
 else
   llamar_present_fase=2;

 escribir_texto(buffer,"ptsE0",304,6,0);
 draw_sprite(buffer,(BITMAP *)(f_obj[39].dat),26,388);
 draw_sprite(buffer, fm_marcador(6), 432, 406);
 escribir_texto(buffer,"E0",480,414,0);
}

//******************************************************************************
// Funcin reiniciar_moviles(...)
//    Se coloca en sus posiciones iniciales a Humphrey, las plataformas mviles
//    y los enemigos.
//******************************************************************************
void reiniciar_moviles(char fs)
{
 char f;
 unsigned short i;

 dt_humphrey.dir=1;
 dt_humphrey.fot=0;
 dt_humphrey.x=3*ANCHO_CELDA;
 dt_humphrey.y=4*ANCHO_CELDA;
 dt_humphrey.andando=0;
 dt_humphrey.temp=0;
 dt_humphrey.mov_inducido=0;
 dt_humphrey.dirfot=1;
 dt_humphrey.estado=MH_NORMAL;
 dt_humphrey.pisando[3]=dt_humphrey.pisando[2]=dt_humphrey.pisando[1]=dt_humphrey.pisando[0]=25;
 dt_humphrey.envenenado=0;
 desp=0;

 dt_plataformas.x[0]=dt_plataformas.xi[0];
 dt_plataformas.y[0]=dt_plataformas.yi[0];
 dt_plataformas.dir[0]=4;
 dt_plataformas.voz[0]=-1;
 dt_plataformas.x[1]=dt_plataformas.xi[1];
 dt_plataformas.y[1]=dt_plataformas.yi[1];
 dt_plataformas.dir[1]=4;
 dt_plataformas.voz[1]=-1;
 dt_plataformas.x[2]=dt_plataformas.xi[2];
 dt_plataformas.y[2]=dt_plataformas.yi[2];
 dt_plataformas.dir[2]=4;
 dt_plataformas.voz[2]=-1;

 dt_enemigos.num=0;
 dt_enemigos.sec=70;
 i=fs?fase[fs-1].ne:0;
 for(f=0;i<fase[fs].ne;i++)
   if(!juego_facil || enemigo[i].fg<100)
    {
     dt_enemigos.num++;
     if(dt_enemigos.estado[f]!=E_ESTADO_NORMAL)
       dt_enemigos.estado[f]=E_ESTADO_MUERTO;
     dt_enemigos.comportamiento[f]=(enemigo[i].yc)&0x0f;
     if(enemigo[i].fg<100)
       dt_enemigos.fot[f]=(enemigo[i].fg)*2+(rand()%2);
     else
       dt_enemigos.fot[f]=(enemigo[i].fg-100)*2+(rand()%2);
     if(dt_enemigos.comportamiento[f]>1)
       dt_enemigos.dir[f]=rand()%4;
     else
       dt_enemigos.dir[f]=(rand()%2)*2+1;
     if(dt_enemigos.dir[f]>1)
       dt_enemigos.invertir[f]=0;
     else
       dt_enemigos.invertir[f]=1;
     dt_enemigos.x[f]=enemigo[i].x*ANCHO_CELDA;
     dt_enemigos.y[f]=(enemigo[i].yc>>4)*ANCHO_CELDA;
     dt_enemigos.temp[f]=0;
     f++;
    }

 reiniciar=0;
}

//******************************************************************************
// Funcin pintar_losetas()
//    Se pintan o despintan las losetas de la lista.
//******************************************************************************
void pintar_losetas(void)
{
 char emitir_sonido=0;
 tp_lst *loseta=primera_loseta;
 tp_lst *loseta_anterior=NULL;

 while(loseta)
  {
   char d=loseta->fot*4;

   blit(mp_suelo[loseta->dir?1:0],buffer_mapa,d,d,
        (loseta->lst/7)*ANCHO_CELDA+d,(loseta->lst%7)*ANCHO_CELDA+d,8*(6-loseta->fot),8*(6-loseta->fot));

   if(loseta->fot<3)
    {
     set_trans_blender(0,0,0,128);
     sombrear_mapa(loseta->lst,loseta->fot);
     set_trans_blender(0,0,0,180);
    }

   if(loseta->fot)
    {
     loseta->fot--;
     loseta_anterior=loseta;
     loseta=loseta->sig;
    }
   else
    {
     if(loseta->dir)
      {
       colocar_brillos(loseta->lst);
       if(mapa[loseta->lst]>19)
        {
         emitir_sonido=1;
         mapa[loseta->lst]+=4;
         num_suelo--;
        }
       else
        mapa[loseta->lst]=24;
      }
     else
       num_suelo++;
     if(loseta==primera_loseta)
      {
       primera_loseta=loseta->sig;
       free(loseta);
       loseta=primera_loseta;
      }
     else
      {
       loseta_anterior->sig=loseta->sig;
       free(loseta);
       loseta=loseta_anterior->sig;
      }
    }
  }
 if(emitir_sonido) reproducir_sonido(14,0);
}

//******************************************************************************
// Funcin pintar_brillos()
//    Se pintan los brillos de las losetas que se acaban de pintar.
//******************************************************************************
void pintar_brillos(void)
{
 tp_brillos *brillos=primer_brillos;
 tp_brillos *anterior=NULL;
 char f;
 char no_borrar;

 while(brillos)
  {
   no_borrar=NUM_BRILLOS;

   for(f=0;f<NUM_BRILLOS;f++)
    {
     if(brillos->temp[f])
      {
       if(brillos->temp[f] > 1)
        {
         brillos->temp[f]--;
        }
       else
        { // Hay 4 fotogramas de brillo, ordenados de menor a mayor
         char ftg=(brillos->fot[f]<8?PRIMER_BRILLO+brillos->fot[f]/2:PRIMER_BRILLO+6-brillos->fot[f]/2)+brillos->tipo[f];
         draw_sprite(buffer_juego,(BITMAP *)(f_obj[ftg].dat),brillos->x[f]-desp,brillos->y[f]);
         brillos->fot[f]++;
         if(brillos->fot[f]==14)
           brillos->temp[f]=0;
        }
      }
     else
      {
       no_borrar--;
      }
    }

   if(no_borrar)
    {
     anterior=brillos;
     brillos=brillos->sig;
    }
   else
    {
     if(anterior)
      {
       anterior->sig=brillos->sig;
       free(brillos);
       brillos=anterior->sig;
      }
     else
      {
       primer_brillos=brillos->sig;
       free(brillos);
       brillos=primer_brillos;
      }
    }
  }
}

//******************************************************************************
// Funcin colocar_brillos(...)
//    Coloca en la lista los nuevos brillos de una loseta recin pintada.
//******************************************************************************
void colocar_brillos(unsigned short lst)
{char f;
 tp_brillos *brillos=malloc(sizeof(tp_brillos));

 brillos->sig=primer_brillos;
 primer_brillos=brillos;
 for(f=0;f<NUM_BRILLOS;f++)
  {
   brillos->fot[f]=0;
   brillos->tipo[f]=(rand()%4)*4;
   brillos->temp[f]=rand()%25+1;
   brillos->x[f]=(lst/7)*ANCHO_CELDA-7+rand()%ANCHO_CELDA;
   brillos->y[f]=(lst%7)*ANCHO_CELDA-7+rand()%ANCHO_CELDA;
  }
 brillos->temp[0]=1;
 if(rand()%2)
   brillos->temp[2]=0;
 if(rand()%2)
   brillos->temp[3]=0;
 if(rand()%2)
   brillos->temp[4]=0;
}

//******************************************************************************
// Funcin sombrear_mapa(...)
//    Se sombrea una loseta de suelo de buffer_mapa con las paredes adyacentes.
//******************************************************************************
void sombrear_mapa(int pos, char sec)
{
 char sombra=0;

 if(pos%7)
  {
   if(mapa[pos-1]==0) sombra=1;
   if(mapa[pos-8]==0) sombra+=2;
  }
 else
   sombra=3;
 if(mapa[pos-7]==0) sombra+=4;
 if(sombra==7) sombra=5;

 if(sombra)
  {
   sec*=4;
   draw_trans_sprite(buffer_mapa,(BITMAP *)(f_obj[89+sombra].dat),
                     (pos/7)*ANCHO_CELDA,(pos%7)*ANCHO_CELDA);
  }
}

//******************************************************************************
// Funcin dibujar_sombra(...)
//    Dibuja una sombra en las zonas que no sean espacio.
//******************************************************************************
void dibujar_sombra(char sombra, int x, int y)
{
 char t;
 char db[4];
 unsigned short cx[4];
 unsigned short cy[4];

 if(sombra<PRIMERA_SOMBRA_E) sombra+=PRIMERA_SOMBRA_H;
 if(y<ANCHO_CELDA*7) 
  {
 cx[0]=cx[2]=x/ANCHO_CELDA;
 cy[0]=cy[1]=y/ANCHO_CELDA;
 cx[1]=cx[3]=(x+ANCHO_CELDA-1)/ANCHO_CELDA;
 cy[2]=cy[3]=(y+ANCHO_CELDA-1)/ANCHO_CELDA;
 if(cy[2]==7) 
   cy[2]=cy[3]=6;

 db[0]=mapa[cx[0]*7+cy[0]]==2?0:1;
 db[1]=mapa[cx[1]*7+cy[1]]==2?0:1;
 db[2]=mapa[cx[2]*7+cy[2]]==2?0:1;
 db[3]=mapa[cx[3]*7+cy[3]]==2?0:1;

 cx[0]=cx[2]=cx[2]*ANCHO_CELDA-desp;
 cy[0]=cy[1]*=ANCHO_CELDA;
 cx[1]=cx[3]=cx[3]*ANCHO_CELDA-desp;
 cy[2]=cy[3]*=ANCHO_CELDA;

 // Se comprueba que partes hay que sombrear.
 t=db[0]+db[1]+db[2]+db[3];
 if(t==4)
  {
   draw_trans_sprite(buffer_juego,(BITMAP *)(f_obj[sombra].dat),x-desp,y);
  }
 else
  {char f;
   for(f=0;f<dt_plataformas.num;f++)
    {
     set_clip(buffer_juego,dt_plataformas.x[f]-desp,              dt_plataformas.y[f],
                           dt_plataformas.x[f]-desp+ANCHO_CELDA-1,dt_plataformas.y[f]+ANCHO_CELDA-1);
     draw_trans_sprite(buffer_juego,(BITMAP *)(f_obj[sombra].dat),x-desp,y);
    }

   if(t)
    {
     if(db[0])
      {
       if(db[1]) 
        {
         set_clip(buffer_juego,cx[0],cy[0],cx[1]+ANCHO_CELDA-1,cy[1]+ANCHO_CELDA-1);
         db[1]=0;
        }
       else if(db[2]) 
        {
         set_clip(buffer_juego,cx[0],cy[0],cx[2]+ANCHO_CELDA-1,cy[2]+ANCHO_CELDA-1);
         db[2]=0;
        }
       else
        {
         set_clip(buffer_juego,cx[0],cy[0],cx[0]+ANCHO_CELDA-1,cy[0]+ANCHO_CELDA-1);
        }
       draw_trans_sprite(buffer_juego,(BITMAP *)(f_obj[sombra].dat),x-desp,y);
      }

     if(db[1])
      {
       if(db[3]) 
        {
         set_clip(buffer_juego,cx[1],cy[1],cx[3]+ANCHO_CELDA-1,cy[3]+ANCHO_CELDA-1);
         db[3]=0;
        }
       else
        {
         set_clip(buffer_juego,cx[1],cy[1],cx[1]+ANCHO_CELDA-1,cy[1]+ANCHO_CELDA-1);
        }
       draw_trans_sprite(buffer_juego,(BITMAP *)(f_obj[sombra].dat),x-desp,y);
      }

     if(db[2])
      {
       if(db[3]) 
        {
         set_clip(buffer_juego,cx[2],cy[2],cx[3]+ANCHO_CELDA-1,cy[3]+ANCHO_CELDA-1);
         db[3]=0;
        }
       else
        {
         set_clip(buffer_juego,cx[2],cy[2],cx[2]+ANCHO_CELDA-1,cy[2]+ANCHO_CELDA-1);
        }
       draw_trans_sprite(buffer_juego,(BITMAP *)(f_obj[sombra].dat),x-desp,y);
      }

     if(db[3])
      {
       set_clip(buffer_juego,cx[3],cy[3],cx[3]+ANCHO_CELDA-1,cy[3]+ANCHO_CELDA-1);
       draw_trans_sprite(buffer_juego,(BITMAP *)(f_obj[sombra].dat),x-desp,y);
      }

    }
   set_clip(buffer_juego,0,0,ANCHO_CELDA*12-1,ANCHO_CELDA*7-1);
  }
 }
}

//******************************************************************************
// Funcin mover_cintas()
//    Mueve las cintas transportadoras.
//******************************************************************************
void mover_cintas(void)
{
 char f=0;
 unsigned short n=8;

 if((dt_cintas.fot+=2)==ANCHO_CELDA) dt_cintas.fot=0;
 if(dt_humphrey.estado==MH_NORMAL && (dt_humphrey.mov_inducido & 0x0f)==0)
  { // Se mueven las cintas y se comprueba si inducen algn movimiento en Humphrey
   int xc,yc;
   while(f<dt_cintas.num)
    {
     while(mapa[n]!=15) n++;
     if(dt_cintas.dirfot[f])
       blit((BITMAP *)(f_obj[12].dat),buffer_mapa,dt_cintas.fot,0,
             xc=ANCHO_CELDA*(n/7),yc=ANCHO_CELDA*(n%7),ANCHO_CELDA,ANCHO_CELDA);
     else
       blit((BITMAP *)(f_obj[12].dat),buffer_mapa,ANCHO_CELDA-dt_cintas.fot,
            0,xc=ANCHO_CELDA*(n/7),yc=ANCHO_CELDA*(n%7),ANCHO_CELDA,ANCHO_CELDA);
     if(dt_humphrey.x+32 >= xc && dt_humphrey.x <= xc+32 &&
        dt_humphrey.y+16 >= yc && dt_humphrey.y <= yc+16)
       dt_humphrey.mov_inducido=dt_cintas.dirfot[f]?0x38:0x18;
     n+=3;
     f++;
    }
  }
 else
  {
   while(f<dt_cintas.num)
    {
     while(mapa[n]!=15) n++;
     if(dt_cintas.dirfot[f])
       blit((BITMAP *)(f_obj[12].dat),buffer_mapa,dt_cintas.fot,0,
            ANCHO_CELDA*(n/7),ANCHO_CELDA*(n%7),ANCHO_CELDA,ANCHO_CELDA);
     else
       blit((BITMAP *)(f_obj[12].dat),buffer_mapa,ANCHO_CELDA-dt_cintas.fot,0,
            ANCHO_CELDA*(n/7),ANCHO_CELDA*(n%7),ANCHO_CELDA,ANCHO_CELDA);
     n+=3;
     f++;
    }
  }
}

//******************************************************************************
// Funcin mover_rayos()
//    Realiza la animacin de las losetas electrificadas.
//******************************************************************************
void mover_rayos(void)
{
 if(dt_rayos.fot<0)
  {
   dt_rayos.fot++;
   if(dt_rayos.fot==0) reproducir_sonido(21,0);
  }
 else
  {char f;
   unsigned short n=0;

   if(dt_rayos.fot!=3 && dt_rayos.fot!=4)
    {
     set_trans_blender(0,0,0,100+(dt_rayos.fot==0||dt_rayos.fot==7?40:(dt_rayos.fot==1||dt_rayos.fot==6?20:0)));
     for(f=0;f<dt_rayos.num;f++)
      {
       while(mapa[n]!=3) n++;
       draw_trans_sprite(buffer_juego,(BITMAP *)(f_obj[dt_rayos.fot<3?46:47].dat),
                         (ANCHO_CELDA*(n/7))-desp,ANCHO_CELDA*(n%7));
       n++;
      }
     set_trans_blender(0,0,0,180);
    }
   if(dt_rayos.fot==7)
     dt_rayos.dir=-1;
   if(dt_rayos.fot==0)
     dt_rayos.dir=1;
   dt_rayos.fot+=dt_rayos.dir;
  }
}

//******************************************************************************
// Funcin mover_plataformas()
//    Mueve las plataformas mviles.
//******************************************************************************
void mover_plataformas(void)
{
 char f,n;

 if(dt_plataformas.mover)
  {
   dt_plataformas.mover=0;
   for(f=0;f<dt_plataformas.num;f++)
     if(dt_plataformas.dir[f]<4)
      {unsigned char obj_plat;
       char dx,dy;
       switch(dt_plataformas.dir[f])
        {
         case 0:
           if(dt_plataformas.y[f])
            {
             obj_plat=mapa[(dt_plataformas.x[f]/ANCHO_CELDA)*7+(dt_plataformas.y[f]-1)/ANCHO_CELDA];
             if(obj_plat==2)
               for(n=0;n<dt_plataformas.num;n++) // Comprobamos si hemos chocado con otra plataforma
                 if(f!=n)
                   if(dt_plataformas.x[f]+ANCHO_CELDA  > dt_plataformas.x[n]    &&
                      dt_plataformas.x[f]              < dt_plataformas.x[n]+ANCHO_CELDA &&
                      dt_plataformas.y[f]             == dt_plataformas.y[n]+ANCHO_CELDA)
                     obj_plat=0;
            }
           else
             obj_plat=0;
           dx=0;
           dy=-2;
           break;
         case 1:
           obj_plat=mapa[((dt_plataformas.x[f]+ANCHO_CELDA)/ANCHO_CELDA)*7+dt_plataformas.y[f]/ANCHO_CELDA];
           if(obj_plat==2)
             for(n=0;n<dt_plataformas.num;n++) // Comprobamos si hemos chocado con otra plataforma
               if(f!=n)
                 if(dt_plataformas.x[f]+ANCHO_CELDA == dt_plataformas.x[n]    &&
                    dt_plataformas.y[f]+ANCHO_CELDA  > dt_plataformas.y[n]    &&
                    dt_plataformas.y[f]              < dt_plataformas.y[n]+ANCHO_CELDA)
                   obj_plat=0;
           dx=2;
           dy=0;
           break;
         case 2:
           if(dt_plataformas.y[f]<6*ANCHO_CELDA)
            {
             obj_plat=mapa[(dt_plataformas.x[f]/ANCHO_CELDA)*7+(dt_plataformas.y[f]+ANCHO_CELDA)/ANCHO_CELDA];
             if(obj_plat==2)
               for(n=0;n<dt_plataformas.num;n++) // Comprobamos si hemos chocado con otra plataforma
                 if(f!=n)
                   if(dt_plataformas.x[f]+ANCHO_CELDA  > dt_plataformas.x[n]    &&
                      dt_plataformas.x[f]              < dt_plataformas.x[n]+ANCHO_CELDA &&
                      dt_plataformas.y[f]+ANCHO_CELDA == dt_plataformas.y[n])
                     obj_plat=0;
            }
           else
             obj_plat=0;
           dx=0;
           dy=2;
           break;
         case 3:
           obj_plat=mapa[((dt_plataformas.x[f]-1)/ANCHO_CELDA)*7+dt_plataformas.y[f]/ANCHO_CELDA];
           if(obj_plat==2)
             for(n=0;n<dt_plataformas.num;n++) // Comprobamos si hemos chocado con otra plataforma
               if(f!=n)
                 if(dt_plataformas.x[f]             == dt_plataformas.x[n]+ANCHO_CELDA &&
                    dt_plataformas.y[f]+ANCHO_CELDA  > dt_plataformas.y[n]    &&
                    dt_plataformas.y[f]              < dt_plataformas.y[n]+ANCHO_CELDA)
                   obj_plat=0;
           dx=-2;
           dy=0;
           break;
        }
       if(obj_plat==2)
        {// Mover la plataforma y comprobar si se induce movimiento
         if(dt_humphrey.estado == MH_NORMAL            &&
            !(dt_humphrey.mov_inducido & 0x0f)         &&
            dt_humphrey.x+32 > dt_plataformas.x[f]     &&
            dt_humphrey.x    <  dt_plataformas.x[f]+32 &&
            dt_humphrey.y+32 > dt_plataformas.y[f]     &&
            dt_humphrey.y    <  dt_plataformas.y[f]+32)
          dt_humphrey.mov_inducido=dt_plataformas.dir[f]*16+8;
         dt_plataformas.x[f]+=dx;
         dt_plataformas.y[f]+=dy;
         if(dt_plataformas.voz[f]>=99)
          {
           if(dt_plataformas.voz[f]>99) detener_sonido(dt_plataformas.voz[f]-100);
           dt_plataformas.voz[f]=reproducir_sonido(19,0);
          }
        }
       else
        {
         dt_plataformas.dir[f]=4; // Detenemos la plataforma
         if(dt_plataformas.voz[f]<99)
          {
           if(dt_plataformas.voz[f]>=0) detener_sonido(dt_plataformas.voz[f]);
           dt_plataformas.voz[f]=reproducir_sonido(20,0);
          }
         else
           dt_plataformas.voz[f]=-1;
        }
      }
  }

 for(f=0;f<dt_plataformas.num;f++)
   blit((BITMAP *)(f_obj[4].dat),buffer_juego,0,0,
        dt_plataformas.x[f]-desp,dt_plataformas.y[f],ANCHO_CELDA,ANCHO_CELDA);
}

//***********************************\\
//  Funciones de estado de Humphrey  \\
//***********************************\\

//******************************************************************************
// Funcin mh_normal()
//    Movimiento normal.
//******************************************************************************
char mh_normal(void)
{
 unsigned char pisando;
 char ant_andando=dt_humphrey.andando;
 short pos;
 int x=190;

 if(!llamar_present_fase)
  {
   if(fm_pulsado_salto() && !dt_humphrey.temp)
    {
     dt_humphrey.estado=MH_DESPEGUE;
     dt_humphrey.temp=7;
     dt_humphrey.fot=0;
     comprobar_pintadas(1);
     reproducir_sonido(2,0);
     return 1;
    }
   mov_inducido();
   mov_normal();
  }
 comprobar_pintadas(0);

 dibujar_sombra(PRIMERA_SOMBRA_E+4,dt_humphrey.x+3,dt_humphrey.y+37);
 draw_sprite(buffer_juego,(BITMAP *)(f_obj[3*dt_humphrey.dir+dt_humphrey.fot+27].dat),
             dt_humphrey.x-desp,dt_humphrey.y);

 if(dt_humphrey.temp) dt_humphrey.temp--;

 pisando=mapa[pos=((dt_humphrey.x+16)/ANCHO_CELDA)*7+(dt_humphrey.y+16)/ANCHO_CELDA];
 if(pisando<20 && pisando!=15) // No est pisando ni el suelo ni una cinta
  {
   if(pisando==mapa[((dt_humphrey.x+31)/ANCHO_CELDA)*ALTO_VENTANA+(dt_humphrey.y+16)/ANCHO_CELDA] &&
      pisando==mapa[((dt_humphrey.x+31)/ANCHO_CELDA)*ALTO_VENTANA+(dt_humphrey.y+31)/ANCHO_CELDA] &&
      pisando==mapa[((dt_humphrey.x+16)/ANCHO_CELDA)*ALTO_VENTANA+(dt_humphrey.y+31)/ANCHO_CELDA])
    {
     switch(pisando)
      {
       case 2: // Vaco
         {char f,caer=1;
          for(f=0;f<dt_plataformas.num;f++)
            if(dt_humphrey.x+32 >  dt_plataformas.x[f]     &&
               dt_humphrey.x    <  dt_plataformas.x[f]+32  &&
               dt_humphrey.y+32 >  dt_plataformas.y[f]     &&
               dt_humphrey.y    <  dt_plataformas.y[f]+32)
             {caer=0;
              if(dt_humphrey.andando || ant_andando)
               {
                if(dt_plataformas.dir[f]==4)
                 {
                  dt_plataformas.dir[f]=dt_humphrey.dir;
                  dt_plataformas.voz[f]+=100;
                 }
                f=4;
               }
             }
          if(caer)
           {
            parar_musica();
            dt_humphrey.estado=MH_CAIDA_VACIO;
            dt_humphrey.temp=0;
            comprobar_pintadas(1);
           }
         }
         break;
       case 3: // Rayo
         if(dt_rayos.fot>=0 && !trampas)
          {
           parar_musica();
           reproducir_sonido(7,0);
           dt_humphrey.estado=MH_REVENTANDO;
           dt_humphrey.temp=0;
          }
         break;  
       case 4: // Loseta explosiva
        {char num_boom=0;
         for(num_boom=0;num_boom<NUM_BOOMS;num_boom++)
           if(pos==dt_booms.pos[num_boom] && dt_booms.temp[num_boom]==0)
             dt_booms.temp[num_boom]=1;
        }
         break;
       case 5: // No pisar
          {char primer_sonido=1;

           tp_lst *loseta=primera_loseta;
           tp_lst *anterior=NULL;
           tp_brillos *brillos=NULL;
           unsigned short lst,lstfin;

           // Eliminamos los brillos
           while(brillos=primer_brillos)
            {
             primer_brillos=brillos->sig;
             free(brillos);
            }
           // Repasamos la lista de elementos a pintar para invertir la direccin de los
           // que se estn pintando, o borrar los elementos que an no hayan empezado a pintarse.
           while(loseta)
            {
             if(loseta->dir)
              {
               if(loseta->fot<5)
                { // Cambiamos la direccin del elemento
                 loseta->dir=0;
                 loseta->fot=5;
                 anterior=loseta;
                 loseta=loseta->sig;
                }
               else 
                { // Borramos el elemento
                 if(anterior)
                  {
                   anterior->sig=loseta->sig;
                   free(loseta);
                   loseta=anterior->sig;
                  }
                 else
                  {
                   primera_loseta=loseta->sig;
                   free(loseta);
                   loseta=primera_loseta;
                  }
                }
              }
             else
              {
               anterior=loseta;
               loseta=loseta->sig;
              }
            }

           // Ahora recorremos el mapa buscando todas las losetas pintadas que estn a la
           // vista, para aadirlas a la lista.
           lst=(desp/ANCHO_CELDA)*7;
           lstfin=lst+(desp%ANCHO_CELDA?(ANCHO_VENTANA+1)*7:ANCHO_VENTANA*ALTO_VENTANA);
           for(;lst<lstfin;lst++)
             if(mapa[lst]>23)
              {
               loseta=malloc(sizeof(tp_lst));
               loseta->lst=lst;
               loseta->dir=0;
               loseta->fot=5;
               loseta->sig=primera_loseta;
               primera_loseta=loseta;
               mapa[lst]-=4;
               fm_restar_puntos();
               if(primer_sonido)
                {
                 reproducir_sonido(11,0);
                 primer_sonido=0;
                }
            }
          }
         break;
       case  6: // Stop
         mapa[pos]=19;
         pintar(pos,1);
         dt_humphrey.animo=ANIMO_PARALIZ;
         dt_humphrey.contanimo=1320;
         reproducir_sonido(15,0);
         blit(fm_marcador(2),buffer,0,0,x=193,406,ANCHO_CELDA,ANCHO_CELDA);
         blit(fm_marcador(3),buffer,0,0,x+=50,408,15,ANCHO_CELDA);
         blit(fm_marcador(3),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(3),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(4),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(4),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(4),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         break;
       case  8: // Vaso
       case  9: // Botella
         mapa[pos]=19;
         pintar(pos,1);
         reproducir_sonido(25,0);
         if(dt_humphrey.vasbot==10-pisando)
          {
           dt_humphrey.animo=ANIMO_TROMPA;
           dt_humphrey.contanimo=1320;
           dt_humphrey.vasbot=3;
           blit(fm_marcador(0),buffer,0,0,x=193,406,ANCHO_CELDA,ANCHO_CELDA);
           blit(fm_marcador(3),buffer,0,0,x+=50,408,15,ANCHO_CELDA);
           blit(fm_marcador(3),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
           blit(fm_marcador(3),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
           blit(fm_marcador(4),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
           blit(fm_marcador(4),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
           blit(fm_marcador(4),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
           blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
           blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
           blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
           blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
           blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
           blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
          }
         else
           dt_humphrey.vasbot=pisando-7;
         break;
       case 10: // Interruptor
         if(dt_rayos.fot>=0) reproducir_sonido(21,0);
         dt_rayos.fot=-200; // Puede pasar andando por ocho losetas y pico
         break;
       case 11: // Vida extra
         mapa[pos]=19;
         pintar(pos,1);
         if(!trampas)dt_humphrey.vidas++;
         reproducir_sonido(22,0);
         break;
       case 12: // Puntos
         mapa[pos]=19;
         pintar(pos,1);
         fm_sumar_puntos(500);
         reproducir_sonido(24,0);
         break;
       case 13: // Cruz roja
         mapa[pos]=19;
         pintar(pos,1);
         dt_humphrey.animo=ANIMO_TRANQUI;
         dt_humphrey.contanimo=1320;
         reproducir_sonido(23,0);
         blit(fm_marcador(1),buffer,0,0,x=193,406,ANCHO_CELDA,ANCHO_CELDA);
         blit(fm_marcador(3),buffer,0,0,x+=50,408,15,ANCHO_CELDA);
         blit(fm_marcador(3),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(3),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(4),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(4),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(4),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         blit(fm_marcador(5),buffer,0,0,x+=15,408,15,ANCHO_CELDA);
         break;
       case 14: // Teletransportador
         if(ant_andando)
         if(dt_humphrey.x%ANCHO_CELDA==0 && dt_humphrey.y%ANCHO_CELDA==0)
          {
           dt_humphrey.estado=MH_TELETRANS;
           dt_humphrey.dirfot=dt_humphrey.temp=0;
          }
         break;
      }
    }
  }

 return 0;
}

//******************************************************************************
// Funcin mh_despegue()
//    Inicio del salto.
//******************************************************************************
char mh_despegue(void)
{
 static char sigue_saltando=0;

 if(dt_humphrey.temp==5) sigue_saltando=1;
 if(!fm_pulsado_salto()) sigue_saltando=0;

 mov_inducido();
 mov_normal();

 dibujar_sombra(0,dt_humphrey.x+24,dt_humphrey.y+24);
 draw_sprite(buffer_juego,(BITMAP *)(f_obj[38].dat),dt_humphrey.x-desp-7,dt_humphrey.y-7);
 if(!dt_humphrey.temp)
  {
   if(sigue_saltando)
    {
     dt_humphrey.temp=56;
     dt_humphrey.estado=MH_VUELO;
    }
   else
    {
     dt_humphrey.temp=8;
     dt_humphrey.estado=MH_NORMAL;
    }
  }
 else
   dt_humphrey.temp--;

 return 0;
}

//******************************************************************************
// Funcin mh_vuelo()
//    Desarrollo del salto.
//******************************************************************************
char mh_vuelo(void)
{

 if(!dt_humphrey.envenenado) mov_normal();
 dibujar_sombra((dt_humphrey.temp%16>7?0:1),dt_humphrey.x+ANCHO_CELDA,dt_humphrey.y+ANCHO_CELDA);
 draw_sprite(buffer_juego,fm_mapasalto(),dt_humphrey.x-desp-18,dt_humphrey.y-18);
 if(dt_humphrey.temp==56 || dt_humphrey.temp==28)
   reproducir_sonido(3,0);
 if(!dt_humphrey.temp || !fm_pulsado_salto() || (dt_humphrey.envenenado && dt_humphrey.temp<46))
  {
   dt_humphrey.temp=7;
   dt_humphrey.estado=MH_ATERRIZAJE;
  }
 else
   dt_humphrey.temp--;

 return 0;
}

//******************************************************************************
// Funcin mh_aterrizaje()
//    Final del salto.
//******************************************************************************
char mh_aterrizaje(void)
{
 unsigned char obj_p[4];

 if(!dt_humphrey.envenenado) mov_normal();
 dibujar_sombra(0,dt_humphrey.x+24,dt_humphrey.y+24);
 draw_sprite(buffer_juego,(BITMAP *)(f_obj[38].dat),dt_humphrey.x-desp-7,dt_humphrey.y-7);

 if(!dt_humphrey.temp) // Si ha llegado al suelo...
  {
   obj_p[0]=mapa[((dt_humphrey.x+31)/ANCHO_CELDA)*ALTO_VENTANA+(dt_humphrey.y+16)/ANCHO_CELDA];
   obj_p[1]=mapa[((dt_humphrey.x+31)/ANCHO_CELDA)*ALTO_VENTANA+(dt_humphrey.y+31)/ANCHO_CELDA];
   obj_p[2]=mapa[((dt_humphrey.x+16)/ANCHO_CELDA)*ALTO_VENTANA+(dt_humphrey.y+31)/ANCHO_CELDA];
   obj_p[3]=mapa[((dt_humphrey.x+16)/ANCHO_CELDA)*ALTO_VENTANA+(dt_humphrey.y+16)/ANCHO_CELDA];
   if(obj_p[0]==2 && obj_p[1]==2 && obj_p[2]==2 && obj_p[3]==2)
    {char f,caer=1;
     for(f=0;f<dt_plataformas.num;f++)
       if(dt_humphrey.x+32 >  dt_plataformas.x[f]     &&
          dt_humphrey.x    <  dt_plataformas.x[f]+32  &&
          dt_humphrey.y+32 >  dt_plataformas.y[f]     &&
          dt_humphrey.y    <  dt_plataformas.y[f]+32)
        {caer=0;
         if(dt_humphrey.envenenado)
          {
           parar_musica();
           dt_humphrey.estado=MH_REVENTANDO;
           dt_humphrey.temp=0;
           reproducir_sonido(5,0);
          }
         else
          {
           dt_humphrey.temp=8;
           dt_humphrey.estado=MH_NORMAL;
          }
        }
     if(caer)
      {
       parar_musica();
       dt_humphrey.estado=MH_CAIDA_VACIO;
       dt_humphrey.temp=0;
       comprobar_pintadas(1);
      }
    }
   else
    {
     if(dt_humphrey.envenenado)
      {
       parar_musica();
       dt_humphrey.estado=MH_REVENTANDO;
       dt_humphrey.temp=0;
       reproducir_sonido(5,0);
      }
     else
      {
       if(obj_p[0]==14 && obj_p[1]==14 && obj_p[2]==14 && obj_p[3]==14 &&
          dt_humphrey.x%ANCHO_CELDA==0 && dt_humphrey.y%ANCHO_CELDA==0)
        {
         dt_humphrey.dirfot=dt_humphrey.temp=0;
         dt_humphrey.estado=MH_TELETRANS;
        }
       else
        {
         dt_humphrey.temp=8;
         dt_humphrey.estado=MH_NORMAL;
        }
      }
    }
  }
 else
   dt_humphrey.temp--;

 return 0;
}

//******************************************************************************
// Funcin mh_caida_vacio()
//    Caida al vaco.
//******************************************************************************
char mh_caida_vacio(void)
{
 if(dt_humphrey.temp<80)
  {
   float reduccion=80-dt_humphrey.temp;
   int rotacion=dt_humphrey.temp*(dt_humphrey.dir&2?-1:1);
   char db[4];
   unsigned short cx[4];
   unsigned short cy[4];
   reduccion/=100;
   rotacion*=3;

   cx[0]=cx[2]=dt_humphrey.x/ANCHO_CELDA;
   cy[0]=cy[1]=dt_humphrey.y/ANCHO_CELDA;
   cx[1]=cx[3]=(dt_humphrey.x+ANCHO_CELDA-1)/ANCHO_CELDA;
   cy[2]=cy[3]=(dt_humphrey.y+ANCHO_CELDA-1)/ANCHO_CELDA;

   db[0]=mapa[cx[0]*7+cy[0]]==2?1:0;
   db[1]=mapa[cx[1]*7+cy[1]]==2?1:0;
   db[2]=mapa[cx[2]*7+cy[2]]==2?1:0;
   db[3]=mapa[cx[3]*7+cy[3]]==2?1:0;

   cx[0]=cx[2]=cx[2]*ANCHO_CELDA-desp;
   cy[0]=cy[1]*=ANCHO_CELDA;
   cx[1]=cx[3]=cx[3]*ANCHO_CELDA-desp;
   cy[2]=cy[3]*=ANCHO_CELDA;

   // Se comprueba si es el primer fotograma para mover un poco a Humphrey
   // y que no se solape demasiado con los posibles suelos
   if(dt_humphrey.temp==0)
    {
     dt_humphrey.mov_inducido=0;
     if(dt_humphrey.x%ANCHO_CELDA==16 && (!db[1] || !db[3]))
       dt_humphrey.mov_inducido=0x01; 
     if(dt_humphrey.x%ANCHO_CELDA==32 && (!db[0] || !db[2]))
       dt_humphrey.mov_inducido=0x02; 
     if(dt_humphrey.y%ANCHO_CELDA==16 && (!db[2] || !db[3]))
       dt_humphrey.mov_inducido+=0x10; 
     if(dt_humphrey.y%ANCHO_CELDA==32 && (!db[0] || !db[1]))
       dt_humphrey.mov_inducido+=0x20; 
     reproducir_sonido(6,0);
    }
   if(dt_humphrey.temp<4)
    {
     if(dt_humphrey.mov_inducido & 0x01)
       dt_humphrey.x-=2;
     if(dt_humphrey.mov_inducido & 0x02)
       dt_humphrey.x+=2;
     if(dt_humphrey.mov_inducido & 0x10)
       dt_humphrey.y-=2;
     if(dt_humphrey.mov_inducido & 0x20)
       dt_humphrey.y+=2;
    }

   // Se comprueba que partes hay que dibujar.
   if(db[0]+db[1]+db[2]+db[3]<4)
    {
     if(db[0])
      {
       if(db[1]) 
        {
         set_clip(buffer_juego,cx[0],cy[0],cx[1]+ANCHO_CELDA-1,cy[1]+ANCHO_CELDA-1);
         db[1]=0;
        }
       else if(db[2]) 
        {
         set_clip(buffer_juego,cx[0],cy[0],cx[2]+ANCHO_CELDA-1,cy[2]+ANCHO_CELDA-1);
         db[2]=0;
        }
       else
        {
         set_clip(buffer_juego,cx[0],cy[0],cx[0]+ANCHO_CELDA-1,cy[0]+ANCHO_CELDA-1);
        }
       pivot_scaled_sprite(buffer_juego,(BITMAP *)(f_obj[38].dat),
                           dt_humphrey.x-desp+24,dt_humphrey.y+24,31,31,
                           itofix(rotacion),ftofix(reduccion));
      }

     if(db[1])
      {
       if(db[3]) 
        {
         set_clip(buffer_juego,cx[1],cy[1],cx[3]+ANCHO_CELDA-1,cy[3]+ANCHO_CELDA-1);
         db[3]=0;
        }
       else
        {
         set_clip(buffer_juego,cx[1],cy[1],cx[1]+ANCHO_CELDA-1,cy[1]+ANCHO_CELDA-1);
        }
       pivot_scaled_sprite(buffer_juego,(BITMAP *)(f_obj[38].dat),
                           dt_humphrey.x-desp+24,dt_humphrey.y+24,31,31,
                           itofix(rotacion),ftofix(reduccion));
      }

     if(db[2])
      {
       if(db[3]) 
        {
         set_clip(buffer_juego,cx[2],cy[2],cx[3]+ANCHO_CELDA-1,cy[3]+ANCHO_CELDA-1);
         db[3]=0;
        }
       else
        {
         set_clip(buffer_juego,cx[2],cy[2],cx[2]+ANCHO_CELDA-1,cy[2]+ANCHO_CELDA-1);
        }
       pivot_scaled_sprite(buffer_juego,(BITMAP *)(f_obj[38].dat),
                           dt_humphrey.x-desp+24,dt_humphrey.y+24,31,31,
                           itofix(rotacion),ftofix(reduccion));
      }

     if(db[3])
      {
       set_clip(buffer_juego,cx[3],cy[3],cx[3]+ANCHO_CELDA-1,cy[3]+ANCHO_CELDA-1);
       pivot_scaled_sprite(buffer_juego,(BITMAP *)(f_obj[38].dat),
                           dt_humphrey.x-desp+24,dt_humphrey.y+24,31,31,
                           itofix(rotacion),ftofix(reduccion));
      }

     set_clip(buffer_juego,0,0,ANCHO_CELDA*ANCHO_VENTANA-1,ANCHO_CELDA*ALTO_VENTANA-1);

    }
   else // Solo toca espacio
     pivot_scaled_sprite(buffer_juego,(BITMAP *)(f_obj[38].dat),
                         dt_humphrey.x-desp+24,dt_humphrey.y+24,31,31,
                         itofix(rotacion),ftofix(reduccion));
 }

 if(dt_humphrey.temp<140)
   dt_humphrey.temp++;
 else
  {
   if(!trampas)dt_humphrey.vidas--;
   reiniciar=1;
  }

 return 0;
}

//******************************************************************************
// Funcin mh_reventando()
//    Humphrey explota.
//******************************************************************************
char mh_reventando(void)
{
 if(dt_humphrey.temp<16)
   draw_sprite(buffer_juego,(BITMAP *)(f_obj[3*dt_humphrey.dir+dt_humphrey.fot+27].dat),
               dt_humphrey.x-desp,dt_humphrey.y);
 if(dt_humphrey.temp<20)
   draw_sprite(buffer_juego,fm_expl(dt_humphrey.temp/4),dt_humphrey.x-desp,dt_humphrey.y);
 if(dt_humphrey.temp<150)
   dt_humphrey.temp++;
 else
  {
   if(!trampas)dt_humphrey.vidas--;
   reiniciar=1;
  }

 return 0;
}

//******************************************************************************
// Funcin mh_teletrans()
//    Teletransporte.
//******************************************************************************
char mh_teletrans(void)
{
 int ny;

 switch(dt_humphrey.dirfot)
  {
   case 0: // Aparece la aspiradora
     dibujar_sombra(PRIMERA_SOMBRA_E+4,dt_humphrey.x+3,dt_humphrey.y+37);
     draw_sprite(buffer_juego,(BITMAP *)(f_obj[3*dt_humphrey.dir+dt_humphrey.fot+27].dat),
                 dt_humphrey.x-desp,dt_humphrey.y);
     if(dt_humphrey.y>3*ANCHO_CELDA)
       ny=dt_humphrey.y-3*ANCHO_CELDA/2-60+dt_humphrey.temp*3;
     else
       ny=dt_humphrey.y+ANCHO_CELDA/2+60-dt_humphrey.temp*3;
     if(dt_humphrey.temp<15)
      {
       set_trans_blender(0,0,0,dt_humphrey.temp*17);
       draw_trans_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?0:3),
                         dt_humphrey.x-desp,ny);
       set_trans_blender(0,0,0,180);
      }
     else
       draw_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?0:3),dt_humphrey.x-desp,ny);
     if(dt_humphrey.temp==20)
      {
       dt_humphrey.dirfot=1;
       dt_humphrey.temp=0;
      }
     else
      {
       dt_humphrey.temp++;
       if(dt_humphrey.temp==1) reproducir_sonido(16,0);
      }
     break;

   case 1: // Humphrey vibra
      {int dx=((rand()%3)-1)*2;
       int dy=((rand()%3)-1)*2;
       dibujar_sombra(PRIMERA_SOMBRA_E+4,dt_humphrey.x+3+dx,dt_humphrey.y+37+dy);
       draw_sprite(buffer_juego,(BITMAP *)(f_obj[3*dt_humphrey.dir+dt_humphrey.fot+27].dat),
                   dt_humphrey.x-desp+dx,dt_humphrey.y+dy);
      }
     draw_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?0:3),dt_humphrey.x-desp,
                 dt_humphrey.y+(dt_humphrey.y>3*ANCHO_CELDA?-3*ANCHO_CELDA/2:ANCHO_CELDA/2));
     if(dt_humphrey.temp==20)
      {
       reproducir_sonido(17,0);
       dt_humphrey.dirfot=2;
       dt_humphrey.temp=0;
      }
     else
      dt_humphrey.temp++;
     break;

   case 2: // La aspiradora absorbe a Humphrey
     if(dt_humphrey.temp<7)
      {
       dibujar_sombra(PRIMERA_SOMBRA_E+4,dt_humphrey.x+3,
                      dt_humphrey.y+37+(dt_humphrey.y>3*ANCHO_CELDA?-ANCHO_CELDA/4:ANCHO_CELDA/4));
       draw_sprite(buffer_juego,(BITMAP *)(f_obj[3*dt_humphrey.dir+dt_humphrey.fot+27].dat),dt_humphrey.x-desp,
                   dt_humphrey.y+(dt_humphrey.y>3*ANCHO_CELDA?-ANCHO_CELDA/4:ANCHO_CELDA/4));
       draw_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?0:3),dt_humphrey.x-desp,
                   dt_humphrey.y+(dt_humphrey.y>3*ANCHO_CELDA?-3*ANCHO_CELDA/2:ANCHO_CELDA/2));
      }
     else if(dt_humphrey.temp<14)
      {
       draw_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?1:4),dt_humphrey.x-desp,
                   dt_humphrey.y+(dt_humphrey.y>3*ANCHO_CELDA?-3*ANCHO_CELDA/2:ANCHO_CELDA/2));
      }
     else if(dt_humphrey.temp<20)
      {
       draw_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?2:5),dt_humphrey.x-desp,
                   dt_humphrey.y+(dt_humphrey.y>3*ANCHO_CELDA?-3*ANCHO_CELDA/2:ANCHO_CELDA/2));
      }
     else
      {
       if(dt_humphrey.y>3*ANCHO_CELDA)
         ny=dt_humphrey.y-3*ANCHO_CELDA/2-(dt_humphrey.temp-20)*3;
       else
         ny=dt_humphrey.y+ANCHO_CELDA/2+(dt_humphrey.temp-20)*3;
       if(dt_humphrey.temp<27)
        {
         draw_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?2:5),
                     dt_humphrey.x-desp,ny);
        }
       else
        {
         set_trans_blender(0,0,0,255-(dt_humphrey.temp-27)*17);
         draw_trans_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?2:5),
                           dt_humphrey.x-desp,ny);
         set_trans_blender(0,0,0,180);
        }
      }

     if(dt_humphrey.temp==40)
      {
       char encontrado=0;
       unsigned short pos=(dt_humphrey.x/ANCHO_CELDA)*7+dt_humphrey.y/ANCHO_CELDA;
       unsigned short npos=pos-7;
       unsigned short ndesp=ANCHO_CELDA;

       // Buscamos la otra loseta de teletransporte hacia la izquierda
       while(npos>6 && !encontrado)
        {
         if(mapa[npos]!=14)
          {
           ndesp+=ANCHO_CELDA;
           npos-=7;
          }
         else
           encontrado=-1;
        }

       // Buscamos la otra loseta de teletransporte hacia la derecha
       if(!encontrado)
        {
         npos=pos+7;
         ndesp=ANCHO_CELDA;
         while(!encontrado)
          {
           if(mapa[npos]!=14)
            {
             ndesp+=ANCHO_CELDA;
             npos+=7;
            }
           else
             encontrado=1;
          }
        }  

       if(encontrado<0)
         desp=(desp>ndesp?desp-ndesp:0);
       else
         desp=(desp+ndesp<max_desp?desp+ndesp:max_desp);
       dt_humphrey.x=(npos/7)*ANCHO_CELDA;
       dt_humphrey.dirfot=3;
       dt_humphrey.temp=0;
      }
     else
      dt_humphrey.temp++;
     break;

   case 3: // La aspiradora aparece en el destino
     if(dt_humphrey.y>3*ANCHO_CELDA)
       ny=dt_humphrey.y-3*ANCHO_CELDA/2-60+dt_humphrey.temp*3;
     else
       ny=dt_humphrey.y+ANCHO_CELDA/2+60-dt_humphrey.temp*3;
     if(dt_humphrey.temp<15)
      {
       set_trans_blender(0,0,0,dt_humphrey.temp*17);
       draw_trans_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?2:5),
                         dt_humphrey.x-desp,ny);
       set_trans_blender(0,0,0,180);
      }
     else
       draw_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?2:5),
                   dt_humphrey.x-desp,ny);
     if(dt_humphrey.temp==20)
      {
       dt_humphrey.dirfot=4;
       dt_humphrey.temp=40;
      }
     else
       dt_humphrey.temp++;
     break;

   case 4: // La aspiradora escupe a Humphrey
     if(dt_humphrey.temp<7)
      {
       if(dt_humphrey.temp==6) reproducir_sonido(18,0);
       dibujar_sombra(PRIMERA_SOMBRA_E+4,dt_humphrey.x+3,
                      dt_humphrey.y+37+(dt_humphrey.y>3*ANCHO_CELDA?-ANCHO_CELDA/4:ANCHO_CELDA/4));
       draw_sprite(buffer_juego,(BITMAP *)(f_obj[3*dt_humphrey.dir+dt_humphrey.fot+27].dat),dt_humphrey.x-desp,
                   dt_humphrey.y+(dt_humphrey.y>3*ANCHO_CELDA?-ANCHO_CELDA/4:ANCHO_CELDA/4));
       draw_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?0:3),dt_humphrey.x-desp,
                   dt_humphrey.y+(dt_humphrey.y>3*ANCHO_CELDA?-3*ANCHO_CELDA/2:ANCHO_CELDA/2));
      }
     else if(dt_humphrey.temp<14)
       draw_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?1:4),dt_humphrey.x-desp,
                   dt_humphrey.y+(dt_humphrey.y>3*ANCHO_CELDA?-3*ANCHO_CELDA/2:ANCHO_CELDA/2));
     else
       draw_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?2:5),dt_humphrey.x-desp,
                   dt_humphrey.y+(dt_humphrey.y>3*ANCHO_CELDA?-3*ANCHO_CELDA/2:ANCHO_CELDA/2));

     if(dt_humphrey.temp)
       dt_humphrey.temp--;
     else
      {
       dt_humphrey.dirfot=5;
       dt_humphrey.temp=20;
      }
     break;

   case 5: // La aspiradora desaparece
     dibujar_sombra(PRIMERA_SOMBRA_E+4,dt_humphrey.x+3,dt_humphrey.y+37);
     draw_sprite(buffer_juego,(BITMAP *)(f_obj[3*dt_humphrey.dir+dt_humphrey.fot+27].dat),
                 dt_humphrey.x-desp,dt_humphrey.y);
     if(dt_humphrey.y>3*ANCHO_CELDA)
       ny=dt_humphrey.y-3*ANCHO_CELDA/2-60+dt_humphrey.temp*3;
     else
       ny=dt_humphrey.y+ANCHO_CELDA/2+60-dt_humphrey.temp*3;
     if(dt_humphrey.temp<15)
      {
       set_trans_blender(0,0,0,dt_humphrey.temp*17);
       draw_trans_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?0:3),
                         dt_humphrey.x-desp,ny);
       set_trans_blender(0,0,0,180);
      }
     else
       draw_sprite(buffer_juego,fm_aspiradora(dt_humphrey.y>3*ANCHO_CELDA?0:3),
                   dt_humphrey.x-desp,ny);
     if(dt_humphrey.temp)
       dt_humphrey.temp--;
     else
      {
       dt_humphrey.fot=0;
       dt_humphrey.dirfot=1;
       dt_humphrey.temp=8;
       dt_humphrey.estado=MH_NORMAL;
      }
     break;
  }
 return 0;
}

//*******************************************************\\
//  Funciones auxiliares para el movimiento de Humphrey  \\
//*******************************************************\\

//******************************************************************************
// Funcin mov_inducido()
//    Aplica a Humphrey el movimiento inducido por las cintas transportadoras
//    o las plataformas mviles.
//******************************************************************************
void mov_inducido(void)
{
 if(dt_humphrey.mov_inducido & 0x0f)
  {
   if(puede_mover_h(dt_humphrey.mov_inducido >> 4))
     switch(dt_humphrey.mov_inducido & 0xf0)
      {
       case 0x00:
         dt_humphrey.y-=2;
         break;
       case 0x10:
         dt_humphrey.x+=2;
         break;
       case 0x20:
         dt_humphrey.y+=2;
         break;
       case 0x30:
         dt_humphrey.x-=2;
         break;
      }
   dt_humphrey.mov_inducido--;
  }
}

//******************************************************************************
// Funcin mov_normal()
//    Mueve a Humphrey segn lo indicado por el teclado o el joystick/joypad.
//******************************************************************************
void mov_normal(void)
{
 if(dt_humphrey.andando)
  {
   if(dt_humphrey.andando==4)
    {
     dt_humphrey.fot=0;
     dt_humphrey.dirfot*=-1;
     if(dt_humphrey.estado==MH_NORMAL)
       reproducir_sonido(dt_humphrey.dirfot>0?0:1,0);
    }
   dt_humphrey.andando++;
   if(dt_humphrey.andando==8)
     dt_humphrey.andando=0;
   if(puede_mover_h(dt_humphrey.dir))
     switch(dt_humphrey.dir)
      {
       case 0:
         dt_humphrey.y-=2;
         break;
       case 1:
         dt_humphrey.x+=2;
         break;
       case 2:
         dt_humphrey.y+=2;
         break;
       case 3:
         dt_humphrey.x-=2;
         break;
      }
  }
 else // Est parado, as que comprobamos la entrada del jugador.
  {
   if(tcj_estado[TCJ_ARR] && puede_mover_h(0))
    {
     dt_humphrey.dir=0;
     dt_humphrey.andando=1;
     dt_humphrey.fot=dt_humphrey.dirfot;
     dt_humphrey.y-=2;
    }
   else if(tcj_estado[TCJ_DER] && puede_mover_h(1))
    {
     dt_humphrey.dir=1;
     dt_humphrey.andando=1;
     dt_humphrey.fot=dt_humphrey.dirfot;
     dt_humphrey.x+=2;
    }
   else if(tcj_estado[TCJ_ABJ] && puede_mover_h(2))
    {
     dt_humphrey.dir=2;
     dt_humphrey.andando=1;
     dt_humphrey.fot=dt_humphrey.dirfot;
     dt_humphrey.y+=2;
    }
   else if(tcj_estado[TCJ_IZQ] && puede_mover_h(3))
    {
     dt_humphrey.dir=3;
     dt_humphrey.andando=1;
     dt_humphrey.fot=dt_humphrey.dirfot;
     dt_humphrey.x-=2;
    }
  }
}

//******************************************************************************
// Funcin puede_mover_h()
//    Comprueba si Humphrey se puede mover en una direccin determinada.
//******************************************************************************
char puede_mover_h(char dir)
{
 int x0,x1,y0,y1;
 switch(dir)
  {
   case 0:
     if(dt_humphrey.y==0) return 0;
     x0=dt_humphrey.x/ANCHO_CELDA;
     x1=(dt_humphrey.x+ANCHO_CELDA-1)/ANCHO_CELDA;
     y0=(dt_humphrey.y-1)/ANCHO_CELDA;
     if(mapa[x0*7+y0]==0 || mapa[x1*7+y0]==0) return 0;
     break;
   case 1:
     if(dt_humphrey.x==buffer_mapa->w-ANCHO_CELDA*2) return 0;
     x0=(dt_humphrey.x+ANCHO_CELDA)/ANCHO_CELDA;
     y0=dt_humphrey.y/ANCHO_CELDA;
     y1=(dt_humphrey.y+ANCHO_CELDA-1)/ANCHO_CELDA;
     if(mapa[x0*7+y0]==0 || mapa[x0*7+y1]==0) return 0;
     break;
   case 2:
     if(dt_humphrey.y==288) return 0;
     x0=(dt_humphrey.x)/ANCHO_CELDA;
     x1=(dt_humphrey.x+ANCHO_CELDA-1)/ANCHO_CELDA;
     y0=(dt_humphrey.y+ANCHO_CELDA)/ANCHO_CELDA;
     if(mapa[x0*7+y0]==0 || mapa[x1*7+y0]==0) return 0;
     break;
   case 3:
     if(dt_humphrey.x==ANCHO_CELDA) return 0;
     x0=(dt_humphrey.x-1)/ANCHO_CELDA;
     y0=dt_humphrey.y/ANCHO_CELDA;
     y1=(dt_humphrey.y+ANCHO_CELDA-1)/ANCHO_CELDA;
     if(mapa[x0*7+y0]==0 || mapa[x0*7+y1]==0) return 0;
     break;

  }
 return 1;
}

//******************************************************************************
// Funcin comprobar_pintadas(...)
//    Comprueba las losetas que Humphrey estaba pisando en el instante anterior,
//    para ver si hay que pintar alguna.
//******************************************************************************
void comprobar_pintadas(char todas)
{
 unsigned short np[4];
 char f;

 if(todas)
  {
   np[0]=np[1]=np[2]=np[3]=0;
  }
 else
  {
   np[0]=( dt_humphrey.x               /ANCHO_CELDA)*7 +  dt_humphrey.y               /ANCHO_CELDA;
   np[1]=((dt_humphrey.x+ANCHO_CELDA-1)/ANCHO_CELDA)*7 +  dt_humphrey.y               /ANCHO_CELDA;
   np[2]=( dt_humphrey.x               /ANCHO_CELDA)*7 + (dt_humphrey.y+ANCHO_CELDA-1)/ANCHO_CELDA;
   np[3]=((dt_humphrey.x+ANCHO_CELDA-1)/ANCHO_CELDA)*7 + (dt_humphrey.y+ANCHO_CELDA-1)/ANCHO_CELDA;
  }

 for(f=0;f<4;f++)
  {
   if(np[0]!=dt_humphrey.pisando[f] && np[1]!=dt_humphrey.pisando[f] &&
      np[2]!=dt_humphrey.pisando[f] && np[3]!=dt_humphrey.pisando[f] &&
      mapa[dt_humphrey.pisando[f]]>19 && mapa[dt_humphrey.pisando[f]]<24)
     pintar(dt_humphrey.pisando[f],1);
   dt_humphrey.pisando[f]=np[f];
  }
}

//******************************************************************************
// Funcin pintar(...)
//    Aade una loseta a la lista de suelos a pintar o despintar.
//******************************************************************************
void pintar(unsigned short nlst, char dir)
{
 tp_lst *loseta=primera_loseta;
 
 // Comprobamos que no estamos pintando ya la loseta
 while(loseta)
  {
   if(loseta->lst==nlst) break;
   loseta=loseta->sig;
  }

 if(!loseta)
  { // No la estamos pintando
   loseta=malloc(sizeof(tp_lst));
   loseta->lst=nlst;
   loseta->fot=5;
   loseta->dir=dir;
   loseta->sig=primera_loseta;
   primera_loseta=loseta;
   if(mapa[nlst]>19) fm_sumar_puntos(5);
  }
}

//*******************************************\\
//  Funciones de movimiento de los enemigos  \\
//*******************************************\\

//******************************************************************************
// Funcin mover_enemigos()
//    Mueve los enemigos.
//******************************************************************************
void mover_enemigos(void)
{
 char f;
 void (*funcion_enemigo[6])(char)={enem_mov_x,enem_mov_x_a,enem_mov_xy,
                                   enem_mov_xy_a,enem_mov_xy_b,enem_mov_xy_a};
 if(dt_enemigos.sec>0) // Se acaba de comenzar, y an no han aparecido los enemigos
  {
   if(dt_enemigos.sec==1)
     dt_enemigos.sec=-20;
   else
     dt_enemigos.sec--;
  }
 else if(dt_enemigos.sec>-5 && dt_enemigos.sec!=0) // Los enemigos estn apareciendo (se ve al enemigo bajo el humo)
  {
   for(f=0;f<dt_enemigos.num;f++)
    {
     if(dt_enemigos.estado[f]==E_ESTADO_NORMAL)
      {
       draw_trans_sprite(buffer_juego,(BITMAP *)(f_obj[PRIMERA_SOMBRA_E+4].dat),
                         dt_enemigos.x[f]-desp+3,dt_enemigos.y[f]+37);

       (dt_enemigos.invertir[f]?draw_sprite_h_flip:draw_sprite)
            (buffer_juego,m_enemigo[dt_enemigos.fot[f]],dt_enemigos.x[f]-desp,dt_enemigos.y[f]);

       draw_sprite(buffer_juego,fm_expl((20+dt_enemigos.sec)/4),
                   dt_enemigos.x[f]-desp,dt_enemigos.y[f]);
      }
    }
   dt_enemigos.sec++;
  }
 else if(dt_enemigos.sec<0) // Los enemigos estn apareciendo (solo se ve el humo)
  {
   for(f=0;f<dt_enemigos.num;f++)
     if(dt_enemigos.estado[f]==E_ESTADO_NORMAL)
       draw_sprite(buffer_juego,fm_expl((20+dt_enemigos.sec)/4),dt_enemigos.x[f]-desp,dt_enemigos.y[f]);
   dt_enemigos.sec++;
  }
 else
  {
   for(f=0;f<dt_enemigos.num;f++)
    {
     if(dt_enemigos.estado[f]==E_ESTADO_REVENT)
      {
       if(dt_enemigos.temp[f]<16)
        {
         draw_trans_sprite(buffer_juego,(BITMAP *)(f_obj[PRIMERA_SOMBRA_E+4].dat),
                           dt_enemigos.x[f]-desp+3,dt_enemigos.y[f]+37);

         (dt_enemigos.invertir[f]?draw_sprite_h_flip:draw_sprite)
             (buffer_juego,m_enemigo[dt_enemigos.fot[f]],dt_enemigos.x[f]-desp,dt_enemigos.y[f]);
        }
       if(dt_enemigos.temp[f]<20)
        {
         draw_sprite(buffer_juego,fm_expl(dt_enemigos.temp[f]/4),
                     dt_enemigos.x[f]-desp,dt_enemigos.y[f]);
         dt_enemigos.temp[f]++;
        }
       else
         dt_enemigos.estado[f]=E_ESTADO_MUERTO;
      }

     if(dt_enemigos.estado[f]==E_ESTADO_NORMAL)
      {
       if(dt_humphrey.estado==MH_NORMAL && dt_humphrey.animo!=ANIMO_TRANQUI)
         if(detec_colis[modo_truecolor]((BITMAP *)(f_obj[3*dt_humphrey.dir+dt_humphrey.fot+27].dat),dt_humphrey.x,dt_humphrey.y,
                        m_enemigo[dt_enemigos.fot[f]],dt_enemigos.x[f],dt_enemigos.y[f],dt_enemigos.invertir[f]))
          {
           if(dt_humphrey.animo==ANIMO_TROMPA)
            {
             dt_enemigos.estado[f]=E_ESTADO_REVENT;
             dt_enemigos.temp[f]=0;
             fm_sumar_puntos(500);
             reproducir_sonido(26,0);
            }
           else
            {
             if(!trampas)
              {
               parar_musica();
               dt_humphrey.estado=MH_REVENTANDO;
               dt_humphrey.temp=0;
               reproducir_sonido(5,0);
              }
            }
          }

       if(dt_humphrey.animo!=ANIMO_PARALIZ)
        {
         funcion_enemigo[dt_enemigos.comportamiento[f]](f);
         if(dt_enemigos.temp[f]==CAMBIAR_FOT)
          {
           dt_enemigos.temp[f]=0;
           if(dt_enemigos.fot[f]&1)
             dt_enemigos.fot[f]--;
           else
             dt_enemigos.fot[f]++;
          }
         else
           dt_enemigos.temp[f]++;
        }
       draw_trans_sprite(buffer_juego,(BITMAP *)(f_obj[PRIMERA_SOMBRA_E+4].dat),
                         dt_enemigos.x[f]-desp+3,dt_enemigos.y[f]+37);

       (dt_enemigos.invertir[f]?draw_sprite_h_flip:draw_sprite)
          (buffer_juego,m_enemigo[dt_enemigos.fot[f]],dt_enemigos.x[f]-desp,dt_enemigos.y[f]);
      }
    }
  }
}

//******************************************************************************
// Funcin enem_mov_x(...)
//    Controla el movimiento de los enemigos que se mueven en el eje x.
//******************************************************************************
void enem_mov_x(char f)
{
 // Comprobamos si hay que cambiar de sentido.
 if(!(dt_enemigos.x[f]%ANCHO_CELDA))
  {unsigned char np=mapa[(dt_enemigos.x[f]/ANCHO_CELDA)*7+dt_enemigos.y[f]/ANCHO_CELDA+(dt_enemigos.invertir[f]?7:-7)];
   if(np==0 || np==2 || np==14 || np==15)
     dt_enemigos.invertir[f]=1-dt_enemigos.invertir[f];
  }

 // Movemos el enemigo.
 dt_enemigos.x[f]+=4*dt_enemigos.invertir[f]-2;
}

//******************************************************************************
// Funcin enem_mov_x_a(...)
//    Controla el movimiento de los enemigos que se mueven en el eje x,
//    acelerando cuando ven a Humphrey.
//******************************************************************************
void enem_mov_x_a(char f)
{
 char dx=0;
 // Movemos el enemigo.
 enem_mov_x(f);

 // Comprobamos si se acelera.
 if((dt_enemigos.x[f]/2)&1)
 if(dt_humphrey.estado==MH_NORMAL)
 if(dt_humphrey.y>dt_enemigos.y[f]-ANCHO_CELDA && dt_humphrey.y<dt_enemigos.y[f]+ANCHO_CELDA)
  {
   if(dt_enemigos.invertir[f])
    {
     if(dt_humphrey.x>dt_enemigos.x[f])
       dx=2;
    }
   else
    {
     if(dt_humphrey.x<dt_enemigos.x[f])
       dx=-2;
    }
  }

 if(dx)
  {
   dt_enemigos.x[f]+=dx;
   if(dt_enemigos.temp[f]==CAMBIAR_FOT)
    {
     dt_enemigos.temp[f]=0;
     if(dt_enemigos.fot[f]&1)
       dt_enemigos.fot[f]--;
     else
       dt_enemigos.fot[f]++;
    }
   else
     dt_enemigos.temp[f]++;
  }
}

//******************************************************************************
// Funcin enem_mov_xy(...)
//    Controla el movimiento de los enemigos que se mueven libremente en los
//    ejes x e y.
//******************************************************************************
void enem_mov_xy(char f)
{
 char despx,despy,acelerando;

 if(dt_enemigos.dir[f]>3)
  {
   dt_enemigos.dir[f]-=4;
   acelerando=1;
  }
 else
   acelerando=0;

 // Comprobamos si hay que cambiar de sentido.
 if(!(dt_enemigos.x[f]%ANCHO_CELDA) && !(dt_enemigos.y[f]%ANCHO_CELDA))
  {char no_puede_mover[3];
   char nueva_dir[3];
   short pos=(dt_enemigos.x[f]/ANCHO_CELDA)*7+dt_enemigos.y[f]/ANCHO_CELDA;
   
   nueva_dir[0]=dt_enemigos.dir[f];
   if(dt_enemigos.dir[f])
     nueva_dir[1]=dt_enemigos.dir[f]-1;
   else
     nueva_dir[1]=3;
   if(dt_enemigos.dir[f]<3)
     nueva_dir[2]=dt_enemigos.dir[f]+1;
   else
     nueva_dir[2]=0;
   no_puede_mover[0]=enem_no_puede_mover(pos,nueva_dir[0]);
   no_puede_mover[1]=enem_no_puede_mover(pos,nueva_dir[1]);
   no_puede_mover[2]=enem_no_puede_mover(pos,nueva_dir[2]);
   if(no_puede_mover[0] && no_puede_mover[1] && no_puede_mover[2])
    {
     dt_enemigos.dir[f]+=(dt_enemigos.dir[f]<2?2:-2);
    }
   else
    {char n;
     do
      {
       if(acelerando)
         acelerando=n=0;
       else
         n=(rand()%7)%3;
      }while(no_puede_mover[n]);
     dt_enemigos.dir[f]=nueva_dir[n];
    }
   if(dt_enemigos.dir[f]==1) dt_enemigos.invertir[f]=1;
   if(dt_enemigos.dir[f]==3) dt_enemigos.invertir[f]=0;
  }

 // Movemos el enemigo.
 if(dt_enemigos.dir[f]&1)
  {despx=2;despy=0;}
 else
  {despx=0;despy=2;}
 if(dt_enemigos.dir[f]&2)
  {despx*=-1;}
 else
  {despy*=-1;}
 dt_enemigos.x[f]+=despx;
 dt_enemigos.y[f]+=despy;
}

//******************************************************************************
// Funcin enem_mov_xy_a(...)
//    Controla el movimiento de los enemigos que se mueven libremente en los
//    ejes x e y, acelerando cuando ven a Humphrey.
//******************************************************************************
void enem_mov_xy_a(char f)
{
 char nx=0,ny=0;

 // Movemos el enemigo.
 if(dt_enemigos.comportamiento[f]==3)
   enem_mov_xy(f);
 else
   enem_mov_xy_b(f);

 // Comprobamos si se acelera.
 if((dt_enemigos.x[f]/2)&1)
 if(dt_humphrey.estado==MH_NORMAL)
 if(dt_humphrey.y>dt_enemigos.y[f]-ANCHO_CELDA && dt_humphrey.y<dt_enemigos.y[f]+ANCHO_CELDA)
  {
   if(dt_enemigos.dir[f]==1)
    {
     if(dt_humphrey.x>dt_enemigos.x[f])
       nx=2;
    }
   else
    {
     if(dt_humphrey.x<dt_enemigos.x[f])
       nx=-2;
    }
  }
 
 if((dt_enemigos.y[f]/2)&1)
 if(dt_humphrey.x>dt_enemigos.x[f]-ANCHO_CELDA && dt_humphrey.x<dt_enemigos.x[f]+ANCHO_CELDA)
  {
   if(dt_enemigos.dir[f]==2)
    {
     if(dt_humphrey.y>dt_enemigos.y[f])
       ny=+2;
    }
   else
    {
     if(dt_humphrey.y<dt_enemigos.y[f])
       ny=-2;
    }
  }

 if(nx || ny)
  {
   dt_enemigos.dir[f]+=4;
   dt_enemigos.x[f]+=nx;
   dt_enemigos.y[f]+=ny;
   if(dt_enemigos.temp[f]==CAMBIAR_FOT)
    {
     dt_enemigos.temp[f]=0;
     if(dt_enemigos.fot[f]&1)
       dt_enemigos.fot[f]--;
     else
       dt_enemigos.fot[f]++;
    }
   else
     dt_enemigos.temp[f]++;
  }
}

//******************************************************************************
// Funcin enem_mov_xy_b(...)
//    Controla el movimiento de los enemigos que se mueven libremente en los
//    ejes x e y, buscando a Humphrey.
//******************************************************************************
void enem_mov_xy_b(char f)
{
 int despx,despy;

 if(dt_humphrey.estado!=MH_NORMAL)
   enem_mov_xy(f);
 else
  {
   if(dt_enemigos.dir[f]>3)
    {
     dt_enemigos.dir[f]-=4;
    }

   // Comprobamos si hay que cambiar de sentido.
   if(!(dt_enemigos.x[f]%ANCHO_CELDA) && !(dt_enemigos.y[f]%ANCHO_CELDA))
    {char no_puede_mover[3];
     char nueva_dir[3];
     short pos=(dt_enemigos.x[f]/ANCHO_CELDA)*7+dt_enemigos.y[f]/ANCHO_CELDA;
     char n=rand()%3;
   
     nueva_dir[n]=dt_enemigos.dir[f];
     n=(n==2?0:n+1);
     if(dt_enemigos.dir[f])
       nueva_dir[n]=dt_enemigos.dir[f]-1;
     else
       nueva_dir[n]=3;
     n=(n==2?0:n+1);
     if(dt_enemigos.dir[f]<3)
       nueva_dir[n]=dt_enemigos.dir[f]+1;
     else
       nueva_dir[n]=0;

     no_puede_mover[0]=enem_no_puede_mover(pos,nueva_dir[0]);
     no_puede_mover[1]=enem_no_puede_mover(pos,nueva_dir[1]);
     no_puede_mover[2]=enem_no_puede_mover(pos,nueva_dir[2]);
     if(no_puede_mover[0] && no_puede_mover[1] && no_puede_mover[2])
      {
       dt_enemigos.dir[f]+=(dt_enemigos.dir[f]<2?2:-2);
      }
     else
      {int mindist;
       int distancia[3];

       for(n=0;n<3;n++)
         if(no_puede_mover[n])
           distancia[n]=dt_humphrey.animo!=ANIMO_TROMPA ? 1000000 : -1;
         else
          {
           if(nueva_dir[n]&1)
            {despx=ANCHO_CELDA;despy=0;}
           else
            {despx=0;despy=ANCHO_CELDA;}
           if(nueva_dir[n]&2)
            {despx*=-1;}
           else
            {despy*=-1;}
           despx+=dt_enemigos.x[f];
           despy+=dt_enemigos.y[f];

           if(despx>dt_humphrey.x)
             distancia[n]=despx-dt_humphrey.x;
           else
             distancia[n]=dt_humphrey.x-despx;
           if(despy>dt_humphrey.y)
             distancia[n]+=despy-dt_humphrey.y;
           else
             distancia[n]+=dt_humphrey.y-despy;
          }

       if(dt_humphrey.animo!=ANIMO_TROMPA)
        {
         if(distancia[0]<distancia[1])
           mindist=distancia[n=0];
         else
           mindist=distancia[n=1];
         dt_enemigos.dir[f]=nueva_dir[distancia[2]<mindist?2:n];
        }
       else
        {
         if(distancia[0]>distancia[1])
           mindist=distancia[n=0];
         else
           mindist=distancia[n=1];
         dt_enemigos.dir[f]=nueva_dir[distancia[2]>mindist?2:n];
        }

      }
     if(dt_enemigos.dir[f]==1) dt_enemigos.invertir[f]=1;
     if(dt_enemigos.dir[f]==3) dt_enemigos.invertir[f]=0;
    }

   // Movemos el enemigo.
   if(dt_enemigos.dir[f]&1)
    {despx=2;despy=0;}
   else
    {despx=0;despy=2;}
   if(dt_enemigos.dir[f]&2)
    {despx*=-1;}
   else
    {despy*=-1;}
   dt_enemigos.x[f]+=despx;
   dt_enemigos.y[f]+=despy;
  }
}

//******************************************************************************
// Funcin enem_no_puede_mover(...)
//    Comprueba si un enemigo en la posicin indicada no puede moverse en la
//    direccin especificada.
//******************************************************************************
char enem_no_puede_mover(short pos, char dir)
{
 char desp=pos%7;

 if(dir==0 && desp==0) return 1;
 if(dir==2 && desp==6) return 1;

 if(dir&1)
  desp=7;
 else
  desp=1;
 if(dir==0 || dir==3)
  pos=mapa[pos-desp];
 else
  pos=mapa[pos+desp];
 
 if(pos==0 || pos==2 || pos==14 || pos==15) return 1;
 return 0;
}

//******************************************************************************
// Funcin mover_mojcas(...)
//    Mueve las mojcas.
//******************************************************************************
void mover_mojcas(char sombra)
{
 char f;
 char invertir[NUM_MOJCAS];
 static char sombras_dibujadas=0;
 
 for(f=juego_facil;f<NUM_MOJCAS;f++)
  {
   invertir[f]=dt_mojcas.x[f]<dt_mojcas.xd[f]?1:0;
   if(!sombras_dibujadas)
     dibujar_sombra(PRIMERA_SOMBRA_E+dt_mojcas.fot[f]+(invertir[f]?2:0),
                    dt_mojcas.x[f]+ANCHO_CELDA,dt_mojcas.y[f]+ANCHO_CELDA);
  }

 if(!sombra)
 for(f=juego_facil;f<NUM_MOJCAS;f++)
  {
   if(dt_mojcas.temp[f]==CAMBIAR_FMOJCA)
    {
     dt_mojcas.fot[f]=(dt_mojcas.fot[f]?0:1);
     dt_mojcas.temp[f]=0;
    }
   else
     dt_mojcas.temp[f]++;

   if(invertir[f])
    {
     draw_sprite_h_flip(buffer_juego,m_enemigo[dt_mojcas.fot[f]],dt_mojcas.x[f]-desp,dt_mojcas.y[f]);
     dt_mojcas.x[f]+=2;
    }
   else
    {
     draw_sprite(buffer_juego,m_enemigo[dt_mojcas.fot[f]],dt_mojcas.x[f]-desp,dt_mojcas.y[f]);
     dt_mojcas.x[f]-=2;
    }

   if(!trampas && dt_humphrey.estado==MH_VUELO && !dt_humphrey.envenenado) 
       if(detec_colis[modo_truecolor](fm_mapasalto(),dt_humphrey.x-18,dt_humphrey.y-18,
                      m_enemigo[dt_mojcas.fot[f]],dt_mojcas.x[f],dt_mojcas.y[f],invertir[f]))
        {
         reproducir_sonido(4,0);
         dt_humphrey.envenenado=1;
        }

   if(dt_mojcas.y[f]<dt_mojcas.yd[f]) dt_mojcas.y[f]+=2;
   if(dt_mojcas.y[f]>dt_mojcas.yd[f]) dt_mojcas.y[f]-=2;

   if(dt_mojcas.x[f]==dt_mojcas.xd[f])
    {
     dt_mojcas.x[f]=dt_mojcas.xd[f];
     dt_mojcas.xd[f]=(rand()%(8*ANCHO_CELDA)+2*ANCHO_CELDA);
     dt_mojcas.xd[f]=dt_mojcas.x[f]+dt_mojcas.xd[f]*(invertir[f]?-1:1);
     dt_mojcas.xd[f]-=dt_mojcas.xd[f]%2;
     if(dt_mojcas.xd[f]<0)dt_mojcas.xd[f]=0;
     if(dt_mojcas.xd[f]>buffer_mapa->w-ANCHO_CELDA)dt_mojcas.xd[f]=buffer_mapa->w-ANCHO_CELDA;
     if(!(rand()%4))
      {
       dt_mojcas.yd[f]=dt_mojcas.y[f]+(ANCHO_CELDA/2+(rand()%(ANCHO_CELDA+ANCHO_CELDA/2)))*(rand()%2?1:-1);
       if(dt_mojcas.yd[f]<0) dt_mojcas.yd[f]=0;
       if(dt_mojcas.yd[f]>ANCHO_CELDA*(ALTO_VENTANA-1)) dt_mojcas.yd[f]=ANCHO_CELDA*(ALTO_VENTANA-1);
       dt_mojcas.yd[f]-=dt_mojcas.yd[f]%2;
      }
    }
  }

 if(sombra)
   sombras_dibujadas=1;
 else
   sombras_dibujadas=0;
}

//******************************************************************************
// Funcin reventar_loseta(...)
//    Realiza la animacin de las losetas boom.
//******************************************************************************
void reventar_loseta(char f)
{
 unsigned short x=(dt_booms.pos[f]/ALTO_VENTANA)*ANCHO_CELDA;
 unsigned short y=(dt_booms.pos[f]%ALTO_VENTANA)*ANCHO_CELDA;
 int dx,dy;
 char ix, iy;


 if(dt_booms.temp[f]<16)
  {
   set_trans_blender(0,0,0,dt_booms.temp[f]*17);
   for(dx=-ANCHO_CELDA, ix=-1;dx<ANCHO_CELDA+1;dx+=ANCHO_CELDA, ix++)
     for(dy=-ANCHO_CELDA, iy=-1;dy<ANCHO_CELDA+1;dy+=ANCHO_CELDA, iy++)
       draw_trans_sprite(buffer_juego,fm_boom(0),dx+x-desp-ix*3*(16-dt_booms.temp[f]),dy+y-iy*3*(16-dt_booms.temp[f]));
   set_trans_blender(0,0,0,180);
   dt_booms.temp[f]++;
  }
 else if(dt_booms.temp[f]<111)
  {
   // Se dibujan los cartuchos
   if(dt_booms.temp[f]==16 || dt_booms.temp[f]==48 || dt_booms.temp[f]==80)
     reproducir_sonido(12,0);
   for(dx=-ANCHO_CELDA;dx<ANCHO_CELDA+1;dx+=ANCHO_CELDA)
     for(dy=-ANCHO_CELDA;dy<ANCHO_CELDA+1;dy+=ANCHO_CELDA)
       draw_sprite(buffer_juego,fm_boom((dt_booms.temp[f]-15)/32),dx+x-desp,dy+y);
   dt_booms.temp[f]++;
   if(dt_booms.temp[f]==111)
    {
     mapa[dt_booms.pos[f]]=19;
     pintar(dt_booms.pos[f],1);
    } 
  }
 else if(dt_booms.temp[f]<=130)
  {int temp=(dt_booms.temp[f]-111)/4;
   int d;

   if(dt_booms.temp[f]==111)
     reproducir_sonido(13,0);
   for(dx=-ANCHO_CELDA;dx<ANCHO_CELDA+1;dx+=ANCHO_CELDA)
     for(dy=-ANCHO_CELDA;dy<ANCHO_CELDA+1;dy+=ANCHO_CELDA)
      {
       if(dt_booms.temp[f]<=126)
         draw_sprite(buffer_juego,fm_boom(2),dx+x-desp,dy+y);
       draw_sprite(buffer_juego,fm_expl(temp),dx+x-desp,dy+y);
      }

   if(dt_humphrey.x>x-2*ANCHO_CELDA  && dt_humphrey.x<x+2*ANCHO_CELDA &&
      dt_humphrey.y>y-2*ANCHO_CELDA  && dt_humphrey.y<y+2*ANCHO_CELDA &&
      dt_humphrey.estado==MH_NORMAL && !trampas)
    {
     parar_musica();
     dt_humphrey.estado=MH_REVENTANDO;
     dt_humphrey.temp=0;
    }

   for(d=0;d<dt_enemigos.num;d++)
     if(dt_enemigos.x[d]>x-2*ANCHO_CELDA && dt_enemigos.x[d]<x+2*ANCHO_CELDA &&
        dt_enemigos.y[d]>y-2*ANCHO_CELDA && dt_enemigos.y[d]<y+2*ANCHO_CELDA &&
        dt_enemigos.estado[d]==E_ESTADO_NORMAL)
      {
       dt_enemigos.estado[d]=E_ESTADO_REVENT;
       dt_enemigos.temp[d]=0;
       fm_sumar_puntos(500);
      }

   dt_booms.temp[f]++;
  }
 else
  {
   dt_booms.temp[f]=0;
  } 
}

//***************************\\
//  Deteccin de colisiones  \\
//***************************\\

//******************************************************************************
// Funcin colision_15_16(...)
//    Deteccin de colisiones para mapas de 15 y 16 bits, usando una mscara
//    para colisiones, y con la posibilidad de calcular la colisin con el mapa
//    mp1 invertido en el eje y.
//******************************************************************************
char colision_15_16(BITMAP *mp0, int x0, int y0, BITMAP *mp1, int x1, int y1, char invertir)
{
 short ct=(short)makecol(255,0,255);
 int fi = y1-y0;
 int ni = x1-x0;
 int ff = (y1+mp1->h)-y0;
 int nf = (x1+mp1->w)-x0;
 int f1,f2,n1,n2;
 short *l1, *l2, *l3;
 BITMAP *mcolis=(BITMAP *)(f_obj[89].dat);

 fi = y1-y0;
 ni = x1-x0;
 ff = (y1+mp1->h)-y0;
 nf = (x1+mp1->w)-x0;

 if(fi < 0) fi=0;
 if(ni < 0) ni=0;
 if(ff > mp0->h) ff = mp0->h;
 if(nf > mp0->w) nf = mp0->w;

 for(f1=fi, f2=fi+y0-y1; f1<ff; f1++, f2++)
  {
   l1=(short *)mp1->line[f2];
   l3=(short *)mcolis->line[f2];
   l2=(short *)mp0->line[f1];
   if(invertir)
     for(n1=ni, n2=mp1->w-1-ni-x0+x1; n1<nf; n1++, n2--)
      {if(l1[n2]!=ct && l2[n1]!=ct && l3[n2]!=ct) return 1;}
   else
     for(n1=ni, n2=ni+x0-x1; n1<nf; n1++, n2++)
      {if(l1[n2]!=ct && l2[n1]!=ct && l3[n2]!=ct) return 1;}
  }      

 return 0;
}

//******************************************************************************
// Funcin colision_24_32(...)
//    Deteccin de colisiones para mapas de 24 y 32 bits, usando una mscara
//    para colisiones, y con la posibilidad de calcular la colisin con el mapa
//    mp1 invertido en el eje y.
//******************************************************************************
char colision_24_32(BITMAP *mp0, int x0, int y0, BITMAP *mp1, int x1, int y1, char invertir)
{
 long ct=(long)makecol(255,0,255);
 int fi = y1-y0;
 int ni = x1-x0;
 int ff = (y1+mp1->h)-y0;
 int nf = (x1+mp1->w)-x0;
 int f1,f2,n1,n2;
 long *l1, *l2, *l3;
 BITMAP *mcolis=(BITMAP *)(f_obj[89].dat);

 fi = y1-y0;
 ni = x1-x0;
 ff = (y1+mp1->h)-y0;
 nf = (x1+mp1->w)-x0;

 if(fi < 0) fi=0;
 if(ni < 0) ni=0;
 if(ff > mp0->h) ff = mp0->h;
 if(nf > mp0->w) nf = mp0->w;

 for(f1=fi, f2=fi+y0-y1; f1<ff; f1++, f2++)
  {
   l1=(long *)mp1->line[f2];
   l3=(long *)mcolis->line[f2];
   l2=(long *)mp0->line[f1];
   if(invertir)
     for(n1=ni, n2=mp1->w-1-ni-x0+x1; n1<nf; n1++, n2--)
      {if(l1[n2]!=ct && l2[n1]!=ct && l3[n2]!=ct) return 1;}
   else
     for(n1=ni, n2=ni+x0-x1; n1<nf; n1++, n2++)
      {if(l1[n2]!=ct && l2[n1]!=ct && l3[n2]!=ct) return 1;}
  }      

 return 0;
}

