//******************************************************************************
// humphrey.c v1.2
// Funcin main() y funciones de estado.
// Por Ignacio Prez Gil 11/09/2004.
//******************************************************************************

// FAI UN SOL DE CARALLO
//   Con isto da movida haiche moito ye-y que, de noite e de da, usa jafas de sol:
//   Fai un sol de carallo!
//
// A MATANZA DO PORCO
//   Mtallo, carallo! A berra e un conxunto de berros dun porco cando o van a matar.
//   San Martio oficial de Monforte  Nepal, o mangosto para agosto, safaris do porco,
//   filloas de sangue, Galicia embutida: Fai un sol de carallo!, Galicia canbal!
//
// ETIOPA TEN FAME
//   Un parado occidental sostn un filete.
//   Un negro deitado, o negro non lle chega, arrastra o bandullo.
//   O parado occidental sostn o filete; o parado altivo... o negro non lle chega...
//   Doa os teus riles: un ril  merenda. Doa os teus riles: outro ril  cea.
//   Fai un sol de carallo. Galicia canbal. Doa os teus riles. MOI MAL ORGANIZADO.
//
//                                                   GALICIA CANBAL - Os Resentidos.

//******************************************************************************
// Includes.
//******************************************************************************
#include <allegro.h>
#include <time.h>
#include <math.h>
#include "hump.h"
#include "juego.h"
#include "audio.h"
#include "tcj.h"
#include "tiempo.h"

//******************************************************************************
// Definiciones, variables globales, estructuras de datos y funciones.
//******************************************************************************
DATAFILE *f_obj=NULL;
extern BITMAP *m_enemigo[60];
extern char juego_facil;
extern unsigned char parallax_activo;
extern unsigned char idioma;
unsigned char inicio_n=0;
unsigned char inicio_f=0;
unsigned char volson;
unsigned char volmus;
char modo_truecolor;
char modo_pc;
int nuevo_record;
extern volatile char tic_reloj;

void ini_allegro(void);
void ini_entrada(void);
void leer_cfg();
void escribir_cfg();

#define fm_idioma(_E_,_I_) (idioma==0?_E_:_I_)
#define fm_volcar()  while(!tic_reloj);\
                     tic_reloj=0;\
                     if(modo_pc)vsync();\
                     acquire_screen();\
                     blit(buffer,screen,0,0,0,0,640,480);\
                     release_screen();


// Tabla de mapas de los enemigos.
extern BITMAP *m_enemigo[60];

// Estructura para los datos de la mojca que hace de cursor.
struct{
   int x,y;
   char dx,dy;
   int mx,my;
   char fot;
   char invertir;
  }dt_mojca = {0,0,0,0,0,0,0,0};
void dibujar_mojca(BITMAP *buffer);

// Estructura para los datos de los enemigos que se mueven por el fondo.
#define NUM_ENEMS 6
struct{
   int x,y;
   char dx,dy;
   char tipo;
   char fot;
   char invertir;
  }dt_enemigo[NUM_ENEMS];
void dibujar_enems(char ini, BITMAP *buffer);

// Estructura para la tabla de puntuaciones.
struct{
   char txt[7];
   int puntos;
  }dt_puntos[5];

#define ANCHO_CELDA 48
#define EST_MENU     0
#define EST_JUEGO    1
#define EST_INTRO    2
#define EST_VERPTS   3
#define EST_OPCIONES 4
#define EST_INTPTS   5
#define EST_SALIR   -1
void elegir_idioma(void);
char menu(void);
char empezar_juego(void);
char intro(void);
char ver_puntos(void);
char introducir_puntos(void);
char opciones(void);

//******************************************************************************
// Funcin main()
//    Inicializa el juego, lo lanza, y desinicializa al final.
//******************************************************************************
int main(void)
{
 char (*funcion_estado[6])(void)={menu,empezar_juego,intro,ver_puntos,opciones,introducir_puntos};
 char estado=EST_INTRO;
 char f;

 ini_allegro();
 if(modo_pc==2) return 0;
 ini_texto();
 ini_juego();
 ini_entrada();
 ini_tiempo();
 ini_audio();
 srand(time(NULL));
 leer_cfg();

 // Esperamos un segundo sin hacer nada para que de tiempo a establecer el modo grfico
 for(f=0;f<50;f++)
  {
   while(!tic_reloj);
   tic_reloj=0;
  }

 if(idioma==2) elegir_idioma();

 while(estado!=EST_SALIR) estado=funcion_estado[estado]();

 fin_texto();
 fin_juego();
 fin_audio();
 return 0;
}
END_OF_MAIN();

//******************************************************************************
// Funcin elegir_idioma()
//    Pregunta por el idioma a utilizar.
//    Se ejecuta nicamente la primera vez que se lanza el juego.
//******************************************************************************
void elegir_idioma(void)
{
 int f;
 BITMAP *buffer=create_bitmap(640,480);
 BITMAP *fondo=(BITMAP *)(f_obj[87].dat);
 BITMAP *humphrey=(BITMAP *)(f_obj[88].dat);

 // Aparece el texto.
 f=1;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);

   draw_sprite(buffer,humphrey,64,28);

   escribir_texto(buffer,"elige tu idioma",96,150,f<31?256-f*8:0);

   if(f>15)
     escribir_texto(buffer,"choose your language",16,210,f<46?256-(f-15)*8:0);

   if(f>30)
     escribir_texto(buffer,"cervantes",144,300,f<61?256-(f-30)*8:0);

   if(f>45)
     escribir_texto(buffer,"shakespeare",144,360,f<76?256-(f-45)*8:0);

   fm_volcar();

   f+=2;
  }while(f<76);

 dt_mojca.x=-48;
 dt_mojca.y=290;
 dt_mojca.dx=dt_mojca.dy=0;
 dt_mojca.mx=144;
 dt_mojca.my=0;
 dt_mojca.fot=0;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);
   draw_sprite(buffer,humphrey,64,28);
   escribir_texto(buffer,"elige tu idioma",96,150,0);
   escribir_texto(buffer,"choose your language",16,210,0);
   escribir_texto(buffer,"cervantes",144,300,0);
   escribir_texto(buffer,"shakespeare",144,360,0);
   dibujar_mojca(buffer);

   fm_volcar();
   tcj_comprobar();
   if(tcj_estado[TCJ_ABJ] && dt_mojca.mx==0 && dt_mojca.my==0 && dt_mojca.y<350)
     dt_mojca.my=60;
   if(tcj_estado[TCJ_ARR] && dt_mojca.mx==0 && dt_mojca.my==0 && dt_mojca.y>290)
     dt_mojca.my=-60;
   if((tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC2] || tcj_estado[TCJ_AC3] ||
       tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5] || tcj_estado[TCJ_DER])
       && dt_mojca.mx==0 && dt_mojca.my==0)
     dt_mojca.mx=700;

  }while(dt_mojca.x<640);

 // Desaparece el texto.
 f=75;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);

   draw_sprite(buffer,humphrey,64,28);

   escribir_texto(buffer,"elige tu idioma",96,150,f<31?256-f*8:0);

   if(f>15)
     escribir_texto(buffer,"choose your language",16,210,f<46?256-(f-15)*8:0);

   if(f>30)
     escribir_texto(buffer,"cervantes",144,300,f<61?256-(f-30)*8:0);

   if(f>45)
     escribir_texto(buffer,"shakespeare",144,360,f<76?256-(f-45)*8:0);

   fm_volcar();

   f-=2;
  }while(f>0);

 destroy_bitmap(buffer);

 if(dt_mojca.y==290)
   idioma=0;
 else
   idioma=1;

 escribir_cfg();
}

//***********************\\
//  Funciones de estado  \\
//***********************\\

//******************************************************************************
// Funcin menu()
//    Men principal.
//******************************************************************************
#define XTXT 90
char menu(void)
{
 int f;
 short contador=0;
 char devolver=EST_MENU;
 BITMAP *buffer=create_bitmap(640,480);
 BITMAP *fondo=(BITMAP *)(f_obj[87].dat);
 BITMAP *humphrey=(BITMAP *)(f_obj[88].dat);

 // Aparece el texto.
 f=1;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);
   dibujar_enems(0,buffer);

   draw_sprite(buffer,humphrey,64,28);

   escribir_texto(buffer,fm_idioma("juego normal","normal game"),XTXT,120,f<31?256-f*8:0);

   if(f>15)
     escribir_texto(buffer,fm_idioma("juego fE1cil","easy game"),XTXT,180,f<46?256-(f-15)*8:0);

   if(f>30)
     escribir_texto(buffer,fm_idioma("opciones","options"),XTXT,240,f<61?256-(f-30)*8:0);

   if(f>45)
     escribir_texto(buffer,fm_idioma("puntuaciones","high scores"),XTXT,300,f<76?256-(f-45)*8:0);

   if(f>60)
     escribir_texto(buffer,fm_idioma("shakespeare","cervantes"),XTXT,360,f<91?256-(f-60)*8:0);

   if(f>75)
     escribir_texto(buffer,fm_idioma("salir","exit"),XTXT,420,256-(f-75)*8);

   reproducir_musica(2);
   fm_volcar();

   f+=2;
  }while(f<106);

 dt_mojca.x=-48;
 dt_mojca.y=110;
 dt_mojca.dx=dt_mojca.dy=0;
 dt_mojca.mx=XTXT;
 dt_mojca.my=0;
 dt_mojca.fot=0;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);
   dibujar_enems(0,buffer);
   draw_sprite(buffer,humphrey,64,28);
   if(idioma==0)
    {
     escribir_texto(buffer,"juego normal",XTXT,120,0);
     escribir_texto(buffer,"juego fE1cil",XTXT,180,0);
     escribir_texto(buffer,"opciones",XTXT,240,0);
     escribir_texto(buffer,"puntuaciones",XTXT,300,0);
     escribir_texto(buffer,"shakespeare",XTXT,360,0);
     escribir_texto(buffer,"salir",XTXT,420,0);
    }
   else
    {
     escribir_texto(buffer,"normal game",XTXT,120,0);
     escribir_texto(buffer,"easy game",XTXT,180,0);
     escribir_texto(buffer,"options",XTXT,240,0);
     escribir_texto(buffer,"high scores",XTXT,300,0);
     escribir_texto(buffer,"cervantes",XTXT,360,0);
     escribir_texto(buffer,"exit",XTXT,420,0);
    }
   dibujar_mojca(buffer);

   reproducir_musica(2);
   fm_volcar();
   contador++;
   tcj_comprobar();
   if(tcj_estado[TCJ_ABJ] && dt_mojca.mx==0 && dt_mojca.my==0)
    {
     contador=0;
     dt_mojca.my=(dt_mojca.y<410?60:200);
    }
   if(dt_mojca.y>480 && dt_mojca.my>0)
    {
     dt_mojca.y=-4;
     dt_mojca.my=114;
    }
   if(tcj_estado[TCJ_ARR] && dt_mojca.mx==0 && dt_mojca.my==0)
    {
     contador=0;
     dt_mojca.my=(dt_mojca.y>110?-60:-200);
    }
   if(dt_mojca.y<-48 && dt_mojca.my<0)
    {
     dt_mojca.y=482;
     dt_mojca.my=-72;
    }
   if((tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC2] || tcj_estado[TCJ_AC3] ||
       tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5] || tcj_estado[TCJ_DER])
       && dt_mojca.mx==0 && dt_mojca.my==0)
    {
     contador=0;
     dt_mojca.mx=700;
    }

   if(contador==3500)
    {
     parar_musica();
     destroy_bitmap(buffer);
     return EST_INTRO;
    }
  }while(dt_mojca.x<640);

 // Desaparece el texto.
 f=105;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);
   dibujar_enems(0,buffer);

   draw_sprite(buffer,humphrey,64,28);

   escribir_texto(buffer,fm_idioma("juego normal","normal game"),XTXT,120,f<31?256-f*8:0);

   if(f>15)
     escribir_texto(buffer,fm_idioma("juego fE1cil","easy game"),XTXT,180,f<46?256-(f-15)*8:0);

   if(f>30)
     escribir_texto(buffer,fm_idioma("opciones","options"),XTXT,240,f<61?256-(f-30)*8:0);

   if(f>45)
     escribir_texto(buffer,fm_idioma("puntuaciones","high scores"),XTXT,300,f<76?256-(f-45)*8:0);

   if(f>60)
     escribir_texto(buffer,fm_idioma("shakespeare","cervantes"),XTXT,360,f<91?256-(f-60)*8:0);

   if(f>75)
     escribir_texto(buffer,fm_idioma("salir","exit"),XTXT,420,256-(f-75)*8);

   reproducir_musica(2);
   fm_volcar();

   f-=2;
  }while(f>0);

 destroy_bitmap(buffer);
 switch((dt_mojca.y-110)/60)
  {
   case 0:
     juego_facil=0;
     devolver=EST_JUEGO;
     break;
   case 1:
     juego_facil=1;
     devolver=EST_JUEGO;
     break;
   case 2:
     devolver=EST_OPCIONES;
     break;
   case 3:
     devolver=EST_VERPTS;
     break;
   case 4:
     if(idioma)
       idioma=0;
     else
       idioma=1;
     devolver=EST_MENU;
     escribir_cfg();
     break;
   case 5:
     devolver=EST_SALIR;
     break;
  }
 return devolver;
}

//******************************************************************************
// Funcin empezar_juego()
//    Lanza el juego. Si es necesario, solicita la fase de inicio.
//    Si se ha finaliza la fase 40, se muestra el fin del juego.
//******************************************************************************
char empezar_juego(void)
{
 unsigned char *inicio=(juego_facil?&inicio_f:&inicio_n);
 char n_inicio, fs=0;

 if(*inicio>1)
  { // Pregunta por la fase de inicio
   char f;
   unsigned char n;
   BITMAP *buffer=create_bitmap(640,480);
   BITMAP *fondo=(BITMAP *)(f_obj[87].dat);
   BITMAP *humphrey=(BITMAP *)(f_obj[88].dat);
   char fases[160];
   short fxi,fx=384;
   char dfx=0;

   reproducir_musica(2);
   for(f=1,n=0;f<=*inicio;f++)
    {
     fases[n++]=f/10+'0';
     fases[n++]=f%10+'0';
     fases[n++]=' ';
     fases[n++]=' ';
     fx-=96;
    }
   fases[n-2]=0;
   reproducir_musica(2);
   fxi=fx;
   f=1;
   do
    {
     blit(fondo,buffer,0,0,0,0,640,480);

     dibujar_enems(0,buffer);
     draw_sprite(buffer,humphrey,64,28);

     if(idioma==0)
       escribir_texto(buffer,"fase de inicio",112,150,f<31?256-f*8:0);
     else
       escribir_texto(buffer,"starting level",104,150,f<31?256-f*8:0);

     if(f>15)
       escribir_texto(buffer,fases,fx,274,256-(f-15)*8);

     reproducir_musica(2);
     fm_volcar();

     f+=2;
    }while(f<46);

   dt_mojca.x=-50;
   dt_mojca.y=225;
   dt_mojca.dx=dt_mojca.dy=0;
   dt_mojca.mx=348;
   dt_mojca.my=0;
   dt_mojca.fot=0;
   do
    {
     blit(fondo,buffer,0,0,0,0,640,480);

     dibujar_enems(0,buffer);
     draw_sprite(buffer,humphrey,64,28);

     if(idioma==0)
       escribir_texto(buffer,"fase de inicio",112,150,0);
     else
       escribir_texto(buffer,"starting level",104,150,0);

     if(dfx>0)
      {
       dfx-=12;
       fx+=12;
      }
     if(dfx<0)
      {
       dfx+=12;
       fx-=12;
      }
     escribir_texto(buffer,fases,fx,274,0);

     dibujar_mojca(buffer);
     tcj_comprobar();
     if(dt_mojca.mx==0 && dfx==0)
      {
       if(tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC2] || tcj_estado[TCJ_AC3] ||
          tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5])
         dt_mojca.mx=700;
       else if(tcj_estado[TCJ_DER] && fx>fxi)
        {
         dt_mojca.invertir=1;
         dfx=-96;
        }
       else if(tcj_estado[TCJ_IZQ] && fx<288)
        {
         dt_mojca.invertir=0;
         dfx=+96;
        }
      }
     reproducir_musica(2);
     fm_volcar();

    }while(dt_mojca.x<640);

   f=45;
   do
    {
     blit(fondo,buffer,0,0,0,0,640,480);

     dibujar_enems(0,buffer);
     draw_sprite(buffer,humphrey,64,28);

     if(idioma==0)
       escribir_texto(buffer,"fase de inicio",112,150,f<31?256-f*8:0);
     else
       escribir_texto(buffer,"starting level",104,150,f<31?256-f*8:0);

     if(f>15)
       escribir_texto(buffer,fases,fx,274,256-(f-15)*8);

     reproducir_musica(2);
     fm_volcar();

     f-=2;
    }while(f>0);

   destroy_bitmap(buffer);
   fs=(char)((288-fx)/96);
  }

 // Se inicia el jusgo.
 parar_musica();
 nuevo_record=0;
 n_inicio=juego(fs,&nuevo_record);

 // Si se ha finalizado la fase 40, se muestra el fin del juego.
 if(n_inicio==40)
  {
   int f=0;
   DATAFILE *f_imgt=load_datafile("imgt.dat");
   BITMAP *buffer=create_bitmap(640,480);
   BITMAP *fondo=(BITMAP *)(f_imgt[0].dat);

   clear_keybuf();
   do
    {
     blit(fondo,buffer,0,0,0,0,640,480);
     reproducir_musica(2);
     fm_volcar();
     tcj_comprobar();
    }while(!tcj_estado[TCJ_AC0] && !tcj_estado[TCJ_AC1] && !tcj_estado[TCJ_AC2] &&
           !tcj_estado[TCJ_AC3] && !tcj_estado[TCJ_AC4] && !tcj_estado[TCJ_AC5] &&
           !keypressed());

   f=1;
   do
    {
     blit(fondo,buffer,0,0,0,0,640,480);

     if(idioma==0)
      {
       escribir_texto(buffer,"enhorabuenaEd",128,56,f<31?256-f*8:0);
       if(f>15)
         escribir_texto(buffer,"has conseguido",104,126,f<46?256-(f-15)*8:0);
       if(f>30)
         escribir_texto(buffer,"pintar toda la casaE6",24,196,f<61?256-(f-30)*8:0);
       if(f>45)
         escribir_texto(buffer,"por fin podrE1s",112,266,f<76?256-(f-45)*8:0);
       if(f>60)
         escribir_texto(buffer,"descansarE6",160,336,f<91?256-(f-60)*8:0);
       if(f>75)
         escribir_texto(buffer,"volver",224,406,256-(f-75)*8);
      }
     else
      {
       escribir_texto(buffer,"congratulationsEd",64,56,f<31?256-f*8:0);
       if(f>15)
         escribir_texto(buffer,"you have painted",80,126,f<46?256-(f-15)*8:0);
       if(f>30)
         escribir_texto(buffer,"all the houseE6",112,196,f<61?256-(f-30)*8:0);
       if(f>45)
         escribir_texto(buffer,"you can rest",144,266,f<76?256-(f-45)*8:0);
       if(f>60)
         escribir_texto(buffer,"at lastE6",200,336,f<91?256-(f-60)*8:0);
       if(f>75)
         escribir_texto(buffer,"back",256,406,256-(f-75)*8);
      }

     reproducir_musica(2);
     fm_volcar();

     f+=2;
    }while(f<106);

   dt_mojca.x=-52;
   dt_mojca.mx=(idioma==0?228:258);
   dt_mojca.y=396;
   dt_mojca.dx=dt_mojca.dy=0;
   dt_mojca.my=0;
   dt_mojca.fot=0;
   do
    {
     blit(fondo,buffer,0,0,0,0,640,480);

     if(idioma==0)
      {
       escribir_texto(buffer,"enhorabuenaEd",128,56,0);
       escribir_texto(buffer,"has conseguido",104,126,0);
       escribir_texto(buffer,"pintar toda la casaE6",24,196,0);
       escribir_texto(buffer,"por fin podrE1s",112,266,0);
       escribir_texto(buffer,"descansarE6",160,336,0);
       escribir_texto(buffer,"volver",224,406,0);
      }
     else
      {
       escribir_texto(buffer,"congratulationsEd",64,56,0);
       escribir_texto(buffer,"you have painted",80,126,0);
       escribir_texto(buffer,"all the houseE6",112,196,0);
       escribir_texto(buffer,"you can rest",144,266,0);
       escribir_texto(buffer,"at lastE6",200,336,0);
       escribir_texto(buffer,"back",256,406,0);
      }

     dibujar_mojca(buffer);
     tcj_comprobar();
     if(dt_mojca.mx==0)
      {
       if(tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC2] || tcj_estado[TCJ_AC3] ||
          tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5] || tcj_estado[TCJ_DER])
         dt_mojca.mx=700;
      }
     reproducir_musica(2);
     fm_volcar();

    }while(dt_mojca.x<640);

   f=105;
   do
    {
     blit(fondo,buffer,0,0,0,0,640,480);

     if(idioma==0)
      {
       escribir_texto(buffer,"enhorabuenaEd",128,56,f<31?256-f*8:0);
       if(f>15)
         escribir_texto(buffer,"has conseguido",104,126,f<46?256-(f-15)*8:0);
       if(f>30)
         escribir_texto(buffer,"pintar toda la casaE6",24,196,f<61?256-(f-30)*8:0);
       if(f>45)
         escribir_texto(buffer,"por fin podrE1s",112,266,f<76?256-(f-45)*8:0);
       if(f>60)
         escribir_texto(buffer,"descansarE6",160,336,f<91?256-(f-60)*8:0);
       if(f>75)
         escribir_texto(buffer,"volver",224,406,256-(f-75)*8);
      }
     else
      {
       escribir_texto(buffer,"congratulationsEd",64,56,f<31?256-f*8:0);
       if(f>15)
         escribir_texto(buffer,"you have painted",80,126,f<46?256-(f-15)*8:0);
       if(f>30)
         escribir_texto(buffer,"all the houseE6",112,196,f<61?256-(f-30)*8:0);
       if(f>45)
         escribir_texto(buffer,"you can rest",144,266,f<76?256-(f-45)*8:0);
       if(f>60)
         escribir_texto(buffer,"at lastE6",200,336,f<91?256-(f-60)*8:0);
       if(f>75)
         escribir_texto(buffer,"back",256,406,256-(f-75)*8);
      }

     reproducir_musica(2);
     fm_volcar();

     f-=2;
    }while(f>0);

   destroy_bitmap(buffer);
   unload_datafile(f_imgt);
  }

 if(n_inicio>*inicio)
  {
   *inicio=n_inicio;
    escribir_cfg();
  }

 dibujar_enems(1,NULL);
 if(nuevo_record>dt_puntos[4].puntos) return EST_INTPTS;
 return EST_MENU;
}

//******************************************************************************
// Funcin intro()
//    Secuencia de introduccin.
//******************************************************************************
#define N_ENEMS_I 70
char intro(void)
{
 BITMAP *buffer=create_bitmap(640,480);
 int color_fondo=makecol(149,149,198);
 short transp;
 char salir=0;
 short h_x, h_y;
 char h_dir,h_fot,voz=-1;
 short e_x[N_ENEMS_I], e_y[N_ENEMS_I], contador;
 unsigned char f=1, e_fot[N_ENEMS_I], e_cont[N_ENEMS_I];
 int d0, d1, d2;
 DATAFILE *f_imgt=NULL;

 // Se inicializan los datos de los enemigos, que se
 // colocan dentro de elipse de semiejes 640 y 336 
 while(f<N_ENEMS_I)
  {
   e_x[f]=rand()%640;
   e_y[f]=rand()%(168*2);
   d0=e_x[f]-48;
   d1=e_x[f]-640+48;
   d2=e_y[f]-168;
   d2*=d2;
   d0=d0*d0+d2;
   d1=d1*d1+d2;
   if(sqrt(d0)+sqrt(d1)<640)
    {
     e_x[f]-=664;
     e_y[f]+=48;
     e_fot[f]=(rand()%58)+2;
     e_cont[f]=rand()%4;
     f++;
    }
  }

 e_x[0]=-1000;
 e_y[0]=216;
 e_fot[0]=40;
 e_cont[0]=0;
 f_imgt=load_datafile("imgt.dat");
 voz=reproducir_sonido(27,0);
// Se enciende la pantalla
 transp=195;
 do
  {
   if(transp<150)
     clear_to_color(buffer,makecol(150-transp,150-transp,200-transp));
   else
     clear_to_color(buffer,makecol(0,0,200-transp));
   fm_volcar();
   transp-=5;
  }while(transp);

// Aparece el logo de Retrospec
 transp=248;
 do
  {
   clear_to_color(buffer,color_fondo);
   set_trans_blender(0,0,0,256-transp);
   draw_trans_sprite(buffer,(BITMAP *)(f_imgt[1].dat),68,80);
   fm_volcar();
  }while(transp-=8);

 clear_to_color(buffer,color_fondo);
 blit((BITMAP *)(f_imgt[1].dat),buffer,0,0,68,80,503,320);

// El logo permanece 6,6 segundos, o hasta que se pulse una tecla.
 contador=0;
 clear_keybuf();
 do
  {
   contador++;
   if(modo_pc) vsync();
   fm_volcar();
   tcj_comprobar();
  }while(!tcj_estado[TCJ_AC0] && !tcj_estado[TCJ_AC1] && !tcj_estado[TCJ_AC2] &&
         !tcj_estado[TCJ_AC3] && !tcj_estado[TCJ_AC4] && !tcj_estado[TCJ_AC5] &&
         !keypressed() && contador<330);
 detener_sonido(voz);
 voz=-1;

// Desaparece el logo
 transp=248;
 do
  {
   clear_to_color(buffer,color_fondo);
   set_trans_blender(0,0,0,transp);
   draw_trans_sprite(buffer,(BITMAP *)(f_imgt[1].dat),68,80);
   fm_volcar();
  }while(transp-=8);
 unload_datafile(f_imgt);
 f_imgt=NULL;

// Se apaga la pantalla
 transp=5;
 do
  {
   if(transp<150)
     clear_to_color(buffer,makecol(150-transp,150-transp,200-transp));
   else
     clear_to_color(buffer,makecol(0,0,200-transp));
   fm_volcar();
   transp+=5;
  }while(transp<200);

// Aparece el texto
 transp=1;
 do
  {
   clear_bitmap(buffer);

   if(idioma==0)
    {
     escribir_texto(buffer,"retrospec presenta",40,40,transp<31?256-transp*8:0);

     if(transp>15)
       escribir_texto(buffer,"un juego por",144,100,transp<46?256-(transp-15)*8:0);

     if(transp>30)
       escribir_texto(buffer,"ignacio pE2rez gilEd",48,160,transp<61?256-(transp-30)*8:0);

     if(transp>45)
       escribir_texto(buffer,"benito manuel nemesio",0,220,transp<76?256-(transp-45)*8:0);

     if(transp>60)
       escribir_texto(buffer,"cubells y adam dawesEd",8,280,transp<91?256-(transp-60)*8:0);

     if(transp>75)
       escribir_texto(buffer,"basado en el juego",56,340,transp<106?256-(transp-75)*8:0);

     if(transp>90)
       escribir_texto(buffer,"original de zigurat",32,400,256-(transp-90)*8);
    }
   else
    {
     escribir_texto(buffer,"retrospec presents a",16,40,transp<31?256-transp*8:0);

     if(transp>15)
       escribir_texto(buffer,"game by ignacio pE2rez",8,100,transp<46?256-(transp-15)*8:0);

     if(transp>30)
       escribir_texto(buffer,"gilEd benito manuel",48,160,transp<61?256-(transp-30)*8:0);

     if(transp>45)
       escribir_texto(buffer,"nemesio cubells",88,220,transp<76?256-(transp-45)*8:0);

     if(transp>60)
       escribir_texto(buffer,"and adam dawesEd",96,280,transp<91?256-(transp-60)*8:0);

     if(transp>75)
       escribir_texto(buffer,"based on the original",8,340,transp<106?256-(transp-75)*8:0);

     if(transp>90)
       escribir_texto(buffer,"game by zigurat",96,400,256-(transp-90)*8);
    }

   fm_volcar();

   transp+=2;
  }while(transp<121);

 clear_bitmap(buffer);
 if(idioma==0)
  {
   escribir_texto(buffer,"retrospec presenta",   40, 40,0);
   escribir_texto(buffer,"un juego por",        144,100,0);
   escribir_texto(buffer,"ignacio pE2rez gilEd", 48,160,0);
   escribir_texto(buffer,"benito manuel nemesio", 0,220,0);
   escribir_texto(buffer,"cubells y adam dawesEd",8,280,0);
   escribir_texto(buffer,"basado en el juego",   56,340,0);
   escribir_texto(buffer,"original de zigurat",  32,400,0);
  }
 else
  {
   escribir_texto(buffer,"retrospec presents a",  16, 40,0);
   escribir_texto(buffer,"game by ignacio pE2rez", 8,100,0);
   escribir_texto(buffer,"gilEd benito manuel",   48,160,0);
   escribir_texto(buffer,"nemesio cubells",       88,220,0);
   escribir_texto(buffer,"and adam dawesEd",      96,280,0);
   escribir_texto(buffer,"based on the original",  8,340,0);
   escribir_texto(buffer,"game by zigurat",       96,400,0);
  }

// El texto permanece hasta que se pulsa un botn o pasan cinco segundos
 clear_keybuf();
 contador=0;
 do
  {
   contador++;
   fm_volcar();
   tcj_comprobar();
  }while(!tcj_estado[TCJ_AC0] && !tcj_estado[TCJ_AC1] && !tcj_estado[TCJ_AC2] &&
         !tcj_estado[TCJ_AC3] && !tcj_estado[TCJ_AC4] && !tcj_estado[TCJ_AC5] &&
         !keypressed() && contador<250);

// Desaparece el texto
 transp=120;
 do
  {
   clear_bitmap(buffer);

   if(idioma==0)
    {
     escribir_texto(buffer,"retrospec presenta",40,40,transp<31?256-transp*8:0);

     if(transp>15)
       escribir_texto(buffer,"un juego por",144,100,transp<46?256-(transp-15)*8:0);

     if(transp>30)
       escribir_texto(buffer,"ignacio pE2rez gilEd",48,160,transp<61?256-(transp-30)*8:0);

     if(transp>45)
       escribir_texto(buffer,"benito manuel nemesio",0,220,transp<76?256-(transp-45)*8:0);

     if(transp>60)
       escribir_texto(buffer,"cubells y adam dawesEd",8,280,transp<91?256-(transp-60)*8:0);

     if(transp>75)
       escribir_texto(buffer,"basado en el juego",56,340,transp<106?256-(transp-75)*8:0);

     if(transp>90)
       escribir_texto(buffer,"original de zigurat",32,400,256-(transp-90)*8);
    }
   else
    {
     escribir_texto(buffer,"retrospec presents a",16,40,transp<31?256-transp*8:0);

     if(transp>15)
       escribir_texto(buffer,"game by ignacio pE2rez",8,100,transp<46?256-(transp-15)*8:0);

     if(transp>30)
       escribir_texto(buffer,"gilEd benito manuel",48,160,transp<61?256-(transp-30)*8:0);

     if(transp>45)
       escribir_texto(buffer,"nemesio cubells",88,220,transp<76?256-(transp-45)*8:0);

     if(transp>60)
       escribir_texto(buffer,"and adam dawesEd",96,280,transp<91?256-(transp-60)*8:0);

     if(transp>75)
       escribir_texto(buffer,"based on the original",8,340,transp<106?256-(transp-75)*8:0);

     if(transp>90)
       escribir_texto(buffer,"game by zigurat",96,400,256-(transp-90)*8);
    }

   fm_volcar();

   transp-=2;
  }while(transp>0);

// Humphrey baja
 clear_keybuf();
 clear_bitmap(buffer);
 h_x=296;
 h_y=-46;
 h_dir=1;
 h_fot=4;
 while(h_y<217 && !salir)
  {
   rectfill(buffer,289,h_y-2,289+47,h_y+45,0);
   draw_sprite(buffer,(BITMAP *)(f_obj[32+h_fot/4].dat),289,h_y);
   h_y+=2;
   if(h_fot==9 && h_dir==1)
     h_dir=-1;
   else if(h_fot==2 && h_dir==-1)
     h_dir=1;
   else
     h_fot+=h_dir;

   if(h_fot==4 && h_dir==1)  reproducir_sonido(0,0);
   if(h_fot==7 && h_dir==-1) reproducir_sonido(1,0);

   fm_volcar();
   tcj_comprobar();
   if(tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC1] || tcj_estado[TCJ_AC2] ||
      tcj_estado[TCJ_AC3] || tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5] || keypressed())
     salir=1;
  }

// Humphrey salta
 h_dir=0;
 h_y=216;
 h_fot=33;
 if(!salir) reproducir_sonido(28,0);
 while(h_dir<60 && !salir)
  {
   rectfill(buffer,289,206,289+47,216+47,0);
   if(h_dir==20)
    {
     h_fot=36;
    }
   else if(h_dir==40)
    {
     h_y=206;
     h_fot=35;
     reproducir_sonido(2,0);
    }
   else if(h_dir==45 || h_dir==55)
    {
     h_y=216;
     h_fot=36;
    }
   else if(h_dir==50)
    {
     h_y=206;
     h_fot=37;
     reproducir_sonido(2,0);
    }

   draw_sprite(buffer,(BITMAP *)(f_obj[h_fot].dat),289,h_y);
   h_dir++;

   fm_volcar();
   tcj_comprobar();
   if(tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC1] || tcj_estado[TCJ_AC2] ||
      tcj_estado[TCJ_AC3] || tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5] || keypressed())
     salir=1;
  }

// Humphrey sale corriendo perseguido por sus fans
 h_dir=1;
 h_fot=4;
 if(!salir) reproducir_sonido(29,0);
 while(e_x[0]<296 && !salir)
  {
   rectfill(buffer,0,48,h_x+47,480-48,0);
   h_x+=6;
   draw_sprite(buffer,(BITMAP *)(f_obj[29+h_fot/4].dat),h_x,h_y);

   for(f=0;f<N_ENEMS_I;f++)
    {
     e_x[f]+=6;
     if(e_cont[f]==3)
      {
       if(e_fot[f]&1)
         e_fot[f]--;
       else
         e_fot[f]++;
       e_cont[f]=0;
      }
     else
       e_cont[f]++;
     draw_sprite_h_flip(buffer,m_enemigo[e_fot[f]],e_x[f],e_y[f]);
    }

   if(h_fot==9 && h_dir==1)
     h_dir=-1;
   else if(h_fot==2 && h_dir==-1)
     h_dir=1;
   else
     h_fot+=h_dir;

   if(voz==-1)
    {
     if((h_fot==4 || h_fot==8) && h_dir==1)  reproducir_sonido(h_fot==4?0:1,0);
     if((h_fot==7 || h_fot==3) && h_dir==-1) reproducir_sonido(h_fot==7?0:1,0);
    }
   if(e_x[0]>-48)
     if(e_cont[0]==0)
       if(e_fot[0]==40)
         if(voz==-1)
           voz=reproducir_sonido(2,0);
         else
           reiniciar_sonido(voz);

   fm_volcar();
   tcj_comprobar();
   if(tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC1] || tcj_estado[TCJ_AC2] ||
      tcj_estado[TCJ_AC3] || tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5] || keypressed())
     salir=1;
  }

// La bola descansa
 e_cont[0]=0;
 e_fot[0]=40;
 rectfill(buffer,0,48,639,480-48,0);
 if(!salir) reproducir_sonido(30,0);
 while(e_cont[0]<136 && !salir)
  {
   rectfill(buffer,e_x[0],e_y[0],e_x[0]+47,e_y[0]+47,0);
   if(e_cont[0]%17==0)
    {
     if(e_fot[0]&1)
       e_fot[0]--;
     else
       e_fot[0]++;
    }
   e_cont[0]++;
   draw_sprite_h_flip(buffer,m_enemigo[e_fot[0]],e_x[0],e_y[0]);

   fm_volcar();
   tcj_comprobar();
   if(tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC1] || tcj_estado[TCJ_AC2] ||
      tcj_estado[TCJ_AC3] || tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5] || keypressed())
     salir=1;
  }

// La bola contina la marcha
 e_cont[0]=0;
 voz=-1;
 while(e_x[0]<640 && !salir)
  {
   rectfill(buffer,e_x[0],e_y[0],e_x[0]+47,e_y[0]+47,0);
   if(e_cont[0]==3)
    {
     if(e_fot[0]&1)
       e_fot[0]--;
     else
       e_fot[0]++;
     e_cont[0]=0;
    }
   else
     e_cont[0]++;
   e_x[0]+=6;
   draw_sprite_h_flip(buffer,m_enemigo[e_fot[0]],e_x[0],e_y[0]);
   if(e_x[0]>-48)
     if(e_cont[0]==0)
       if(e_fot[0]==40)
         if(voz==-1)
           voz=reproducir_sonido(2,0);
         else
           reiniciar_sonido(voz);

   fm_volcar();
   tcj_comprobar();
   if(tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC1] || tcj_estado[TCJ_AC2] ||
      tcj_estado[TCJ_AC3] || tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5] || keypressed())
     salir=1;
  }

// Aparece el fondo
 f=0;
 voz=-1;
 while(f<120 && !salir)
  {
   if(f==0 || f==60) reproducir_sonido(13,0);
   if(f<60)
    {
     clear_bitmap(buffer);
     if(f<20)
      {
       d0=(rand()%3-1)*3;
       d1=(rand()%3-1)*3;
      }
     else if(f<40)
      {
       d0=(rand()%3-1)*2;
       d1=(rand()%3-1)*2;
      }
     else
      {
       d0=(rand()%3-1);
       d1=(rand()%3-1);
      }
     blit((BITMAP *)(f_obj[87].dat),buffer,0,0,d0,d1,640,480);
    }
   else
    {
     rectfill(buffer,64-3,28-3,((BITMAP *)(f_obj[88].dat))->w+6+64,((BITMAP *)(f_obj[88].dat))->h+6+28,0);
     if(f<80)
      {
       d0=(rand()%3-1)*3;
       d1=(rand()%3-1)*3;
      }
     else if(f<100)
      {
       d0=(rand()%3-1)*2;
       d1=(rand()%3-1)*2;
      }
     else
      {
       d0=(rand()%3-1);
       d1=(rand()%3-1);
      }
     draw_sprite(buffer,(BITMAP *)(f_obj[88].dat),64+d0,28+d1);
    }

   f++;

   fm_volcar();
   tcj_comprobar();
   if(tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC1] || tcj_estado[TCJ_AC2] ||
      tcj_estado[TCJ_AC3] || tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5] || keypressed())
     salir=1;
  }

 detener_sonidos();
 destroy_bitmap(buffer);
 dibujar_enems(1,NULL);
 return EST_MENU;
}

//******************************************************************************
// Funcin opciones()
//    Muestra las opciones (prallax y volmenes de sonido y msica).
//******************************************************************************
char opciones(void)
{
 int f;
 char ant_volson, voz=-1;
 BITMAP *buffer=create_bitmap(640,480);
 BITMAP *fondo=(BITMAP *)(f_obj[87].dat);
 BITMAP *humphrey=(BITMAP *)(f_obj[88].dat);

 // Aparece el texto.
 f=1;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);
   dibujar_enems(0,buffer);

   draw_sprite(buffer,humphrey,64,28);

   escribir_texto(buffer,fm_idioma("pE1rallax","parallax"),192,112,f<31?256-f*8:0);

   if(f>15)
    {
     if(parallax_activo)
      {
       escribir_texto(buffer,fm_idioma("si","yes"),208,166,f<46?256-(f-15)*8:0);
       escribir_texto(buffer,"no",368,166,f<46?256-(f-15)*4:128);
      }
     else
      {
       escribir_texto(buffer,fm_idioma("si","yes"),208,166,f<46?256-(f-15)*4:128);
       escribir_texto(buffer,"no",368,166,f<46?256-(f-15)*8:0);
      }
    }

   if(f>30)
    {
     if(idioma==0)
       escribir_texto(buffer,"volumen de sonidos",48,220,f<61?256-(f-30)*8:0);
     else
       escribir_texto(buffer,"sound volume",136,220,f<61?256-(f-30)*8:0);
    }

   if(f>45)
   if(f<76)
    {
     escribir_texto(buffer,"E8",208,274,256-(f-45)*8);
     escribir_numero(buffer,volson,3,272,274,256-(f-45)*8);
     escribir_texto(buffer,"E9",400,274,256-(f-45)*8);
    }
   else
    {
     escribir_texto(buffer,"E8",208,274,0);
     escribir_numero(buffer,volson,3,272,274,0);
     escribir_texto(buffer,"E9",400,274,0);
    }

   if(f>60)
    {
     if(idioma==0)
       escribir_texto(buffer,"volumen de mE5sica",64,328,f<91?256-(f-60)*8:0);
     else
       escribir_texto(buffer,"music volume",136,328,f<91?256-(f-60)*8:0);
    }

   if(f>75)
   if(f<106)
    {
     escribir_texto(buffer,"E8",208,382,256-(f-75)*8);
     escribir_numero(buffer,volmus,3,272,382,256-(f-75)*8);
     escribir_texto(buffer,"E9",400,382,256-(f-75)*8);
    }
   else
    {
     escribir_texto(buffer,"E8",208,382,0);
     escribir_numero(buffer,volmus,3,272,382,0);
     escribir_texto(buffer,"E9",400,382,0);
    }

   if(f>90)
    {
     if(idioma==0)
       escribir_texto(buffer,"volver",224,436,256-(f-90)*8);
     else
       escribir_texto(buffer,"back",258,436,256-(f-90)*8);
    }

   reproducir_musica(2);
   fm_volcar();

   f+=2;
  }while(f<121);

 dt_mojca.x=-50;
 dt_mojca.y=156;
 dt_mojca.dx=dt_mojca.dy=0;
 dt_mojca.mx=210;
 dt_mojca.my=0;
 dt_mojca.fot=0;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);
   dibujar_enems(0,buffer);
   draw_sprite(buffer,humphrey,64,28);
   escribir_texto(buffer,"parallax",192,112,0);
   escribir_texto(buffer,"E8",208,274,0);
   escribir_numero(buffer,volson,3,272,274,0);
   escribir_texto(buffer,"E9",400,274,0);
   escribir_texto(buffer,"E8",208,382,0);
   escribir_numero(buffer,volmus,3,272,382,0);
   escribir_texto(buffer,"E9",400,382,0);

   if(idioma==0)
    {
     if(parallax_activo)
      {
       escribir_texto(buffer,"si",208,166,0);
       escribir_texto(buffer,"no",368,166,128);
      }
     else
      {
       escribir_texto(buffer,"si",208,166,128);
       escribir_texto(buffer,"no",368,166,0);
      }
     escribir_texto(buffer,"volumen de sonidos",48,220,0);
     escribir_texto(buffer,"volumen de mE5sica",64,328,0);
     escribir_texto(buffer,"volver",224,436,0);
    }
   else
    {
     if(parallax_activo)
      {
       escribir_texto(buffer,"yes",208,166,0);
       escribir_texto(buffer,"no",368,166,128);
      }
     else
      {
       escribir_texto(buffer,"yes",208,166,128);
       escribir_texto(buffer,"no",368,166,0);
      }
     escribir_texto(buffer,"sound volume",136,220,0);
     escribir_texto(buffer,"music volume",136,328,0);
     escribir_texto(buffer,"back",258,436,256-(f-90)*8);
    }
   dibujar_mojca(buffer);

   reproducir_musica(2);
   fm_volcar();
   tcj_comprobar();

   if(tcj_estado[TCJ_ABJ] && dt_mojca.mx==0 && dt_mojca.my==0 && dt_mojca.y<426)
     dt_mojca.my=(dt_mojca.y==372?54:108);

   if(tcj_estado[TCJ_ARR] && dt_mojca.mx==0 && dt_mojca.my==0 && dt_mojca.y>156)
     dt_mojca.my=(dt_mojca.y==426?-54:-108);

   if((tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC2] || tcj_estado[TCJ_AC3] ||
       tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5] || tcj_estado[TCJ_DER])
       && dt_mojca.mx==0 && dt_mojca.my==0 && dt_mojca.y==426)
     dt_mojca.mx=700;

   if(tcj_estado[TCJ_DER] && dt_mojca.mx==0 && dt_mojca.my==0 && dt_mojca.x==160)
     dt_mojca.mx=270;

   if(tcj_estado[TCJ_IZQ] && dt_mojca.mx==0 && dt_mojca.my==0 && dt_mojca.x==430)
     dt_mojca.mx=-270;

   if(dt_mojca.mx==0 && dt_mojca.my==0 && dt_mojca.x==160)
     dt_mojca.invertir=1;

   if(dt_mojca.mx==0 && dt_mojca.my==0 && dt_mojca.x==430)
     dt_mojca.invertir=0;

   ant_volson=volson;
   if((tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC2] || tcj_estado[TCJ_AC3] ||
       tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5])
       && dt_mojca.mx==0 && dt_mojca.my==0)
    {
     if(dt_mojca.y==156 && dt_mojca.x==160 && parallax_activo==0)
       parallax_activo=1;
     else if(dt_mojca.y==156 && dt_mojca.x==430 && parallax_activo==1)
       parallax_activo=0;
     else if(dt_mojca.y==264 && dt_mojca.x==160 && volson>0)
       volson--;
     else if(dt_mojca.y==264 && dt_mojca.x==430 && volson<100)
       volson++;
     else if(dt_mojca.y==372 && dt_mojca.x==160 && volmus>0)
       modificar_volmus(--volmus);
     else if(dt_mojca.y==372 && dt_mojca.x==430 && volmus<100)
       modificar_volmus(++volmus);
    }
  if(volson!=ant_volson)
   {
    if(voz==-1)
      voz=reproducir_sonido(15,1);
     modificar_volson(volson, voz);
   }
  else
   {
    if(voz>=0)
     {
      detener_sonido(voz);
      voz=-1;
     }
   }

  }while(dt_mojca.x<640);

 // Desaparece el texto.
 f=120;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);
   dibujar_enems(0,buffer);

   draw_sprite(buffer,humphrey,64,28);

   escribir_texto(buffer,"parallax",192,112,f<31?256-f*8:0);

   if(f>15)
    {
     if(parallax_activo)
      {
       escribir_texto(buffer,fm_idioma("si","yes"),208,166,f<46?256-(f-15)*8:0);
       escribir_texto(buffer,"no",368,166,f<46?256-(f-15)*4:128);
      }
     else
      {
       escribir_texto(buffer,fm_idioma("si","yes"),208,166,f<46?256-(f-15)*4:128);
       escribir_texto(buffer,"no",368,166,f<46?256-(f-15)*8:0);
      }
    }

   if(f>30)
    {
     if(idioma==0)
       escribir_texto(buffer,"volumen de sonidos",48,220,f<61?256-(f-30)*8:0);
     else
       escribir_texto(buffer,"sound volume",136,220,f<61?256-(f-30)*8:0);
    }

   if(f>45)
   if(f<76)
    {
     escribir_texto(buffer,"E8",208,274,256-(f-45)*8);
     escribir_numero(buffer,volson,3,272,274,256-(f-45)*8);
     escribir_texto(buffer,"E9",400,274,256-(f-45)*8);
    }
   else
    {
     escribir_texto(buffer,"E8",208,274,0);
     escribir_numero(buffer,volson,3,272,274,0);
     escribir_texto(buffer,"E9",400,274,0);
    }

   if(f>60)
    {
     if(idioma==0)
       escribir_texto(buffer,"volumen de mE5sica",64,328,f<91?256-(f-60)*8:0);
     else
       escribir_texto(buffer,"music volume",136,328,f<91?256-(f-60)*8:0);
    }

   if(f>75)
   if(f<106)
    {
     escribir_texto(buffer,"E8",208,382,256-(f-75)*8);
     escribir_numero(buffer,volmus,3,272,382,256-(f-75)*8);
     escribir_texto(buffer,"E9",400,382,256-(f-75)*8);
    }
   else
    {
     escribir_texto(buffer,"E8",208,382,0);
     escribir_numero(buffer,volmus,3,272,382,0);
     escribir_texto(buffer,"E9",400,382,0);
    }

   if(f>90)
    {
     if(idioma==0)
       escribir_texto(buffer,"volver",224,436,256-(f-90)*8);
     else
       escribir_texto(buffer,"back",258,436,256-(f-90)*8);
    }

   reproducir_musica(2);
   fm_volcar();

   f-=2;
  }while(f>0);

 destroy_bitmap(buffer);
 escribir_cfg();
 return EST_MENU;
}

//******************************************************************************
// Funcin ver_puntos()
//    Muestra la tabla de rcords.
//******************************************************************************
char ver_puntos(void)
{
 int f;
 BITMAP *buffer=create_bitmap(640,480);
 BITMAP *fondo=(BITMAP *)(f_obj[87].dat);
 char *txp="E6E6E6E6E6";

 // Aparece el texto.
 f=1;
 do
  {
   unsigned char transp;

   blit(fondo,buffer,0,0,0,0,640,480);
   dibujar_enems(0,buffer);
   draw_sprite(buffer,(BITMAP *)(f_obj[88].dat),64,28);

   if(f<31)
    {
     escribir_texto(buffer,dt_puntos[0].txt,96,120,transp=(unsigned char)(256-f*8));
     escribir_texto(buffer,txp,96+32*3,120,transp);
     escribir_numero(buffer,dt_puntos[0].puntos,6,96+32*8,120,transp);
    }
   else
    {
     escribir_texto(buffer,dt_puntos[0].txt,96,120,0);
     escribir_texto(buffer,txp,96+32*3,120,0);
     escribir_numero(buffer,dt_puntos[0].puntos,6,96+32*8,120,0);
    }

   if(f>15)
   if(f<46)
    {
     escribir_texto(buffer,dt_puntos[1].txt,96,180,transp=(unsigned char)(256-(f-15)*8));
     escribir_texto(buffer,txp,96+32*3,180,transp);
     escribir_numero(buffer,dt_puntos[1].puntos,6,96+32*8,180,transp);
    }
   else
    {
     escribir_texto(buffer,dt_puntos[1].txt,96,180,0);
     escribir_texto(buffer,txp,96+32*3,180,0);
     escribir_numero(buffer,dt_puntos[1].puntos,6,96+32*8,180,0);
    }

   if(f>30)
   if(f<61)
    {
     escribir_texto(buffer,dt_puntos[2].txt,96,240,transp=(unsigned char)(256-(f-30)*8));
     escribir_texto(buffer,txp,96+32*3,240,transp);
     escribir_numero(buffer,dt_puntos[2].puntos,6,96+32*8,240,transp);
    }
   else
    {
     escribir_texto(buffer,dt_puntos[2].txt,96,240,0);
     escribir_texto(buffer,txp,96+32*3,240,0);
     escribir_numero(buffer,dt_puntos[2].puntos,6,96+32*8,240,0);
    }

   if(f>45)
   if(f<76)
    {
     escribir_texto(buffer,dt_puntos[3].txt,96,300,transp=(unsigned char)(256-(f-45)*8));
     escribir_texto(buffer,txp,96+32*3,300,transp);
     escribir_numero(buffer,dt_puntos[3].puntos,6,96+32*8,300,transp);
    }
   else
    {
     escribir_texto(buffer,dt_puntos[3].txt,96,300,0);
     escribir_texto(buffer,txp,96+32*3,300,0);
     escribir_numero(buffer,dt_puntos[3].puntos,6,96+32*8,300,0);
    }

   if(f>60)
   if(f<91)
    {
     escribir_texto(buffer,dt_puntos[4].txt,96,360,transp=(unsigned char)(256-(f-60)*8));
     escribir_texto(buffer,txp,96+32*3,360,transp);
     escribir_numero(buffer,dt_puntos[4].puntos,6,96+32*8,360,transp);
    }
   else
    {
     escribir_texto(buffer,dt_puntos[4].txt,96,360,0);
     escribir_texto(buffer,txp,96+32*3,360,0);
     escribir_numero(buffer,dt_puntos[4].puntos,6,96+32*8,360,0);
    }

   if(f>75)
     escribir_texto(buffer,fm_idioma("volver","back"),fm_idioma(240,258),420,256-(f-75)*8);

   reproducir_musica(2);
   fm_volcar();

   f+=2;
  }while(f<106);

 dt_mojca.x=-48;
 dt_mojca.y=410;
 dt_mojca.dx=dt_mojca.dy=0;
 dt_mojca.mx=fm_idioma(240,258);
 dt_mojca.my=0;
 dt_mojca.fot=0;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);
   dibujar_enems(0,buffer);
   draw_sprite(buffer,(BITMAP *)(f_obj[88].dat),64,28);
   for(f=0;f<5;f++)
    {
     short y=120+60*f;
     escribir_texto(buffer,dt_puntos[f].txt,96,y,0);
     escribir_texto(buffer,txp,96+32*3,y,0);
     escribir_numero(buffer,dt_puntos[f].puntos,6,96+32*8,y,0);
    }
   escribir_texto(buffer,fm_idioma("volver","back"),fm_idioma(240,258),420,0);
   dibujar_mojca(buffer);

   reproducir_musica(2);
   fm_volcar();
   tcj_comprobar();
   if((tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC2] || tcj_estado[TCJ_AC3] ||
       tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5] || tcj_estado[TCJ_DER])
       && dt_mojca.mx==0 && dt_mojca.my==0)
     dt_mojca.mx=700;

  }while(dt_mojca.x<640);

 // Desaparece el texto.
 f=105;
 do
  {
   unsigned char transp;

   blit(fondo,buffer,0,0,0,0,640,480);
   dibujar_enems(0,buffer);

   draw_sprite(buffer,(BITMAP *)(f_obj[88].dat),64,28);

   if(f<31)
    {
     escribir_texto(buffer,dt_puntos[0].txt,96,120,transp=(unsigned char)(256-f*8));
     escribir_texto(buffer,txp,96+32*3,120,transp);
     escribir_numero(buffer,dt_puntos[0].puntos,6,96+32*8,120,transp);
    }
   else
    {
     escribir_texto(buffer,dt_puntos[0].txt,96,120,0);
     escribir_texto(buffer,txp,96+32*3,120,0);
     escribir_numero(buffer,dt_puntos[0].puntos,6,96+32*8,120,0);
    }

   if(f>15)
   if(f<46)
    {
     escribir_texto(buffer,dt_puntos[1].txt,96,180,transp=(unsigned char)(256-(f-15)*8));
     escribir_texto(buffer,txp,96+32*3,180,transp);
     escribir_numero(buffer,dt_puntos[1].puntos,6,96+32*8,180,transp);
    }
   else
    {
     escribir_texto(buffer,dt_puntos[1].txt,96,180,0);
     escribir_texto(buffer,txp,96+32*3,180,0);
     escribir_numero(buffer,dt_puntos[1].puntos,6,96+32*8,180,0);
    }

   if(f>30)
   if(f<61)
    {
     escribir_texto(buffer,dt_puntos[2].txt,96,240,transp=(unsigned char)(256-(f-30)*8));
     escribir_texto(buffer,txp,96+32*3,240,transp);
     escribir_numero(buffer,dt_puntos[2].puntos,6,96+32*8,240,transp);
    }
   else
    {
     escribir_texto(buffer,dt_puntos[2].txt,96,240,0);
     escribir_texto(buffer,txp,96+32*3,240,0);
     escribir_numero(buffer,dt_puntos[2].puntos,6,96+32*8,240,0);
    }

   if(f>45)
   if(f<76)
    {
     escribir_texto(buffer,dt_puntos[3].txt,96,300,transp=(unsigned char)(256-(f-45)*8));
     escribir_texto(buffer,txp,96+32*3,300,transp);
     escribir_numero(buffer,dt_puntos[3].puntos,6,96+32*8,300,transp);
    }
   else
    {
     escribir_texto(buffer,dt_puntos[3].txt,96,300,0);
     escribir_texto(buffer,txp,96+32*3,300,0);
     escribir_numero(buffer,dt_puntos[3].puntos,6,96+32*8,300,0);
    }

   if(f>60)
   if(f<91)
    {
     escribir_texto(buffer,dt_puntos[4].txt,96,360,transp=(unsigned char)(256-(f-60)*8));
     escribir_texto(buffer,txp,96+32*3,360,transp);
     escribir_numero(buffer,dt_puntos[4].puntos,6,96+32*8,360,transp);
    }
   else
    {
     escribir_texto(buffer,dt_puntos[4].txt,96,360,0);
     escribir_texto(buffer,txp,96+32*3,360,0);
     escribir_numero(buffer,dt_puntos[4].puntos,6,96+32*8,360,0);
    }

   if(f>75)
     escribir_texto(buffer,fm_idioma("volver","back"),fm_idioma(240,258),420,256-(f-75)*8);

   reproducir_musica(2);
   fm_volcar();

   f-=2;
  }while(f>0);

 destroy_bitmap(buffer);
 return EST_MENU;
}

#define fm_informar_txt() \
 letras=0; f=indice-7; if(f<0) f+=48; ptxt=alfabeto;\
 while(f) {if(ptxt[0]=='E') ptxt+=2; else ptxt++; f--;}\
 do\
  {if((txt[f++]=*ptxt)!='E')\
    {letras++; txt[f++]=' ';}\
   if((++ptxt)[0]==0) ptxt=alfabeto;\
  }while(letras<15);\
 txt[f-1]=0

//*******************************************************************
// Funcin introducir_puntos()
//    Se introducen las iniciales para la tabla de rcords.
//*******************************************************************
char introducir_puntos(void)
{
 int f;
 BITMAP *buffer=create_bitmap(640,480);
 BITMAP *fondo=(BITMAP *)(f_obj[87].dat);
 char alfabeto[]="aE1bcdeE2fghiE3jklmnE7oE4pqrstuE5vwxyz0123456789E0E6E8E9EaEb";
 char txt[45];
 char *ptxt;
 unsigned char indice=0, letras;
 char iniciales[9];
 char dtxt=0,xtxt=-32;
 char pulsado=1;

 if(idioma==1) alfabeto[59]='c';

 for(f=0;f<9;iniciales[f++]=0);
 fm_informar_txt();

 // Aparece el texto.
 f=1;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);
   dibujar_enems(0,buffer);
   draw_sprite(buffer,(BITMAP *)(f_obj[88].dat),64,28);

   if(idioma==0)
     escribir_texto(buffer,"enhorabuena",144,120,f<31?256-f*8:0);
   else
     escribir_texto(buffer,"congratulations",80,120,f<31?256-f*8:0);

   if(f>15)
   if(idioma==0)
     escribir_texto(buffer,"introduce tus",120,180,f<46?256-(f-15)*8:0);
   else
     escribir_texto(buffer,"enter your",168,180,f<46?256-(f-15)*8:0);

   if(f>30)
   if(idioma==0)
     escribir_texto(buffer,"iniciales",176,240,f<61?256-(f-30)*8:0);
   else
     escribir_texto(buffer,"initials",192,240,f<61?256-(f-30)*8:0);

   if(f>45)
     escribir_texto(buffer,txt,-32,334,256-(f-45)*8);

   reproducir_musica(2);
   fm_volcar();

   f+=2;
  }while(f<76);

 dt_mojca.x=-52;
 dt_mojca.y=284;
 dt_mojca.dx=dt_mojca.dy=0;
 dt_mojca.mx=348;
 dt_mojca.my=0;
 dt_mojca.fot=0;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);
   dibujar_enems(0,buffer);
   draw_sprite(buffer,(BITMAP *)(f_obj[88].dat),64,28);

   if(idioma==0)
    {
     escribir_texto(buffer,"enhorabuena",144,120,0);
     escribir_texto(buffer,"introduce tus",120,180,0);
     escribir_texto(buffer,"iniciales",176,240,0);
    }
   else
    {
     escribir_texto(buffer,"congratulations",80,120,0);
     escribir_texto(buffer,"enter your",168,180,0);
     escribir_texto(buffer,"initials",192,240,0);
    }

   if(dtxt)
    {
     if(dtxt>0)
      {
       xtxt+=12;
       dtxt-=12;
      }
     else
      {
       xtxt-=12;
       dtxt+=12;
      }
    }
   escribir_texto(buffer,txt,xtxt,334,0);
   if(xtxt==-80)
    {
     if(indice==47)
       indice=0;
     else
       indice++;
    }
   if(xtxt==16)
    {
     if(indice==0)
       indice=47;
     else
       indice--;
    }
   if(xtxt==-80 || xtxt==16)
    {
     xtxt=-32;
     fm_informar_txt();
    }

   if(iniciales[0])
    {
     escribir_texto(buffer,iniciales,272,394,0);
     if(iniciales[3])
      {
       escribir_texto(buffer,iniciales+3,304,394,0);
       if(iniciales[6])
         escribir_texto(buffer,iniciales+6,336,394,0);
      }
    }

   dibujar_mojca(buffer);
   reproducir_musica(2);
   fm_volcar();
   tcj_comprobar();
   if(dtxt==0 && dt_mojca.mx==0)
    {
     if(tcj_estado[TCJ_IZQ] && (indice!=46 || (indice==46 && !iniciales[6])))
      {
       dtxt=48;
       dt_mojca.invertir=0;
      }
     if(tcj_estado[TCJ_DER] && (indice!=47 || (indice==47 && !iniciales[6])))
      {
       dtxt=-48;
       dt_mojca.invertir=1;
      }

     if(!tcj_estado[TCJ_AC0] && !tcj_estado[TCJ_AC2] && !tcj_estado[TCJ_AC3] &&
        !tcj_estado[TCJ_AC4] && !tcj_estado[TCJ_AC5])
       pulsado=0;

     if((tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC2] || tcj_estado[TCJ_AC3] ||
         tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5]) && !pulsado)
      {
       pulsado=1;
       if(indice==47) // Fin
        {
         dt_mojca.mx=700;
        }
       else if(indice==46) // Se borra una letra
        {
         if(iniciales[6]) iniciales[6]=iniciales[7]=0;
         else if (iniciales[3]) iniciales[3]=iniciales[4]=0;
         else iniciales[0]=iniciales[1]=0;
        }
       else // Se escribe una letra
        {
         f=indice;
         ptxt=alfabeto;
         while(f)
          {
           if(ptxt[0]=='E')
             ptxt+=2;
           else
             ptxt++;
           f--;
          }
         f=0;
         while(iniciales[f]) f+=3;
         if((iniciales[f]=ptxt[0])=='E') iniciales[f+1]=ptxt[1];
         if(f==6)
          {
           indice=47;
           fm_informar_txt();
          }
        }
      }
    }

  }while(dt_mojca.x<640);

 // Desaparece el texto.
 f=90;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);
   dibujar_enems(0,buffer);
   draw_sprite(buffer,(BITMAP *)(f_obj[88].dat),64,28);

   if(idioma==0)
     escribir_texto(buffer,"enhorabuena",144,120,f<31?256-f*8:0);
   else
     escribir_texto(buffer,"congratulations",80,120,f<31?256-f*8:0);

   if(f>15)
   if(idioma==0)
     escribir_texto(buffer,"introduce tus",120,180,f<46?256-(f-15)*8:0);
   else
     escribir_texto(buffer,"enter your",168,180,f<46?256-(f-15)*8:0);

   if(f>30)
   if(idioma==0)
     escribir_texto(buffer,"iniciales",176,240,f<61?256-(f-30)*8:0);
   else
     escribir_texto(buffer,"initials",192,240,f<61?256-(f-30)*8:0);

   if(f>45)
     escribir_texto(buffer,txt,-32,334,f<76?256-(f-45)*8:0);

   if(f>60 && iniciales[0])
    {
     escribir_texto(buffer,iniciales,272,394,256-(f-60)*8);
     if(iniciales[3])
      {
       escribir_texto(buffer,iniciales+3,304,394,256-(f-60)*8);
       if(iniciales[6])
         escribir_texto(buffer,iniciales+6,336,394,256-(f-60)*8);
      }
    }

   reproducir_musica(2);
   fm_volcar();

   f-=2;
  }while(f>0);

 destroy_bitmap(buffer);
 // Si se ha escrito algo, se introducen las iniciales y los puntos en la tabla
 if(iniciales[0])
  {char n;
   f=3;
   while(nuevo_record>dt_puntos[f].puntos && f>=0)
    {
     dt_puntos[f+1].puntos=dt_puntos[f].puntos;
     for(n=0;n<6;n++)
       dt_puntos[f+1].txt[n]=dt_puntos[f].txt[n];
     f--;
    }

   f++;
   dt_puntos[f].puntos=nuevo_record;
   if((dt_puntos[f].txt[0]=iniciales[0])=='E')
    {
     dt_puntos[f].txt[1]=iniciales[1];
     n=2;
    }
   else
     n=1;

   if((dt_puntos[f].txt[n]=iniciales[3])=='E')
    {
     dt_puntos[f].txt[n+1]=iniciales[4];
     n+=2;
    }
   else
     n+=1;

   if((dt_puntos[f].txt[n]=iniciales[6])=='E')
    {
     dt_puntos[f].txt[n+1]=iniciales[7];
     n+=2;
    }
   else
     n+=1;
   for(;n<7;n++) dt_puntos[f].txt[n]=0;
   escribir_cfg();
  }

 return EST_VERPTS;
}

//******************************************************************************
// Funcin pausa(...)
//    Muestra una imgen oscurecida del buffer del juego, dando la
//    opcin de continuar el juego o volver al men principal.
//******************************************************************************
char pausa(BITMAP *buffer2, char mus, int *num_suelo)
{
 BITMAP *buffer=create_bitmap(640,480);
 BITMAP *fondo=create_bitmap(640,480);
 char f;
 unsigned char tx=fm_idioma(96,144);
 int contador=*num_suelo;

 clear_bitmap(fondo);
 set_trans_blender(0,0,0,128);
 draw_trans_sprite(fondo,buffer2,0,0);

 // Aparece el texto.
 f=1;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);

   escribir_texto(buffer,fm_idioma("volver al juego","back to game"),tx,130,f<31?256-f*8:0);

   if(f>15)
     escribir_texto(buffer,fm_idioma("salir del juego","exit game"),tx,190,256-(f-15)*8);

   f+=2;
   if(mus<100) reproducir_musica(mus);
   fm_volcar();
   if(contador <0 && contador > -450) contador--;
  }while(f<46);

 dt_mojca.x=-48;
 dt_mojca.y=120;
 dt_mojca.dx=dt_mojca.dy=0;
 dt_mojca.mx=tx;
 dt_mojca.my=0;
 dt_mojca.fot=0;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);
   escribir_texto(buffer,fm_idioma("volver al juego","back to game"),tx,130,0);
   escribir_texto(buffer,fm_idioma("salir del juego","exit game"),tx,190,0);
   dibujar_mojca(buffer);
   if(mus<100) reproducir_musica(mus);

   fm_volcar();
   if(contador <0 && contador > -450) contador--;
   tcj_comprobar();
   if(tcj_estado[TCJ_ABJ] && dt_mojca.mx==0 && dt_mojca.my==0 && dt_mojca.y<180)
     dt_mojca.my=60;
   if(tcj_estado[TCJ_ARR] && dt_mojca.mx==0 && dt_mojca.my==0 && dt_mojca.y>120)
     dt_mojca.my=-60;
   if((tcj_estado[TCJ_AC0] || tcj_estado[TCJ_AC2] || tcj_estado[TCJ_AC3] ||
       tcj_estado[TCJ_AC4] || tcj_estado[TCJ_AC5] || tcj_estado[TCJ_DER])
       && dt_mojca.mx==0 && dt_mojca.my==0)
     dt_mojca.mx=700;

  }while(dt_mojca.x<640);

 // Desaparece el texto.
 f=45;
 do
  {
   blit(fondo,buffer,0,0,0,0,640,480);

   escribir_texto(buffer,fm_idioma("volver al juego","back to game"),tx,130,f<31?256-f*8:0);

   if(f>15)
     escribir_texto(buffer,fm_idioma("salir del juego","exit game"),tx,190,256-(f-15)*8);

   dibujar_mojca(buffer);
   f-=2;
   if(mus<100) reproducir_musica(mus);
   fm_volcar();
   if(contador <0 && contador > -450) contador--;
  }while(f>0);

 destroy_bitmap(fondo);
 destroy_bitmap(buffer);
 *num_suelo=contador;
 if(dt_mojca.y==180)
  {
   f=0;
   detener_sonidos();
  }
 else
   f=1;
 return f;
}

//*******************************\\
//  Funciones de inicializacin  \\
//*******************************\\

//******************************************************************************
// Funcin ini_allegro()
//    Inicializa la librera Allegro.
//******************************************************************************
void ini_allegro(void)
{
 allegro_init();
 modo_truecolor=0;
 modo_pc=1;

 set_color_depth(16);
 if(set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0))
  {
   modo_truecolor=1;
   set_color_depth(32);
   if(set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0))
    {
     modo_pc=0;
     modo_truecolor=0;
     set_color_depth(16);
     if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0))
      {
       modo_truecolor=1;
       set_color_depth(32);
       if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0))
        {
         allegro_message("No se ha podido establecer ningun modo de video./nCould not set any video mode.");
         modo_pc=2;
        }
      }
    }
  }
}

//******************************************************************************
// Funcin ini_entrada()
//    Inicializa los dispositivos de entrada (teclado y joystick).
//******************************************************************************
void ini_entrada(void)
{
 tcj_inicializar(TCJ_INSTALAR_T_J);
 tcj_incorporar_tecla(TCJ_ARR, KEY_Q);
 tcj_incorporar_tecla(TCJ_ABJ, KEY_A);
 tcj_incorporar_tecla(TCJ_IZQ, KEY_O);
 tcj_incorporar_tecla(TCJ_DER, KEY_P);
 tcj_incorporar_tecla(TCJ_ARR, KEY_UP);
 tcj_incorporar_tecla(TCJ_ABJ, KEY_DOWN);
 tcj_incorporar_tecla(TCJ_IZQ, KEY_LEFT);
 tcj_incorporar_tecla(TCJ_DER, KEY_RIGHT);
 tcj_incorporar_tecla(TCJ_AC0, KEY_SPACE);
 tcj_incorporar_tecla(TCJ_AC0, KEY_LCONTROL);
 tcj_incorporar_tecla(TCJ_AC1, KEY_ESC);
 tcj_incorporar_tecla(TCJ_AC2, KEY_RCONTROL);
 tcj_incorporar_tecla(TCJ_AC2, KEY_LSHIFT);
 tcj_incorporar_tecla(TCJ_AC3, KEY_Z);
 tcj_incorporar_tecla(TCJ_AC3, KEY_RSHIFT);
 tcj_incorporar_tecla(TCJ_AC4, KEY_ENTER);
 tcj_incorporar_tecla(TCJ_AC4, KEY_ENTER_PAD);
 tcj_incorporar_tecla(TCJ_AC5, KEY_M);
 tcj_incorporar_tecla(TCJ_AC5, KEY_N);
}

//****************************************************\\
//  Funciones de dibujo de cursor (mojca) y enemigos  \\
//****************************************************\\

//******************************************************************************
// Funcin dibujar_mojca(...)
//    Dibuja el cursor (la mojca), movindolo si es necesario.
//******************************************************************************
void dibujar_mojca(BITMAP *buffer)
{

 if(dt_mojca.fot==9)
   dt_mojca.fot=0;
 else
   dt_mojca.fot++;
 
 if(dt_mojca.mx || dt_mojca.my)
  {// Hay que mover la mojca.
   if(dt_mojca.mx<0)
    {
     dt_mojca.x-=(dt_mojca.mx>-12?6:12);
     dt_mojca.mx+=(dt_mojca.mx>-12?6:12);
     dt_mojca.invertir=0;
    }
   if(dt_mojca.mx>0)
    {
     dt_mojca.x+=(dt_mojca.mx<12?6:12);
     dt_mojca.mx-=(dt_mojca.mx<12?6:12);
     dt_mojca.invertir=1;
    }

   if(dt_mojca.my<0)
    {
     dt_mojca.y-=(dt_mojca.my>-12?6:12);
     dt_mojca.my+=(dt_mojca.my>-12?6:12);
    }
   if(dt_mojca.my>0)
    {
     dt_mojca.y+=(dt_mojca.my<12?6:12);
     dt_mojca.my-=(dt_mojca.my<12?6:12);
    }
  }
 else
  { // Movimiento aleatorio de la mojca cuando est quieta en el sitio.
   if(dt_mojca.fot==0 || dt_mojca.fot==5)
    {
     dt_mojca.dx+=((rand()%3)-1)*2;
     if(dt_mojca.dx==-4) dt_mojca.dx=-2;
     if(dt_mojca.dx== 4) dt_mojca.dx= 2;

     dt_mojca.dy+=((rand()%3)-1)*2;
     if(dt_mojca.dy==-4) dt_mojca.dy=-2;
     if(dt_mojca.dy== 4) dt_mojca.dy= 2;
    }
  }

 (dt_mojca.invertir?draw_sprite_h_flip:draw_sprite)
   (buffer,m_enemigo[dt_mojca.fot/5],dt_mojca.x+dt_mojca.dx,dt_mojca.y+dt_mojca.dy);
}

//******************************************************************************
// Funcin dibujar_enems(...)
//    Dibuja los enemigos que se mueven por detrs del texto de las
//    opciones. Si ini==1 no se dibujan, sino que se colocan fuera de
//    la pantalla.
//******************************************************************************
void dibujar_enems(char ini, BITMAP *buffer)
{
 char f;

 if(!ini)
   for(f=0;f<NUM_ENEMS;f++)
    {
     dt_enemigo[f].x+=dt_enemigo[f].dx;
     dt_enemigo[f].y+=dt_enemigo[f].dy;
     if(dt_enemigo[f].fot==13)
       dt_enemigo[f].fot=0;
     else
      dt_enemigo[f].fot++;

     if(dt_enemigo[f].invertir)
       draw_sprite_h_flip(buffer,m_enemigo[dt_enemigo[f].tipo+dt_enemigo[f].fot/7],
                          dt_enemigo[f].x,dt_enemigo[f].y);
     else
       draw_sprite(buffer,m_enemigo[dt_enemigo[f].tipo+dt_enemigo[f].fot/7],
                   dt_enemigo[f].x,dt_enemigo[f].y);
    }

 for(f=0;f<NUM_ENEMS;f++)
   if((dt_enemigo[f].x>=640 && dt_enemigo[f].dx>0) ||
      (dt_enemigo[f].x<=-ANCHO_CELDA && dt_enemigo[f].dx<0) ||
      (dt_enemigo[f].y>=480 && dt_enemigo[f].dy>0) ||
      (dt_enemigo[f].y<=-ANCHO_CELDA && dt_enemigo[f].dy<0) ||
      ini)
    { 
     dt_enemigo[f].tipo=(1+rand()%29)*2;
     dt_enemigo[f].fot=rand()%8;
     switch(rand()%4)
      {
       case 0: // Enemigo que se mueve hacia la derecha
         dt_enemigo[f].x=0-(ini?f*ANCHO_CELDA:0)-ANCHO_CELDA;
         dt_enemigo[f].dx=2;
         dt_enemigo[f].y=rand()%(480-ANCHO_CELDA);
         dt_enemigo[f].dy=0;
         dt_enemigo[f].invertir=1;
         break;
       case 1: // Enemigo que se mueve hacia la izquierda
         dt_enemigo[f].x=640+(ini?f*ANCHO_CELDA:0);
         dt_enemigo[f].dx=-2;
         dt_enemigo[f].y=rand()%(480-ANCHO_CELDA);
         dt_enemigo[f].dy=0;
         dt_enemigo[f].invertir=0;
         break;
       case 2: // Enemigo que se mueve hacia abajo
         dt_enemigo[f].y=0-(ini?f*ANCHO_CELDA:0)-ANCHO_CELDA;
         dt_enemigo[f].dy=2;
         dt_enemigo[f].x=rand()%(640-ANCHO_CELDA);
         dt_enemigo[f].dx=0;
         dt_enemigo[f].invertir=rand()%2;
         break;
       case 3: // Enemigo que se mueve hacia arriba
         dt_enemigo[f].y=480+(ini?f*ANCHO_CELDA:0);
         dt_enemigo[f].dy=-2;
         dt_enemigo[f].x=rand()%(640-ANCHO_CELDA);
         dt_enemigo[f].dx=0;
         dt_enemigo[f].invertir=rand()%2;
         break;
      }
    }
}

//******************************************\\
//  Funciones del fichero de configuracin  \\
//******************************************\\

//******************************************************************************
// Funcin leer_cfg()
//    Le el fichero de configuracin.
//******************************************************************************
void leer_cfg(void)
{
 PACKFILE *cfg;
 char f;

 if(cfg=pack_fopen("cfg.dat",F_READ))
  {
   pack_fread(&idioma, sizeof(unsigned char), cfg);
   pack_fread(&parallax_activo, sizeof(unsigned char), cfg);
   pack_fread(&inicio_n, sizeof(unsigned char), cfg);
   pack_fread(&inicio_f, sizeof(unsigned char), cfg);
   pack_fread(&volson, sizeof(unsigned char), cfg);
   pack_fread(&volmus, sizeof(unsigned char), cfg);
   for(f=0;f<5;f++)
    {
     dt_puntos[f].txt[6]=0;
     pack_fread(dt_puntos[f].txt, 6*sizeof(char), cfg);
     dt_puntos[f].puntos=pack_igetl(cfg);
    }
   pack_fclose(cfg);
  }
 else
  { // No existe fichero de configuracin, por lo que se asignan valores por defecto.
   idioma=2;
   parallax_activo=1;
   inicio_n=inicio_f=0;
   volson=volmus=100;

   dt_puntos[0].txt[0]='z'; dt_puntos[0].txt[1]='i'; dt_puntos[0].txt[2]='g';
   dt_puntos[0].txt[3]=dt_puntos[0].txt[3]=dt_puntos[0].txt[3]=dt_puntos[0].txt[3]=0;
   dt_puntos[0].puntos=25000;

   dt_puntos[1].txt[0]='g'; dt_puntos[1].txt[1]='r'; dt_puntos[1].txt[2]='a';
   dt_puntos[1].txt[3]=dt_puntos[1].txt[3]=dt_puntos[1].txt[3]=dt_puntos[1].txt[3]=0;
   dt_puntos[1].puntos=20000;

   dt_puntos[2].txt[0]='a'; dt_puntos[2].txt[1]='d'; dt_puntos[2].txt[2]='w';
   dt_puntos[2].txt[3]=dt_puntos[2].txt[3]=dt_puntos[2].txt[3]=dt_puntos[2].txt[3]=0;
   dt_puntos[2].puntos=15000;

   dt_puntos[3].txt[0]='r'; dt_puntos[3].txt[1]='m'; dt_puntos[3].txt[2]='o';
   dt_puntos[3].txt[3]=dt_puntos[3].txt[3]=dt_puntos[3].txt[3]=dt_puntos[3].txt[3]=0;
   dt_puntos[3].puntos=10000;

   dt_puntos[4].txt[0]='i'; dt_puntos[4].txt[1]='p'; dt_puntos[4].txt[2]='g';
   dt_puntos[4].txt[3]=dt_puntos[4].txt[3]=dt_puntos[4].txt[3]=dt_puntos[4].txt[3]=0;
   dt_puntos[4].puntos=5000;
  }

 modificar_volmus(volmus);
 modificar_volson(volson, -1);
}

//******************************************************************************
// Funcin escribir_cfg()
//    Escribe el fichero de configuracin.
//******************************************************************************
void escribir_cfg(void)
{
 PACKFILE *cfg;
 char f;

 cfg=pack_fopen("cfg.dat",F_WRITE);
 pack_fwrite(&idioma, sizeof(unsigned char), cfg);
 pack_fwrite(&parallax_activo, sizeof(unsigned char), cfg);
 pack_fwrite(&inicio_n, sizeof(unsigned char), cfg);
 pack_fwrite(&inicio_f, sizeof(unsigned char), cfg);
 pack_fwrite(&volson, sizeof(unsigned char), cfg);
 pack_fwrite(&volmus, sizeof(unsigned char), cfg);
 for(f=0;f<5;f++)
  {
   pack_fwrite(dt_puntos[f].txt, 6*sizeof(char), cfg);
   pack_iputl(dt_puntos[f].puntos, cfg);
  }

 pack_fclose(cfg);
}

