#include "../config.h"

#ifdef _CAST_
#include "../cpu/68000.h"
#include "../cpu/op68k.h"
#else
#include "../cpu/m68k.h"
#endif

// to register io functions
#include "../mmu/mmu.h"

#include "via.h"

// the mapping address of this VIA
#define VIABASE 0xD901
// the increment value
#define VIA_INC 8


uint8 via_hdd_orb;
uint8 via_hdd_ora;
uint8 via_hdd_ira=0x00;
uint8 via_hdd_irb=0xff;
uint8 via_hdd_ddrb;
uint8 via_hdd_ddra;

uint8 via_hdd_t1c_l;
uint8 via_hdd_t1c_h;

uint8 via_hdd_t1l_l;
uint8 via_hdd_t1l_h;

uint8 via_hdd_t2c_l;
uint8 via_hdd_t2c_h;

uint8 via_hdd_sr;
uint8 via_hdd_acr;
uint8 via_hdd_pcr;
uint8 via_hdd_ifr;
uint8 via_hdd_ier;

// check VIA status update
void via_hdd_tick(void)
{
    IDLE_INIT_FUNC("via_hdd_tick()");
 // fixme : should handle timers
 
 // test T1
 // T1 in timed interrupt
// if ((via_hdd_acr&0xC0) == 0x40)
//    if (via_hdd_ier&0x40) {
//       static int c=1;
//       c=(c+1)%256;
//       if (c==0) {
//           IDLE_TRACE("random T1 interrupt");
//           via_hdd_ifr|=0xC0;
//           m68k_set_irq(M68K_IRQ_1);
//       }
// }
}

void via_hdd_access_orb(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_orb=*val&0xFF;
     }
     else
     {
        *val=(int)((via_hdd_orb&via_hdd_ddrb) |
        (via_hdd_irb&(~via_hdd_ddrb))) & 0xFF;
     }
}

void via_hdd_access_ora(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_ora=*val&0xFF;
     }
     else
     {
        *val=(int)((via_hdd_ora&via_hdd_ddra) |
        (via_hdd_ira&(~via_hdd_ddra))) & 0xFF;
     }
}

void via_hdd_access_ddrb(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_ddrb=*val&0xFF;
     }
     else
     {
        *val=(int)((via_hdd_orb&via_hdd_ddrb) |
        (via_hdd_irb&(~via_hdd_ddrb))) & 0xFF;
     }
}

void via_hdd_access_ddra(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_ddra=*val&0xFF;
     }
     else
     {
         *val=via_hdd_ddra;
     }
}

void via_hdd_access_t1c_l(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_t1c_l=*val&0xFF;
     }
     else
     {
         *val=via_hdd_t1c_l;
     }
}

void via_hdd_access_t1c_h(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_t1c_h=*val&0xFF;
     }
     else
     {
         *val=via_hdd_t1c_h;
     }
}

void via_hdd_access_t1l_l(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_t1l_l=*val&0xFF;
     }
     else
     {
         *val=via_hdd_t1l_l;
     }
}

void via_hdd_access_t1l_h(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_t1l_h=*val&0xFF;
     }
     else
     {
         *val=via_hdd_t1l_h;
     }
}

void via_hdd_access_t2c_l(int* val,int mode,int size)
{
     IDLE_INIT_FUNC("via_hdd_access_t2c_l");
     if (mode==IO_WRITE)
     {
        IDLE_TRACE("set T2l=%02x acr=%02x ier=%02x",*val,via_hdd_acr,via_hdd_ier);
        via_hdd_t2c_l=*val&0xFF;
     }
     else
     {
         *val=via_hdd_t2c_l;
        IDLE_TRACE("get T2l=%02x acr=%02x ier=%02x",*val,via_hdd_acr,via_hdd_ier);
     }
}

void via_hdd_access_t2c_h(int* val,int mode,int size)
{
     IDLE_INIT_FUNC("via_hdd_access_t2c_h");
     
     if (mode==IO_WRITE)
     {
        IDLE_TRACE("set T2h=%02x acr=%02x ier=%02x",*val,via_hdd_acr,via_hdd_ier);
        via_hdd_t2c_h=*val&0xFF;
     }
     else
     {
         *val=via_hdd_t2c_h;
        IDLE_TRACE("get T2h=%02x acr=%02x ier=%02x",*val,via_hdd_acr,via_hdd_ier);
     }
}

void via_hdd_access_sr(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_sr=*val&0xFF;
     }
     else
     {
         *val=via_hdd_sr;
     }
}

void via_hdd_access_acr(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_acr=*val&0xFF;
     }
     else
     {
         *val=via_hdd_acr;
     }
}

void via_hdd_access_pcr(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_pcr=*val&0xFF;
     }
     else
     {
         *val=via_hdd_pcr;
     }
}

void via_hdd_access_ifr(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_ifr=via_hdd_ifr&((!(*val&0x7F))&0xFF);
        if ((via_hdd_ifr&0x7F)!=0x00) via_hdd_ifr|=0x80;
        else via_hdd_ifr&=0x7f;
     }
     else
     {
         *val=via_hdd_ifr;
     }
}

void via_hdd_access_ier(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        // set ier                
        if (*val&0x80)
            via_hdd_ier|=(*val&0x7F);
        // reset ier
        else
            via_hdd_ier=(via_hdd_ier&(!(*val&0x7F)))&0x7F;

     }
     else
     {
         *val=via_hdd_ier;
     }
}

void via_hdd_access_ora_direct(int* val,int mode,int size)
{
     if (mode==IO_WRITE)
     {
        via_hdd_ora=*val&0xFF;
     }
     else
     {
         *val=via_hdd_ora;
     }
}

void via_set_DIAG(void)
{
     via_hdd_irb|=0x40;
}

void via_reset_DIAG(void)
{
     IDLE_INIT_FUNC("via_reset_DIAG()");
     via_hdd_irb&=0xBF;
     
     // if T2 is in pulse counting mode
     if ((via_hdd_acr&0x20) == 0x20) {
        IDLE_TRACE("t2 PULSE mode %04x",(via_hdd_t2c_h<<8)|via_hdd_t2c_l);
        via_hdd_ifr|=0xA0;
        m68k_set_irq(M68K_IRQ_2);
     }
}

void init_via_hdd_io(void)
{
     int i,j;
     for (i=0xD800;i<0xDC00;i=i+0x80)
         for (j=0;j<8;j+=2) {
             registerIoFunc(i+j+1+VIA_ORB*VIA_INC     ,&via_hdd_access_orb);
             registerIoFunc(i+j+1+VIA_ORA*VIA_INC     ,&via_hdd_access_ora);
             registerIoFunc(i+j+1+VIA_DDRB*VIA_INC    ,&via_hdd_access_ddrb);
             registerIoFunc(i+j+1+VIA_DDRA*VIA_INC    ,&via_hdd_access_ddra);
             registerIoFunc(i+j+1+VIA_T1C_L*VIA_INC   ,&via_hdd_access_t1c_l);
             registerIoFunc(i+j+1+VIA_T1C_H*VIA_INC   ,&via_hdd_access_t1c_h);
             registerIoFunc(i+j+1+VIA_T1L_L*VIA_INC   ,&via_hdd_access_t1l_l);
             registerIoFunc(i+j+1+VIA_T1L_H*VIA_INC   ,&via_hdd_access_t1l_h);
             registerIoFunc(i+j+1+VIA_T2C_L*VIA_INC   ,&via_hdd_access_t2c_l);
             registerIoFunc(i+j+1+VIA_T2C_H*VIA_INC   ,&via_hdd_access_t2c_h);
             registerIoFunc(i+j+1+VIA_SR*VIA_INC      ,&via_hdd_access_sr);
             registerIoFunc(i+j+1+VIA_ACR*VIA_INC     ,&via_hdd_access_acr);
             registerIoFunc(i+j+1+VIA_PCR*VIA_INC     ,&via_hdd_access_pcr);
             registerIoFunc(i+j+1+VIA_IFR*VIA_INC     ,&via_hdd_access_ifr);
             registerIoFunc(i+j+1+VIA_IER*VIA_INC     ,&via_hdd_access_ier);
             registerIoFunc(i+j+1+VIA_ORA_DIRECT*VIA_INC,&via_hdd_access_ora_direct);
     }
}
