/*
 * Castaway
 *  (C) 1994 - 2002 Martin Doering, Joachim Hoenig
 *
 * $File$ - 68k add instructions
 *
 * This file is distributed under the GPL, version 2 or at your
 * option any later version.  See doc/license.txt for details.
 *
 * revision history
 *  23.05.2002  JH  FAST1.0.1 code import: KR -> ANSI, restructuring
 *  10.07.2002  JH  Fixed Z-Flag for ADDX
 *  08.10.2002  JH  Fixed Z-Flag for ADD.B 0x80+0x80 and Add.W 0x8000+0x8000.
 *  30.10.2002  JH  Replaced "% 8" with "& 7". Helps lesser compilers to generate faster code.
 */
#ifndef PROTOH
static char     sccsid[] = "$Id: op68kadd.c,v 1.2 2006/10/26 19:42:02 gilles_fetis Exp $";
#include "68000.h"
#include "op68k.h"

/*
 * Opfuncs.
 */

#define DoAddB(target,source) \
    {register int32 tgt;\
    tgt = target + source;\
    SetXC((uint32) source > (uint32) ~target);\
    SetV((tgt < -128) || (tgt > 127));\
    target = tgt;\
    SetNZ(target);};
#define DoAddW(target,source) \
    {register int32 tgt;\
    tgt = target + source;\
    SetXC((uint32) source > (uint32) ~target);\
    SetV((tgt < -32768) || (tgt > 32767));\
    target = tgt;\
    SetNZ(target);};
#define DoAddL(target,source) \
    /* Overflow precondition: source has same sign */\
    SetV((target < 0) == (source < 0));\
    SetXC((uint32) source > (uint32) ~target);\
    target += source;\
    /* target and source now have different sign: overflow! */\
    SetV(GetV() && (target<0) != (source<0));\
    SetNZ(target);

#define DoAdda(target,source) target += source;

#define DoAddx(target,source) \
    /* Overflow precondition: source has same sign */\
    SetV ((target < 0) == (source < 0));\
    if (GetX ()) {\
        SetXC ((uint32) source >= (uint32) ~target);\
        target += source + 1;\
    } else {\
        SetXC ((uint32) source > (uint32) ~target);\
        target += source;\
    }\
    /* target and source now have different sign: overflow! */\
    SetV (GetV() && (target<0) != (source<0));\
    SetZ(target == 0 ? GetZ() : 0);\
    SetN(target < 0);

#endif

Oper (Opd000, DoAddB, DB, SdB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opd010, DoAddB, DB, SainB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opd018, DoAddB, DB, SaipB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opd020, DoAddB, DB, SmaiB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opd028, DoAddB, DB, SdaiB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opd030, DoAddB, DB, SaixB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opd038, DoAddB, DB, SearB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opd040, DoAddW, DW, SdW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opd048, DoAddW, DW, SaW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opd050, DoAddW, DW, SainW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opd058, DoAddW, DW, SaipW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opd060, DoAddW, DW, SmaiW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opd068, DoAddW, DW, SdaiW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opd070, DoAddW, DW, SaixW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opd078, DoAddW, DW, SearW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opd080, DoAddL, DL, SdL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opd088, DoAddL, DL, SaL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opd090, DoAddL, DL, SainL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opd098, DoAddL, DL, SaipL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opd0a0, DoAddL, DL, SmaiL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opd0a8, DoAddL, DL, SdaiL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opd0b0, DoAddL, DL, SaixL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opd0b8, DoAddL, DL, SearL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opd0c0, DoAdda, DL, SdW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd0c8, DoAdda, DL, SaW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd0d0, DoAdda, DL, SainW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd0d8, DoAdda, DL, SaipW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd0e0, DoAdda, DL, SmaiW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd0e8, DoAdda, DL, SdaiW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd0f0, DoAdda, DL, SaixW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd0f8, DoAdda, DL, SearW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)

Oper (Opd100, DoAddx, DB, SdB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opd108, DoAddx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 0, GMB, SMB)
Oper (Opd110, DoAddB, DB, SdB, 0, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opd118, DoAddB, DB, SdB, 0, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opd120, DoAddB, DB, SdB, 0, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opd128, DoAddB, DB, SdB, 0, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opd130, DoAddB, DB, SdB, 0, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opd138, DoAddB, DB, SdB, 0, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opd140, DoAddx, DW, SdW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opd148, DoAddx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 0, GMW, SMW)
Oper (Opd150, DoAddW, DW, SdW, 0, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opd158, DoAddW, DW, SdW, 0, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opd160, DoAddW, DW, SdW, 0, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opd168, DoAddW, DW, SdW, 0, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opd170, DoAddW, DW, SdW, 0, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opd178, DoAddW, DW, SdW, 0, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opd180, DoAddx, DL, SdL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opd188, DoAddx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 0, GML, SML)
Oper (Opd190, DoAddL, DL, SdL, 0, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opd198, DoAddL, DL, SdL, 0, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opd1a0, DoAddL, DL, SdL, 0, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opd1a8, DoAddL, DL, SdL, 0, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opd1b0, DoAddL, DL, SdL, 0, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opd1b8, DoAddL, DL, SdL, 0, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Opd1c0, DoAdda, DL, SdL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd1c8, DoAdda, DL, SaL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd1d0, DoAdda, DL, SainL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd1d8, DoAdda, DL, SaipL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd1e0, DoAdda, DL, SmaiL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd1e8, DoAdda, DL, SdaiL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd1f0, DoAdda, DL, SaixL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Opd1f8, DoAdda, DL, SearL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)

Oper (Opd200, DoAddB, DB, SdB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opd210, DoAddB, DB, SainB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opd218, DoAddB, DB, SaipB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opd220, DoAddB, DB, SmaiB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opd228, DoAddB, DB, SdaiB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opd230, DoAddB, DB, SaixB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opd238, DoAddB, DB, SearB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opd240, DoAddW, DW, SdW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opd248, DoAddW, DW, SaW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opd250, DoAddW, DW, SainW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opd258, DoAddW, DW, SaipW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opd260, DoAddW, DW, SmaiW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opd268, DoAddW, DW, SdaiW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opd270, DoAddW, DW, SaixW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opd278, DoAddW, DW, SearW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opd280, DoAddL, DL, SdL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opd288, DoAddL, DL, SaL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opd290, DoAddL, DL, SainL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opd298, DoAddL, DL, SaipL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opd2a0, DoAddL, DL, SmaiL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opd2a8, DoAddL, DL, SdaiL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opd2b0, DoAddL, DL, SaixL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opd2b8, DoAddL, DL, SearL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opd2c0, DoAdda, DL, SdW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd2c8, DoAdda, DL, SaW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd2d0, DoAdda, DL, SainW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd2d8, DoAdda, DL, SaipW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd2e0, DoAdda, DL, SmaiW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd2e8, DoAdda, DL, SdaiW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd2f0, DoAdda, DL, SaixW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd2f8, DoAdda, DL, SearW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)

Oper (Opd300, DoAddx, DB, SdB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opd308, DoAddx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 1, GMB, SMB)
Oper (Opd310, DoAddB, DB, SdB, 1, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opd318, DoAddB, DB, SdB, 1, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opd320, DoAddB, DB, SdB, 1, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opd328, DoAddB, DB, SdB, 1, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opd330, DoAddB, DB, SdB, 1, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opd338, DoAddB, DB, SdB, 1, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opd340, DoAddx, DW, SdW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opd348, DoAddx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 1, GMW, SMW)
Oper (Opd350, DoAddW, DW, SdW, 1, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opd358, DoAddW, DW, SdW, 1, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opd360, DoAddW, DW, SdW, 1, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opd368, DoAddW, DW, SdW, 1, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opd370, DoAddW, DW, SdW, 1, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opd378, DoAddW, DW, SdW, 1, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opd380, DoAddx, DL, SdL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opd388, DoAddx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 1, GML, SML)
Oper (Opd390, DoAddL, DL, SdL, 1, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opd398, DoAddL, DL, SdL, 1, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opd3a0, DoAddL, DL, SdL, 1, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opd3a8, DoAddL, DL, SdL, 1, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opd3b0, DoAddL, DL, SdL, 1, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opd3b8, DoAddL, DL, SdL, 1, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Opd3c0, DoAdda, DL, SdL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd3c8, DoAdda, DL, SaL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd3d0, DoAdda, DL, SainL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd3d8, DoAdda, DL, SaipL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd3e0, DoAdda, DL, SmaiL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd3e8, DoAdda, DL, SdaiL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd3f0, DoAdda, DL, SaixL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Opd3f8, DoAdda, DL, SearL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)

Oper (Opd400, DoAddB, DB, SdB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opd410, DoAddB, DB, SainB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opd418, DoAddB, DB, SaipB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opd420, DoAddB, DB, SmaiB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opd428, DoAddB, DB, SdaiB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opd430, DoAddB, DB, SaixB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opd438, DoAddB, DB, SearB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opd440, DoAddW, DW, SdW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opd448, DoAddW, DW, SaW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opd450, DoAddW, DW, SainW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opd458, DoAddW, DW, SaipW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opd460, DoAddW, DW, SmaiW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opd468, DoAddW, DW, SdaiW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opd470, DoAddW, DW, SaixW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opd478, DoAddW, DW, SearW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opd480, DoAddL, DL, SdL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opd488, DoAddL, DL, SaL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opd490, DoAddL, DL, SainL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opd498, DoAddL, DL, SaipL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opd4a0, DoAddL, DL, SmaiL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opd4a8, DoAddL, DL, SdaiL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opd4b0, DoAddL, DL, SaixL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opd4b8, DoAddL, DL, SearL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opd4c0, DoAdda, DL, SdW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd4c8, DoAdda, DL, SaW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd4d0, DoAdda, DL, SainW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd4d8, DoAdda, DL, SaipW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd4e0, DoAdda, DL, SmaiW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd4e8, DoAdda, DL, SdaiW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd4f0, DoAdda, DL, SaixW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd4f8, DoAdda, DL, SearW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)

Oper (Opd500, DoAddx, DB, SdB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opd508, DoAddx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 2, GMB, SMB)
Oper (Opd510, DoAddB, DB, SdB, 2, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opd518, DoAddB, DB, SdB, 2, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opd520, DoAddB, DB, SdB, 2, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opd528, DoAddB, DB, SdB, 2, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opd530, DoAddB, DB, SdB, 2, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opd538, DoAddB, DB, SdB, 2, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opd540, DoAddx, DW, SdW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opd548, DoAddx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 2, GMW, SMW)
Oper (Opd550, DoAddW, DW, SdW, 2, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opd558, DoAddW, DW, SdW, 2, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opd560, DoAddW, DW, SdW, 2, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opd568, DoAddW, DW, SdW, 2, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opd570, DoAddW, DW, SdW, 2, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opd578, DoAddW, DW, SdW, 2, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opd580, DoAddx, DL, SdL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opd588, DoAddx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 2, GML, SML)
Oper (Opd590, DoAddL, DL, SdL, 2, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opd598, DoAddL, DL, SdL, 2, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opd5a0, DoAddL, DL, SdL, 2, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opd5a8, DoAddL, DL, SdL, 2, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opd5b0, DoAddL, DL, SdL, 2, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opd5b8, DoAddL, DL, SdL, 2, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Opd5c0, DoAdda, DL, SdL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd5c8, DoAdda, DL, SaL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd5d0, DoAdda, DL, SainL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd5d8, DoAdda, DL, SaipL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd5e0, DoAdda, DL, SmaiL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd5e8, DoAdda, DL, SdaiL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd5f0, DoAdda, DL, SaixL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Opd5f8, DoAdda, DL, SearL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)

Oper (Opd600, DoAddB, DB, SdB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opd610, DoAddB, DB, SainB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opd618, DoAddB, DB, SaipB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opd620, DoAddB, DB, SmaiB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opd628, DoAddB, DB, SdaiB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opd630, DoAddB, DB, SaixB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opd638, DoAddB, DB, SearB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opd640, DoAddW, DW, SdW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opd648, DoAddW, DW, SaW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opd650, DoAddW, DW, SainW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opd658, DoAddW, DW, SaipW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opd660, DoAddW, DW, SmaiW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opd668, DoAddW, DW, SdaiW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opd670, DoAddW, DW, SaixW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opd678, DoAddW, DW, SearW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opd680, DoAddL, DL, SdL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opd688, DoAddL, DL, SaL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opd690, DoAddL, DL, SainL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opd698, DoAddL, DL, SaipL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opd6a0, DoAddL, DL, SmaiL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opd6a8, DoAddL, DL, SdaiL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opd6b0, DoAddL, DL, SaixL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opd6b8, DoAddL, DL, SearL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opd6c0, DoAdda, DL, SdW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd6c8, DoAdda, DL, SaW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd6d0, DoAdda, DL, SainW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd6d8, DoAdda, DL, SaipW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd6e0, DoAdda, DL, SmaiW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd6e8, DoAdda, DL, SdaiW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd6f0, DoAdda, DL, SaixW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd6f8, DoAdda, DL, SearW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)

Oper (Opd700, DoAddx, DB, SdB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opd708, DoAddx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 3, GMB, SMB)
Oper (Opd710, DoAddB, DB, SdB, 3, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opd718, DoAddB, DB, SdB, 3, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opd720, DoAddB, DB, SdB, 3, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opd728, DoAddB, DB, SdB, 3, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opd730, DoAddB, DB, SdB, 3, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opd738, DoAddB, DB, SdB, 3, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opd740, DoAddx, DW, SdW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opd748, DoAddx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 3, GMW, SMW)
Oper (Opd750, DoAddW, DW, SdW, 3, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opd758, DoAddW, DW, SdW, 3, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opd760, DoAddW, DW, SdW, 3, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opd768, DoAddW, DW, SdW, 3, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opd770, DoAddW, DW, SdW, 3, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opd778, DoAddW, DW, SdW, 3, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opd780, DoAddx, DL, SdL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opd788, DoAddx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 3, GML, SML)
Oper (Opd790, DoAddL, DL, SdL, 3, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opd798, DoAddL, DL, SdL, 3, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opd7a0, DoAddL, DL, SdL, 3, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opd7a8, DoAddL, DL, SdL, 3, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opd7b0, DoAddL, DL, SdL, 3, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opd7b8, DoAddL, DL, SdL, 3, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Opd7c0, DoAdda, DL, SdL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd7c8, DoAdda, DL, SaL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd7d0, DoAdda, DL, SainL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd7d8, DoAdda, DL, SaipL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd7e0, DoAdda, DL, SmaiL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd7e8, DoAdda, DL, SdaiL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd7f0, DoAdda, DL, SaixL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Opd7f8, DoAdda, DL, SearL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)

Oper (Opd800, DoAddB, DB, SdB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opd810, DoAddB, DB, SainB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opd818, DoAddB, DB, SaipB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opd820, DoAddB, DB, SmaiB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opd828, DoAddB, DB, SdaiB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opd830, DoAddB, DB, SaixB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opd838, DoAddB, DB, SearB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opd840, DoAddW, DW, SdW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opd848, DoAddW, DW, SaW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opd850, DoAddW, DW, SainW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opd858, DoAddW, DW, SaipW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opd860, DoAddW, DW, SmaiW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opd868, DoAddW, DW, SdaiW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opd870, DoAddW, DW, SaixW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opd878, DoAddW, DW, SearW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opd880, DoAddL, DL, SdL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opd888, DoAddL, DL, SaL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opd890, DoAddL, DL, SainL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opd898, DoAddL, DL, SaipL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opd8a0, DoAddL, DL, SmaiL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opd8a8, DoAddL, DL, SdaiL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opd8b0, DoAddL, DL, SaixL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opd8b8, DoAddL, DL, SearL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opd8c0, DoAdda, DL, SdW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd8c8, DoAdda, DL, SaW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd8d0, DoAdda, DL, SainW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd8d8, DoAdda, DL, SaipW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd8e0, DoAdda, DL, SmaiW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd8e8, DoAdda, DL, SdaiW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd8f0, DoAdda, DL, SaixW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd8f8, DoAdda, DL, SearW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)

Oper (Opd900, DoAddx, DB, SdB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opd908, DoAddx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 4, GMB, SMB)
Oper (Opd910, DoAddB, DB, SdB, 4, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opd918, DoAddB, DB, SdB, 4, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opd920, DoAddB, DB, SdB, 4, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opd928, DoAddB, DB, SdB, 4, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opd930, DoAddB, DB, SdB, 4, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opd938, DoAddB, DB, SdB, 4, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opd940, DoAddx, DW, SdW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opd948, DoAddx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 4, GMW, SMW)
Oper (Opd950, DoAddW, DW, SdW, 4, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opd958, DoAddW, DW, SdW, 4, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opd960, DoAddW, DW, SdW, 4, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opd968, DoAddW, DW, SdW, 4, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opd970, DoAddW, DW, SdW, 4, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opd978, DoAddW, DW, SdW, 4, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opd980, DoAddx, DL, SdL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opd988, DoAddx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 4, GML, SML)
Oper (Opd990, DoAddL, DL, SdL, 4, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opd998, DoAddL, DL, SdL, 4, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opd9a0, DoAddL, DL, SdL, 4, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opd9a8, DoAddL, DL, SdL, 4, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opd9b0, DoAddL, DL, SdL, 4, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opd9b8, DoAddL, DL, SdL, 4, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Opd9c0, DoAdda, DL, SdL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd9c8, DoAdda, DL, SaL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd9d0, DoAdda, DL, SainL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd9d8, DoAdda, DL, SaipL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd9e0, DoAdda, DL, SmaiL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd9e8, DoAdda, DL, SdaiL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd9f0, DoAdda, DL, SaixL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Opd9f8, DoAdda, DL, SearL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)

Oper (Opda00, DoAddB, DB, SdB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opda10, DoAddB, DB, SainB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opda18, DoAddB, DB, SaipB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opda20, DoAddB, DB, SmaiB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opda28, DoAddB, DB, SdaiB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opda30, DoAddB, DB, SaixB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opda38, DoAddB, DB, SearB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opda40, DoAddW, DW, SdW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opda48, DoAddW, DW, SaW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opda50, DoAddW, DW, SainW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opda58, DoAddW, DW, SaipW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opda60, DoAddW, DW, SmaiW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opda68, DoAddW, DW, SdaiW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opda70, DoAddW, DW, SaixW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opda78, DoAddW, DW, SearW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opda80, DoAddL, DL, SdL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opda88, DoAddL, DL, SaL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opda90, DoAddL, DL, SainL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opda98, DoAddL, DL, SaipL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opdaa0, DoAddL, DL, SmaiL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opdaa8, DoAddL, DL, SdaiL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opdab0, DoAddL, DL, SaixL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opdab8, DoAddL, DL, SearL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opdac0, DoAdda, DL, SdW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdac8, DoAdda, DL, SaW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdad0, DoAdda, DL, SainW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdad8, DoAdda, DL, SaipW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdae0, DoAdda, DL, SmaiW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdae8, DoAdda, DL, SdaiW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdaf0, DoAdda, DL, SaixW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdaf8, DoAdda, DL, SearW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)

Oper (Opdb00, DoAddx, DB, SdB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opdb08, DoAddx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 5, GMB, SMB)
Oper (Opdb10, DoAddB, DB, SdB, 5, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opdb18, DoAddB, DB, SdB, 5, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opdb20, DoAddB, DB, SdB, 5, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opdb28, DoAddB, DB, SdB, 5, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opdb30, DoAddB, DB, SdB, 5, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opdb38, DoAddB, DB, SdB, 5, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opdb40, DoAddx, DW, SdW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opdb48, DoAddx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 5, GMW, SMW)
Oper (Opdb50, DoAddW, DW, SdW, 5, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opdb58, DoAddW, DW, SdW, 5, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opdb60, DoAddW, DW, SdW, 5, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opdb68, DoAddW, DW, SdW, 5, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opdb70, DoAddW, DW, SdW, 5, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opdb78, DoAddW, DW, SdW, 5, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opdb80, DoAddx, DL, SdL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opdb88, DoAddx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 5, GML, SML)
Oper (Opdb90, DoAddL, DL, SdL, 5, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opdb98, DoAddL, DL, SdL, 5, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opdba0, DoAddL, DL, SdL, 5, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opdba8, DoAddL, DL, SdL, 5, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opdbb0, DoAddL, DL, SdL, 5, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opdbb8, DoAddL, DL, SdL, 5, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Opdbc0, DoAdda, DL, SdL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdbc8, DoAdda, DL, SaL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdbd0, DoAdda, DL, SainL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdbd8, DoAdda, DL, SaipL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdbe0, DoAdda, DL, SmaiL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdbe8, DoAdda, DL, SdaiL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdbf0, DoAdda, DL, SaixL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Opdbf8, DoAdda, DL, SearL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)

Oper (Opdc00, DoAddB, DB, SdB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opdc10, DoAddB, DB, SainB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opdc18, DoAddB, DB, SaipB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opdc20, DoAddB, DB, SmaiB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opdc28, DoAddB, DB, SdaiB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opdc30, DoAddB, DB, SaixB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opdc38, DoAddB, DB, SearB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opdc40, DoAddW, DW, SdW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opdc48, DoAddW, DW, SaW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opdc50, DoAddW, DW, SainW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opdc58, DoAddW, DW, SaipW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opdc60, DoAddW, DW, SmaiW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opdc68, DoAddW, DW, SdaiW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opdc70, DoAddW, DW, SaixW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opdc78, DoAddW, DW, SearW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opdc80, DoAddL, DL, SdL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opdc88, DoAddL, DL, SaL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opdc90, DoAddL, DL, SainL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opdc98, DoAddL, DL, SaipL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opdca0, DoAddL, DL, SmaiL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opdca8, DoAddL, DL, SdaiL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opdcb0, DoAddL, DL, SaixL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opdcb8, DoAddL, DL, SearL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opdcc0, DoAdda, DL, SdW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opdcc8, DoAdda, DL, SaW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opdcd0, DoAdda, DL, SainW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opdcd8, DoAdda, DL, SaipW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opdce0, DoAdda, DL, SmaiW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opdce8, DoAdda, DL, SdaiW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opdcf0, DoAdda, DL, SaixW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opdcf8, DoAdda, DL, SearW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)

Oper (Opdd00, DoAddx, DB, SdB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opdd08, DoAddx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 6, GMB, SMB)
Oper (Opdd10, DoAddB, DB, SdB, 6, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opdd18, DoAddB, DB, SdB, 6, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opdd20, DoAddB, DB, SdB, 6, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opdd28, DoAddB, DB, SdB, 6, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opdd30, DoAddB, DB, SdB, 6, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opdd38, DoAddB, DB, SdB, 6, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opdd40, DoAddx, DW, SdW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opdd48, DoAddx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 6, GMW, SMW)
Oper (Opdd50, DoAddW, DW, SdW, 6, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opdd58, DoAddW, DW, SdW, 6, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opdd60, DoAddW, DW, SdW, 6, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opdd68, DoAddW, DW, SdW, 6, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opdd70, DoAddW, DW, SdW, 6, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opdd78, DoAddW, DW, SdW, 6, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opdd80, DoAddx, DL, SdL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opdd88, DoAddx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 6, GML, SML)
Oper (Opdd90, DoAddL, DL, SdL, 6, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opdd98, DoAddL, DL, SdL, 6, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opdda0, DoAddL, DL, SdL, 6, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opdda8, DoAddL, DL, SdL, 6, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opddb0, DoAddL, DL, SdL, 6, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opddb8, DoAddL, DL, SdL, 6, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Opddc0, DoAdda, DL, SdL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opddc8, DoAdda, DL, SaL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opddd0, DoAdda, DL, SainL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opddd8, DoAdda, DL, SaipL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opdde0, DoAdda, DL, SmaiL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opdde8, DoAdda, DL, SdaiL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opddf0, DoAdda, DL, SaixL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Opddf8, DoAdda, DL, SearL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)

Oper (Opde00, DoAddB, DB, SdB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opde10, DoAddB, DB, SainB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opde18, DoAddB, DB, SaipB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opde20, DoAddB, DB, SmaiB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opde28, DoAddB, DB, SdaiB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opde30, DoAddB, DB, SaixB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opde38, DoAddB, DB, SearB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opde40, DoAddW, DW, SdW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opde48, DoAddW, DW, SaW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opde50, DoAddW, DW, SainW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opde58, DoAddW, DW, SaipW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opde60, DoAddW, DW, SmaiW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opde68, DoAddW, DW, SdaiW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opde70, DoAddW, DW, SaixW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opde78, DoAddW, DW, SearW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opde80, DoAddL, DL, SdL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opde88, DoAddL, DL, SaL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opde90, DoAddL, DL, SainL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opde98, DoAddL, DL, SaipL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opdea0, DoAddL, DL, SmaiL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opdea8, DoAddL, DL, SdaiL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opdeb0, DoAddL, DL, SaixL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opdeb8, DoAddL, DL, SearL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opdec0, DoAdda, DL, SdW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opdec8, DoAdda, DL, SaW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opded0, DoAdda, DL, SainW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opded8, DoAdda, DL, SaipW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opdee0, DoAdda, DL, SmaiW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opdee8, DoAdda, DL, SdaiW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opdef0, DoAdda, DL, SaixW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opdef8, DoAdda, DL, SearW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)

Oper (Opdf00, DoAddx, DB, SdB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opdf08, DoAddx, DB, SmaiB, (inst & 7), DB, DA, CmaiB15, 7, GMB, SMB)
Oper (Opdf10, DoAddB, DB, SdB, 7, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opdf18, DoAddB, DB, SdB, 7, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opdf20, DoAddB, DB, SdB, 7, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opdf28, DoAddB, DB, SdB, 7, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opdf30, DoAddB, DB, SdB, 7, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opdf38, DoAddB, DB, SdB, 7, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opdf40, DoAddx, DW, SdW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opdf48, DoAddx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 7, GMW, SMW)
Oper (Opdf50, DoAddW, DW, SdW, 7, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opdf58, DoAddW, DW, SdW, 7, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opdf60, DoAddW, DW, SdW, 7, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opdf68, DoAddW, DW, SdW, 7, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opdf70, DoAddW, DW, SdW, 7, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opdf78, DoAddW, DW, SdW, 7, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opdf80, DoAddx, DL, SdL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opdf88, DoAddx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 7, GML, SML)
Oper (Opdf90, DoAddL, DL, SdL, 7, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opdf98, DoAddL, DL, SdL, 7, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opdfa0, DoAddL, DL, SdL, 7, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opdfa8, DoAddL, DL, SdL, 7, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opdfb0, DoAddL, DL, SdL, 7, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opdfb8, DoAddL, DL, SdL, 7, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Opdfc0, DoAdda, DL, SdL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opdfc8, DoAdda, DL, SaL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opdfd0, DoAdda, DL, SainL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opdfd8, DoAdda, DL, SaipL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opdfe0, DoAdda, DL, SmaiL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opdfe8, DoAdda, DL, SdaiL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opdff0, DoAdda, DL, SaixL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Opdff8, DoAdda, DL, SearL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)

Oper (Op0600, DoAddB, DB, SimmB, 0, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op0610, DoAddB, DB, SimmB, 0, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op0618, DoAddB, DB, SimmB, 0, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op0620, DoAddB, DB, SimmB, 0, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op0628, DoAddB, DB, SimmB, 0, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op0630, DoAddB, DB, SimmB, 0, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op0638, DoAddB, DB, SimmB, 0, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op0640, DoAddW, DW, SimmW, 0, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op0650, DoAddW, DW, SimmW, 0, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op0658, DoAddW, DW, SimmW, 0, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op0660, DoAddW, DW, SimmW, 0, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op0668, DoAddW, DW, SimmW, 0, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op0670, DoAddW, DW, SimmW, 0, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op0678, DoAddW, DW, SimmW, 0, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op0680, DoAddL, DL, SimmL, 0, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op0690, DoAddL, DL, SimmL, 0, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op0698, DoAddL, DL, SimmL, 0, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op06a0, DoAddL, DL, SimmL, 0, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op06a8, DoAddL, DL, SimmL, 0, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op06b0, DoAddL, DL, SimmL, 0, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op06b8, DoAddL, DL, SimmL, 0, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5000, DoAddB, DB, Ss, 8, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5010, DoAddB, DB, Ss, 8, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5018, DoAddB, DB, Ss, 8, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5020, DoAddB, DB, Ss, 8, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5028, DoAddB, DB, Ss, 8, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5030, DoAddB, DB, Ss, 8, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5038, DoAddB, DB, Ss, 8, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5040, DoAddW, DW, Ss, 8, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5048, DoAdda, DL, Ss, 8, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5050, DoAddW, DW, Ss, 8, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5058, DoAddW, DW, Ss, 8, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5060, DoAddW, DW, Ss, 8, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5068, DoAddW, DW, Ss, 8, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5070, DoAddW, DW, Ss, 8, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5078, DoAddW, DW, Ss, 8, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5080, DoAddL, DL, Ss, 8, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5088, DoAdda, DL, Ss, 8, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5090, DoAddL, DL, Ss, 8, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5098, DoAddL, DL, Ss, 8, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op50a0, DoAddL, DL, Ss, 8, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op50a8, DoAddL, DL, Ss, 8, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op50b0, DoAddL, DL, Ss, 8, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op50b8, DoAddL, DL, Ss, 8, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5200, DoAddB, DB, Ss, 1, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5210, DoAddB, DB, Ss, 1, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5218, DoAddB, DB, Ss, 1, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5220, DoAddB, DB, Ss, 1, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5228, DoAddB, DB, Ss, 1, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5230, DoAddB, DB, Ss, 1, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5238, DoAddB, DB, Ss, 1, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5240, DoAddW, DW, Ss, 1, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5248, DoAdda, DL, Ss, 1, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5250, DoAddW, DW, Ss, 1, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5258, DoAddW, DW, Ss, 1, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5260, DoAddW, DW, Ss, 1, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5268, DoAddW, DW, Ss, 1, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5270, DoAddW, DW, Ss, 1, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5278, DoAddW, DW, Ss, 1, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5280, DoAddL, DL, Ss, 1, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5288, DoAdda, DL, Ss, 1, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5290, DoAddL, DL, Ss, 1, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5298, DoAddL, DL, Ss, 1, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op52a0, DoAddL, DL, Ss, 1, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op52a8, DoAddL, DL, Ss, 1, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op52b0, DoAddL, DL, Ss, 1, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op52b8, DoAddL, DL, Ss, 1, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5400, DoAddB, DB, Ss, 2, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5410, DoAddB, DB, Ss, 2, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5418, DoAddB, DB, Ss, 2, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5420, DoAddB, DB, Ss, 2, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5428, DoAddB, DB, Ss, 2, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5430, DoAddB, DB, Ss, 2, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5438, DoAddB, DB, Ss, 2, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5440, DoAddW, DW, Ss, 2, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5448, DoAdda, DL, Ss, 2, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5450, DoAddW, DW, Ss, 2, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5458, DoAddW, DW, Ss, 2, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5460, DoAddW, DW, Ss, 2, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5468, DoAddW, DW, Ss, 2, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5470, DoAddW, DW, Ss, 2, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5478, DoAddW, DW, Ss, 2, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5480, DoAddL, DL, Ss, 2, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5488, DoAdda, DL, Ss, 2, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5490, DoAddL, DL, Ss, 2, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5498, DoAddL, DL, Ss, 2, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op54a0, DoAddL, DL, Ss, 2, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op54a8, DoAddL, DL, Ss, 2, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op54b0, DoAddL, DL, Ss, 2, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op54b8, DoAddL, DL, Ss, 2, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5600, DoAddB, DB, Ss, 3, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5610, DoAddB, DB, Ss, 3, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5618, DoAddB, DB, Ss, 3, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5620, DoAddB, DB, Ss, 3, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5628, DoAddB, DB, Ss, 3, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5630, DoAddB, DB, Ss, 3, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5638, DoAddB, DB, Ss, 3, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5640, DoAddW, DW, Ss, 3, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5648, DoAdda, DL, Ss, 3, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5650, DoAddW, DW, Ss, 3, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5658, DoAddW, DW, Ss, 3, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5660, DoAddW, DW, Ss, 3, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5668, DoAddW, DW, Ss, 3, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5670, DoAddW, DW, Ss, 3, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5678, DoAddW, DW, Ss, 3, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5680, DoAddL, DL, Ss, 3, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5688, DoAdda, DL, Ss, 3, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5690, DoAddL, DL, Ss, 3, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5698, DoAddL, DL, Ss, 3, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op56a0, DoAddL, DL, Ss, 3, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op56a8, DoAddL, DL, Ss, 3, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op56b0, DoAddL, DL, Ss, 3, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op56b8, DoAddL, DL, Ss, 3, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5800, DoAddB, DB, Ss, 4, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5810, DoAddB, DB, Ss, 4, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5818, DoAddB, DB, Ss, 4, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5820, DoAddB, DB, Ss, 4, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5828, DoAddB, DB, Ss, 4, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5830, DoAddB, DB, Ss, 4, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5838, DoAddB, DB, Ss, 4, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5840, DoAddW, DW, Ss, 4, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5848, DoAdda, DL, Ss, 4, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5850, DoAddW, DW, Ss, 4, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5858, DoAddW, DW, Ss, 4, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5860, DoAddW, DW, Ss, 4, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5868, DoAddW, DW, Ss, 4, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5870, DoAddW, DW, Ss, 4, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5878, DoAddW, DW, Ss, 4, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5880, DoAddL, DL, Ss, 4, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5888, DoAdda, DL, Ss, 4, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5890, DoAddL, DL, Ss, 4, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5898, DoAddL, DL, Ss, 4, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op58a0, DoAddL, DL, Ss, 4, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op58a8, DoAddL, DL, Ss, 4, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op58b0, DoAddL, DL, Ss, 4, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op58b8, DoAddL, DL, Ss, 4, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5a00, DoAddB, DB, Ss, 5, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5a10, DoAddB, DB, Ss, 5, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5a18, DoAddB, DB, Ss, 5, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5a20, DoAddB, DB, Ss, 5, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5a28, DoAddB, DB, Ss, 5, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5a30, DoAddB, DB, Ss, 5, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5a38, DoAddB, DB, Ss, 5, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5a40, DoAddW, DW, Ss, 5, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5a48, DoAdda, DL, Ss, 5, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5a50, DoAddW, DW, Ss, 5, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5a58, DoAddW, DW, Ss, 5, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5a60, DoAddW, DW, Ss, 5, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5a68, DoAddW, DW, Ss, 5, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5a70, DoAddW, DW, Ss, 5, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5a78, DoAddW, DW, Ss, 5, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5a80, DoAddL, DL, Ss, 5, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5a88, DoAdda, DL, Ss, 5, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5a90, DoAddL, DL, Ss, 5, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5a98, DoAddL, DL, Ss, 5, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op5aa0, DoAddL, DL, Ss, 5, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op5aa8, DoAddL, DL, Ss, 5, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op5ab0, DoAddL, DL, Ss, 5, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op5ab8, DoAddL, DL, Ss, 5, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5c00, DoAddB, DB, Ss, 6, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5c10, DoAddB, DB, Ss, 6, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5c18, DoAddB, DB, Ss, 6, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5c20, DoAddB, DB, Ss, 6, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5c28, DoAddB, DB, Ss, 6, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5c30, DoAddB, DB, Ss, 6, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5c38, DoAddB, DB, Ss, 6, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5c40, DoAddW, DW, Ss, 6, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5c48, DoAdda, DL, Ss, 6, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5c50, DoAddW, DW, Ss, 6, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5c58, DoAddW, DW, Ss, 6, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5c60, DoAddW, DW, Ss, 6, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5c68, DoAddW, DW, Ss, 6, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5c70, DoAddW, DW, Ss, 6, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5c78, DoAddW, DW, Ss, 6, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5c80, DoAddL, DL, Ss, 6, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5c88, DoAdda, DL, Ss, 6, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5c90, DoAddL, DL, Ss, 6, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5c98, DoAddL, DL, Ss, 6, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op5ca0, DoAddL, DL, Ss, 6, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op5ca8, DoAddL, DL, Ss, 6, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op5cb0, DoAddL, DL, Ss, 6, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op5cb8, DoAddL, DL, Ss, 6, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5e00, DoAddB, DB, Ss, 7, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5e10, DoAddB, DB, Ss, 7, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5e18, DoAddB, DB, Ss, 7, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5e20, DoAddB, DB, Ss, 7, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5e28, DoAddB, DB, Ss, 7, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5e30, DoAddB, DB, Ss, 7, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5e38, DoAddB, DB, Ss, 7, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5e40, DoAddW, DW, Ss, 7, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5e48, DoAdda, DL, Ss, 7, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5e50, DoAddW, DW, Ss, 7, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5e58, DoAddW, DW, Ss, 7, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5e60, DoAddW, DW, Ss, 7, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5e68, DoAddW, DW, Ss, 7, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5e70, DoAddW, DW, Ss, 7, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5e78, DoAddW, DW, Ss, 7, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5e80, DoAddL, DL, Ss, 7, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5e88, DoAdda, DL, Ss, 7, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5e90, DoAddL, DL, Ss, 7, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5e98, DoAddL, DL, Ss, 7, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op5ea0, DoAddL, DL, Ss, 7, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op5ea8, DoAddL, DL, Ss, 7, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op5eb0, DoAddL, DL, Ss, 7, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op5eb8, DoAddL, DL, Ss, 7, DL, DA, Ceaw, (inst & 7), GML, SML)
