// main.cpp
//
// containing main structure of the game
// with all the necessary inits, etc.
//
// for all copyright information, see the
// file COPYRIGHT
//
// Nathan Letwory

// no arguments for main, 'cause I don't use
// 'em

#include <allegro.h>
#include <stdio.h>    // for my own Log-function and saving the high scores
#include <string.h>

#include "hnefatafl.h" // header for data

// introducing used functions:
void loki(char *s);	// our log-function for debug-purposes
int backdrop_proc(int viesti, DIALOG *k, int n);
int oma_nappi1_proc(int viesti, DIALOG *k, int n);	// handler for button type 1;
void twopl_game(void); // our two_pl game
void setup_board(void); // init and setup the board.
int check_pos(void);
int get_pos(void);
int valid_move(void);
void draw_it(void);
void dump_screen(void);
int check_victory(void);
void check_eat(void);		// remove a piece from the board?
void horizontal_check(void);
void vertical_check(void);
void nomal_check(void);
void draw_eaten_pieces(void);
void animate_move(void);
void update_particles(void);
void init_particles(void);

void nse_w(int one, int two, int three, int four, int five, int six);
void nsw_w(int one, int two, int three, int four, int five, int six);

// introducing some vars
#define MENU_WAIT		250   // ms to wait in menu after clicking a button...

#define BROWN_P			99
#define WHITE_P			43
#define KING_P			66
#define EMPTY			0
#define OUTSIDE_BOARD	33

#define NOT_MOVED		0
#define VALID			1
#define NOT_VALID		-1

#define BOARDX			11
#define BOARDY			11

#define TILE			32

#define GAME_CONTINUES	0
#define WHITE_WINS		1
#define BROWN_WINS		2
#define DRAW			3

#define ON_ROW			5

#define MOVE_SPEED		1	// keep this on one or two. My code doesn't handle higher speeds
							// very well. On the other hand. 2 is fast enough.

int clickedx = 0;
int clickedy = 0;
int mousex = 0;
int mousey = 0;
int selectx = 0;
int selecty = 0;

#define START_COLOR		20
#define STOP_COLOR		24
int select_color = START_COLOR;

#define MAX_PARTICLES		200

float slowdown = 1.0;
float xspeeddir = 0.0;
float yspeeddir = 0.0;
float xspeed2dir = 0.0;
float yspeed2dir = 0.0;
float fountainx = 625.0;
float fountain2x = 433.0;
float fountain2y = 40.0;
float fountainy = 40.0;
int fountain_color = 40;
int dirkeys = 0;
int dir2keys = 0;

#define F_RIGHT		1
#define F_LEFT		2
#define F_UP		4
#define F_DOWN		8

typedef struct {
	float life;
	float fade;
	float x;
	float y;
	float xspeed;
	float yspeed;
	float xgrav;
	float ygrav;
	int color;
} particle;

particle elementen[MAX_PARTICLES];
particle elementen2[MAX_PARTICLES];

int turn = 0;

int brown_eaten = 0;
int white_eaten = 0;

int brown_total = 24;
int white_total = 13;

int forced_exit = 0;
int clicked = 0;

typedef struct {
	int piece;
	int x;
	int y;
	int movx;
	int movy;
	int selected;
	int destx;
	int desty;
} posxy;

int select_start = 0;	// position of selected piece
int select_end = 0;		// postion we want the selected piece to.

int obstructed = 0;		// path obstructed ? print right message (not allowed to jump!)
int diagonal = 0;		// set when player attempts diagonal move. NOT ALLOWED

#define MOVING_BROWN			1
#define MOVING_WHITE			2
#define MOVING_KING				3
#define MOVING_NOTHING			0
int moving = MOVING_NOTHING;	// when got valid move, animated it. This is set until animation is done.
#define MOVE_LEFT		1
#define MOVE_RIGHT		2
#define MOVE_UP			3
#define MOVE_DOWN		4
#define NO_DIRECTION	0
int moving_dir = NO_DIRECTION;
int destx = 0;
int desty = 0;
int startx = 0;
int starty = 0;

int starti = 0;
int desti = 0;

int piece_selected = 0;

int game_status = GAME_CONTINUES;

posxy board[BOARDX*BOARDY];
//posxy tilepos[BOARDX*BOARDY];

BITMAP *board_map;

BITMAP *buf;
char info_buf[50] = "";
char info2_buf[50] = "";
char info3_buf[50] = "";
char vuoro_buf[25] = "";

char *lokitiedostonimi = "loki.txt";
char *tietotiedostonimi = "hnefatafl.dat";
FILE *lokitiedosto;
DATAFILE *tietotiedosto;

DIALOG keskustelu[] =
{
	//{ (proc)			(x)		(y)		(w)		(h)		(fg)	(bg)	(key)	(flags)	(d1)	(d2)			(dp)	(dp2)	(dp3)}
	{d_clear_proc,		0,		0,		0,		0,		0,		0,		0,		0,		0,		0,				NULL,	NULL,	NULL},
	// background for menu
	{backdrop_proc,		0,		0,		640,	480,	0,		0,		0,		0,		1,		0,				NULL,	NULL,	NULL},
	// options
	{oma_nappi1_proc,	50,		150,	92,		29,		0,		0,		0,		D_EXIT,	2,		OPTIONS_A,		NULL,	NULL,	NULL},
	// two-player
	{oma_nappi1_proc,	75,		200,	207,	35,		0,		0,		0,		D_EXIT,	3,		TWOPL_A,		NULL,	NULL,	NULL},
	// one-player
	{oma_nappi1_proc,	100,	250,	205,	35,		0,		0,		0,		D_EXIT,	4,		ONEPL_A,		NULL,	NULL,	NULL},
	// hall of fame
	{oma_nappi1_proc,	75,		300,	146,	29,		0,		0,		0,		D_EXIT,	5,		FAME_A,			NULL,	NULL,	NULL},
	// credits
	{oma_nappi1_proc,	50,		350,	87,		30,		0,		0,		0,		D_EXIT,	6,		CREDITS_A,		NULL,	NULL,	NULL},
	// quit
	{oma_nappi1_proc,	580,	440,	52,		32,		0,		0,		0,		D_EXIT,	7,		QUIT_A,			NULL,	NULL,	NULL},
	// end of dialog
	{NULL,				0,		0,		0,		0,		0,		0,		0,		0,		0,		0,				NULL,	NULL,	NULL}
};

int fps_counter = 0;
int fps = 0;

int update_input = 1;

void input_int(void)
{
	update_input = 1;
}
END_OF_FUNCTION(input_int);

void fps_int(void)
{
	fps = fps_counter;
	fps_counter = 0;
}
END_OF_FUNCTION(fps_int);

void loki(char *s)
{
	lokitiedosto = fopen(lokitiedostonimi, "a");
	fprintf(lokitiedosto, "%s\n", s);
	fclose(lokitiedosto);
}

// modified d_bitmap_proc to allow changing bitmaps in buttons...
int oma_nappi1_proc(int viesti, DIALOG *k, int n)
{
	BITMAP *draw = (BITMAP *)k->dp;

	switch(viesti)
	{
	case MSG_LOSTMOUSE:
		keskustelu[k->d1].dp = (BITMAP *)tietotiedosto[k->d2 + 1].dat;
		return D_REDRAWME;
	case MSG_GOTMOUSE:
		keskustelu[k->d1].dp = (BITMAP *)tietotiedosto[k->d2].dat;
		return D_REDRAWME;
	case MSG_CLICK:
	//	keskustelu[k->d1].dp = (BITMAP *)tietotiedosto[k->d2 +  2].dat;
		return D_CLOSE;
	case MSG_DRAW:
		masked_blit(draw, screen, 0, 0, k->x, k->y, k->w, k->h);
		return D_O_K;
	}

	return D_O_K;
}

int backdrop_proc(int viesti, DIALOG *k, int n)
{
	BITMAP *draw = (BITMAP *)k->dp;
	if(viesti == MSG_DRAW)
		blit(draw, screen, 0, 0, k->x, k->y, k->w, k->h);
	return D_O_K;
}

void setup_board(void)
{
	int i = 0;
	int j = 0;
	
	int overblijf = 0;

	int brown_start[24] =
	{3, 4, 5, 6, 7, 16, 33, 43, 44, 54, 55, 56, 64, 65, 66, 76, 77, 87, 104, 113, 114, 115, 116, 117};
	int white_start[12] =
	{38, 48, 49, 50, 58, 59, 61, 62, 70, 71, 72, 82};
	int king_start = 60;

	// first init all the stuff we need
	for(i = 0; i < (BOARDX*BOARDY); i++)
	{
		board[i].piece = EMPTY;
		if(i>0)
		{
			if((i%11) == 0)
			{
				overblijf++;
			}
		}
		board[i].y = overblijf * 32 + 40;
		board[i].x = (i-overblijf*11)*32 + 40;
	}

	// now setup the pieces in the array

	//brown pieces
	for (i = 0; i<24; i++)
	{
		board[brown_start[i]].piece = BROWN_P;
	}

	// white pieces
	for (i = 0; i<12; i++)
	{
		board[white_start[i]].piece = WHITE_P;
	}

	// white king
	board[king_start].piece = KING_P;

	return;
}

int check_victory(void)
{

	int king_pos = 0;
	int i = 0;
	game_status = GAME_CONTINUES;

	// first check kings position. If on savehaven : White won!
	if(board[0].piece == KING_P)
	{
		game_status = WHITE_WINS;
	}
	if(board[10].piece == KING_P)
	{
		game_status = WHITE_WINS;
	}
	if(board[110].piece == KING_P)
	{
		game_status = WHITE_WINS;
	}
	if(board[120].piece == KING_P)
	{
		game_status = WHITE_WINS;
	}

	// search for King position
	for(i = 0; i < BOARDX * BOARDY; i++)
	{
		if(board[i].piece == KING_P)
		{
			king_pos = i;
			break;
		}
	}

	if((king_pos == 49) || (king_pos == 59) || (king_pos == 61) || (king_pos == 71))
	{
		switch(king_pos)
		{
		case 49:
			if((board[king_pos-11].piece == BROWN_P) && (board[king_pos+1].piece == BROWN_P) && (board[king_pos-1].piece == BROWN_P))
			{
				game_status = BROWN_WINS;
			}
			break;
		case 59:
			if((board[king_pos-11].piece == BROWN_P) && (board[king_pos-1].piece == BROWN_P) && (board[king_pos+11].piece == BROWN_P))
			{
				game_status = BROWN_WINS;
			}
			break;
		case 61:
			if((board[king_pos+11].piece == BROWN_P) && (board[king_pos+1].piece == BROWN_P) && (board[king_pos-11].piece == BROWN_P))
			{
				game_status = BROWN_WINS;
			}
			break;
		case 71:
			if((board[king_pos+11].piece == BROWN_P) && (board[king_pos+1].piece == BROWN_P) && (board[king_pos-1].piece == BROWN_P))
			{
				game_status = BROWN_WINS;
			}
			break;
		}
	} else {
		if((board[king_pos-11].piece == BROWN_P) && (board[king_pos+11].piece == BROWN_P) && (board[king_pos-1].piece == BROWN_P) && (board[king_pos+1].piece == BROWN_P))
		{
			if (king_pos < 12)	// this if...else if ... else construction is needed, because we
								// would otherwise get false winning conditions...
			{
				game_status = GAME_CONTINUES;
			} else if (king_pos > 20 && king_pos < 23) {
				game_status = GAME_CONTINUES;
			} else if (king_pos > 31 && king_pos < 34) {
				game_status = GAME_CONTINUES;
			} else if (king_pos > 42 && king_pos < 45) {
				game_status = GAME_CONTINUES;
			} else if (king_pos > 53 && king_pos < 56) {
				game_status = GAME_CONTINUES;
			} else if (king_pos > 64 && king_pos < 67) {
				game_status = GAME_CONTINUES;
			} else if (king_pos > 75 && king_pos < 78) {
				game_status = GAME_CONTINUES;
			} else if (king_pos > 86 && king_pos < 89) {
				game_status = GAME_CONTINUES;
			} else if (king_pos > 97 && king_pos < 100) {
				game_status = GAME_CONTINUES;
			} else if (king_pos > 108) {
				game_status = GAME_CONTINUES;
			} else {
				game_status = BROWN_WINS;
			}
		}
	}
			
	switch(game_status)
	{
	case BROWN_WINS:
		strcpy(info_buf, "BROWN wins the game");
		break;
	case WHITE_WINS:
		strcpy(info_buf, "WHITE wins the game");
		break;
	case DRAW:
		strcpy(info_buf, "It's a draw");
		break;
	default:
		strcpy(info_buf, "");
	}

	return game_status;
}

void horizontal_check(void)
{
	if(!turn)
	{
		// upper row
		if(select_end == 1)
		{
			if(board[11].piece == BROWN_P)
			{
				if(board[22].piece == WHITE_P || board[22].piece == KING_P)
				{
					// brown get's eaten
					board[22].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece taken by white");
				}
			}
		}
		if(select_end == 9)
		{
			if(board[21].piece == BROWN_P)
			{
				if(board[32].piece == WHITE_P || board[32].piece == KING_P)
				{
					// brown get's eaten
					board[21].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece taken by white");
				}
			}
		}
		if(select_end == 2)
		{
			if(board[1].piece == BROWN_P)
			{
				if(board[11].piece == WHITE_P || board[11].piece == KING_P)
				{
					// brown get's eaten
					board[1].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece taken by white");
				}
			}
		}
		if(select_end == 8)
		{
			if(board[9].piece == BROWN_P)
			{
				if(board[21].piece == WHITE_P || board[21].piece == KING_P)
				{
					// brown get's eaten
					board[9].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece has been taken by white");
				}
			}
		}
		if(select_end > 0 && select_end < 10)
		{
			if(board[select_end - 1].piece == BROWN_P && (board[select_end - 2].piece == WHITE_P || board[select_end - 2].piece == KING_P))
			{
				board[select_end - 1].piece = EMPTY;
				brown_eaten++;
				init_particles();
				strcpy(info2_buf, "a brown piece has been taken by white");
			}
			if(board[select_end + 1].piece == BROWN_P && (board[select_end + 2].piece == WHITE_P || board[select_end + 2].piece == KING_P))
			{
				board[select_end + 1].piece = EMPTY;
				brown_eaten++;
				init_particles();
				strcpy(info2_buf, "a brown piece has been taken by white");
			}
			if(board[select_end + 11].piece == BROWN_P && (board[select_end + 22].piece == WHITE_P || board[select_end + 22].piece == KING_P))
			{
				board[select_end + 11].piece = EMPTY;
				brown_eaten++;
				init_particles();
				strcpy(info2_buf, "a brown piece has been taken by white");
			}
		}
		// bottom row
		if(select_end == 111)
		{
			if(board[99].piece == BROWN_P)
			{
				if(board[88].piece == WHITE_P || board[88].piece == KING_P)
				{
					// brown get's eaten
					board[99].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece taken by white");
				}
			}
		}
		if(select_end == 119)
		{
			if(board[109].piece == BROWN_P)
			{
				if(board[98].piece == WHITE_P || board[98].piece == KING_P)
				{
					// brown get's eaten
					board[109].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece taken by white");
				}
			}
		}
		if(select_end == 112)
		{
			if(board[111].piece == BROWN_P)
			{
				if(board[99].piece == WHITE_P || board[99].piece == KING_P)
				{
					// brown get's eaten
					board[111].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece taken by white");
				}
			}
		}
		if(select_end == 118)
		{
			if(board[119].piece == BROWN_P)
			{
				if(board[109].piece == WHITE_P || board[109].piece == KING_P)
				{
					// brown get's eaten
					board[119].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece has been taken by white");
				}
			}
		}
		if(select_end > 110 && select_end < 120)
		{
			if(board[select_end - 1].piece == BROWN_P && (board[select_end - 2].piece == WHITE_P || board[select_end - 2].piece == KING_P))
			{
				board[select_end - 1].piece = EMPTY;
				brown_eaten++;
				init_particles();
				strcpy(info2_buf, "a brown piece has been taken by white");
			}
			if(board[select_end + 1].piece == BROWN_P && (board[select_end + 2].piece == WHITE_P || board[select_end + 2].piece == KING_P))
			{
				board[select_end + 1].piece = EMPTY;
				brown_eaten++;
				init_particles();
				strcpy(info2_buf, "a brown piece has been taken by white");
			}
			if(board[select_end - 11].piece == BROWN_P && (board[select_end - 22].piece == WHITE_P || board[select_end - 22].piece == KING_P))
			{
				board[select_end - 11].piece = EMPTY;
				brown_eaten++;
				init_particles();
				strcpy(info2_buf, "a brown piece has been taken by white");
			}
		}
	} else {
		// check for brown eating white pieces...
		// upper row
		if(select_end == 1)
		{
			if(board[11].piece == WHITE_P)
			{
				if(board[22].piece == BROWN_P)
				{
					// white get's eaten
					board[22].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece taken by brown");
				}
			}
		}
		if(select_end == 9)
		{
			if(board[21].piece == WHITE_P)
			{
				if(board[32].piece == BROWN_P)
				{
					// white get's eaten
					board[21].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece taken by brown");
				}
			}
		}
		if(select_end == 2)
		{
			if(board[1].piece == WHITE_P)
			{
				if(board[11].piece == BROWN_P)
				{
					// white get's eaten
					board[1].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece taken by brown");
				}
			}
		}
		if(select_end == 8)
		{
			if(board[9].piece == WHITE_P)
			{
				if(board[21].piece == BROWN_P)
				{
					// white get's eaten
					board[9].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece has been taken by brown");
				}
			}
		}
		if(select_end > 0 && select_end < 10)
		{
			if(board[select_end - 1].piece == WHITE_P && board[select_end - 2].piece == BROWN_P)
			{
				board[select_end - 1].piece = EMPTY;
				white_eaten++;
				init_particles();
				strcpy(info2_buf, "a white piece has been taken by brown");
			}
			if(board[select_end + 1].piece == WHITE_P && board[select_end + 2].piece == BROWN_P)
			{
				board[select_end + 1].piece = EMPTY;
				white_eaten++;
				init_particles();
				strcpy(info2_buf, "a white piece has been taken by brown");
			}
			if(board[select_end + 11].piece == WHITE_P && board[select_end + 22].piece == BROWN_P)
			{
				board[select_end + 11].piece = EMPTY;
				white_eaten++;
				init_particles();
				strcpy(info2_buf, "a white piece has been taken by brown");
			}
		}
		// bottom row
		if(select_end == 111)
		{
			if(board[99].piece == WHITE_P)
			{
				if(board[88].piece == BROWN_P)
				{
					// white get's eaten
					board[99].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece has been taken by brown");
				}
			}
		}
		if(select_end == 119)
		{
			if(board[109].piece == WHITE_P)
			{
				if(board[98].piece == BROWN_P)
				{
					// white get's eaten
					board[109].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece taken by brown");
				}
			}
		}
		if(select_end == 112)
		{
			if(board[111].piece == WHITE_P)
			{
				if(board[99].piece == BROWN_P)
				{
					// white get's eaten
					board[111].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece taken by brown");
				}
			}
		}
		if(select_end == 118)
		{
			if(board[119].piece == WHITE_P)
			{
				if(board[109].piece == BROWN_P)
				{
					// white get's eaten
					board[119].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece has been taken by brown");
				}
			}
		}
		if(select_end > 110 && select_end < 120)
		{
			if(board[select_end - 1].piece == WHITE_P && board[select_end - 2].piece == BROWN_P)
			{
				board[select_end - 1].piece = EMPTY;
				white_eaten++;
				init_particles();
				strcpy(info2_buf, "a white piece has been taken by brown");
			}
			if(board[select_end + 1].piece == WHITE_P && board[select_end + 2].piece == BROWN_P)
			{
				board[select_end + 1].piece = EMPTY;
				white_eaten++;
				init_particles();
				strcpy(info2_buf, "a white piece has been taken by brown");
			}
			if(board[select_end - 11].piece == WHITE_P && board[select_end - 22].piece == BROWN_P)
			{
				board[select_end - 11].piece = EMPTY;
				white_eaten++;
				init_particles();
				strcpy(info2_buf, "a white piece has been taken by brown");
			}
		}
	}

	return;
}

void vertical_check(void)
{
	if(!turn)
	{
		// left file
		if(select_end == 11)
		{
			if(board[1].piece == BROWN_P)
			{
				if(board[2].piece == WHITE_P || board[2].piece == KING_P)
				{
					// brown get's eaten
					board[1].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece taken by white");
				}
			}
		}
		if(select_end == 99)
		{
			if(board[111].piece == BROWN_P)
			{
				if(board[113].piece == WHITE_P || board[113].piece == KING_P)
				{
					// brown get's eaten
					board[111].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece taken by white");
				}
			}
		}
		if(select_end == 22)
		{
			if(board[11].piece == BROWN_P)
			{
				if(board[1].piece == WHITE_P || board[1].piece == KING_P)
				{
					// brown get's eaten
					board[11].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece taken by white");
				}
			}
		}
		if(select_end == 88)
		{
			if(board[99].piece == BROWN_P)
			{
				if(board[111].piece == WHITE_P || board[111].piece == KING_P)
				{
					// brown get's eaten
					board[99].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece has been taken by white");
				}
			}
		}
		if(select_end > 0 && select_end < 110)
		{
			if(board[select_end - 11].piece == BROWN_P && (board[select_end - 22].piece == WHITE_P || board[select_end - 22].piece == KING_P))
			{
				board[select_end - 11].piece = EMPTY;
				brown_eaten++;
				init_particles();
				strcpy(info2_buf, "a brown piece has been taken by white");
			}
			if(board[select_end + 11].piece == BROWN_P && (board[select_end + 22].piece == WHITE_P || board[select_end + 22].piece == KING_P))
			{
				board[select_end + 11].piece = EMPTY;
				brown_eaten++;
				init_particles();
				strcpy(info2_buf, "a brown piece has been taken by white");
			}
		}
		// right file
		if(select_end == 21)
		{
			if(board[9].piece == BROWN_P)
			{
				if(board[8].piece == WHITE_P || board[8].piece == KING_P)
				{
					// brown get's eaten
					board[9].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece taken by white");
				}
			}
		}
		if(select_end == 109)
		{
			if(board[119].piece == BROWN_P)
			{
				if(board[118].piece == WHITE_P || board[118].piece == KING_P)
				{
					// brown get's eaten
					board[119].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece taken by white");
				}
			}
		}
		if(select_end == 32)
		{
			if(board[21].piece == BROWN_P)
			{
				if(board[9].piece == WHITE_P || board[9].piece == KING_P)
				{
					// brown get's eaten
					board[21].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece taken by white");
				}
			}
		}
		if(select_end == 98)
		{
			if(board[109].piece == BROWN_P)
			{
				if(board[119].piece == WHITE_P || board[119].piece == KING_P)
				{
					// brown get's eaten
					board[109].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "a brown piece has been taken by white");
				}
			}
		}
		if(select_end > 10 && select_end < 120)
		{
			if(board[select_end - 11].piece == BROWN_P && (board[select_end - 22].piece == WHITE_P || board[select_end - 22].piece == KING_P))
			{
				board[select_end - 11].piece = EMPTY;
				brown_eaten++;
				init_particles();
				strcpy(info2_buf, "a brown piece has been taken by white");
			}
			if(board[select_end + 11].piece == BROWN_P && (board[select_end + 22].piece == WHITE_P || board[select_end + 22].piece == KING_P))
			{
				board[select_end + 11].piece = EMPTY;
				brown_eaten++;
				init_particles();
				strcpy(info2_buf, "a brown piece has been taken by white");
			}
		}
	} else {
		// check for brown eating white pieces...
		// upper row
		if(select_end == 11)
		{
			if(board[1].piece == WHITE_P)
			{
				if(board[2].piece == BROWN_P)
				{
					// white get's eaten
					board[2].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece taken by brown");
				}
			}
		}
		if(select_end == 99)
		{
			if(board[111].piece == WHITE_P)
			{
				if(board[112].piece == BROWN_P)
				{
					// white get's eaten
					board[111].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece taken by brown");
				}
			}
		}
		if(select_end == 88)
		{
			if(board[99].piece == WHITE_P)
			{
				if(board[111].piece == BROWN_P)
				{
					// white get's eaten
					board[99].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece taken by brown");
				}
			}
		}
		if(select_end == 22)
		{
			if(board[11].piece == WHITE_P)
			{
				if(board[1].piece == BROWN_P)
				{
					// white get's eaten
					board[11].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece has been taken by brown");
				}
			}
		}
		if(select_end > 0 && select_end < 110)
		{
			if(board[select_end - 11].piece == WHITE_P && board[select_end - 22].piece == BROWN_P)
			{
				board[select_end - 11].piece = EMPTY;
				white_eaten++;
				init_particles();
				strcpy(info2_buf, "a white piece has been taken by brown");
			}
			if(board[select_end + 11].piece == WHITE_P && board[select_end + 22].piece == BROWN_P)
			{
				board[select_end + 11].piece = EMPTY;
				white_eaten++;
				init_particles();
				strcpy(info2_buf, "a white piece has been taken by brown");
			}
		}
		// bottom row
		if(select_end == 21)
		{
			if(board[9].piece == WHITE_P)
			{
				if(board[8].piece == BROWN_P)
				{
					// white get's eaten
					board[9].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece has been taken by brown");
				}
			}
		}
		if(select_end == 109)
		{
			if(board[119].piece == WHITE_P)
			{
				if(board[118].piece == BROWN_P)
				{
					// white get's eaten
					board[119].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece taken by brown");
				}
			}
		}
		if(select_end == 32)
		{
			if(board[21].piece == WHITE_P)
			{
				if(board[9].piece == BROWN_P)
				{
					// white get's eaten
					board[21].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece taken by brown");
				}
			}
		}
		if(select_end == 98)
		{
			if(board[109].piece == WHITE_P)
			{
				if(board[119].piece == BROWN_P)
				{
					// white get's eaten
					board[109].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "a white piece has been taken by brown");
				}
			}
		}
		if(select_end > 10 && select_end < 120)
		{
			if(board[select_end - 11].piece == WHITE_P && board[select_end - 22].piece == BROWN_P)
			{
				board[select_end - 11].piece = EMPTY;
				white_eaten++;
				init_particles();
				strcpy(info2_buf, "a white piece has been taken by brown");
			}
			if(board[select_end + 11].piece == WHITE_P && board[select_end + 22].piece == BROWN_P)
			{
				board[select_end + 11].piece = EMPTY;
				white_eaten++;
				init_particles();
				strcpy(info2_buf, "a white piece has been taken by brown");
			}
		}
	}
	return;
}

void nse_w(int n_one, int n_two, int s_one, int s_two, int e_one, int e_two)
{
	if(board[e_one].piece == BROWN_P && (board[e_two].piece == WHITE_P || board[e_two].piece == KING_P))
	{
		board[e_one].piece = EMPTY;
		brown_eaten++;
		init_particles();
		strcpy(info2_buf, "brown piece taken by white");
	}
	if(board[n_one].piece == BROWN_P && (board[n_two].piece == WHITE_P || board[n_two].piece == KING_P))
	{
		board[n_one].piece = EMPTY;
		brown_eaten++;
		init_particles();
		strcpy(info2_buf, "brown piece taken by white");
	}
	if(board[s_one].piece == BROWN_P && (board[s_two].piece == WHITE_P || board[s_two].piece == KING_P))
	{
		board[s_one].piece = EMPTY;
		brown_eaten++;
		init_particles();
		strcpy(info2_buf, "brown piece taken by white");
	}
	return;
}

void nsw_w(int n_one, int n_two, int s_one, int s_two, int w_one, int w_two)
{
	if(board[w_one].piece == BROWN_P && (board[w_two].piece == WHITE_P || board[w_two].piece == KING_P))
	{
		board[w_one].piece = EMPTY;
		brown_eaten++;
		init_particles();
		strcpy(info2_buf, "brown piece taken by white");
	}
	if(board[n_one].piece == BROWN_P && (board[n_two].piece == WHITE_P || board[n_two].piece == KING_P))
	{
		board[n_one].piece = EMPTY;
		brown_eaten++;
		init_particles();
		strcpy(info2_buf, "brown piece taken by white");
	}
	if(board[s_one].piece == BROWN_P && (board[s_two].piece == WHITE_P || board[s_two].piece == KING_P))
	{
		board[s_one].piece = EMPTY;
		brown_eaten++;
		init_particles();
		strcpy(info2_buf, "brown piece taken by white");
	}
	return;
}

void nse_b(int n_one, int n_two, int s_one, int s_two, int e_one, int e_two)
{
	if(board[e_one].piece == WHITE_P && board[e_two].piece == BROWN_P)
	{
		board[e_one].piece = EMPTY;
		white_eaten++;
		init_particles();
		strcpy(info2_buf, "white piece taken by brown");
	}
	if(board[n_one].piece == WHITE_P && board[n_two].piece == BROWN_P)
	{
		board[n_one].piece = EMPTY;
		white_eaten++;
		init_particles();
		strcpy(info2_buf, "white piece taken by brown");
	}
	if(board[s_one].piece == WHITE_P && board[s_two].piece == BROWN_P)
	{
		board[s_one].piece = EMPTY;
		white_eaten++;
		init_particles();
		strcpy(info2_buf, "white piece taken by brown");
	}
	return;
}

void nsw_b(int n_one, int n_two, int s_one, int s_two, int w_one, int w_two)
{
	if(board[w_one].piece == WHITE_P && board[w_two].piece == BROWN_P)
	{
		board[w_one].piece = EMPTY;
		white_eaten++;
		init_particles();
		strcpy(info2_buf, "white piece taken by brown");
	}
	if(board[n_one].piece == WHITE_P && board[n_two].piece == BROWN_P)
	{
		board[n_one].piece = EMPTY;
		white_eaten++;
		init_particles();
		strcpy(info2_buf, "white piece taken by brown");
	}
	if(board[s_one].piece == WHITE_P && board[s_two].piece == BROWN_P)
	{
		board[s_one].piece = EMPTY;
		white_eaten++;
		init_particles();
		strcpy(info2_buf, "white piece taken by brown");
	}
	return;
}

void wes_w(int w_one, int w_two, int e_one, int e_two, int s_one, int s_two)
{
	if(board[s_one].piece == BROWN_P && (board[s_two].piece == WHITE_P || board[s_two].piece == KING_P))
	{
		board[s_one].piece = EMPTY;
		brown_eaten++;
		init_particles();
		strcpy(info2_buf, "brown piece taken by white");
	}
	if(board[w_one].piece == BROWN_P && (board[w_two].piece == WHITE_P || board[w_two].piece == KING_P))
	{
		board[w_one].piece = EMPTY;
		brown_eaten++;
		init_particles();
		strcpy(info2_buf, "brown piece taken by white");
	}
	if(board[e_one].piece == BROWN_P && (board[e_two].piece == WHITE_P || board[e_two].piece == KING_P))
	{
		board[e_one].piece = EMPTY;
		brown_eaten++;
		init_particles();
		strcpy(info2_buf, "brown piece taken by white");
	}
	return;
}

void wen_w(int w_one, int w_two, int e_one, int e_two, int n_one, int n_two)
{
	if(board[n_one].piece == BROWN_P && (board[n_two].piece == WHITE_P || board[n_two].piece == KING_P))
	{
		board[n_one].piece = EMPTY;
		brown_eaten++;
		init_particles();
		strcpy(info2_buf, "brown piece taken by white");
	}
	if(board[w_one].piece == BROWN_P && (board[w_two].piece == WHITE_P || board[w_two].piece == KING_P))
	{
		board[w_one].piece = EMPTY;
		brown_eaten++;
		init_particles();
		strcpy(info2_buf, "brown piece taken by white");
	}
	if(board[e_one].piece == BROWN_P && (board[e_two].piece == WHITE_P || board[e_two].piece == KING_P))
	{
		board[e_one].piece = EMPTY;
		brown_eaten++;
		init_particles();
		strcpy(info2_buf, "brown piece taken by white");
	}
	return;
}

void wes_b(int w_one, int w_two, int e_one, int e_two, int s_one, int s_two)
{
	if(board[s_one].piece == WHITE_P && board[s_two].piece == BROWN_P)
	{
		board[s_one].piece = EMPTY;
		white_eaten++;
		init_particles();
		strcpy(info2_buf, "white piece taken by brown");
	}
	if(board[w_one].piece == WHITE_P && board[w_two].piece == BROWN_P)
	{
		board[w_one].piece = EMPTY;
		white_eaten++;
		init_particles();
		strcpy(info2_buf, "white piece taken by brown");
	}
	if(board[e_one].piece == WHITE_P && board[e_two].piece == BROWN_P)
	{
		board[e_one].piece = EMPTY;
		white_eaten++;
		init_particles();
		strcpy(info2_buf, "white piece taken by brown");
	}
	return;
}

void wen_b(int w_one, int w_two, int e_one, int e_two, int n_one, int n_two)
{
	if(board[n_one].piece == WHITE_P && board[n_two].piece == BROWN_P)
	{
		board[n_one].piece = EMPTY;
		white_eaten++;
		init_particles();
		strcpy(info2_buf, "white piece taken by brown");
	}
	if(board[w_one].piece == WHITE_P && board[w_two].piece == BROWN_P)
	{
		board[w_one].piece = EMPTY;
		white_eaten++;
		init_particles();
		strcpy(info2_buf, "white piece taken by brown");
	}
	if(board[e_one].piece == WHITE_P && board[e_two].piece == BROWN_P)
	{
		board[e_one].piece = EMPTY;
		white_eaten++;
		init_particles();
		strcpy(info2_buf, "white piece taken by brown");
	}
	return;
}

void normal_check(void)
{
	int n_one = 0;
	int n_two = 0;

	int s_one = 0;
	int s_two = 0;

	int w_one = 0;
	int w_two = 0;

	int e_one = 0;
	int e_two = 0;

	n_one = select_end - 11;
	n_two = select_end - 22;

	s_one = select_end + 11;
	s_two = select_end + 22;

	w_one = select_end - 1;
	w_two = select_end - 2;

	e_one = select_end + 1;
	e_two = select_end + 2;

	if(!turn) // checking white first
	{
		if((select_end > 12) && (select_end < 20))
		{
			wes_w(w_one, w_two, e_one, e_two, s_one, s_two);
		} else if(select_end > 100 && select_end < 108)
		{
			wen_w(w_one, w_two, e_one, e_two, n_one, n_two);
		} else {
			switch(select_end)
			{
			case 23:
			case 34:
			case 45:
			case 56:
			case 67:
			case 78:
			case 89:
				nse_w(n_one, n_two, s_one, s_two, e_one, e_two);
				break;
			case 31:
			case 42:
			case 53:
			case 64:
			case 75:
			case 86:
			case 97:
				nsw_w(n_one, n_two, s_one, s_two, w_one, w_two);
				break;
			default:
				// check ALL directions!
				if(board[w_one].piece == BROWN_P && (board[w_two].piece == WHITE_P || board[w_two].piece == KING_P))
				{
					board[w_one].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "brown piece taken by white");
				}
				if(board[e_one].piece == BROWN_P && (board[e_two].piece == WHITE_P || board[e_two].piece == KING_P))
				{
					board[e_one].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "brown piece taken by white");
				}
				if(board[n_one].piece == BROWN_P && (board[n_two].piece == WHITE_P || board[n_two].piece == KING_P))
				{
					board[n_one].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "brown piece taken by white");
				}
				if(board[s_one].piece == BROWN_P && (board[s_two].piece == WHITE_P || board[s_two].piece == KING_P))
				{
					board[s_one].piece = EMPTY;
					brown_eaten++;
					init_particles();
					strcpy(info2_buf, "brown piece taken by white");
				}
			}
		}
	} else { // brown can be checked now
		if((select_end > 12) && (select_end < 20))
		{
			wes_b(w_one, w_two, e_one, e_two, s_one, s_two);
		} else if(select_end > 100 && select_end < 108)
		{
			wen_b(w_one, w_two, e_one, e_two, n_one, n_two);
		} else {
			switch(select_end)
			{
			case 23:
			case 34:
			case 45:
			case 56:
			case 67:
			case 78:
			case 89:
				nse_b(n_one, n_two, s_one, s_two, e_one, e_two);
				break;
			case 31:
			case 42:
			case 53:
			case 64:
			case 75:
			case 86:
			case 97:
				nsw_b(n_one, n_two, s_one, s_two, w_one, w_two);
				break;
			default:
				// check ALL directions!
				if(board[w_one].piece == WHITE_P && board[w_two].piece == BROWN_P)
				{
					board[w_one].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "white piece taken by brown");
				}
				if(board[e_one].piece == WHITE_P && board[e_two].piece == BROWN_P)
				{
					board[e_one].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "white piece taken by brown");
				}
				if(board[n_one].piece == WHITE_P && board[n_two].piece == BROWN_P)
				{
					board[n_one].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "white piece taken by brown");
				}
				if(board[s_one].piece == WHITE_P && board[s_two].piece == BROWN_P)
				{
					board[s_one].piece = EMPTY;
					white_eaten++;
					init_particles();
					strcpy(info2_buf, "white piece taken by brown");
				}
			}
		}
	}

	return;
}

void check_eat(void)
{
	if(!turn) // we have to check whether white eats something and update board accordingly
	{
		if (select_end < 12)
		{
			horizontal_check();
		} else if (select_end > 20 && select_end < 23) {
			vertical_check();
		} else if (select_end > 31 && select_end < 34) {
			vertical_check();
		} else if (select_end > 42 && select_end < 45) {
			vertical_check();
		} else if (select_end > 53 && select_end < 56) {
			vertical_check();
		} else if (select_end > 64 && select_end < 67) {
			vertical_check();
		} else if (select_end > 75 && select_end < 78) {
			vertical_check();
		} else if (select_end > 86 && select_end < 89) {
			vertical_check();
		} else if (select_end > 97 && select_end < 100) {
			vertical_check();
		} else if (select_end == 109) {
			vertical_check();
		} else if (select_end > 109) {
			horizontal_check();
		} else {
			normal_check();
		}
	} else { // it was brown that just moved. do the check.
		if (select_end < 12)
		{
			horizontal_check();
		} else if (select_end > 20 && select_end < 23) {
			vertical_check();
		} else if (select_end > 31 && select_end < 34) {
			vertical_check();
		} else if (select_end > 42 && select_end < 45) {
			vertical_check();
		} else if (select_end > 53 && select_end < 56) {
			vertical_check();
		} else if (select_end > 64 && select_end < 67) {
			vertical_check();
		} else if (select_end > 75 && select_end < 78) {
			vertical_check();
		} else if (select_end > 86 && select_end < 89) {
			vertical_check();
		} else if (select_end > 97 && select_end < 100) {
			vertical_check();
		} else if (select_end == 109) {
			vertical_check();
		} else if (select_end > 109) {
			horizontal_check();
		} else {
			normal_check();
		}
	}
	return;
}

int check_pos(void)
{
	int x = 0;
	int y = 0;

	int posx = 0;
	int posy = 0;

	// let's check some positions, shall we?
	if(!((clickedx > 40 && clickedy > 40) && (clickedx < (40 + BOARDX*TILE) && clickedy < (40 + BOARDY * TILE))))
	{
		return OUTSIDE_BOARD;
	} else {
		x = clickedx - 40;
		y = clickedy - 40;

		posx = x / 32;
		posy = y / 32;

		/*if(piece_selected)
		{
			desti = posx + posy * 11;
			destx = board[desti].x;
			desty =	board[desti].y;
		} else {
			starti = posx + posy * 11;
			startx = board[starti].x;
			starty = board[starti].y;
		}*/
		
		return board[posx + posy * 11].piece;
	}

}

int get_pos(void)
{
	return ((((clickedx - 40)/32))+  11* ((clickedy - 40)/32));
}

int valid_move(void)
{
	int delta = 0;
	int i = 0;
	int j = 0;
	int k = 0;

	int rowstart = 0;
	int rowend = 0;

	if(((select_end == 0) || (select_end == 10) || (select_end == 110) || (select_end == 120) || (select_end == 60)) && board[select_start].piece != KING_P)
		return NOT_VALID;

	diagonal = 0;
	obstructed = 0;

	delta = select_end - select_start;
	for(i = 0; i<=select_start; i++)
	{
		if(!(i%11))
			rowstart++;
	}

	for(i = 0; i<=select_end; i++)
	{
		if(!(i%11))
			rowend++;
	}

	if(delta < 0) // either move up or left
	{
		// either up or left
		if(abs(delta)<11)
		{
			// move left
			if(rowstart != rowend)
			{
				// player tries to jump lines. That's a no-no
				return NOT_VALID;
			}
			j = select_start - 1;
			k = select_end;
			for(i = j; i >= k; i--)
			{
				if(!(board[i].piece == EMPTY))
				{
					obstructed = 1;
				}
			}
			if(obstructed)
			{
				return NOT_VALID;
			} else {
				moving_dir = MOVE_LEFT;
				return VALID;
			}
		} else {
			// move up
			if(delta%11){
				// no diagonals!
				loki("diagonal attempt");
				diagonal = 1;
				return NOT_VALID;
			}
			j = select_start - 11;
			k = select_end;
			for(i = j; i >= k; i-=11)
			{
				if(!(board[i].piece == EMPTY))
				{
					obstructed = 1;
					loki("found obstacle on chosen path. no-no");
				}
			}
			if(obstructed)
			{
				loki("obstructed path. no will do");
				return NOT_VALID;
			} else {
				// wow, valid move. DO IT
				// we moved UP.
				moving_dir = MOVE_UP;
				return VALID;
			}
		}
	} else if (delta == 0) { // player decided not to move
		moving_dir = MOVING_NOTHING;
		return NOT_MOVED;
	} else if (delta > 0) { // either move down or right
		if(delta < 11)
		{
			// move right
			if(rowstart != rowend)
			{
				// player tries to jump lines. That's a no-no
				loki("diagonal attempt");
				diagonal = 1;
				return NOT_VALID;
			}

			loki("check if path is obstructed");
			j = select_start + 1;
			k = select_end;
			for(i = j; i <= k; i++)
			{
				if(!(board[i].piece == EMPTY))
				{
					obstructed = 1;
					loki("obstructed path. We are not allowed to jump!");
				}
			}
			if(obstructed)
			{
				loki("no jumps so returning NOT_VALID");
				return NOT_VALID;
			} else {
				// valid move to the RIGHT!
				moving_dir = MOVE_RIGHT;
				return VALID;
			}
		} else {
			// down
			if(delta%11){
				// no diagonals!
				loki("diagonal attempt");
				diagonal = 1;
				return NOT_VALID;
			}
			j = select_start + 11;
			k = select_end;
			for(i = j; i <= k; i+=11)
			{
				if(!board[i].piece == EMPTY)
				{
					obstructed = 1;
				}
			}
			if(obstructed)
			{
				return NOT_VALID;
			} else {
				// wow, valid move. DO IT
				// we moved DOWN.
				moving_dir = MOVE_DOWN;
				return VALID;
			}
		}
	}

	return 0;
}

void dump_screen(void)
{
	BITMAP *bmp;
	PALETTE pl;
	get_palette(pl);

	bmp = create_sub_bitmap(screen, 0, 0, 640, 480);
	save_bitmap("screenshot.bmp", bmp, pl);
	destroy_bitmap(bmp);

	strcpy(info3_buf, "dumped screenshot");

	return;
}

void draw_eaten_pieces(void)
{
	int hor = 0;
	int vert = 0;

	int i = 0;
	int j = 0;

	if(brown_eaten)
	{
		hor = brown_eaten/ON_ROW;
		vert = brown_eaten%ON_ROW;

		for(i = 0; i < hor; i++)
		{
			for(j = 0; j < ON_ROW; j++)
			{
				blit((BITMAP *)tietotiedosto[BROWN].dat, buf, 0, 0, 450+j*TILE, 70+i*TILE, TILE, TILE);
			}
		}
		if(vert)
		{
			for(i = 0; i < vert; i++)
			{
				blit((BITMAP *)tietotiedosto[BROWN].dat, buf, 0, 0, 450+i*TILE, 70+(hor)*TILE, TILE, TILE);
			}
		}
	}
	if(white_eaten)
	{
		hor = white_eaten/ON_ROW;
		vert = white_eaten%ON_ROW;

		for(i = 0; i < hor; i++)
		{
			for(j = 0; j < ON_ROW; j++)
			{
				blit((BITMAP *)tietotiedosto[WHITE].dat, buf, 0, 0, 450+j*TILE, 270+i*TILE, TILE, TILE);
			}
		}
		if(vert)
		{
			for(i = 0; i < vert; i++)
			{
				blit((BITMAP *)tietotiedosto[WHITE].dat, buf, 0, 0, 450+i*TILE, 270+(hor)*TILE, TILE, TILE);
			}
		}
	}
	return;
}

void animate_move(void)
{

	switch(moving_dir)
	{
	case MOVE_LEFT:
		board[select_start].movx	-= MOVE_SPEED;
		break;
	case MOVE_RIGHT:
		board[select_start].movx += MOVE_SPEED;
		break;
	case MOVE_UP:
		board[select_start].movy	-= MOVE_SPEED;
		break;
	case MOVE_DOWN:
		board[select_start].movy += MOVE_SPEED;
		break;
	}
	
	if(board[select_start].movx == board[select_start].destx && board[select_start].movy == board[select_start].desty)
	{
		moving = MOVING_NOTHING;
		board[select_end].piece = board[select_start].piece;
		board[select_start].piece = EMPTY;
		game_status = check_victory();
		if(!(game_status == WHITE_WINS) && !(game_status == BROWN_WINS) && !(game_status == DRAW))
		{
			check_eat();
		}
		turn = ! turn;
	}

	return;
}

void update_particles(void)
{
	int i;
	
	for (i = 0; i < MAX_PARTICLES; i++)
	{
		elementen[i].x+=elementen[i].xspeed/(slowdown*1000.0);
		elementen[i].y+=elementen[i].yspeed/(slowdown*1000.0);

		elementen[i].xspeed+=elementen[i].xgrav;
		elementen[i].yspeed+=elementen[i].ygrav;

		elementen[i].life-=elementen[i].fade;
		if(elementen[i].life < 0.0) // do some Jeesus stuff on this dead particle...
		{
			elementen[i].life = 0.5;
			elementen[i].fade=float(rand()%500)/1000.0+.0003;

			elementen[i].x = fountainx;
			elementen[i].y = fountainy;

			elementen[i].xspeed = xspeeddir + float((rand()%60)-32.0);
			elementen[i].yspeed = yspeeddir + float((rand()%60)-32.0);

			elementen[i].color = fountain_color;
		}
		if(dirkeys&F_LEFT && elementen[i].xgrav>-0.8)
			elementen[i].xgrav-=0.01;
		if(dirkeys&F_RIGHT && elementen[i].xgrav<0.8)
			elementen[i].xgrav+=0.01;
		if(dirkeys&F_UP && elementen[i].ygrav>-0.8)
			elementen[i].xgrav-=0.01;
		if(dirkeys&F_DOWN && elementen[i].ygrav<0.8)
			elementen[i].xgrav+=0.01;
	}
	for (i = 0; i < MAX_PARTICLES; i++)
	{
		elementen2[i].x+=elementen2[i].xspeed/(slowdown*1000.0);
		elementen2[i].y+=elementen2[i].yspeed/(slowdown*1000.0);

		elementen2[i].xspeed+=elementen2[i].xgrav;
		elementen2[i].yspeed+=elementen2[i].ygrav;

		elementen2[i].life-=elementen2[i].fade;
		if(elementen2[i].life < 0.0) // do some Jeesus stuff on this dead particle...
		{
			elementen2[i].life = 0.5;
			elementen2[i].fade=float(rand()%500)/1000.0+.0003;

			elementen2[i].x = fountain2x;
			elementen2[i].y = fountain2y;

			elementen2[i].xspeed = xspeed2dir + float((rand()%60)-32.0);
			elementen2[i].yspeed = yspeed2dir + float((rand()%60)-32.0);

			elementen2[i].color = fountain_color;
		}
		if(dir2keys&F_LEFT && elementen2[i].xgrav>-0.8)
			elementen2[i].xgrav-=0.01;
		if(dir2keys&F_RIGHT && elementen2[i].xgrav<0.8)
			elementen2[i].xgrav+=0.01;
		if(dir2keys&F_UP && elementen2[i].ygrav>-0.8)
			elementen2[i].xgrav-=0.01;
		if(dir2keys&F_DOWN && elementen2[i].ygrav<0.8)
			elementen2[i].xgrav+=0.01;
	}
	return;
}

void init_particles(void)
{
	int i;

	for (i = 0; i < MAX_PARTICLES; i++)
	{
		elementen[i].life = 2.0;
		elementen[i].fade = float(rand()%100)/1000.0 + 0.003;
		elementen[i].xspeed = float((rand()%50) - 25.0) * 30.0;
		elementen[i].yspeed = float((rand()%50) - 25.0) * 30.0;
		elementen[i].xgrav = 0.0;
		elementen[i].ygrav = 0.3;
		elementen[i].x = fountainx;
		elementen[i].y = fountainy;
		elementen[i].color = rand()%200 + 20;
	}
	for (i = 0; i < MAX_PARTICLES; i++)
	{
		elementen2[i].life = 2.0;
		elementen2[i].fade = float(rand()%100)/1000.0 + 0.003;
		elementen2[i].xspeed = float((rand()%50) - 25.0) * 30.0;
		elementen2[i].yspeed = float((rand()%50) - 25.0) * 30.0;
		elementen2[i].xgrav = 0.0;
		elementen2[i].ygrav = 0.3;
		elementen2[i].x = fountain2x;
		elementen2[i].y = fountain2y;
		elementen2[i].color = rand()%200 + 20;
	}
	return;
}

void draw_it(void)
{
	int i;

	acquire_bitmap(buf);

	blit(board_map, buf, 0, 0, 0, 0, 640, 480);

	if(selectx)
	{
		select_color++;
		if(select_color>STOP_COLOR)
		{
			select_color = START_COLOR;
		}
		rect(buf, ((selectx-40)/32)*32+40, ((selecty-40)/32)*32+40, ((selectx-40)/32)*32+72, ((selecty-40)/32)*32+72, select_color );
	}

	for(i = 0; i < MAX_PARTICLES; i++)
	{
		putpixel(buf, elementen[i].x, elementen[i].y, elementen[i].color);
		putpixel(buf, elementen2[i].x, elementen2[i].y, elementen2[i].color);
	}

	for(i = 0; i < BOARDX*BOARDY; i++)
	{
		switch(board[i].piece)
		{
		case BROWN_P:
			if(i == select_start && moving != MOVING_NOTHING)
			{
				masked_blit((BITMAP *)tietotiedosto[BROWN].dat, buf, 0, 0, board[i].movx, board[i].movy, TILE, TILE);
			} else {
				masked_blit((BITMAP *)tietotiedosto[BROWN].dat, buf, 0, 0, board[i].x, board[i].y, TILE, TILE);
			}
			break;
		case WHITE_P:
			if(i == select_start && moving != MOVING_NOTHING)
			{
				masked_blit((BITMAP *)tietotiedosto[WHITE].dat, buf, 0, 0, board[i].movx, board[i].movy, TILE, TILE);
			} else {
				masked_blit((BITMAP *)tietotiedosto[WHITE].dat, buf, 0, 0, board[i].x, board[i].y, TILE, TILE);
			}
			break;
		case KING_P:
			if(i == select_start && moving != MOVING_NOTHING)
			{
				masked_blit((BITMAP *)tietotiedosto[KING].dat, buf, 0, 0, board[i].movx, board[i].movy, TILE, TILE);
			} else {
				masked_blit((BITMAP *)tietotiedosto[KING].dat, buf, 0, 0, board[i].x, board[i].y, TILE, TILE);
			}
			break;
		}
	}

	draw_eaten_pieces();

	if(vuoro_buf)
	{
		textout(buf, font, vuoro_buf, 216-(text_length(font, vuoro_buf)/2), 422, -1);
	}
	if(info_buf)
	{
		textout(buf, font, info_buf, 216-(text_length(font, info_buf)/2), 422+1*text_height(font), -1);
	}
	if(info2_buf)
	{
		textout(buf, font, info2_buf, 216-(text_length(font, info2_buf)/2), 422+2*text_height(font), 45);
	}
	if(info3_buf)
	{
		textout(buf, font, info3_buf, 216-(text_length(font, info3_buf)/2), 422+3*text_height(font), 12);
	}

	if(fps)
	{
		textprintf(buf, font, 625, 0, -1, "%d fps", fps);
	}

	circle(buf, mousex, mousey, 4, 250);

	release_bitmap(buf);

	blit(buf, screen, 0, 0, 0, 0, 640, 480);

	fps_counter++;

	update_particles();

	return;
}

void get_input(void)
{
	dirkeys = 0;
	dir2keys = 0;
	if(key[KEY_ESC])
	{
		forced_exit = 1;
	}
	
	if(key[KEY_F12])
	{
		dump_screen();
	}

	if(key[KEY_A])
	{
		dir2keys |= F_LEFT;
	}
	if(key[KEY_D])
	{
		dir2keys |= F_RIGHT;
	}
	if(key[KEY_S])
	{
		dir2keys |= F_DOWN;
	}
	if(key[KEY_W])
	{
		dir2keys |= F_UP;
	}

	if(key[KEY_4_PAD])
	{
		dirkeys |= F_LEFT;
	}
	if(key[KEY_6_PAD])
	{
		dirkeys |= F_RIGHT;
	}
	if(key[KEY_2_PAD])
	{
		dirkeys |= F_DOWN;
	}
	if(key[KEY_8_PAD])
	{
		dirkeys |= F_UP;
	}

	if(key[KEY_TAB])
	{
		init_particles();
	}
	
	if(mouse_b & 1)
	{
		clicked = 1;
		clickedx = mouse_x;
		clickedy = mouse_y;
		//rest(150);
	}
	
	if(key[KEY_F1])
	{
		loki("request for help, but not yet done. Heheheh");
	}

	update_input = 0;
	return;
}

void twopl_game(void)
{
	int i=0;
	int move_buf = 0;
	int game_over = 0; // normal end of game (win/lose/draw)

	int validness = 0;

	int moved_piece = 0; // buffer for piece nr.


	turn = 0; // whose turn is it? 0 = white, 1 = brown. White starts!
	int nr_turn = 1;

	set_color_depth(8);
	set_palette((RGB *)tietotiedosto[PL].dat);

	setup_board();

	board_map = create_system_bitmap(640, 480);
	buf = create_system_bitmap(640, 480);
	if(!board_map)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Couldn't create system bitmap");
		loki("Couldn't create system bitmap");
		exit(1);
	}
	if(!buf)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Couldn't create system bitmap");
		loki("Couldn't create system bitmap");
		exit(1);
	}
	

	board_map = (BITMAP *)tietotiedosto[BOARD].dat;

	// show bitmap and and [press a button to start]

	while(!mouse_b)
	{
		acquire_bitmap(buf);
		blit(board_map, buf, 0, 0, 0, 0, 640, 480);
		textout(buf, font, "press a button to start", 216-(text_length(font, "press button to start")/2), 438-(text_height(font)/2), -1);
		release_bitmap(buf);
		blit(buf, screen, 0, 0, 0, 0, 640, 480);
	}

	rest(MENU_WAIT);

	init_particles();

	strcpy(vuoro_buf, "white's turn");

	LOCK_VARIABLE(fps_counter);
	LOCK_VARIABLE(fps);
	LOCK_FUNCTION(fps_int);

	install_int(fps_int, 1000);

	LOCK_VARIABLE(update_input);
	LOCK_FUNCTION(input_int);

	install_int(input_int, 100);

	while(!game_over && !forced_exit)
	{
		clicked = 0;
		mousex = mouse_x;
		mousey = mouse_y;

		if(turn)
		{
			strcpy(vuoro_buf, "brown's turn");
		} else {
			strcpy(vuoro_buf, "white's turn");
		}

		// get input
		// process input (mouse and esc + func, keys)
		//		<F1> help
		//		<F12> screenshot in screenshot.bmp
		//		<ESC> go back to main menu without asking, etc.
		//		button1 - take/put piece
		
		if(update_input)
		{
			get_input();
		}

		if(!forced_exit && (game_status == GAME_CONTINUES) && (moving==MOVING_NOTHING))
		{
			if(clicked)
			{
				// check whether we had an empty hand or not
				if(!piece_selected) // empty hand
				{
					if(!turn) // white's turn
					{
						if(check_pos() == WHITE_P)
						{
							// take it
							select_start = get_pos();
							piece_selected = !piece_selected;
							strcpy(info2_buf, "selected a white piece");
							selectx = clickedx;
							selecty = clickedy;
							move_buf = MOVING_WHITE;
						} else if (check_pos() == KING_P) {
							// take it
							select_start = get_pos();
							piece_selected = !piece_selected;
							strcpy(info2_buf, "selected the white king");
							selectx = clickedx;
							selecty = clickedy;
							move_buf = MOVING_KING;
						} else if (check_pos() == BROWN_P) {
							// not your piece!
							// print message telling it is white's turn
							// so only white pieces are allowed to be moved!
							strcpy(info2_buf, "Not your piece!");
						}
					} else if(turn) { // brown's turn
						if(check_pos() == BROWN_P)
						{
							// take it
							select_start = get_pos();
							piece_selected = !piece_selected;
							strcpy(info2_buf, "selected a brown piece");
							selectx = clickedx;
							selecty = clickedy;
							move_buf = MOVING_BROWN;
						} else if (check_pos() == KING_P) {
							// not your piece!
							// print message telling it is white's turn
							// so only white pieces are allowed to be moved!
							strcpy(info2_buf, "you won't win by just selecting the king");
							selectx = clickedx;
							selecty = clickedy;
						} else if (check_pos() == WHITE_P) {
							// not your piece!
							// print message telling it is white's turn
							// so only white pieces are allowed to be moved!
							strcpy(info2_buf, "Not your piece!");
						}
					}
				} else if (piece_selected) {
					// we already had a piece in our hand
					// check whether move is valid
					if (!turn) // white's turn
					{
						select_end = get_pos();
						
						validness = valid_move();
						if(validness>0){
							// move accepted
							// also check for winning conditions (King on savehouse?). Brown
							// ran out of pieces?
							board[select_start].destx = board[select_end].x;
							board[select_start].desty = board[select_end].y;
							board[select_start].movx = board[select_start].x;
							board[select_start].movy = board[select_start].y;
							moving = move_buf;
							piece_selected = 0;
							strcpy(info2_buf, "");
							selectx = 0;
							selecty = 0;
						} else if (validness == 0) {
							strcpy(info2_buf, "white cancelled selection");
							piece_selected = 0;
							selectx = 0;
							selecty = 0;
						} else {
							strcpy(info2_buf, "illegal move by white");
						}
					} else if (turn) // brown's turn
					{
						select_end = get_pos();
						validness = valid_move();
						if(validness>0){
							// move accepted
							// also check for winning conditions, etc.
							board[select_start].destx = board[select_end].x;
							board[select_start].desty = board[select_end].y;
							board[select_start].movx = board[select_start].x;
							board[select_start].movy = board[select_start].y;
							moving = move_buf;
							piece_selected = 0;
							strcpy(info2_buf, "");
							selectx = 0;
							selecty = 0;
						} else if (validness == 0) {
							strcpy(info2_buf, "brown cancelled selection");
							piece_selected = 0;
							selectx = 0;
							selecty = 0;
						} else {
							strcpy(info2_buf, "illegal move by brown");
						}
					}
				} // end of piece_selected
			} // end of checking mouse input			
		} // end if(!forced_exit ...
		draw_it();
		if(moving>MOVING_NOTHING)
		{
			animate_move();
		}
	} // while not yet end of game, loop, loop, loop

	clear_keybuf();

	remove_int(fps_int);
	remove_int(input_int);

	forced_exit = 0;
	clicked = 0;
	game_over = 0;
	selectx = 0;
	selecty = 0;
	moving = 0;
	move_buf = 0;

	return;

}

// MAIN FUNCTION, what would we be without it ;)
int main()
{
	int palautusarvo = 0;

	BITMAP *creditbuf = NULL;
	BITMAP *famebuf = NULL;
	BITMAP *notyetbuf = NULL;

	// open the log-file for logging, this cleans it.
	lokitiedosto = fopen(lokitiedostonimi, "w");
	fclose(lokitiedosto);

	// initialising Allegro
	allegro_init();

	install_keyboard();
	install_mouse();
	install_timer();

	set_color_depth(8);

	if(set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0)<0)
	{
		allegro_message("Oops, couldn't initialise gfx_mode");
		loki("failed to set gfx_mode:");
		loki(allegro_error);
		exit(1);
	}

	creditbuf = create_system_bitmap(640, 480);
	famebuf = create_system_bitmap(640, 480);
	notyetbuf = create_system_bitmap(640, 480);

	// load datafile
	tietotiedosto = load_datafile(tietotiedostonimi);

	set_palette((RGB *)tietotiedosto[PL].dat);

	blit((BITMAP *)tietotiedosto[OPEN_TITLE].dat, creditbuf, 0, 0, 0, 0, 640, 480);
	blit((BITMAP *)tietotiedosto[OPEN_TITLE].dat, famebuf, 0, 0, 0, 0, 640, 480);
	blit((BITMAP *)tietotiedosto[OPEN_TITLE].dat, notyetbuf, 0, 0, 0, 0, 640, 480);
	masked_blit((BITMAP *)tietotiedosto[CREDIT_TEXT].dat, creditbuf, 0, 0, 40, 100, 540, 410);
	masked_blit((BITMAP *)tietotiedosto[FAME_TEXT].dat, famebuf, 0, 0, 40, 100, 540, 410);
	masked_blit((BITMAP *)tietotiedosto[NOTYET].dat, notyetbuf, 0, 0, 40, 100, 540, 410);

	// put on title screen
	while(!key[KEY_ESC] && !mouse_b)
	{
		blit((BITMAP *)tietotiedosto[OPEN_TITLE].dat, screen, 0, 0, 0, 0, 640, 480);
	}
	rest(MENU_WAIT);

	clear_keybuf();
	
	// before we throw the user into the DIALOG, we
	// have to bind the right pics into it, otherwise
	// we won't see a bit... :)
	keskustelu[1].dp = (BITMAP *)tietotiedosto[OPEN_TITLE].dat;
	keskustelu[2].dp = (BITMAP *)tietotiedosto[OPTIONS_B].dat;
	keskustelu[3].dp = (BITMAP *)tietotiedosto[TWOPL_B].dat;
	keskustelu[4].dp = (BITMAP *)tietotiedosto[ONEPL_B].dat;
	keskustelu[5].dp = (BITMAP *)tietotiedosto[FAME_B].dat;
	keskustelu[6].dp = (BITMAP *)tietotiedosto[CREDITS_B].dat;
	keskustelu[7].dp = (BITMAP *)tietotiedosto[QUIT_B].dat;
	

	while(palautusarvo != 7 && palautusarvo != -1)
	{

		palautusarvo = do_dialog(keskustelu, -1);
		
		switch(palautusarvo)
		{
		case 2:
			// now we should do the options dialog
			clear(screen);
			rest(MENU_WAIT);
			while(!keypressed() && !mouse_b)
			{
				blit(notyetbuf, screen, 0, 0, 0, 0, 640, 480);
			}
			rest(MENU_WAIT);
			break;
		case 3:
			// now we should go to the game
			loki("now we go to the game (almost 100% implemented)");
			clear(screen);
			rest(MENU_WAIT);
			twopl_game();
			break;
		case 4:
			// ai-stuff
			clear(screen);
			rest(MENU_WAIT);
			while(!keypressed() && !mouse_b)
			{
				blit(notyetbuf, screen, 0, 0, 0, 0, 640, 480);
			}
			rest(MENU_WAIT);
			break;
		case 5:
			// hall of fame
			clear(screen);
			rest(MENU_WAIT);
			while(!keypressed() && !mouse_b)
			{
				blit(famebuf, screen, 0, 0, 0, 0, 640, 480);
			}
			rest(MENU_WAIT);
			break;
		case 6:
			// now we should show the credits
			clear(screen);
			rest(MENU_WAIT);
			while(!keypressed() && !mouse_b)
			{
				blit(creditbuf, screen, 0, 0, 0, 0, 640, 480);
			}
			rest(MENU_WAIT);
			break;
		case 7:
			// so the player wants to quit...
			// well, throw the credits to him before it's over...
			clear(screen);
			rest(MENU_WAIT);
			break;
		case -1:
			// so the player wants to quit...
			// well, throw the credits to him before it's over...
			clear(screen);
			rest(MENU_WAIT);
			break;
		default:
			// something went wrong!
			loki("something went wrong!");
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message("died in while(palautusarvo != 4) lus... :(");
			exit(1);
		}
		// reset of graphs
		keskustelu[1].dp = (BITMAP *)tietotiedosto[OPEN_TITLE].dat;
		keskustelu[2].dp = (BITMAP *)tietotiedosto[OPTIONS_B].dat;
		keskustelu[3].dp = (BITMAP *)tietotiedosto[TWOPL_B].dat;
		keskustelu[4].dp = (BITMAP *)tietotiedosto[ONEPL_B].dat;
		keskustelu[5].dp = (BITMAP *)tietotiedosto[FAME_B].dat;
		keskustelu[6].dp = (BITMAP *)tietotiedosto[CREDITS_B].dat;
		keskustelu[7].dp = (BITMAP *)tietotiedosto[QUIT_B].dat;
	}
	
	while(!keypressed() && !mouse_b)
	{
		blit(creditbuf, screen, 0, 0, 0, 0, 640, 480);
	}
	rest(MENU_WAIT);

	// it's a wrap! (after we have cleaned up, if necessary...)

	destroy_bitmap(buf);
	destroy_bitmap(creditbuf);
	destroy_bitmap(notyetbuf);
	destroy_bitmap(famebuf);
	destroy_bitmap(board_map);

	unload_datafile(tietotiedosto);

	allegro_exit();

	return 0;

}
END_OF_MAIN()