#include "resources.h"
#include "the_end_loop.h"

bool do_the_end_loop(void)
{
	bool fade_in_scene = true;
	bool fade_out_scene = false;
	float level_trans = 1.0f;
	int key_press;
	
	while(!fade_out_scene ||  level_trans < 1.0f)
	{
		if(key[KEY_SPACE] || key[KEY_ENTER] || mouse_b & 1)
		{
			frame_time *= 3.0f;
		}
		if(keypressed())
		{
			key_press = readkey();

			if(key_press >> 8 == KEY_ESC)
			{
				clear_keybuf();
				return true;
			}
			clear_keybuf();
		}

		clear_keybuf();
		
		if(fade_out_scene)
		{
			level_trans += 0.25f * frame_time;
			if(level_trans >= 1.0f)
			{
				clear_keybuf();
				return true;
			}
		}
		if(fade_in_scene)
		{
			level_trans -= 0.25f * frame_time;
			if(level_trans <= 0.0f)
			{
				fade_out_scene = true;
				fade_in_scene = false;
				level_trans = 0.0f;
			}
		}
		
		draw_sprite(back_buffer, the_end, 0, 0);
		
		set_trans_blender(255, 255, 255, (int)(255.0 * level_trans));
		draw_trans_sprite(back_buffer, black_screen, 0, 0);
	
		FlipScreen();
	}
	

	clear_keybuf();
	return true;
}

