#include <cmath>
#include "resources.h"

BITMAP *back_buffer;
BITMAP *background;
BITMAP *seed;
CLGO_BOUNDING_CIRCLE *seed_circle;
BITMAP *island;
CLGO_BIT_MASK *island_bit_mask;
BITMAP *waves;
BITMAP *bird_a;
CLGO_BIT_MASK *bird_a_bit_mask;
BITMAP *bird_b;
CLGO_BIT_MASK *bird_b_bit_mask;
BITMAP *dolphin;
CLGO_BOUNDING_CIRCLE *dolphin_circle;
CLGO_BOUNDING_CIRCLE *dolphin_circle_2;
CLGO_BOUNDING_CIRCLE *dolphin_circle_3;
BITMAP *white_pixel;
BITMAP *stalk;
BITMAP *flower;
BITMAP *dawn;
BITMAP *stage_clear_text;
BITMAP *black_screen;
BITMAP *title;
BITMAP *quit;
BITMAP *new_game;
BITMAP *fullscreen;
BITMAP *the_end;

FMUSIC_MODULE *bgm;
FSOUND_SAMPLE *wind;
FSOUND_SAMPLE *select;
FSOUND_SAMPLE *start;
FSOUND_SAMPLE *water;
FSOUND_SAMPLE *flap;
FSOUND_SAMPLE *hit;

volatile unsigned int counter = 0;
unsigned int last_counter = 0;
float frame_time = 0.0f;
void timer_handler(void);
void create_waves(void);

void LoadResources(void)
{
	back_buffer = create_bitmap(320, 240);
	background = load_bitmap("data/bg.bmp", NULL);
	seed = load_bitmap("data/seed.bmp", NULL);
	seed_circle = clgo_create_bcircle(0, 0, 4.0f);
	island = load_bitmap("data/island.bmp", NULL);
	island_bit_mask = clgo_create_bitmask(0, 0,  island);
	create_waves();
	bird_a = load_bitmap("data/bird_a.bmp", NULL);
	bird_a_bit_mask  = clgo_create_bitmask(0, 0,  bird_a);
	bird_b = load_bitmap("data/bird_b.bmp", NULL);
	bird_b_bit_mask = clgo_create_bitmask(0, 0,  bird_b);
	dolphin = load_bitmap("data/dolphin.bmp", NULL);
	dolphin_circle = clgo_create_bcircle(0, 0, 12.0f);
	dolphin_circle_2 = clgo_create_bcircle(0, 0, 12.0f);
	dolphin_circle_3 = clgo_create_bcircle(0, 0, 12.0f);
	white_pixel = create_bitmap(1,1);
	clear_to_color(white_pixel, makecol(255, 255, 255));
	stalk = load_bitmap("data/stalk.bmp", NULL);
	flower = load_bitmap("data/flower.bmp", NULL);
	dawn = load_bitmap("data/dawn.bmp", NULL);
	stage_clear_text = load_bitmap("data/stage_clear.bmp", NULL);
	black_screen = create_bitmap(320, 240);
	clear_to_color(black_screen, makecol(0, 0, 0));
	title = load_bitmap("data/title.bmp", NULL);
	quit = load_bitmap("data/quit.bmp", NULL);
	new_game = load_bitmap("data/new_game.bmp", NULL);
	fullscreen = load_bitmap("data/fullscreen.bmp", NULL);
	the_end = load_bitmap("data/the_end.bmp", NULL);
	
	bgm = FMUSIC_LoadSong("data/bgm.mod");
	wind = FSOUND_Sample_Load(FSOUND_FREE, "data/wind.wav", FSOUND_NORMAL,0, 0);
	select = FSOUND_Sample_Load(FSOUND_FREE, "data/select.wav", FSOUND_NORMAL,0, 0);
	start = FSOUND_Sample_Load(FSOUND_FREE, "data/start.wav", FSOUND_NORMAL,0, 0);
	water = FSOUND_Sample_Load(FSOUND_FREE, "data/water.wav", FSOUND_NORMAL,0, 0);
	flap = FSOUND_Sample_Load(FSOUND_FREE, "data/flap.wav", FSOUND_NORMAL,0, 0);
	hit = FSOUND_Sample_Load(FSOUND_FREE, "data/hit.wav", FSOUND_NORMAL,0, 0);
	
	LOCK_VARIABLE(counter);
    LOCK_FUNCTION(timer_handler);
    install_int_ex(timer_handler, MSEC_TO_TIMER(1));
	
}

void FreeResources(void)
{
	destroy_bitmap(back_buffer);
	destroy_bitmap(background);
	destroy_bitmap(seed);
	clgo_destroy_bcircle(seed_circle);
	destroy_bitmap(island);
	clgo_destroy_bitmask(island_bit_mask);
	destroy_bitmap(waves);
	destroy_bitmap(bird_a);
	clgo_destroy_bitmask(bird_a_bit_mask);
	destroy_bitmap(bird_b);
	clgo_destroy_bitmask(bird_b_bit_mask);
	destroy_bitmap(dolphin);
	clgo_destroy_bcircle(dolphin_circle);
	clgo_destroy_bcircle(dolphin_circle_2);
	clgo_destroy_bcircle(dolphin_circle_3);
	destroy_bitmap(white_pixel);
	destroy_bitmap(stalk);
	destroy_bitmap(flower);
	destroy_bitmap(dawn);
	destroy_bitmap(stage_clear_text);
	destroy_bitmap(black_screen);
	destroy_bitmap(title);
	destroy_bitmap(quit);
	destroy_bitmap(new_game);
	destroy_bitmap(fullscreen);
	destroy_bitmap(the_end);
	
	FMUSIC_FreeSong(bgm);
}

void FlipScreen(void)
{
	stretch_blit(back_buffer, screen, 0, 0, 320, 240, 0, 0, 640, 480);
	
	while(counter == last_counter)
	{
		rest(1);
	}
	
	if(counter >= last_counter)
	{
		frame_time = (float)(counter - last_counter) / 1000.0f;
	}
	else
	{
		frame_time = (float)counter / 1000.0f;
	}
	
	last_counter = counter;
}

void timer_handler(void)
{
	counter++;
}
END_OF_FUNCTION(timer_handler)

void create_waves(void)
{
	waves = create_bitmap(80, 10);
	
	clear_to_color(waves, makecol(255, 0, 255));
	
	for(int i = 0; i < 80; i++)
	{
		int y_val = (int)(cos((float)i / 12.692f) * 4.0f + 4.0f);
		putpixel(waves, i, y_val, makecol(0, 0, 60 - y_val * 4));
		for(int y = y_val + 1; y < 10; y++)
		{
			putpixel(waves, i, y, makecol(0, 0, 70 - y * 4));
		}
	}
}

int find_island_collision_y(int x_pos)
{
	int y_pos;
	bool not_found_yet = true;
	
	x_pos = x_pos - island_bit_mask->bb.x;
	for(y_pos = 0; y_pos < island_bit_mask->bb.height && not_found_yet; y_pos++)
	{
		if(clgo_get_bitmask_bit(island_bit_mask, x_pos, y_pos))
		{
			not_found_yet = false;
		}
	}
	y_pos += island_bit_mask->bb.y;
	return y_pos;
}
