#include <allegro.h>
#include <FMOD/fmod.h>
#include "resources.h"
#include "game_loop.h"
#include "level_name_loop.h"
#include "menu_loop.h"
#include "the_end_loop.h"

void init(void);
void deinit(void);
void close_button(void);

bool emergency_quit = false;

int main(void)
{
	int level;
	int lives;
	init();
	
	FMUSIC_PlaySong(bgm);
	
	while(!emergency_quit)
	{
		do_menu_loop();
		go_to_next_level = false;
		quit_game = false;
		level = 1;
		num_birds = 3;
		speed_multiplier = 1.2f;
		lives = 3;
		while(!emergency_quit && !quit_game)
		{			
			do_level_name_loop(level, lives);
			reset_game_loop();
			while(do_game_loop() && !emergency_quit)
			{
			}
			
			if(go_to_next_level)
			{
				level++;
				speed_multiplier += 0.1f;
				num_birds = 3 + (level - 1) % 3;
			}
			else
			{
				lives--;
				if(lives <= 0)
				{
					do_the_end_loop();
					quit_game = true;
				}
			}
		} 
	}
	deinit();
	return 1;
}
END_OF_MAIN()

void init(void)
{
	allegro_init();
	install_timer();
    install_keyboard();
    install_mouse();
    
    srand(time(0));
	
	LOCK_FUNCTION(close_button);
    set_close_button_callback(close_button);
	
	set_window_title("Happy Falling");
	
	set_color_depth(32);
    set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
    
    FSOUND_Init(44100, 32, 0);
    
    LoadResources();
}

void deinit(void)
{
	FreeResources();
	FSOUND_Close();
	allegro_exit();
}

void close_button(void)
{
	emergency_quit = true;
}
END_OF_FUNCTION(close_button_handler)
