#include "resources.h"
#include "flower.h"

void FLOWER::setup(int x_center, int y_low)
{
	F_PARTICLE add_me;
	x = x_center;
	y = y_low;
	height = 0.0f;
	
	falling_particles.clear();
	particle_trans = 1.0f;
	add_me.x = (float)(x_center - 2);
	add_me.y = (float)(y_low - 4);
	add_me.y_speed = 4.0;
	for(int i = 0; i < 3; i++)
	{
		falling_particles.push_back(add_me);
		add_me.x += 2;
	}
}

void FLOWER::update(void)
{
	height += 8.0f * frame_time;
	
	update_falling_particles();
}

void FLOWER::draw(void)
{
	int source_height;
	bool draw_flower = false;
	
	draw_falling_particles();
	
	source_height = (int)height;
	
	if(source_height > stalk->h)
	{
		source_height = stalk->h;
		draw_flower = true;
	}
	masked_blit(stalk, back_buffer, 0, stalk->h - source_height, x - 2, y - source_height, stalk->w, source_height);
	
	if(draw_flower)
		draw_sprite(back_buffer, flower, x - 4, y - 12);
}

bool FLOWER::done_with_animation(void)
{
	return ((int)height > stalk->h);
}

void FLOWER::update_falling_particles(void)
{
	int x_draw;
	int y_draw;
	
	particle_trans -= 1.0f * frame_time;
	if(particle_trans < 0.0f)
	{
		particle_trans = 0.0f;
	}
	
	for(unsigned int i = 0; i < falling_particles.size(); i++)
	{
		falling_particles[i].y += falling_particles[i].y_speed * frame_time;
		y_draw = (int)falling_particles[i].y;
		x_draw = (int)falling_particles[i].x;
		
		if(y_draw >= find_island_collision_y(x_draw))
		{
			y_draw = find_island_collision_y(x_draw) - 1;
			falling_particles[i].y = (float)y_draw;
		}
	}
}

 void FLOWER::draw_falling_particles(void)
 {
 	int x_draw;
 	int y_draw;
 	
 	for(unsigned int i = 0; i < falling_particles.size(); i++)
	{
		y_draw = (int)falling_particles[i].y;
		x_draw = (int)falling_particles[i].x;
		
		set_trans_blender(255, 255, 255, (int)(255.0 * particle_trans));
		draw_trans_sprite(back_buffer, white_pixel, x_draw, y_draw);
	}
 }

