#ifndef RESOURCES_H_
#define RESOURCES_H_

#include <allegro.h>
#include <FMOD/fmod.h>
#include "collegro.h"

extern bool emergency_quit;
extern float frame_time;
extern BITMAP *back_buffer;
extern BITMAP *background;
extern BITMAP *seed;
extern CLGO_BOUNDING_CIRCLE *seed_circle;
extern BITMAP *island;
extern CLGO_BIT_MASK *island_bit_mask;
extern BITMAP *waves;
extern BITMAP *bird_a;
extern CLGO_BIT_MASK *bird_a_bit_mask;
extern BITMAP *bird_b;
extern CLGO_BIT_MASK *bird_b_bit_mask;
extern BITMAP *dolphin;
extern CLGO_BOUNDING_CIRCLE *dolphin_circle;
extern CLGO_BOUNDING_CIRCLE *dolphin_circle_2;
extern CLGO_BOUNDING_CIRCLE *dolphin_circle_3;
extern BITMAP *white_pixel;
extern BITMAP *stalk;
extern BITMAP *flower;
extern BITMAP *dawn;
extern BITMAP *stage_clear_text;
extern BITMAP *black_screen;
extern BITMAP *title;
extern BITMAP *quit;
extern BITMAP *new_game;
extern BITMAP *fullscreen;
extern BITMAP *the_end;

extern FMUSIC_MODULE *bgm;
extern FSOUND_SAMPLE *wind;
extern FSOUND_SAMPLE *select;
extern FSOUND_SAMPLE *start;
extern FSOUND_SAMPLE *water;
extern FSOUND_SAMPLE *flap;
extern FSOUND_SAMPLE *hit;

void LoadResources(void);
void FreeResources(void);

void FlipScreen(void);

int find_island_collision_y(int x_pos);

#endif /*RESOURCES_H_*/
