#include "resources.h"
#include "menu_loop.h"

void grab_menu_input(void);

int menu_selection;
bool show_title;

bool do_menu_loop(void)
{
	menu_selection = 0;
	show_title = true;
	
	while(show_title)
	{
		FlipScreen();
		
		grab_menu_input();
		
		blit(title, back_buffer, 0, 0, 0, 0, 320, 240);
		
		set_trans_blender(255, 255, 255, 80);
		
		if(menu_selection == 0)
		{
			draw_sprite(back_buffer, new_game, 160 - new_game->w / 2, 148);
		}
		else
		{
			draw_trans_sprite(back_buffer, new_game, 160 - new_game->w / 2, 148);
		}
		if(menu_selection == 1)
		{
			draw_sprite(back_buffer, fullscreen, 160 - fullscreen->w / 2, 170);
		}
		else
		{
			draw_trans_sprite(back_buffer, fullscreen, 160 - fullscreen->w / 2, 170);
		}
		if(menu_selection == 2)
		{
			draw_sprite(back_buffer, quit, 160 - quit->w / 2, 192);
		}
		else
		{
			draw_trans_sprite(back_buffer, quit, 160 - quit->w / 2, 192);
		}
		
		FlipScreen();
	}
	return true;
}

void grab_menu_input(void)
{
	int key_press;
	
	if(keypressed())
	{
		key_press = readkey();
		if(key_press >> 8 ==  KEY_UP)
		{
			menu_selection--;
			if(menu_selection < 0)
			{
				menu_selection = 0;
			}
			else
			{
				FSOUND_PlaySound(6, select);
			}
		}
		if(key_press >> 8 ==  KEY_DOWN)
		{
			menu_selection++;
			if(menu_selection > 2)
			{
				menu_selection = 2;
			}
			else
			{
				FSOUND_PlaySound(6, select);
			}
		}
		
		if(key_press >> 8 == KEY_ESC)
		{
			if(menu_selection != 2)
				menu_selection = 2;
			else
			{
				show_title = false;
				emergency_quit = true;
			}
		}
		
		if(key_press >> 8 == KEY_SPACE || key_press >> 8 == KEY_ENTER)
		{
			if(menu_selection == 0)
			{
				show_title = false;
				FSOUND_PlaySound(6, start);
			}
			if(menu_selection == 1)
			{
				FSOUND_PlaySound(6, start);
				if (is_windowed_mode()) 
				{
					set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
     			} 
     			else 
     			{
     				set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
      			}
			}
			if(menu_selection == 2)
			{
				show_title = false;
				emergency_quit = true;
			}
		}
		clear_keybuf();
	}
}
