#include "resources.h"
#include "level_name_loop.h"

int num_quotes = 12;
char *quotes[] = {"Achieve richness from Nature.", /*OK*/
/*OK*/				  "Nature invites us to look closer.",
/*OK*/				  "A weed is a flower in disguise.",
/*OK*/				  "Days I see flowers are wonderful.",
/*OK*/				  "There is a way that nature speaks.",
/*OK*/				  "A flower is an educated weed.",
/*OK*/				  "Trees speak to the listening heavens.",
/*OK*/				  "The beauty of earth gives strength.",
/*OK*/				  "Leaves of grass tell life's story.",
/*OK*/				  "Focus on nature, not on destruction.",
/*OK*/				  "Green trees are better than gold ones.",
/*OK*/				  "Lying on grass never wastes time."};
float level_trans;
bool fade_in_scene;
bool fade_out_scene;

bool do_level_name_loop(int level, int lives)
{
	int quote_num;
	BITMAP *temp_bitmap;
	fade_in_scene = true;
	fade_out_scene = false;
	level_trans = 1.0f;
	int key_press;
	
	quote_num = rand() % num_quotes;
	
	temp_bitmap = create_bitmap(320, 240);
	clear_to_color(temp_bitmap, makecol(255, 0, 255));
	
	textprintf_ex(temp_bitmap, font, 3, 3, makecol(255, 255, 255), 
						 makecol(255, 0, 255), "Lives: ");
	
	textprintf_centre_ex(temp_bitmap, font, 160, 95, makecol(255, 255, 255), 
						 makecol(255, 0, 255), "- Stage %i -", level);
						 
	textprintf_centre_ex(temp_bitmap, font, 160, 118, makecol(255, 255, 255), 
						 makecol(255, 0, 255), "\"%s\"", quotes[quote_num]);
	
	while(!fade_out_scene ||  level_trans < 1.0f)
	{
		clear_to_color(back_buffer, makecol(0, 0, 0));
		
		blit(background, back_buffer, 0, 0, 0, 0, 320, 240);
	
		if(key[KEY_SPACE] || key[KEY_ENTER] || mouse_b & 1)
		{
			frame_time *= 3.0f;
		}
		if(keypressed())
		{
			key_press = readkey();

			if(key_press >> 8 == KEY_ESC)
			{
				clear_keybuf();
				destroy_bitmap(temp_bitmap);
				return true;
			}
			clear_keybuf();
		}

		clear_keybuf();
		
		if(fade_out_scene)
		{
			level_trans += 0.25f * frame_time;
			if(level_trans >= 1.0f)
			{
				destroy_bitmap(temp_bitmap);
				clear_keybuf();
				return true;
			}
		}
		if(fade_in_scene)
		{
			level_trans -= 0.25f * frame_time;
			if(level_trans <= 0.0f)
			{
				fade_out_scene = true;
				fade_in_scene = false;
				level_trans = 0.0f;
			}
		}
		
		draw_sprite(back_buffer, temp_bitmap, 0, 0);
		
		int x_start = 54;
		for(int i = 0; i < lives; i++)
		{
			draw_sprite(back_buffer, seed, x_start, 2);
			x_start+= seed->w + 2;
		}
		
		set_trans_blender(255, 255, 255, (int)(255.0 * level_trans));
		draw_trans_sprite(back_buffer, black_screen, 0, 0);
	
		FlipScreen();
	}
	
	destroy_bitmap(temp_bitmap);

	clear_keybuf();
	return true;
}
