#include <cmath>
#include <vector>
#include "resources.h"
#include "game_loop.h"
#include "bird.h"
#include "death_particles.h"
#include "flower.h"
#include "collegro.h"

using namespace std;

void update_logic(void);
void draw(void);
void grab_input(void);
void update_birds(void);
void draw_birds(void);
void new_bird(unsigned int index);
bool check_for_deadly_collision(void);

float seed_x;
float seed_y;
float seed_y_speed;
bool game_win;
bool stage_clear;
bool show_win_text;
bool go_to_next_level;
bool quit_game;
float win_text_trans;
float dolphin_x;
int dolphin_y;
float dawn_trans;
float waves_a_offset;
float waves_b_offset;
bool is_dead;
bool fade_out_screen;
bool going_up_previously;
float fade_out_trans;
int num_birds = 5;
float speed_multiplier = 1.2f;
vector<BIRD> birds;
DEATH_PARTICLES death_particles;
FLOWER the_flower;

void reset_game_loop(void)
{
	BIRD new_bird;
	CLGO_BOUNDING_BOX *safety_box;
	CLGO_BOUNDING_BOX *bird_a_box_1;
	CLGO_BOUNDING_BOX *bird_a_box_2;
	CLGO_BOUNDING_BOX *bird_b_box_1;
	CLGO_BOUNDING_BOX *bird_b_box_2;
	
	is_dead = false;
	show_win_text = false;
	fade_out_screen = false;
	go_to_next_level = false;
	going_up_previously = false;
	death_particles.particles.clear();
	
	win_text_trans = 0.0f;
	fade_out_trans = 0.0f;
	dawn_trans = 0.0f;
	seed_x = 10.0f;
	seed_y = 40.0f;
	seed_y_speed = 1.0f;
	dolphin_x = 320.0f;
	game_win = false;
	stage_clear = false;
	quit_game = false;
	waves_a_offset = 0.0f;
	waves_b_offset = 0.0f;
	
	safety_box = clgo_create_bbox((int)seed_x, (int)seed_y, 100, 100);

	birds.clear();
	
	bird_a_box_1 = clgo_create_bbox(0,  0,  bird_a_bit_mask->bb.width,  bird_a_bit_mask->bb.height); 
	bird_a_box_2 = clgo_create_bbox(0,  0,  bird_a_bit_mask->bb.width,  bird_a_bit_mask->bb.height);  
	bird_b_box_1 = clgo_create_bbox(0,  0,  bird_b_bit_mask->bb.width,  bird_b_bit_mask->bb.height);  
	bird_b_box_2 = clgo_create_bbox(0,  0,  bird_b_bit_mask->bb.width,  bird_b_bit_mask->bb.height);   

	clgo_update_bcircle(seed_circle, (int)seed_x + 3, (int)seed_y + 4);
	for(int i = 0; i < num_birds; i++)
	{
		int collide;
		do
		{
			collide = 0;
			new_bird.x = rand() % 320;
			new_bird.y = rand() % 170 + 10;
			new_bird.animation_frame = 0.0f;
			new_bird.animation_speed = (float)(rand() % 200) / 40.0f + 1.0f;
			
			clgo_update_bbox(bird_a_box_1, (int)new_bird.x, (int)new_bird.y);
			clgo_update_bbox(bird_b_box_1, (int)new_bird.x, (int)new_bird.y);
			
			for(int j = 0; j < i; j++)
			{
				clgo_update_bbox(bird_a_box_2, (int)birds[j].x, (int)birds[j].y);
				clgo_update_bbox(bird_b_box_2, (int)birds[j].x, (int)birds[j].y);
				collide += clgo_collide_bbox_bbox(bird_a_box_1, bird_a_box_2); 
				collide += clgo_collide_bbox_bbox(bird_a_box_1, bird_b_box_2); 
				collide += clgo_collide_bbox_bbox(bird_b_box_1, bird_a_box_2); 
				collide += clgo_collide_bbox_bbox(bird_b_box_1, bird_b_box_2); 
			}
			
			clgo_update_bitmask(bird_b_bit_mask, (int)new_bird.x, (int)new_bird.y);
			collide += clgo_collide_bbox_bbox(safety_box, bird_a_box_1);
			collide += clgo_collide_bbox_bbox(safety_box, bird_b_box_1);
		} while (collide != 0);
		
		birds.push_back(new_bird);
	}
	clgo_destroy_bbox(safety_box);
	clgo_destroy_bbox(bird_a_box_1);
	clgo_destroy_bbox(bird_a_box_2);
	clgo_destroy_bbox(bird_b_box_1);
	clgo_destroy_bbox(bird_b_box_2);
}

bool do_game_loop(void)
{
	grab_input();
	
	if(death_particles.is_done() || go_to_next_level || quit_game)
	{
		return false;
	}
	
	update_logic();
	draw();
	
	FlipScreen();
	
	return true;
}

void update_logic(void)
{
	int prev_dolphin_y;
	frame_time *= speed_multiplier;
	if(!is_dead && !game_win)
	{
		seed_x += 4.0f * frame_time;
		seed_y += seed_y_speed * frame_time;
	}
	
	prev_dolphin_y = 215 + (int)(sin(dolphin_x / 25.0f) * 30.0f);
	dolphin_x -= 70.0f * frame_time;
	if(dolphin_x < -63.0f)
	{
		dolphin_x = 320.0f;
	}
	dolphin_y = 215 + (int)(sin(dolphin_x / 25.0f) * 30.0f);
	
	if((prev_dolphin_y < 225 && dolphin_y >= 225) || (prev_dolphin_y > 225 && dolphin_y <= 225))
	{
		FSOUND_PlaySound(6, water);
	}
	
	waves_a_offset -= 10.0f * frame_time;
	while(waves_a_offset <= -80.0f)
	{
		waves_a_offset += 80.0f;
	}
	waves_b_offset += 20.0f * frame_time;
	while(waves_b_offset > 0.0f)
	{
		waves_b_offset -= 80.0f;
	}
	
	update_birds();
	
	if((key[KEY_SPACE] || mouse_b & 1) && !game_win)
	{
		if(going_up_previously == false)
		{
			FSOUND_PlaySound(5, wind);
		}
		seed_y_speed -= 30.0f * frame_time;
		going_up_previously = true;
	}
	else
	{
		if(seed_y_speed < 0)
		{
			seed_y_speed += 15.0f * frame_time;
		}
		seed_y_speed += 5.0f * frame_time;
		
		going_up_previously = false;
	}
	
	if(is_dead)
	{
		death_particles.update();
	}
	
	if(game_win)
	{
		the_flower.update();
		stage_clear = the_flower.done_with_animation();
	}
	
	if(stage_clear)
	{
		show_win_text = true;
		dawn_trans += 0.125 * frame_time;
		if(dawn_trans >= 0.5f)
		{
			dawn_trans = 0.5f;
			show_win_text = true;
		}
	}
	
	if(!is_dead && !game_win)
	{
		clgo_update_bcircle(seed_circle, (int)seed_x + 3, (int)seed_y + 4);
		clgo_update_bitmask(island_bit_mask, 320 - island->w - 45, 240 - island->h);
		clgo_update_bcircle(dolphin_circle, (int)dolphin_x + 12, dolphin_y + 18 + (int)-(cos(dolphin_x / 25.0f) * 15.0f));
		clgo_update_bcircle(dolphin_circle_2, (int)dolphin_x + 32, dolphin_y + 10 + (int)-(cos(dolphin_x / 25.0f) * 5.0f));
		clgo_update_bcircle(dolphin_circle_3, (int)dolphin_x + 52, dolphin_y + 18 + (int)(cos(dolphin_x / 25.0f) * 15.0f));
	}
	
	if(!is_dead && !game_win)
	{
		death_particles.setup((int)seed_x, (int)seed_y);
		is_dead = check_for_deadly_collision();
	}
	
	if(!game_win && clgo_collide_bcircle_bitmask(seed_circle, island_bit_mask))
	{
		the_flower.setup((int)seed_x + 2, find_island_collision_y((int)seed_x + 2) - 1);
		game_win = true;
	}
	
	if(show_win_text)
	{
		win_text_trans += 0.25f * frame_time;
		if(win_text_trans >= 1.0f)
		{
			win_text_trans = 1.0f;
			fade_out_screen = true;
		}
	}
	
	if(fade_out_screen)
	{
		fade_out_trans += 0.125f * frame_time;
		if(fade_out_trans >= 1.0f)
		{
			fade_out_trans = 1.0f;
			go_to_next_level = true;
		}
	}
}

void draw(void)
{
	int angle;
	
	blit(background, back_buffer, 0, 0, 0, 0, 320, 240);
	
	if(stage_clear)
	{
		set_trans_blender(255, 255, 255, (int)(255.0 * dawn_trans));
		draw_trans_sprite(back_buffer, dawn, 0, 0);
	}
	
	for(int i = (int)waves_b_offset; i < 320; i += 80)
	{
		draw_sprite(back_buffer, waves, i, 240 - 10);
	}
	
	angle = (int)(cos(dolphin_x / 25.0f) * 30.0f);
	rotate_sprite(back_buffer, dolphin, (int)dolphin_x, dolphin_y, itofix(angle));
	
	for(int i = (int)waves_a_offset; i < 320; i += 80)
	{
		draw_sprite(back_buffer, waves, i, 240 - 10);
	}
	
	draw_birds();
	
	draw_sprite(back_buffer, island, 320 - island->w - 45, 240 - island->h);
	
	if(!is_dead && !game_win)
	{
		angle = (int)(sin(seed_x / 8.0f) * 50.0f);
		pivot_sprite(back_buffer, seed, (int)seed_x + 3, (int)seed_y + 3, 3, 3, itofix(angle));
	}
	
	if(game_win)
	{
		the_flower.draw();
	}
	
	if(is_dead)
	{
		death_particles.draw();
	}
	
	if(show_win_text)
	{
		set_trans_blender(255, 255, 255, (int)(255.0 * win_text_trans));
		draw_trans_sprite(back_buffer, stage_clear_text, 160 - (stage_clear_text->w / 2), 50);
	}
	
	if(fade_out_screen)
	{
		set_trans_blender(255, 255, 255, (int)(255.0 * fade_out_trans));
		draw_trans_sprite(back_buffer, black_screen, 0, 0);
	}
	//clgo_draw_bcircle(dolphin_circle, back_buffer, makecol(255, 0, 0));
	//clgo_draw_bcircle(dolphin_circle_2, back_buffer, makecol(255, 0, 0));
	//clgo_draw_bcircle(dolphin_circle_3, back_buffer, makecol(255, 0, 0));
}

void grab_input(void)
{
	int key_press;
	
	if(keypressed())
	{
		key_press = readkey();
		if(key_press >> 8 ==  KEY_P)
		{
			
		}
		
		if((game_win || stage_clear || show_win_text))
		{
			if(key_press >> 8 == KEY_ESC)
			{
				go_to_next_level = true;
			}
		}
		else
		{
			if(key_press >> 8 == KEY_ESC)
			{
				quit_game = true;
			}
		}
		clear_keybuf();
	}
	
	if(game_win || stage_clear || show_win_text)
	{
		if(key[KEY_SPACE] || key[KEY_ENTER] || mouse_b & 1)
		{
			frame_time *= 2.0f;
		}
	}
}

void update_birds(void)
{
	float old_frame;
	for(unsigned int i = 0; i < birds.size(); i++)
	{
		birds[i].x -= (30.0f * frame_time);
		if(birds[i].x < 0 - bird_a->w)
		{
			new_bird((unsigned int)i);
		}
		old_frame = birds[i].animation_frame;
		birds[i].animation_frame += birds[i].animation_speed * frame_time;
		
		if(old_frame < 1.0f && birds[i].animation_frame >= 1.0f)
		{
			FSOUND_PlaySound(i + 7, flap);
		}
		
		if(birds[i].animation_frame >= 2.0f)
		{
			FSOUND_PlaySound(i + 7, flap);
			birds[i].animation_frame -= 2.0f;
		}
	}
}

void draw_birds(void)
{
	for(unsigned int i = 0; i < birds.size(); i++)
	{
		if(birds[i].animation_frame <= 1.0f)
		{
			draw_sprite(back_buffer, bird_a, (int)birds[i].x, (int)birds[i].y);
		}
		else
		{
			draw_sprite(back_buffer, bird_b, (int)birds[i].x, (int)birds[i].y);
		}
	}
}

void new_bird(unsigned int index)
{
	CLGO_BOUNDING_BOX *bird_a_box_1;
	CLGO_BOUNDING_BOX *bird_a_box_2;
	CLGO_BOUNDING_BOX *bird_b_box_1;
	CLGO_BOUNDING_BOX *bird_b_box_2;
	int collide;
	
	bird_a_box_1 = clgo_create_bbox(0,  0,  bird_a_bit_mask->bb.width,  bird_a_bit_mask->bb.height); 
	bird_a_box_2 = clgo_create_bbox(0,  0,  bird_a_bit_mask->bb.width,  bird_a_bit_mask->bb.height);  
	bird_b_box_1 = clgo_create_bbox(0,  0,  bird_b_bit_mask->bb.width,  bird_b_bit_mask->bb.height);  
	bird_b_box_2 = clgo_create_bbox(0,  0,  bird_b_bit_mask->bb.width,  bird_b_bit_mask->bb.height);   

	clgo_update_bcircle(seed_circle, (int)seed_x + 3, (int)seed_y + 4);
	do
	{
		collide = 0;
		birds[index].x = 320.0f;
		birds[index].y = (float)(rand() % 180 + seed_y - 70);
		birds[index].animation_frame = 0.0f;
		birds[index].animation_speed = (float)(rand() % 200) / 40.0f + 1.0f;
		
		clgo_update_bbox(bird_a_box_1, (int)birds[index].x, (int)birds[index].y);
		clgo_update_bbox(bird_b_box_1, (int)birds[index].x, (int)birds[index].y);
		
		for(unsigned int j = 0; j < birds.size(); j++)
		{
			if(j != index)
			{
				clgo_update_bbox(bird_a_box_2, (int)birds[j].x, (int)birds[j].y);
				clgo_update_bbox(bird_b_box_2, (int)birds[j].x, (int)birds[j].y);
				collide += clgo_collide_bbox_bbox(bird_a_box_1, bird_a_box_2); 
				collide += clgo_collide_bbox_bbox(bird_a_box_1, bird_b_box_2); 
				collide += clgo_collide_bbox_bbox(bird_b_box_1, bird_a_box_2); 
				collide += clgo_collide_bbox_bbox(bird_b_box_1, bird_b_box_2);
			} 
		}
	} while (collide != 0);
	
	clgo_destroy_bbox(bird_a_box_1);
	clgo_destroy_bbox(bird_a_box_2);
	clgo_destroy_bbox(bird_b_box_1);
	clgo_destroy_bbox(bird_b_box_2);
}

bool check_for_deadly_collision(void)
{
	if(clgo_collide_bcircle_bcircle(seed_circle, dolphin_circle))
	{
		FSOUND_PlaySound(15, hit);
		return true;
	}
	if(clgo_collide_bcircle_bcircle(seed_circle, dolphin_circle_2))
	{
		FSOUND_PlaySound(15, hit);
		return true;
	}
	if(clgo_collide_bcircle_bcircle(seed_circle, dolphin_circle_3))
	{
		FSOUND_PlaySound(15, hit);
		return true;
	}
		
	for(unsigned int i = 0; i < birds.size(); i++)	
	{
		if(birds[i].animation_frame <= 1.0f)
		{
			clgo_update_bitmask(bird_a_bit_mask, (int)birds[i].x, (int)birds[i].y);
			if(clgo_collide_bcircle_bitmask(seed_circle, bird_a_bit_mask))
			{
				FSOUND_PlaySound(15, hit);
				return true;
			}
		}
		else
		{
			clgo_update_bitmask(bird_b_bit_mask, (int)birds[i].x, (int)birds[i].y);
			if(clgo_collide_bcircle_bitmask(seed_circle, bird_b_bit_mask))
			{
				FSOUND_PlaySound(15, hit);
				return true;
			}
		}
	}
	
	if((seed_y) > 230.0f)
	{
		FSOUND_PlaySound(15, hit);
		return true;
	}
	
	if((seed_x) > 320.0f)
	{
		FSOUND_PlaySound(15, hit);
		return true;
	}
	
	return false;
}
