#include "resources.h"
#include "death_particles.h"

void DEATH_PARTICLES::setup(int x_loc, int y_loc)
{
	D_PARTICLE add_me;
	int x = x_loc;
	int y = y_loc;
	
	particles.clear();
	while(y < y_loc + 6)
	{
		add_me.x = (float) x;
		add_me.y = (float)y;
		add_me.y_vec = -(y - y_loc) * 2.0f - rand() % 5;
		add_me.trans = 1.0f;
		if(x < x_loc + 4)
		{
			add_me.x_vec = -10.0f - (rand() % 20) -(y - y_loc) / 2.0f;
		}
		else
		{
			add_me.x_vec = 10.0f + (rand() % 20) + (y - y_loc) / 2.0f;;
		}
		
		x += 2;
		particles.push_back(add_me);
		if(x > x_loc + 7)
		{
			x = x_loc + (y % 2);
			y++;
		}
	} 
}

void DEATH_PARTICLES::update(void)
{
	for(unsigned int i = 0; i < particles.size(); i++)
	{
		particles[i].x += particles[i].x_vec * frame_time;
		particles[i].y += particles[i].y_vec * frame_time;
		particles[i].y_vec += 20.0f * frame_time;
		
		if(particles[i].trans > 0.0f)
		{
			particles[i].trans -= 0.5f * frame_time;
			if(particles[i].trans < 0.0f)
			{
				particles[i].trans = 0.0f;
			}
		}
	}
}

void DEATH_PARTICLES::draw(void)
{
	int trans_color;
	
	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	for(unsigned int i = 0; i < particles.size(); i++)
	{
		trans_color = (int)(particles[i].trans * 255.0f);
		set_trans_blender(255, 255, 255, trans_color);
		draw_trans_sprite(back_buffer, white_pixel, (int)particles[i].x, (int)particles[i].y);
	}
	solid_mode();
}

bool DEATH_PARTICLES::is_done(void)
{
	if(particles.size() > 1)
	{
		return (particles[0].trans <= 0.0f);
	}
	return false;
}
