#include "main.h"

static DATAFILE *anim;
static int animx[64], animy[64];

Tile map[MAPH][MAPW];

static BITMAP *tiles[256][4];
static int tilex[256], tiley[256];

BITMAP *mouse = NULL;

BITMAP *
crop (BITMAP *bmp, int *offx, int *offy)
{
  int x, y;
  int x1 = bmp->w - 1, y1 = bmp->h - 1, x2 = 0, y2 = 0;
  BITMAP *crop;
  for (y = 0; y < bmp->h; y++)
  {
    for (x = 0; x < bmp->w; x++)
    {
      if (getpixel (bmp, x, y) != bitmap_mask_color (bmp))
      {
	if (x < x1) x1 = x;
	if (y < y1) y1 = y;
	if (x > x2) x2 = x;
	if (y > y2) y2 = y;
      }
    }
  }
  crop = create_bitmap (1 + x2 - x1, 1 + y2 - y1);
  blit (bmp, crop, x1, y1, 0, 0, crop->w, crop->h);
  printf ("Trimmed %d, %d to %d, %d.\n", bmp->w, bmp->h, crop->w, crop->h);
  destroy_bitmap (bmp);
  *offx = x1;
  *offy = y1;
  return crop;
}

BITMAP *
upload (BITMAP *bmp)
{
  BITMAP *up = create_video_bitmap (bmp->w, bmp->h);
  if (up)
  {
    blit (bmp, up, 0, 0, 0, 0, bmp->w, bmp->h);
    printf ("Uploaded %d, %d.\n", bmp->w, bmp->h);
    return up;
  }
  return bmp;
}

void
map_loadtiles (void)
{
  static int once = 0;
  if (once) return;
  once++;
  printf ("Loading tiles.\n");
  tiles[1][0] = upload (crop (load_bitmap ("dat/gnomeguard.dat#grass.tga", NULL), &tilex[1], &tiley[1]));
  tiles[2][0] = upload (crop (load_bitmap ("dat/gnomeguard.dat#water1.tga", NULL), &tilex[2], &tiley[2]));
  tiles[2][1] = upload (crop (load_bitmap ("dat/gnomeguard.dat#water2.tga", NULL), &tilex[2], &tiley[2]));
  tiles[2][2] = upload (crop (load_bitmap ("dat/gnomeguard.dat#water3.tga", NULL), &tilex[2], &tiley[2]));
  tiles[2][3] = upload (crop (load_bitmap ("dat/gnomeguard.dat#water4.tga", NULL), &tilex[2], &tiley[2]));
  tiles[3][0] = upload (crop (load_bitmap ("dat/gnomeguard.dat#block.tga", NULL), &tilex[3], &tiley[3]));
  tiles[4][0] = upload (crop (load_bitmap ("dat/gnomeguard.dat#exit.tga", NULL), &tilex[4], &tiley[4]));
  tiles[5][0] = upload (crop (load_bitmap ("dat/gnomeguard.dat#beacon.tga", NULL), &tilex[5], &tiley[5]));
  tiles[6][0] = upload (crop (load_bitmap ("dat/gnomeguard.dat#barrier.tga", NULL), &tilex[6], &tiley[6]));
  tiles[7][0] = upload (crop (load_bitmap ("dat/gnomeguard.dat#trap.tga", NULL), &tilex[7], &tiley[7]));
  
  mouse = upload (load_bitmap ("dat/gnomeguard.dat#mouse.tga", NULL));
  
  anim = load_datafile ("dat/gnomeguard.dat#gnome.dat");
  {
    int i;
    for (i = 0; i < 64; i++)
    {
      anim[i].dat = upload (crop (anim[i].dat, &animx[i], &animy[i]));
    }
  }
}

int
map_tilex (int x, int y)
{
  return ((x >> 1) - y) >> 4;
}

int
map_tiley (int x, int y)
{
  return (y + (x >> 1)) >> 4;
}

int
map_pixelx (int x, int y)
{
  return (x + y) << 4;
}

int
map_pixely (int x, int y)
{
  return (y - x) << 3;
}

Tile *
map_tile (int x, int y)
{
  return &map[y & (MAPH - 1)][x & (MAPW - 1)];
}

#define L TILEW * 6
#define T TILEH * 3
#define B TILEH * 3

void
map_draw_base (int mapx, int mapy, int left, int top, int right, int bottom)
{
  int xpix, ypix;
  int xline;
  int xmap, ymap;
  int xmapline, ymapline;

  mapx -= L;
  mapy -= T;
  
  xmap = map_tilex (mapx, mapy);
  ymap = map_tiley (mapx, mapy);
  xpix = map_pixelx (xmap, ymap);
  ypix = map_pixely (xmap, ymap);
  xpix -= mapx;
  ypix -= mapy;

  if (ypix > 0)
  {
    xmap++;
    xpix += TILEW;
    ypix -= TILEH;
  }

  xline = left + xpix - L;
  ypix = top + ypix - T;
  xmapline = xmap;
  ymapline = ymap;

  while (ypix <= bottom + TILEH + B)
  {
    xmap = xmapline;
    ymap = ymapline;
    xpix = xline;
    while (xpix <= right)
    {
      Tile *t;

      t = map_tile (xmap, ymap);
      if (!(xmap & 3) && !(ymap & 3))
      {
	if (t->base)
	{
	  int a = 0;
	  if (t->base == 2) a = (game_time >> 2) & 3;
	  draw_sprite (gfx_buffer, tiles[t->base][a],
	    xpix - 64 + tilex[t->base],
	    ypix - 128 + tiley[t->base]);
	}
      }

      xpix += TILEW * 2;
      xmap += 1;
      ymap += 1;
    }
    xline -= TILEW;
    ypix += TILEH;
    xmapline -= 1;
    if (xline <= left - TILEW * 2 - L)
    {
      xline += TILEW * 2;
      xmapline += 1;
      ymapline += 1;
    }
  }
}

#define L2 TILEW * 6
#define T2 TILEH * 3
#define B2 TILEH * 8

void
map_draw_gnomes (int mapx, int mapy, int left, int top, int right, int bottom)
{
  int xpix, ypix;
  int xline;
  int xmap, ymap;
  int xmapline, ymapline;

  mapx -= L2;
  mapy -= T2;
  
  xmap = map_tilex (mapx, mapy);
  ymap = map_tiley (mapx, mapy);
  xpix = map_pixelx (xmap, ymap);
  ypix = map_pixely (xmap, ymap);
  xpix -= mapx;
  ypix -= mapy;

  if (ypix > 0)
  {
    xmap++;
    xpix += TILEW;
    ypix -= TILEH;
  }

  xline = left + xpix - L2;
  ypix = top + ypix - T2;
  xmapline = xmap;
  ymapline = ymap;

  while (ypix <= bottom + TILEH + B2)
  {
    xmap = xmapline;
    ymap = ymapline;
    xpix = xline;
    while (xpix <= right)
    {
      Tile *t;

      t = map_tile (xmap, ymap);
      
      if (t->gnome)
      {
	int a = t->gnome->step * 8 + t->gnome->dir;
        draw_sprite (gfx_buffer,
	  anim[a].dat,
	  xpix - 64 - dirx[t->gnome->dir] * t->gnome->step + animx[a],
	  ypix - 84 - diry[t->gnome->dir] * t->gnome->step + animy[a]);
      }
      
      
      if (t->top == 3 || t->top == 4)
      {
	if (!(xmap & 3) && !(ymap & 3))
	{
	  draw_sprite (gfx_buffer, tiles [t->top][0],
	    xpix - 64 + tilex[t->top],
	    ypix - 128 + tiley[t->top]);
	}
      }
      if (t->top == 5 || t->top == 6)
      {
	draw_sprite (gfx_buffer,
	  tiles [t->top][0],
	  xpix - 112 + tilex[t->top],
	  ypix - 128 + tiley[t->top]);
      }

      xpix += TILEW * 2;
      xmap += 1;
      ymap += 1;
    }
    xline -= TILEW;
    ypix += TILEH;
    xmapline -= 1;
    if (xline <= left - TILEW * 2 - L2)
    {
      xline += TILEW * 2;
      xmapline += 1;
      ymapline += 1;
    }
  }
}

