#include <allegro.h>
#include <stdio.h>
#include <assert.h>

typedef struct State State;
struct State
{
  void (*init) (void);
  void (*update_logic) (void);
  void (*update_graphics) (void);
  void (*cleanup) (void);
};

typedef struct Gnome Gnome;
struct Gnome
{
  int state;
  int x, y, step, dir;
};

typedef struct Tile Tile;
struct Tile
{
  int base;
  int top;
  Gnome *gnome;
};
  
extern State *state;
extern BITMAP *gfx_buffer;
extern volatile int game_time;

extern PALETTE pal_red;
extern PALETTE pal_black;
extern PALETTE pal_green;

extern State menu_state;
extern State game_state;
extern State exit_state;
extern State level_state;
extern State init_state;

#define LEVELNUM 8

#define GNOMES 256
extern Gnome gnomes[GNOMES];

extern int leveltime[];
extern int level;
extern int home;
extern int dead;

#define MAPW 256
#define MAPH 256
#define TILEW 16
#define TILEH 8
extern Tile map[MAPH][MAPW];

extern int dirx[8], diry[8];

int map_tilex (int x, int y);
int map_tiley (int x, int y);
int map_pixelx (int x, int y);
int map_pixely (int x, int y);
Tile *map_tile (int x, int y);
void map_loadtiles (void);
void map_draw_base (int mapx, int mapy, int left, int top, int right, int bottom);
void map_draw_gnomes (int mapx, int mapy, int left, int top, int right, int bottom);

extern BITMAP *mouse;
