#include "main.h"

volatile int game_time;
int x_pos;
BITMAP *gfx_buffer;
State *state;
PALETTE pal_red;
PALETTE pal_black;
PALETTE pal_green;

static BITMAP *page[2];
static FONT *sysfont;

void
game_timer (void)
{
  game_time++;
}

void
run (void)
{
  int logic_time;
  int time_1sec = 0;
  int fps_counter_1sec = 0;
  State *oldstate;
  int fps = 0;

  x_pos = 0;
  game_time = 0;
  logic_time = 0;

  state = &init_state;
  state->init ();

  for (;;)
  {
    oldstate = state;
    while (game_time >= logic_time)
    {
      state->update_logic ();
      logic_time++;
    
      /* skip if too far behind */
      if (game_time - logic_time > 120)
      {
	logic_time = game_time;
      }
      
      if (state != oldstate)
      {
	if (oldstate)
	{
	  oldstate->cleanup ();
	}
	oldstate = state;
	state->init ();
      }
    }

    state->update_graphics ();
    
    //select_palette (pal_black);
    //text_mode (-1);
    //textprintf_right (gfx_buffer, sysfont, SCREEN_W, SCREEN_H - 8, -1, "%d FPS", fps);
    
    if (gfx_buffer == page[0])
    {
      show_video_bitmap (gfx_buffer);
      gfx_buffer = page[1];
    }
    else if (gfx_buffer == page[1])
    {
      show_video_bitmap (gfx_buffer);
      gfx_buffer = page[0];
    }
    else
    {
      blit (gfx_buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    }
    
    fps_counter_1sec++;
    if (game_time >= time_1sec)
    {
      fps = fps_counter_1sec;
      fps_counter_1sec = 0;
      time_1sec = game_time + 60;
    }
  }
}

int
main (void)
{
  int s;
  allegro_init ();
  set_color_depth (16);
  s = set_gfx_mode (GFX_AUTODETECT, 640, 480, 0, 0);
  if (s)
  {
  	 set_color_depth (desktop_color_depth ());
  	 s = set_gfx_mode (GFX_AUTODETECT, 640, 480, 0, 0);
  }
  
  if (s)
  {
  	 allegro_message ("Can't acquire Allegro screen.\n");
  	 exit(-1);
  }
  sysfont = font;
  printf ("Loading font.\n");
  font = load_datafile ("dat/gnomeguard.dat#font.dat")[0].dat;
  if (!font) exit(-1);
  {
    int p;
    for (p = 0; p <= 32; p++)
    {
      pal_red [p].r = p * 63 / 32;
      pal_red [p].g = p * 0;
      pal_red [p].b = p * 0;
    }
    for (p = 0; p <= 32; p++)
    {
      pal_black [p].r = p * 63 / 32;
      pal_black [p].g = p * 63 / 32;
      pal_black [p].b = p * 63 / 32;
    }
    for (p = 0; p <= 32; p++)
    {
      pal_green [p].r = 0;
      pal_green [p].g = p * 63 / 32;
      pal_green [p].b = 0;
    }
  }
  
  install_sound (DIGI_AUTODETECT, MIDI_NONE, NULL);
  
  page[0] = create_video_bitmap (SCREEN_W, SCREEN_H);
  page[1] = create_video_bitmap (SCREEN_W, SCREEN_H);
  gfx_buffer = page[0];
  if (!page[0] || !page[1])
  {
    gfx_buffer = create_bitmap (SCREEN_W, SCREEN_H);
  }

  install_keyboard ();
  install_mouse ();

  install_timer ();
  install_int_ex (game_timer, BPS_TO_TIMER (60));

  run ();

  return (0);
}

END_OF_MAIN ();
