#include "main.h"

static int preparation;
static BITMAP *back = NULL;

static void
init (void)
{
  preparation = 60 * 10;
  if (!back) back = load_bitmap ("dat/gnomeguard.dat#level.tga", NULL);
}

static void
cleanup (void)
{
}

static void
update_logic (void)
{
  
  while (keypressed())
  {
    int k = readkey() >> 8;
    if (k == KEY_ENTER)
    {
      if (level < LEVELNUM) state = &game_state;
    }
    if (k == KEY_ESC)
    {
      state = &menu_state;
    }
  }
  
  if (level < LEVELNUM) preparation--;
  if (preparation == 0) state = &game_state;
}

static void
update_graphics (void)
{
  int th = text_height (font);
  blit (back, gfx_buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  
  text_mode (-1);

  if (home != -1)
  {
    int y = 0;
    select_palette (pal_green);
    textprintf_centre (gfx_buffer, font, SCREEN_W / 2, y += th, -1,
      "You guarded %d gnomes!", home);
    if (home == 256)
    {
      select_palette (pal_green);
      textprintf_centre (gfx_buffer, font, SCREEN_W / 2, y += th, -1,
      "You did very well,");
      select_palette (pal_green);
      textprintf_centre (gfx_buffer, font, SCREEN_W / 2, y += th, -1,
      "not a single gnome died!");
    }
    if (dead > 1)
    {
      select_palette (pal_red);
      textprintf_centre (gfx_buffer, font, SCREEN_W / 2, y += th, -1,
      "But you led %d gnomes", dead);
      textprintf_centre (gfx_buffer, font, SCREEN_W / 2, y += th, -1,
      "straigth into their death!");
    }
    if (dead == 1)
    {
      select_palette (pal_red);
      textprintf_centre (gfx_buffer, font, SCREEN_W / 2, y += th, -1,
      "Only one poor guy didn't make it.");
    }
    if (GNOMES - home - dead > 1)
    {
      select_palette (pal_red);
      textprintf_centre (gfx_buffer, font, SCREEN_W / 2, y += th, -1,
      "%d gnomes were helpless left back!", GNOMES - home - dead);
    }
    if (GNOMES - home - dead == 1)
    {
      select_palette (pal_red);
      textprintf_centre (gfx_buffer, font, SCREEN_W / 2, y += th, -1,
      "Why did you leave back that one?");
    }
  }
    
  if (level == LEVELNUM)
  {
    select_palette (pal_green);
    textprintf_centre (gfx_buffer, font, SCREEN_W / 2, SCREEN_H / 2, -1,
      "Congratulations! You Win!");
    select_palette (pal_black);
    textprintf_centre (gfx_buffer, font, SCREEN_W / 2, SCREEN_H / 2 + th * 2, -1,
      "Now the gnomes can sleep well.");
  }
  else
  {
    select_palette (pal_green);
    textprintf_centre (gfx_buffer, font, SCREEN_W / 2, SCREEN_H / 2, -1,
      "Get Ready for Level %d!", level);
    select_palette (pal_black);
    textprintf (gfx_buffer, font, 0, SCREEN_H / 2 + th * 2, -1,
      "Gnomes: 256");
    textprintf_right (gfx_buffer, font, SCREEN_W, SCREEN_H / 2 + th * 2, -1,
      "Time: %d:%02d", leveltime[level] / 60, leveltime[level] % 60);
    textprintf (gfx_buffer, font, 0, SCREEN_H / 2 + th * 3, -1,
      "Min to Guard: 200");
    textprintf_right (gfx_buffer, font, SCREEN_W, SCREEN_H / 2 + th * 3, -1,
      "Max to Die: 56");
  }
}

State level_state =
{
  init, update_logic, update_graphics, cleanup
};
