#include "main.h"

static BITMAP *back = NULL;

static void
init (void)
{
  printf ("Menu.\n");
  if (!back) back = load_bitmap ("dat/gnomeguard.dat#menu.tga", NULL);
}

static void
cleanup (void)
{
}

static void
update_logic (void)
{
  while (keypressed())
  {
    int k = readkey() >> 8;
    if (k == KEY_ENTER)
    {
      level = 1;
      home = -1;
      state = &level_state;
    }
    if (k == KEY_SPACE)
    {
      state = &level_state;
    }
    if (k == KEY_ESC)
    {
      state = &exit_state;
    }
  }
}

static void
update_graphics (void)
{
  int th = text_height (font);
  blit (back, gfx_buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  text_mode (-1);
  select_palette (pal_green);
  if (home != -1)
  {
    textprintf_centre (gfx_buffer, font, SCREEN_W / 2, 0, -1,
    "Press Space to Continue Game");
  }
  textprintf_centre (gfx_buffer, font, SCREEN_W / 2, SCREEN_H / 2, -1,
    "Press Enter to start New Game");
  select_palette (pal_black);
  textprintf_centre (gfx_buffer, font, SCREEN_W / 2, SCREEN_H - th, -1,
    "Press Esc to Leave");
}

State menu_state =
{
  init, update_logic, update_graphics, cleanup
};
