#include "main.h"

static BITMAP *title = NULL;
static int titletime;

static void
init (void)
{
  printf ("Intro.\n");
  if (!title)
  {
    title = load_bitmap ("dat/gnomeguard.dat#title.tga", NULL);
  }
  titletime = 60 * 5;
}

static void
cleanup (void)
{
  destroy_bitmap (title);
}

static void
update_logic (void)
{
  while (keypressed())
  {
    int k = readkey() >> 8;
    if (k == KEY_ENTER || k == KEY_ESC)
    {
      state = &menu_state;
    }
  }
  titletime--;
  if (titletime == 0)
    state = &menu_state;
}

static void
update_graphics (void)
{
  blit (title, gfx_buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}

State init_state =
{
  init, update_logic, update_graphics, cleanup
};
