#include "main.h"

static int gotox, gotoy;
static int scrollx, scrolly;
static int scrolldx, scrolldy;
Gnome gnomes[GNOMES];
static int clocktick;

int leveltime[] = {0, 5 * 60, 5 * 60, 5 * 60, 5 * 60, 6 * 60, 6 * 60, 7 * 60};
int level = 1;
int home = -1;
int dead = 0;

SAMPLE *gg[4] = {NULL, NULL, NULL, NULL};

int dirx[8] = { +4, +2, +0, -2, -4, -2, -0, +2 }; 
int diry[8] = { +0, -1, -2, -1, -0, +1, +2, +1 };
int tilex[8] = { +1, +1, +1,  0, -1, -1, -1,  0 };
int tiley[8] = { +1,  0, -1, -1, -1,  0, +1, +1 };

static void
init (void)
{  
  int startx = -1, starty = -1;
  char mapname [1024];
  BITMAP *mappic;
  // use snprintf in linux
  sprintf (mapname, "dat/gnomeguard.dat#map%d.tga", level);
  printf ("Game: Map \"%s\".\n", mapname);
  set_color_conversion (COLORCONV_NONE);
  mappic = load_bitmap (mapname, NULL);
  set_color_conversion (COLORCONV_TOTAL | COLORCONV_KEEP_TRANS | COLORCONV_DITHER);
  map_loadtiles ();
    
  if (!gg[0]) gg[0] = load_sample ("dat/gnomeguard.dat#g1.wav");
  if (!gg[1]) gg[1] = load_sample ("dat/gnomeguard.dat#g2.wav");
  if (!gg[2]) gg[2] = load_sample ("dat/gnomeguard.dat#g3.wav");
  if (!gg[3]) gg[3] = load_sample ("dat/gnomeguard.dat#gd.wav");
    
  {
    int y;
    for (y = 0; y < MAPH; y++)
    {
      int x;
      for (x = 0; x < MAPW; x++)
      {
	int x2 = x >> 2;
	int y2 = y >> 2;
	int c = getpixel (mappic, x2, y2);
	Tile *t = map_tile (x, y);
	if (c == 0)
	{
	  c = 1;
	  if (startx == -1)
	  {
	    startx = x;
	    starty = y;
	  }
	   
	  if (x2 != (startx >> 2) || y2 != (starty >> 2))
	  {
	    c = 4;
	  }
	}
	t->base = 0;
	t->top = 0;
	if (c == 1 || c == 2 || c == 4 || c == 7) t->base = c;
	if (c == 3) t->top = c;
	t->gnome = NULL;
      }
    }
  }
  {
    int g;
    for (g = 0; g < GNOMES; g++)
    {
      gnomes[g].state = 0;
      gnomes[g].x = startx - 8 + (g & 15);
      gnomes[g].y = starty - 8 + (g >> 4);
      gnomes[g].step = 0;
      gnomes[g].dir = (rand() >> 8) & 7;
      map_tile (gnomes[g].x, gnomes[g].y)->gnome = &gnomes[g];
    }
  }
  scrolldx = 0;
  scrolldy = 0;
  scrollx = map_pixelx (startx, starty);
  scrolly = map_pixely (startx, starty);
  gotox = startx;
  gotoy = starty;
  home = 0;
  dead = 0;
  clocktick = 60 * leveltime[level];
  
  destroy_bitmap (mappic);
}


static void
cleanup (void)
{
}

static void
gnomes_move (void)
{
  int g;
  for (g = 0; g < GNOMES; g++)
  {
    Gnome *gnome = &gnomes[g];
    Tile *t;
    
    if (gnome->state == 1) continue;
    
    t = map_tile (gnome->x, gnome->y);
    
    assert (t->gnome == gnome);
    
    if (gnome->step)
    {       
      gnome->step--;
    }
    else
    {
      Tile *nt;
      int nx, ny;
            
      if (! ((rand() >> 8) & 7)) {
	int r = (rand() >> 8) & 3;
	if (r == 0 || r == 1)
	{
	  int dx = gnome->x - gotox;
	  int dy = gnome->y - gotoy;
	  
	  if (dx > MAPW / 2) dx -= MAPW;
	  if (dx < -MAPW / 2) dx += MAPW;
	  if (dy > MAPH / 2) dy -= MAPH;
	  if (dy < -MAPH / 2) dy += MAPH;
	  
	  if (dx > 0)
	  {
	    if (dy > 0)
	    {
	      gnome->dir = 4;
	    }
	    if (dy < 0)
	    {
	      gnome->dir = 6;
	    }
	    if (dy == 0)
	    {
	      gnome->dir = 5;
	    }
	  }
	  if (dx < 0)
	  {
	    if (dy < 0)
	    {
	      gnome->dir = 0;
	    }
	    if (dy > 0)
	    {
	      gnome->dir = 2;
	    }
	    if (dy == 0)
	    {
	      gnome->dir = 1;
	    }
	  }
	  if (dx == 0)
	  {
	    if (dy < 0)
	    {
	      gnome->dir = 7;
	    }
	    if (dy > 0)
	    {
	      gnome->dir = 3;
	    }
	  }
	}
	if (r == 2)
	{
	  if (!((rand()>>8) & 255)) play_sample (gg[1], 255, 127, 1000 + (rand() & 255), 0);
	  gnome->dir ++;
	}
	if (r == 3)
	{
	  if (!((rand()>>8) & 255)) play_sample (gg[2], 255, 127, 1000 + (rand() & 255), 0);
	  gnome->dir --;
	}
	gnome->dir &= 7;
      }
      
      nx = (gnome->x + tilex [gnome->dir]) & (MAPW - 1);
      ny = (gnome->y + tiley [gnome->dir]) & (MAPH - 1);
      nt = map_tile (nx, ny);
            
      if (!nt->gnome && nt->top == 0 && nt->base != 2)
      {
	nt->gnome = gnome;
	t->gnome = NULL;
	t = nt;
	gnome->x = nx;
	gnome->y = ny;
	gnome->step = 7;
	
	if (nt->base == 4)
	{
	  t->gnome = NULL;
	  gnome->state = 1;
	  play_sample (gg[0], 255, 127, 1000, 0);
	  home++;
	}
	if (nt->base == 7)
	{
	  t->gnome = NULL;
	  gnome->state = 1;
	  play_sample (gg[3], 255, 127, 1000, 0);
	  dead++;
	}
      }
    }
  }
}

static void
update_logic (void)
{
  while (keypressed())
  {
    int k = readkey() >> 8;
    if (k == KEY_ESC)
    {
      state = &level_state;
    }
    
    /* I don't like cheat codes.. so this doesn't go into the release version
    if (k == KEY_C)
    {
      home = 256;
    }
    */
  }

  if (!key[KEY_LEFT] || !key[KEY_RIGHT])
  {
    if (key[KEY_LEFT])
    {
      if (scrolldx > 0) scrolldx = 0;
      if (scrolldx > -16) scrolldx -= 4;
    }
    else if (key[KEY_RIGHT])
    {
      if (scrolldx < 0) scrolldx = 0;
      if (scrolldx < 16)scrolldx += 4;
    }
    else
    {
      scrolldx = 0;
    }
  }
  
  if (!key[KEY_UP] || !key[KEY_DOWN])
  {
    if (key[KEY_UP])
    {	
      if (scrolldy > 0) scrolldy = 0;
      if (scrolldy > -8) scrolldy -= 2;
    }
    else if (key[KEY_DOWN])
    {
      if (scrolldy < 0) scrolldy = 0;
      if (scrolldy < 8) scrolldy += 2;
    }
    else
    {
      scrolldy = 0;
    }
  }
  
  {
    int xm, ym;
    get_mouse_mickeys (&xm, &ym);
    if (xm > 16) xm = 16;
    if (xm < -16) xm = -16;
    if (ym > 8) ym = 8;
    if (ym < -8) ym = -8;
    if (mouse_x == SCREEN_W - 1 && xm > 0) scrollx += xm;
    if (mouse_y == SCREEN_H - 1 && ym > 0) scrolly += ym;
    if (mouse_x == 0 && xm < 0) scrollx += xm;
    if (mouse_y == 0 && ym < 0) scrolly += ym;
  }
  
  scrollx += scrolldx;
  scrolly += scrolldy;
  
  if (mouse_b == 2)
  {
    int i, j;
    int x, y;
    Tile *t;
    x = map_tilex (scrollx + mouse_x, scrolly + mouse_y) & (MAPH - 1);
    y = map_tiley (scrollx + mouse_x, scrolly + mouse_y) & (MAPW - 1);
    for (i = -1; i < 2; i++)
    {
      for (j = -1; j < 2; j++)
      {
	t = map_tile (x + j, y + i);
	if (!t->top && !i && !j)
	{
	  map_tile (gotox, gotoy)->top = 0;
	  t->top = 5;
	  gotox = x;
	  gotoy = y;
	}
	if (t->top == 6)
	{
	  t->top = 0;
	}
      }
    }
  }
  
  if (mouse_b == 1)
  {
    int i, j;
    int x, y;
    x= map_tilex (scrollx + mouse_x, scrolly + mouse_y) & (MAPH - 1);
    y = map_tiley (scrollx + mouse_x, scrolly + mouse_y) & (MAPW - 1);
    for (i = -1; i < 2; i++)
    {
      for (j = -1; j < 2; j++)
      {
	Tile *t;
	if (!i || !j)
	{
	  t = map_tile (x + j, y + i);
	  if (!t->top && t->base == 1)
	  {
	    t->top = 6;
	  }
	}
      }
    }
  }
  
  clocktick--;
  
  if (clocktick <= 0 || dead > 56 || home + dead >= 256)
  {
    if (home >= 200) level++;
    state = &level_state;
  }
  
  gnomes_move ();
}

static void
update_graphics (void)
{
  map_draw_base (scrollx, scrolly, 0, 0, 640 - 1, 480 - 1);
  map_draw_gnomes (scrollx, scrolly, 0, 0, 640 - 1, 480 - 1);
  
  text_mode (-1);
  select_palette (pal_red);
  textprintf (gfx_buffer, font, 0, 0, -1, "%d", dead);
  select_palette (pal_green);
  textprintf (gfx_buffer, font, 200, 0, -1, "%d", home);
  select_palette (pal_black);
  textprintf (gfx_buffer, font, 100, 0, -1, "%d", GNOMES - home - dead);
  select_palette (pal_black);
  textprintf_right (gfx_buffer, font, SCREEN_W, 0, -1, "%02d:%02d", clocktick / 3600, (clocktick / 60) % 60);
  
  draw_sprite (gfx_buffer, mouse, mouse_x - 8, mouse_y - 8);
}

State game_state =
{
  init, update_logic, update_graphics, cleanup
};
