/****************************************************
 * Project:   Glizda Game
 * FILE:      main.cc
 * Author:    Andrew Deren
 * Date:      1/2/98
 * Length:    518
 ****************************************************/

#include <conio.h>
#include <time.h>
#include "glizda.h"
#include "agui.h"

DATAFILE *main_data;
DATAFILE *sprites_data; //in map 1 to 20
DATAFILE *walls_data;   //in map 101 to 120
DATAFILE *special_data; // special sprite on map 201 to 220
DATAFILE *sounds_data;  // sound effects
DATAFILE *glizda_data;  // glizda graphics
DATAFILE *effects_data; // special effects (explosion, etc.)
DATAFILE *music_data;   // musics
COLOR_MAP trans_table;
BITMAP *global_bitmap;

EPISOD_INFO episod1;
EPISOD_INFO episod2;
EPISOD_INFO episod3;
EPISOD_INFO episod4;
EPISOD_INFO episod5;
EPISOD_INFO episod_custom;

DATAFILE *episod1_text;
DATAFILE *episod2_text;
DATAFILE *episod3_text;
DATAFILE *episod4_text;
DATAFILE *episod5_text;

int sound_on;
int music_on;

int shareware;
char *end_string = NULL;
dialog *main_dialog;

void Error(va_list arg_list, ...)
{
   va_list arg_ptr;
   char *format;
   char Buffer[500];
 	allegro_exit();
   va_start(arg_ptr, arg_list);
   format = (char*)arg_list;
   vsprintf(Buffer,format,arg_ptr);
   printf("Fatal Error:\n");
   printf("%s", Buffer);
	exit(1);
}

int load_episod(EPISOD_INFO *episod, char *filename)
{
   FILE *file;
   INT version;
   char temp[20];

   // try opening the file
   file = fopen(filename, "rb");
   if (!file) {
      episod->loaded = FALSE;
      return FALSE;     // could not open
   }

   // get the file ID
   fread(temp, sizeof(char), strlen("GLIZDA EPISOD")+1, file);
   // check if file is glizda episod
   if (strcmp(temp, "GLIZDA EPISOD") != 0) {
      fclose(file);
      episod->loaded = FALSE;
      return FALSE;
   }
   // check for the right version
   fread(&version, sizeof(INT), 1, file);
   if (version != 10) {
      fclose(file);
      episod->loaded = FALSE;
      return FALSE;
   }
   // get the name of the episod
   fread(episod->name, sizeof(char), 26, file);
   // get number of maps
   fread(&(episod->num_maps), sizeof(INT), 1, file);
   // read the maps
   episod->maps = (MAP_INFO*)malloc(sizeof(MAP_INFO)*episod->num_maps);
   fread(episod->maps, sizeof(MAP_INFO), episod->num_maps, file);
   fclose(file);
   episod->loaded = TRUE;
   return TRUE;
}

#define unload_episod(episod) free(episod.maps)

#define ENCODE_CHAR 't'
/* This function encodes a letter using encode_string
   Uses the formula letter + encode_char - 32 if it is less than 127
   and letter + encode_char - 127 if it is not. */
int encode_char(int letter, int encode_char = ENCODE_CHAR)
{
	// if letter < 32 it is control character, so return it unchanged
   if (letter < 32) return letter;
   else if (letter + encode_char - 32 <= 126) return (letter + encode_char -32);
   else return letter + encode_char - 127;
}

int registration_dialog(void)
{
   char name[25];
   char password[25];
   char temp[25];
   allegro_exit();
   set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
   textbackground(BLACK);
   textcolor(WHITE);
   clrscr();
   textbackground(BLUE);
   gotoxy(1, 1);
   clreol();
   cprintf("Enter your registration information.");
   gotoxy(1, 25);
   clreol();
   cprintf("G L I Z D A  v1.0 - Registration");
   textbackground(BLACK);
   gotoxy(3, 2);
   printf("Enter your name: ");
   gets(name);
   gotoxy(3, 3);
   printf("Enter the registration code: ");
   gets(password);

   int i;
   for (i=0; i<strlen(name); i++)
       temp[i] = encode_char(name[i]);
   temp[i] = '\0';
   if (strlen(name) < 5)
      end_string = "Name has to be at least 5 characters.";
   else if (strcmp(temp, password)==0) {
      FILE *file = fopen("glizda.reg", "wb");
      if (file) {
         fwrite(name, sizeof(char), 25, file);
         fwrite(password, sizeof(char), 25, file);
         fclose(file);
         end_string = "Registration Successful.";
      }
      else
         end_string = "Could not register. Check if the disk is not write-protected";
   }
   else end_string = "Registration Failed. Wrong Registration Code";
   exit_game();
}


void ExecProc(int (*proc)(void), int change_mouse = TRUE)
{
  	clear (screen);				  //clear the screen
	fade_in ((RGB *) main_data[GAME_PALLETE].dat, 64);
  	// Set up the default colors
 	set_default_object_colors (0, 235, 236, 237, 238, 239, 240, 241);
	gui_fg_color = makecol8 (0, 0, 0);
	gui_mg_color = makecol8 (192, 192, 192);
	gui_bg_color = makecol8 (255, 255, 255);
   if (change_mouse)
      set_mouse_sprite((BITMAP*)main_data[MOUSE_PTR].dat);
   font = (FONT*)main_data[GAME_FONT].dat;
   clear(screen);
   proc();

   fade_in((RGB*)main_data[TITLE_PALLETE].dat, 64);
   set_mouse_sprite((BITMAP*)main_data[TITLE_CURSOR].dat);
   font = (FONT*)main_data[TITLE_FONT].dat;
   main_dialog->redraw();
}

int ProcStartEditor(void)
{
   ExecProc(editor_main);
   return FALSE;
}

int ProcStartGlizda(void)
{
   ExecProc(glizda_main);
   return FALSE;
}

int ProcStartEpisod(void)
{
   ExecProc(episod_main);
   return FALSE;
}

int ProcQuit(void)
{
   main_dialog->close();
   return FALSE;
}

int draw_title_bitmap(void)
{
   blit((BITMAP*)main_data[TITLE].dat, screen, 0, 0, 0, 0, 640, 480);
   if (shareware) {
      text_mode(-1);
      textout(screen, font, "Unregistered Shareware Version", 10, 460, 9);
   }
   text_mode(-1);
   textout(screen, (FONT*)main_data[GAME_FONT].dat, GLIZDA_INFO1, 500, 450, makecol8(255, 255, 255));
   textout(screen, (FONT*)main_data[GAME_FONT].dat, GLIZDA_INFO2, 500, 460, makecol8(255, 255, 255));
   return D_O_K;
}

int dump_screen(int key_pressed)
{
   if (key_pressed >> 8 == KEY_F10) {
      RGB title_pal[256];
      get_palette(title_pal);
      //create temp bitmap
      BITMAP *tbmp = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
      //save the picture with game pallete
      save_pcx("title.pcx", tbmp, title_pal);
      destroy_bitmap(tbmp);     //destroy bitmap
   }
   return D_O_K;
}

void main_menu(void)
{
   font = (FONT*)main_data[TITLE_FONT].dat;
   fade_in((RGB*)main_data[TITLE_PALLETE].dat, 64);
   set_mouse_sprite((BITMAP*)main_data[TITLE_CURSOR].dat);
   clear_screen_object bmpScreen;

   bmpScreen.set_xchar_callback(dump_screen);
   bmpScreen.set_draw_callback(draw_title_bitmap);
   font_button_object cmdEditor("Map Editor", ProcStartEditor);
   font_button_object cmdEpisod("Episod Editor", ProcStartEpisod);
   font_button_object cmdGlizda("Game", ProcStartGlizda);
   font_button_object cmdExit("Exit", ProcQuit);
   font_button_object cmdRegister("Register", registration_dialog);


   dialog the_dialog;
   main_dialog = &the_dialog;

   the_dialog.add(bmpScreen, 0,   0, 640, 480);
   the_dialog.add(cmdEditor, 20, 10, 150, 25);
   the_dialog.add(cmdEpisod, 20, 40, 150, 25);
   the_dialog.add(cmdGlizda, 20, 70, 150, 25);
   the_dialog.add(cmdExit,   20, 100, 150, 25);
   if (shareware)
      the_dialog.add(cmdRegister, 20, 130, 150, 25);

   the_dialog.execute();
}

void increment_timer(...)
{
   glizda_timer++;
   global_timer++;
}
END_OF_FUNCTION(increment_timer);


void cprintf_centre(int x, int y, char *string)
{
    gotoxy(x - strlen(string)/2, y);
    cputs(string);

}

float callback_counter = 0;
void trans_callback(int k)
{
   gotoxy(2, 10);
   cprintf("[%3.0f %%]", (callback_counter/255)*100);
   callback_counter++;
}

void check_shareware()
{
   FILE *file;
   char password[25];
   char name[25];
   char temp[25];
   int i;
   if (!exists("glizda.reg"))
      shareware = TRUE;
   else {
      file = fopen("glizda.reg", "rb");
      if (!file) {
         shareware = TRUE;
         return;
      }
      fread(name, sizeof(char), 25, file);
      fread(password, sizeof(char), 25, file);
      fclose(file);
      for (i=0; i<strlen(name); i++)
         temp[i] = encode_char(name[i]);
      temp[i] = '\0';
      if (strcmp(password, temp) == 0)
         shareware = FALSE;
      else shareware = TRUE;
   }
}

void StartGlizda(void)
{
   check_shareware();
   clrscr();
   textbackground(BLUE);
   textcolor(WHITE);
   clreol();
   gotoxy(1, 25);
   clreol();
   cprintf_centre(40, 1, "Starting Glizda v1.0");
   if (shareware)
      cprintf_centre(40, 25, "(C) Ader Software 1998 - Unregistered Shareware Version");
   else
      cprintf_centre(40, 25, "(C) Ader Software 1998 - Registered Version");
   textbackground(BLACK);

   gotoxy(2, 2);
	cprintf ("Initializing allegro...\n");
	allegro_init ();				  //initialize allegro

   gotoxy(2, 3);
	cprintf ("installing keyboard handler...\n");
	install_keyboard ();			  //install keyboard handler

   gotoxy(2, 4);
	cprintf ("installing timer...\n");
	install_timer ();				  //install timer

   gotoxy(2, 5);
	cprintf ("installing mouse...\n");
	install_mouse ();				  //install mouse

   gotoxy(2, 6);
   cprintf ("installing sound drivers...\n");
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {
      gotoxy(2, 6);
      cprintf("Error installing sound drivers.\n");
      sound_on = FALSE;
      music_on = FALSE;
   }
   else {
     sound_on = TRUE;
     music_on = TRUE;
   }

   //load data files
   gotoxy(2, 7);
   cprintf("Loading data files...\n");
   if (!exists(WALLS_FILE)) Error("Cannot find %s file.\n", WALLS_FILE);
   else walls_data = load_datafile(WALLS_FILE);
   if (!exists(SPRITES_FILE)) Error("Cannot find %s file.\n", SPRITES_FILE);
   else sprites_data = load_datafile(SPRITES_FILE);
   if (!exists(MAIN_FILE)) Error("Cannot find %s file.\n", MAIN_FILE);
   else main_data = load_datafile(MAIN_FILE);
   if (!exists(SPECIAL_FILE)) Error("Cannot find %s file.\n", SPECIAL_FILE);
   else special_data = load_datafile(SPECIAL_FILE);
   if (!exists(GLIZDA_FILE)) Error("Cannot find %s file.\n", GLIZDA_FILE);
   else glizda_data = load_datafile(GLIZDA_FILE);
   if (!exists(EFFECTS_FILE)) Error("Cannot find %s file.\n", EFFECTS_FILE);
   else effects_data = load_datafile(EFFECTS_FILE);
   if (!exists(MUSIC_FILE)) Error("Cannot find %s file.\n", MUSIC_FILE);
   else music_data = load_datafile(MUSIC_FILE);

   gotoxy(2, 8);
   if (sound_on) {
      if (!exists(SOUND_FILE)) {
         cprintf("File %s not found. No sound.\n", SOUND_FILE);
         sound_on = FALSE;
      }
      else {
         cprintf("Loading sound data file...\n");
         sounds_data = load_datafile(SOUND_FILE);
      }
   }
   gotoxy(2, 9);
   cprintf("Creating transluency table...\n");
   create_trans_table(&trans_table, (RGB*)main_data[GAME_PALLETE].dat, 100,
                                    100, 100, trans_callback);
   color_map = &trans_table;

   gotoxy(2, 10);
   cprintf("Initializing joystick...\n");
   initialise_joystick();

   gotoxy(2, 11);
   cprintf("Loading episodes...\n");
   //episod 1
   if (!load_episod(&episod1, EPISOD1_DATA)) {
      strcpy(episod1.name, "Episod 1");
      episod1_text = NULL;
   }
   else {
      if (exists(EPISOD1_TEXT))
         episod1_text = load_datafile(EPISOD1_TEXT);
   }
   //episod 2
   if (!load_episod(&episod2, EPISOD2_DATA)) {
      strcpy(episod2.name, "Episod 2");
      episod2_text = NULL;
   }
   else {
      if (exists(EPISOD2_TEXT))
         episod2_text = load_datafile(EPISOD2_TEXT);
   }
   //episod 3
   if (!load_episod(&episod3, EPISOD3_DATA)) {
      strcpy(episod3.name, "Episod 3");
      episod3_text = NULL;
   }
   else {
      if (exists(EPISOD3_TEXT))
         episod3_text = load_datafile(EPISOD3_TEXT);
   }
   //episod 4
   if (!load_episod(&episod4, EPISOD4_DATA)) {
      strcpy(episod4.name, "Episod 4");
      episod4_text = NULL;
   }
   else {
      if (exists(EPISOD4_TEXT))
         episod4_text = load_datafile(EPISOD4_TEXT);
   }
   //episod 5
   if (!load_episod(&episod5, EPISOD5_DATA)) {
      strcpy(episod5.name, "Episod 5");
      episod5_text = NULL;
   }
   else {
      if (exists(EPISOD5_TEXT))
         episod5_text = load_datafile(EPISOD5_TEXT);
   }

 	//set graphics mode
   gotoxy(2, 12);
   cprintf("Setting graphics mode...");
	set_gfx_mode (GFX_AUTODETECT, 640, 480, 0, 0);	//set graphics mode to 640x480x256
   font = (FONT*)main_data[GAME_FONT].dat;

   // init stuff for game
   mapa = create_bitmap(18*24, 18*24);
   glizda_timer = global_timer = 0;
   LOCK_VARIABLE(glizda_timer);
   LOCK_VARIABLE(global_timer);
   LOCK_FUNCTION(increment_timer);
   install_int(increment_timer, 10);
   global_bitmap = create_bitmap(640, 480);
   end_string = NULL;
   strcpy(high_scores_view_name, "No Episod Selected");
}

void exit_game()
{
   allegro_exit();
   clrscr();
   textbackground(BROWN); 
   window(3, 3, 79, 21);
   clrscr();
   textbackground(RED);
   textcolor(WHITE);
   window(2, 2, 78, 20);
   clrscr();
	
 	cprintf_centre(40, 2, "Ader Software 1998");
   cprintf_centre(40, 3, "G L I Z D A  v1.00");
	
   cprintf_centre(40, 4, "http://www.geocities.com/SiliconVally/Vista/1042");
   cprintf_centre(40, 6, "Programing  by");
   cprintf_centre(40, 7, "Andrew Deren  aderen@eecs.uic.edu");
   cprintf_centre(40, 8, "Graphics by");
   cprintf_centre(40, 9, "Rafal Wiszowaty");
   cprintf_centre(40, 11, "Special Thanks To:");
   cprintf_centre(40, 12, "DJ Delorie - for making DJGPP");
   cprintf_centre(40, 13, "Shawn Hargreaves - for making allegro game library");
   cprintf_centre(40, 14, "and all the other people who contributed to");
   cprintf_centre(40, 15, "DJGPP development tools and utilities.");
   cprintf_centre(40, 17, "(C) Ader Software 1998");
   textbackground(BLACK);
   if (end_string) {
      gotoxy(1, 21);
      printf("%s", end_string);
   }
   gotoxy(1, 23);
   clreol(); 
   exit(0);
}

main()
{
	srandom((int)time(NULL));
   StartGlizda();
   show_mouse(screen);
   main_menu();
   fade_out(1);
   exit_game();
}

int reg_error_dialog()
{
   // Object definitions - DEGUI 1.2 beta
   box_object object_1;
   button_object object_2("OK",0,true);
   panel_ridge_object object_4;
   centerd_text_object object_3("Error");
   centerd_text_object object_5("Sorry, you need to");
   centerd_text_object object_6("register the game");
   centerd_text_object object_7("for this option to");
   centerd_text_object object_8("be available");

   // Add Objects to the dialog
   dialog the_dialog;
   the_dialog.add(object_1,150,150,215,130);
   the_dialog.add(object_2,240,250,50,20);
   the_dialog.add(object_4,155,155,205,20);
   the_dialog.add(object_3,250,160,20,8);
   the_dialog.add(object_5,260,185,72,8);
   the_dialog.add(object_6,260,200,68,8);
   the_dialog.add(object_7,260,215,72,8);
   the_dialog.add(object_8,255,230,48,8);
   the_dialog.center();
   the_dialog.popup();
   return FALSE;
}
