/****************************************************
 * Project:   Glizda Game
 * FILE:      editor.cc
 * Author:    Andrew Deren
 * Date:      1/2/98
 * Length:    630
 ****************************************************/

#include "editor.h"
#include "agui.h"
#include "glizda.h"

MAP map;             //map being edited
MAP undomap;
int current_sprite;  //sprite currently selected
int current_wall;    //texture (walls) currenctly selected
int current_special; // current special sprite
char file_name[256]; //file name of the file currently edited


//GUI Objects
dialog *editor_dialog;                     //main dialog
checkbox_object *chkGrid;       //check box for grid on and off
bitmap_button_object *cmdSprites; //button to change sprites
bitmap_button_object *cmdWalls;   //button to change walls
bitmap_button_object *cmdSpecial; // button to change special graphics
label_object *lblFileName;        //displays file name of the edited map

MapObject *dialog_map;                  //map object


//temporarly not working, used to set grid color
int ProcColor(void)
{
   int c = do_color_dialog(50, 50, dialog_map->get_gridcolor());
   dialog_map->set_gridcolor(c);
   return TRUE;
}

//calculate number of sprites in the map
int CalculateSprites(void)
{
   int sprites = 0;     //init sprites is 0
   int i, j;            //loop counters
   for (i=0; i<18; i++) {
      for (j=0; j<18; j++) {
          //sprites are between 1 and 20 in map.values[][] array
         if (map.values[i][j] > 0 && map.values[i][j] <= 20) sprites++;
         if (map.values[i][j] == 213) sprites++;
      }
   }
   return sprites;
}

int Undo(void)
{
   MAP tmap;
   memcpy(&tmap, &map, sizeof(MAP));
   memcpy(&map, &undomap, sizeof(MAP));
   memcpy(&undomap, &tmap, sizeof(MAP));
   dialog_map->redraw();
   return FALSE;
}

void CopyToUndo(void)
{
   memcpy(&undomap, &map, sizeof(MAP));
}

int ClearAllSprites(void)
{
   int i, j;
   CopyToUndo();
   for (i=0; i<18; i++) {
      for (j=0; j<18; j++) {
         if (map.values[i][j] > 0 && map.values[i][j] <= 20)
            map.values[i][j] = 0;
      }
   }
   dialog_map->redraw();
   return FALSE;
}

int ClearAllWalls(void)
{
   int i, j;
   CopyToUndo();
   for (i=0; i<18; i++) {
      for (j=0; j<18; j++) {
         if (map.values[i][j] > 100 && map.values[i][j] <= 120)
            map.values[i][j] = 0;
      }
   }
   dialog_map->redraw();
   return FALSE;
}

int ClearAllSpecial(void)
{
   int i, j;
   CopyToUndo();
   for (i=0; i<18; i++) {
      for (j=0; j<18; j++) {
         if (map.values[i][j] > 200 && map.values[i][j] <= 220)
            map.values[i][j] = 0;
      }
   }
   dialog_map->redraw();
   return FALSE;
}

int ReplaceSprites(void)
{
   int i, j;
   CopyToUndo();
   for (i=0; i<18; i++) {
      for (j=0; j<18; j++) {
         if (map.values[i][j] > 0 && map.values[i][j] <= 20)
            map.values[i][j] = current_sprite;
      }
   }
   dialog_map->redraw();
   return FALSE;
}

int ReplaceWalls(void)
{
   int i, j;
   CopyToUndo();
   for (i=0; i<18; i++) {
      for (j=0; j<18; j++) {
         if (map.values[i][j] > 100 && map.values[i][j] <= 120)
            map.values[i][j] = current_wall+100;
      }
   }
   dialog_map->redraw();
   return FALSE;
}


int DoBorderAround(void)
{
   CopyToUndo();
   for (int i=0; i < 18; i++) {
      map.values[i][0] = current_wall + 100;
      map.values[i][17] = current_wall + 100;
      map.values[0][i] = current_wall + 100;
      map.values[17][i] = current_wall + 100;
   }
   dialog_map->redraw();
   return FALSE;
}

int ScreenDump(void)
{
      RGB title_pal[256];
      get_palette(title_pal);
      //create temp bitmap
      BITMAP *tbmp = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
      //save the picture with game pallete
      save_pcx("editor.pcx", tbmp, title_pal);
      destroy_bitmap(tbmp);     //destroy bitmap

   return FALSE;
}


/**************************** menu procedures ************************/
//start new map
int ProcNew(void)
{
   int i, j;
   strcpy(map.IdString, "glizda");  //map IdString is "glizda"
   strcpy(map.version, "v1.0");     //map version is "v1.0"
   map.glizda_x = map.glizda_y = 0; //set glizda location to 0, 0
   map.sprites_to_eat = 0;          //number of sprites to eat is 0
   for (i=0; i<18; i++) {           //reset all values to 0
      for (j=0; j<18; j++) {
         map.values[i][j] = 0;      //init all values to 0
      }
   }
   strcpy(file_name, "untitled.map");  //set file name to be untitled.map
   lblFileName->set_text(file_name);
   dialog_map->redraw();                //draw the dialog
   CopyToUndo();
   return FALSE;                        //return TRUE
}

//open the map
int ProcOpen(void)
{
 	FILE *file;       //file
   MAP tmap;         //temp map
   char ttext[256];  //temp text
   ttext[0] = '\0';  //make ttext nothing
   int errorflag = FALSE;   //did error occured while opening map?

   //open file dialog
   if (file_select("Open Map", ttext, "map") != 0) {
     	file = fopen(ttext, "rb");      //try to open file
      if (!file) {         //opening failed
        	alert("Error opening file.", NULL, NULL, "OK", NULL, KEY_ENTER, 0);
         return FALSE;
      }
      else {          //read data from file
        	fread(&tmap, sizeof(struct MAP), 1, file);
         fclose(file);              //close file

         //check if valid file type
         if (strcmp(tmap.IdString, "glizda") != 0) {
            //is map is invalid; ask if should be opened anyway
            if (alert("Error", "File of invalid type", "Open anyway?",
                               "Yes", "No", KEY_ENTER, KEY_ESC) == 2)
               errorflag = TRUE;
         }
         //check if valid version
         if (strcmp(tmap.version, "v1.0") != 0) {
            //if invalid version ask if should be opened any way
            if (alert("Error!!!", " file of invalid version.", "Open anyway?",
                                  "Yes", "No", KEY_ENTER, KEY_ESC) == 2)
               errorflag = TRUE;
         }
         if (!errorflag) {  //user wants to open map
            //copy data from tmap to map
            strcpy(file_name, get_filename(ttext));
            memcpy(&map, &tmap, sizeof(struct MAP));
            CopyToUndo();
            lblFileName->set_text(file_name);
         }
       } //end else !file
   }  //end if file_select
   dialog_map->redraw();
   return FALSE;
}

//save the map
int ProcSave(void)
{
   FILE *file; //file
   file = fopen(file_name, "wb");   //try opening the file
   //check if able to open
   if (!file)	alert("Error saving file.", NULL, NULL, "OK", NULL, KEY_ENTER, 0);
   else {
      //get number of sprites
      map.sprites_to_eat = CalculateSprites();
      //write data to file
      strcpy(map.IdString, "glizda");  //map IdString is "glizda"
      strcpy(map.version, "v1.0");     //map version is "v1.0"

      fwrite(&map, sizeof(struct MAP), 1, file);
      //close file
      fclose(file);
   }
   return FALSE;
}

//save as
int ProcSaveAs(void)
{
 	int temp = 1;
 	FILE *file;  //file
   char ttext[256];   //temp text
   //default file name is old file name
   strcpy(ttext, file_name);
   //do file select dialog
  	if (file_select("Save Map", ttext, "map") != 0) {
     	if (exists(ttext)) //if file exists prompt if overwrite
     	   temp = (alert("File already exists.", "Overwrite?", NULL, "OK", "Cancel", KEY_ENTER, KEY_ESC) == 1);
		if (temp == 1) {       //write data to file
		   file = fopen(ttext, "wb");  //open file
         //check if able to open
   	   if (!file)	alert("Error saving file.", NULL, NULL, "OK", NULL, KEY_ENTER, 0);
	   	else {
            //calculate number of sprites
            map.sprites_to_eat = CalculateSprites();
            //save data to file
			   fwrite(&map, sizeof(struct MAP), 1, file);
      	   fclose(file); //close file
            //get file name that the map was saved
            strcpy(file_name, get_filename(ttext));
            lblFileName->set_text(file_name);
	      }  //end else
      }  //end if temp == 1
   }  //end if file select
   dialog_map->redraw();
   return TRUE;
}

//proc exit
int ProcExit(void)
{
   editor_dialog->close();
   return FALSE;
}

//help
int ProcHelp(void)
{
   static char *help_text =
           "Editing Maps: \n"
           "-------------\n\n"
           "   Sprites are the items that can be eaten by glizda (worm) "
           "Walls are items that can kill glizda. \n\n"
           "   To change sprites or walls click on the button "
           "or select change sprite or wall from the menu \n\n"
           "   To place sprite use left mouse button and to "
           "place wall use right mouse button.\n\n"
           "   To erase sprite or wall hold shift and click mouse button \n\n"
           "   To change glizda (worm) location hold alt key and put "
           "worm in new location.\n\n"
           "   Clear Walls button or menu command deletes all walls from "
           "the map.\n\n"
           "   Clear Sprites button or menu command deletes all sprites from "
           "the map.\n\n"
           "   Replace All Sprites button or menu command replaces all "
           "occurances of any sprite with currently selected sprite.\n\n"
           "   Replace All Walls button or menu command replaces all "
           "occurances of any wall with currently selected wall.\n\n"
           "   Do Border button or menu command puts a border around map "
           "with currently selected wall. All levels must be enclosed by "
			  "a border otherwise the game might behave unexpectly when glizda "
			  "leaves the map.\n\n"
           "   Special Sprites: to put a special sprite hold ctrl key and "
           "click left mouse button. Clear all special button clears all "
           "special sprites from the map. To find more information on Special "
			  "sprites go to game help menu. NOTE: each level has to have at "
			  "least one EndLevel special sprite.\n\n";
			  
   // Object definitions - DEGUI 1.2 beta
   box_object panMain;
   centerd_text_object lblTitle("H E L P");
   textbox_object edtHelp(help_text,true,true);
   button_object cmdOK("Ok",0,true);

   // Add Objects to the dialog
   dialog the_dialog;
   the_dialog.add(panMain,140,90,260,275);
   the_dialog.add(lblTitle,264,100,28,8);
   the_dialog.add(edtHelp,145,115,250,210);
   the_dialog.add(cmdOK,240,335,60,25);
   the_dialog.center();
   the_dialog.popup();

   return FALSE;
}


//diasplay about information
int ProcAbout(void)
{
   // Object definitions - DEGUI 1.2 beta
   shadow_box_object object_1;
   bitmap_object bmpAbout((BITMAP*)main_data[ABOUT_EDITOR].dat);
   panel_ridge_object object_3;
   button_object cmdOK("OK",0,true);
   centerd_text_object lbl_GE("Glizda Editor v1.0");
   centerd_text_object lbl_AD("Andrew Deren 1997");
   centerd_text_object lbl_About("ABOUT");

   // Add Objects to the dialog
   dialog a_dialog;
   a_dialog.add(object_1,100,100,220,280);
   a_dialog.add(bmpAbout,110,130,200,175);
   a_dialog.add(object_3,105,105,210,20);
   a_dialog.add(cmdOK,190,350,36,25);
   a_dialog.add(lbl_GE,210,320,72,8);
   a_dialog.add(lbl_AD,210,335,68,8);
   a_dialog.add(lbl_About,215,110,20,8);
   a_dialog.center();
   a_dialog.popup();
   return TRUE;
}

//display amout of free memory left
int ProcFreeMem(void)
{
   char temp_text1[25];
   char temp_text2[25];
    // Object definitions - DEGUI 1.2 beta
   shadow_box_object object_1;
   panel_ridge_object object_2;
   centerd_text_object object_3("FREE MEM");
   text_object lblFPM("Free Physical Memory:");
   sprintf(temp_text1, "%d KB", _go32_dpmi_remaining_physical_memory()/1024);
   centerd_text_object object_5(temp_text1);
   sprintf(temp_text2, "%d KB", _go32_dpmi_remaining_virtual_memory()/1024);
   text_object lblFVM("Free Virtual Memory:");
   centerd_text_object object_7(temp_text2);
   button_object cmdOK("OK", 0, TRUE);

   // Add Objects to the dialog
   dialog a_dialog;
   a_dialog.add(object_1,100,100,180,155);
   a_dialog.add(object_2,105,105,170,20);
   a_dialog.add(object_3,190,110,32,8);
   a_dialog.add(lblFPM,105,140,168,8);
   a_dialog.add(object_5,190,160,24,8);
   a_dialog.add(lblFVM,105,185,160,8);
   a_dialog.add(object_7,190,205,24,8);
   a_dialog.add(cmdOK, 165,225,50,25);
   a_dialog.center();
   a_dialog.popup();
   return TRUE;
}

void SelectGraphics(int *current, DATAFILE *gd)
{
   int i, x, y;
   if (*current < 1 || *current > 20)
      *current = 1;

   dialog s_dialog;
   bitmap_radio_object bmpObj[20];
   button_object cmdOk("OK", KEY_ENTER, TRUE);
   panel_raised_object main_window;
   x = y = 0;
   s_dialog.add(main_window, 0, 0, 165, 170);
   for (i=0; i<20; i++) {
      bmpObj[i].set_bitmap((BITMAP*)gd[i+1].dat);
      s_dialog.add(bmpObj[i], 10+x*30, 10+y*30, 25, 25);
      x++;
      if (x == 5) {
         y++;
         x = 0;
      }
   }
   bmpObj[*current-1].select();
   s_dialog.add(cmdOk, 50, 140, 60, 25);
   s_dialog.center();
   s_dialog.popup();
   for (i=0;i<20; i++) {
      if (bmpObj[i].selected()) {
         *current = i+1;
         break;
      }
   }
}

int ProcChangeSprite(void)
{
   SelectGraphics(&current_sprite, sprites_data);
   cmdSprites->set_bitmap((BITMAP*)sprites_data[current_sprite].dat);
   cmdSprites->redraw();
   return FALSE;
}

int ProcChangeWall(void)
{
   SelectGraphics(&current_wall, walls_data);
   cmdWalls->set_bitmap((BITMAP*)walls_data[current_wall].dat);
   cmdWalls->redraw();
   return FALSE;
}

int ProcChangeSpecial(void)
{
   SelectGraphics(&current_special, special_data);
   cmdSpecial->set_bitmap((BITMAP*)special_data[current_special].dat);
   cmdSpecial->redraw();
   return FALSE;
}

void EditorInit(void)
{
   current_sprite = current_wall = 1;
   sprintf(file_name, "untitled.map");
}

void StartEditorGUI(void)
{

   current_sprite = current_wall = current_special = 1;

   menu mnuFile;        //file menu
   menu mnuOptions;     //options menu
   menu mnuCommands;    //commands menu
   menu mnuHelp;        //help menu
   menu allegro_menu;   //menu holding all menus

   dialog the_dialog;
   editor_dialog = &the_dialog;

   clear_screen_object objClear;                //clear screen object
   frame_object frmMap(PANEL_SUNKEN_FRAME);    //frame around map
   label_object txtLoc("");


   MapObject dialog_mapP;                  //map object
   dialog_map = &dialog_mapP;
   dialog_map->SetTextObject(&txtLoc);

   mnuFile.add("New", ProcNew);
   mnuFile.add("Open", ProcOpen);

   if (shareware)
      mnuFile.add("Save", reg_error_dialog);
   else
      mnuFile.add("Save", ProcSave);

   if (shareware)
      mnuFile.add("Save As", reg_error_dialog);
   else
      mnuFile.add("Save As", ProcSaveAs);

   mnuFile.add();
   mnuFile.add("Exit", ProcExit);

   mnuOptions.add("Free memory", ProcFreeMem);
   mnuOptions.add("Grid Color", ProcColor);
   mnuOptions.add("Save screen to file", ScreenDump);

   mnuCommands.add("Undo", Undo);
   mnuCommands.add();
   mnuCommands.add("Change Sprite", ProcChangeSprite);
   mnuCommands.add("Change Wall", ProcChangeWall);
   mnuCommands.add();
   mnuCommands.add("Clear All Sprites", ClearAllSprites);
   mnuCommands.add("Clear All Walls", ClearAllWalls);
   mnuCommands.add("Clear All Special Sprites", ClearAllSpecial);
   mnuCommands.add();
   mnuCommands.add("Replace All Sprites", ReplaceSprites);
   mnuCommands.add("Replace All Walls", ReplaceWalls);
   mnuCommands.add();
   mnuCommands.add("Do Border", DoBorderAround);

   mnuHelp.add("Help", ProcHelp);
   mnuHelp.add();
   mnuHelp.add("About", ProcAbout);

   allegro_menu.add("&File", mnuFile);
   allegro_menu.add("&Options", mnuOptions);
   allegro_menu.add("&Commands", mnuCommands);
   allegro_menu.add("&Help", mnuHelp);

   menu_object menu(allegro_menu);     //main menu

   label_object lblFileNameP("Untitled.map");
   lblFileName = &lblFileNameP;

   bitmap_button_object cmdNew((BITMAP*)main_data[NEW_PCX].dat, ProcNew, "New");
   bitmap_button_object cmdOpen((BITMAP*)main_data[OPEN_PCX].dat, ProcOpen, "Open");
   bitmap_button_object cmdSave((BITMAP*)main_data[SAVE_PCX].dat, ProcSave, "Save");
   bitmap_button_object cmdHelp((BITMAP*)main_data[HELP_PCX].dat, ProcHelp, "Help");
   bitmap_button_object cmdUndo((BITMAP*)main_data[UNDO_PCX].dat, Undo, "Undo");
   if (shareware) {
      cmdSave.set_click_proc(reg_error_dialog);
   }

   text_object txtFileName("File: ");
   text_object txtSprites("Current sprite: ");
   text_object txtWalls("Current wall:   ");
   text_object txtSpecial("Current special: ");
   text_object txtAbout("Glizda Editor v1.00");
   text_object txtAbout2("Andrew Deren 1997");
   win_button_object cmdClearWalls("Clear Walls", 0, 0, ClearAllWalls);
   win_button_object cmdClearSprites("Clear Sprites", 0, 0, ClearAllSprites);
   win_button_object cmdDoBorder("Do Border", 0, 0, DoBorderAround);
   win_button_object cmdRepSprites("Replace Sprites", 0, 0, ReplaceSprites);
   win_button_object cmdRepWalls("Replace Walls", 0, 0, ReplaceWalls);
   win_button_object cmdClearSpecial("Clear Special", 0, 0, ClearAllSpecial);

   panel_groove_object panel1;   // around the location
   panel_groove_object panel2;   // around file name
   panel_groove_object panel3;   // around icon buttons
   panel_groove_object panel4;
   panel_groove_object panel5;

   checkbox_object chkGridP("Grid");       //check box for grid on and off
   chkGrid = &chkGridP;
   chkGrid->select();

   bitmap_button_object cmdSpritesP((BITMAP*)sprites_data[current_sprite].dat,
                        ProcChangeSprite, "Change Sprite"); //button to change sprites
   cmdSprites = &cmdSpritesP;

   bitmap_button_object cmdWallsP((BITMAP*)walls_data[current_wall].dat,
                        ProcChangeWall, "Change Wall");
   cmdWalls = &cmdWallsP;

   bitmap_button_object cmdSpecialP((BITMAP*)special_data[current_special].dat,
                        ProcChangeSpecial, "Change Special");
   cmdSpecial = &cmdSpecialP;

   the_dialog.add(objClear);
   the_dialog.add(menu);

   the_dialog.add(panel5,     480,  295,    115,     120);
   the_dialog.add(txtSpecial, 482,  310,     60,      10);
   the_dialog.add(txtSprites, 482,  350,     60,      10);
   the_dialog.add(txtWalls,   482,  390,     60,      10);
   the_dialog.add(cmdSpecialP, 558,  300,      32,      32);
   the_dialog.add(cmdSpritesP, 558,  340,      32,      32);
   the_dialog.add(cmdWallsP,   558,  380,      32,      32);

   the_dialog.add(panel4, 480, 418, 115, 37);
   the_dialog.add(txtAbout, 485, 420, 105, 9);
   the_dialog.add(txtAbout2, 485, 435, 105, 9);

   the_dialog.add(panel3, 480, 65, 115, 185);
   the_dialog.add(cmdClearSprites, 485, 70, 105, 24);
   the_dialog.add(cmdClearWalls,   485, 100, 105, 24);
   the_dialog.add(cmdClearSpecial, 485, 130, 105, 24);
   the_dialog.add(cmdDoBorder,     485, 160, 105, 24);
   the_dialog.add(cmdRepSprites,   485, 190, 105, 24);
   the_dialog.add(cmdRepWalls,     485, 220, 105, 24);

   the_dialog.add(frmMap,      29,  26, 18*24+1, 18*24+1);
   the_dialog.add(dialog_mapP,  30,  27,   18*24,   18*24);
   the_dialog.add(chkGridP,    410, 465,     100,      10);

   the_dialog.add(panel1, 382, 2, 80, 19);
   the_dialog.add(txtLoc,      385,  4,     70,      14);

   the_dialog.add(txtFileName, 32, 465,      60,      10);
   the_dialog.add(lblFileNameP,100, 465,     150,      10);

   the_dialog.add(panel2,     480, 30, 115, 25);
   the_dialog.add(cmdNew,     482, 32, 20, 20);
   the_dialog.add(cmdOpen,    504, 32, 20, 20);
   the_dialog.add(cmdSave,    526, 32, 20, 20);
   the_dialog.add(cmdUndo,    548, 32, 20, 20);
   the_dialog.add(cmdHelp,    570, 32, 20, 20);
//   the_dialog.unclose();
//   ProcAbout();
   ProcNew();
   the_dialog.execute();
}

int editor_main()
{
   StartEditorGUI();
   return FALSE;
}

