/****************************************************
 * Project:   Glizda Game
 * FILE:      helpgame.cc
 * Author:    Andrew Deren
 * Date:      1/2/98
 * Length:    268
 ****************************************************/

#include "agui.h"
#include "glizda.h"

int current_page;
dialog *help_dialog;

#define MAX_PAGES 3

// walls
void draw_page1(void)
{
   int i;
   textprintf(global_bitmap, font, 50, 50, 15, "The game of glizda is pretty simple to play. Glizda refers to a worm that you move by using ");
   textprintf(global_bitmap, font, 50, 65, 15, "arrow keys on the keyboard or by using joystick. The purpose of the game is to eat all the sprites.");
   textprintf(global_bitmap, font, 50, 80, 15, "These are the sprites that can be eaten in order to finish level: ");
   for (i=1; i<11; i++) {
      draw_sprite(global_bitmap, (BITMAP*)sprites_data[i].dat, 100 + i * 30, 100);
      textprintf(global_bitmap, font, 100 + i * 30, 130, 15, "%2d", 100 + i * 5);
      draw_sprite(global_bitmap, (BITMAP*)sprites_data[i+10].dat, 100 + i * 30, 140);
      textprintf(global_bitmap, font, 100 + i * 30, 170, 15, "%2d", 100 + (i+10)*5);
   }
   textprintf(global_bitmap, font, 50, 185, 15, "Below them is number of points that are added to score when the sprite is eaten. When all of those");
   textprintf(global_bitmap, font, 50, 200, 15, "sprites from the level are eaten then the special sprite 'End Level' has to be entered. Look at");
   textprintf(global_bitmap, font, 50, 215, 15, "special sprites section for more information on special sprites.");
   textprintf(global_bitmap, font, 50, 235, 15, "The following are the sprites or wall that cannot be entered and kill glizda:");
   for (i=1; i<11; i++) {
      draw_sprite(global_bitmap, (BITMAP*)walls_data[i].dat, 100 + i * 30, 250);
      draw_sprite(global_bitmap, (BITMAP*)walls_data[i+10].dat, 100 + i * 30, 280);
   }
   textprintf(global_bitmap, font, 50, 320, 15, "Whenever glizda eats a sprite the size of glizda increases by one, and when glizda eats itself ");
   textprintf(global_bitmap, font, 50, 335, 15, "it dies.");
   textprintf(global_bitmap, font, 50, 355, 15, "There are several kinds of games you can play. There are couple of episodes already made that you");
   textprintf(global_bitmap, font, 50, 370, 15, "can play or you can make your own episodes and play them as custom episodes. You can also play");
   textprintf(global_bitmap, font, 50, 385, 15, "singe maps that can be created using map editor.");
   textprintf(global_bitmap, font, 500, 10, 15, "Page: 1 of %d", MAX_PAGES);
}

// sprites
void draw_page2(void)
{
   textprintf_centre(global_bitmap, (FONT*)main_data[TITLE_FONT].dat, 320, 60, makecol8(255, 0, 0), "Special Sprites");
   draw_sprite(global_bitmap, (BITMAP*)special_data[1].dat, 60, 90);
   textprintf(global_bitmap, font, 100, 90, 15, "This sprite can be pushed around the map in all directions. When pushed on other ");
   textprintf(global_bitmap, font, 100, 100, 15, "wall or sprite glizda will die.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[2].dat, 60, 130);
   textprintf(global_bitmap, font, 100, 130, 15, "This sprite is similar to the previous one, but can be pushed only in");
   textprintf(global_bitmap, font, 100, 140, 15, "horizontal directions.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[3].dat, 60, 170);
   textprintf(global_bitmap, font, 100, 170, 15, "This sprite is similar to the previous one, but can be pushed only in");
   textprintf(global_bitmap, font, 100, 180, 15, "vertical directions.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[4].dat, 60, 210);
   textprintf(global_bitmap, font, 100, 210, 15, "When eaten this sprite decreases size of glizda by one.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[5].dat, 60, 250);
   textprintf(global_bitmap, font, 100, 250, 15, "When this sprite is eaten glizda becomes a ghost and can walk through walls. ");
   textprintf(global_bitmap, font, 100, 260, 15, "But this works only once. When one wall is crossed glizda is normal again.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[6].dat, 60, 290);
   textprintf(global_bitmap, font, 100, 290, 15, "Teleport sprite lets the glizda teleport from one place to another.");
   textprintf(global_bitmap, font, 100, 300, 15, "When walked upon, the glizda will be teleported to another teleport on the map.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[7].dat, 60, 330);
   draw_sprite(global_bitmap, (BITMAP*)special_data[8].dat, 90, 330);
   draw_sprite(global_bitmap, (BITMAP*)special_data[9].dat, 120, 330);
   draw_sprite(global_bitmap, (BITMAP*)special_data[10].dat, 150, 330);
   textprintf(global_bitmap, font, 180, 330, 15, "Those sprites can only be entered from one direction");
   textprintf(global_bitmap, font, 180, 340, 15, "When entered from other direction then the arrow pointing the glizda will die.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[11].dat, 60, 370);
   textprintf(global_bitmap, font, 100, 370, 15, "Bomb sprite can be pushed on any object (wall, sprite or other special sprite) and");
   textprintf(global_bitmap, font, 100, 380, 15, "will destroy everything when pushed on (except when pushed on the outside wall).");

   draw_sprite(global_bitmap, (BITMAP*)special_data[12].dat, 60, 410);
   textprintf(global_bitmap, font, 100, 410, 15, "This sprites rotates the sprites that can be entered from one direction only by ");
   textprintf(global_bitmap, font, 100, 420, 15, "90 degrees, making them face in opposite direction.");


   textprintf(global_bitmap, font, 500, 10, 15, "Page: 2 of %d", MAX_PAGES);
}

// special
void draw_page3(void)
{
   textprintf_centre(global_bitmap, (FONT*)main_data[TITLE_FONT].dat, 320, 60, makecol8(255, 0, 0), "Special Sprites");

   draw_sprite(global_bitmap, (BITMAP*)special_data[13].dat, 60, 90);
   textprintf(global_bitmap, font, 100, 90, 15, "When two of those sprites are pushed together they will disapear and a collectible sprite");
   textprintf(global_bitmap, font, 100, 100, 15, "will appear in their place.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[14].dat, 60, 130);
   textprintf(global_bitmap, font, 100, 130, 15, "This sprite removed all the fog from the map.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[15].dat, 60, 170);
   textprintf(global_bitmap, font, 100, 170, 15, "This sprite is worth 2500 points when collected.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[16].dat, 60, 210);
   textprintf(global_bitmap, font, 100, 210, 15, "This sprite adds 15 more seconds to the time needed to finish the level.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[17].dat, 60, 250);
   textprintf(global_bitmap, font, 100, 250, 15, "When two of those sprites are next to each other they disappear.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[18].dat, 60, 290);
   textprintf(global_bitmap, font, 100, 290, 15, "When glizda enters this sprite the game is saved and when glizda dies");
   textprintf(global_bitmap, font, 100, 300, 15, "the game continues from this point.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[19].dat, 60, 330);
   textprintf(global_bitmap, font, 100, 330, 15, "This sprite has to be entered when all the collectible sprites are collected.");
   textprintf(global_bitmap, font, 100, 340, 15, "then the level is finished.");

   draw_sprite(global_bitmap, (BITMAP*)special_data[20].dat, 60, 370);
   textprintf(global_bitmap, font, 100, 370, 15, "This sprite can be pushed into ");
   draw_sprite(global_bitmap, (BITMAP*)special_data[13].dat, 280, 370);
   draw_sprite(global_bitmap, (BITMAP*)special_data[17].dat, 310, 370);
   textprintf(global_bitmap, font, 340, 370, 15, "and will make them disappear.");

   textprintf(global_bitmap, font, 500, 10, 15, "Page: 3 of %d", MAX_PAGES);
}

void draw_custom_background(char *title=NULL)
{
   text_mode(-1);
   drawing_mode(DRAW_MODE_COPY_PATTERN, (BITMAP*)main_data[TEXTURE].dat, 0, 0);
   rectfill(global_bitmap, 0, 0, SCREEN_W, SCREEN_H, 1);
   solid_mode();
   blit((BITMAP*)main_data[BACKGROUND].dat, global_bitmap, 40, 40, 40, 40, 560, 400);
   vline(global_bitmap, 40, 40, 440, makecol8(0, 0, 0));
   vline(global_bitmap, 600, 40, 440, makecol8(255, 255, 255));
   hline(global_bitmap, 40, 40, 600, makecol8(0, 0, 0));
   hline(global_bitmap, 40, 440, 600, makecol8(255, 255, 255));
   draw_trans_sprite(global_bitmap, (BITMAP*)main_data[BACKGROUND].dat, 0, 0);
   if (title) {
      textout_centre(global_bitmap, (FONT*)main_data[TITLE_FONT].dat, title, 322, 7, 0);
      textout_centre(global_bitmap, (FONT*)main_data[TITLE_FONT].dat, title, 320, 5, 15);
   }
}

int ClearObjectProc(void)
{
   draw_custom_background("H E L P");
   switch (current_page) {
      case 1: draw_page1(); break;
      case 2: draw_page2(); break;
      case 3: draw_page3(); break;
      default: draw_page1(); break;
   }
   blit(global_bitmap, screen, 0, 0, 0, 0, 640, 480);
   return D_O_K;
}

int exit_help_dialog_proc(void)
{
   help_dialog->close();
   return FALSE;
}

int next_page_proc(void)
{
   current_page++;
   if (current_page > MAX_PAGES) current_page = 1;
   help_dialog->redraw();
   return FALSE;
}

int prev_page_proc(void)
{
   current_page--;
   if (current_page <= 0) current_page = MAX_PAGES;
   help_dialog->redraw();
   return FALSE;
}

int help_main(void)
{
   current_page = 1;
   dialog the_dialog;
   help_dialog = &the_dialog;
   texture_button_object cmdExit("Exit", (BITMAP*)main_data[TEXTURE2].dat,
                         (FONT*)main_data[TITLE_FONT].dat, exit_help_dialog_proc);
   texture_button_object cmdNext("Next", (BITMAP*)main_data[TEXTURE2].dat,
                         (FONT*)main_data[TITLE_FONT].dat, next_page_proc);
   texture_button_object cmdPrev("Previous", (BITMAP*)main_data[TEXTURE2].dat,
                         (FONT*)main_data[TITLE_FONT].dat, prev_page_proc);
   clear_screen_object clrObject;
   clrObject.set_draw_callback(ClearObjectProc);

   the_dialog.add(clrObject);
   the_dialog.add(cmdExit, 245, 450, 150, 25);
   the_dialog.add(cmdNext, 500, 450, 100, 25);
   the_dialog.add(cmdPrev, 40, 450, 100, 25);
   the_dialog.execute();
   return FALSE;
}

////////////////////////// High Scores Stuff //////////////////////
void load_highscores(char *filename)
{
   int i;
   if (!exists(filename)) {
      for (i=0; i<MAX_HIGHSCORES; i++) {
         strcpy(hi_scores[i].name, "Glizda");
         hi_scores[i].level = 1;
         hi_scores[i].score = 0;
      }
   }
   else {
      FILE *file;
      file = fopen(filename, "rb");
      if (!file) {
         for (i=0; i<MAX_HIGHSCORES; i++) {
           strcpy(hi_scores[i].name, "Glizda");
           hi_scores[i].level = 1;
           hi_scores[i].score = 0;
         }
         return;
      }
      fread(hi_scores, sizeof(HISCORE_INFO), MAX_HIGHSCORES, file);
      fclose(file);
   }
}

void save_highscores(char *filename)
{
   FILE *file;
   file = fopen(filename, "wb");
   if (file) {
      fwrite(hi_scores, sizeof(HISCORE_INFO), MAX_HIGHSCORES, file);
      fclose(file);
   }
}

bool is_highscore(int score)
{
   if (hi_scores[MAX_HIGHSCORES-1].score < score)
     return TRUE;
   else return FALSE;
}

int update_highscores(char *name, int level, int score)
{
   int i;
   for (i=MAX_HIGHSCORES-1; i>=0; i--) {
      if (score > hi_scores[i].score) {
         if (i != 0) {
            hi_scores[i].score = hi_scores[i-1].score;
            hi_scores[i].level = hi_scores[i-1].level;
            strcpy(hi_scores[i].name, hi_scores[i-1].name);
         }
      }
      else break;
   }
   i++;
   high_scores_view_place = i;
   hi_scores[i].score = score;
   hi_scores[i].level = level;
   strcpy(hi_scores[i].name, name);
   return i;
}
