/****************************************************
 * Project:   Glizda Game
 * FILE:      glizda.h
 * Author:    Andrew Deren
 * Date:      1/2/98
 * Length:    166
 ****************************************************/

#ifndef __GLIZDA_H
#define __GLIZDA_H

//include files
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdarg.h>
#include <allegro.h>
#include <degui.h>
#include "mdat.h"             //main data
#include "gdat.h"             // glizda data
#include "edat.h"             // effects data
#include "sounds.h"           // sounds data
#include "internal.h"         //from degui
#include "music.h"

#define GLIZDA_INFO1 "Glizda v1.0"
#define GLIZDA_INFO2 "(c) Andrew Deren 1998"

//files with data
#define SPRITES_FILE "sdat.dat"  //file with sprites
#define WALLS_FILE "wdat.dat"    //file with walls
#define SPECIAL_FILE "spdat.dat" // file with special textures
#define MAIN_FILE "mdat.dat"     //file with main data
#define SOUND_FILE "sounds.dat"  //file with sounds
#define GLIZDA_FILE "gdat.dat"   // file with glizda graphics
#define EFFECTS_FILE "edat.dat"  // file with effects graphics
#define MUSIC_FILE "music.dat"   // file with musics

extern DATAFILE *main_data;      // various game stuff
extern DATAFILE *sprites_data; //in map 1 to 20
extern DATAFILE *walls_data;   //in map 101 to 120
extern DATAFILE *special_data; // 201 to 206 in map
extern DATAFILE *sounds_data;  // sounds and musics
extern DATAFILE *glizda_data;  // graphics for glizda
extern DATAFILE *effects_data; // graphics for special effects
extern DATAFILE *music_data;   // musics

extern COLOR_MAP trans_table; // transulency table
extern BITMAP *global_bitmap; // big bitmap used for lot of stuff (640x480)
extern int shareware;         // is this version shareware?

typedef unsigned short int INT;
typedef unsigned char BYTE;


#define MAP_SIZE 18        //map is 18 by 18
typedef struct MAP {
   char IdString[7];       // "glizda"
   char version[5];        //v1.0
   BYTE glizda_x, glizda_y;  //location of glizda
   BYTE sprites_to_eat;      //sprites that have to be eaten
   BYTE values[MAP_SIZE][MAP_SIZE];      //actual values of the map
} MAP;


#define MAP_NAME_SIZE 13
#define MAX_MAPS 100

// info about map in episod
typedef struct MAP_INFO {
   char map_name[MAP_NAME_SIZE];    // name of map
   INT num_sprites;                 // number of sprites to collect
   INT time_limit;                  // maximum time for map to be played
   BYTE speed;                      // speed of glizda
   BYTE glizda_x, glizda_y;         // location of glizda
   BYTE data[MAP_SIZE][MAP_SIZE];   // values for sprites and walls
                                    // 1..20 are sprites and walls are 101..120
} MAP_INFO;


/* Episod structure in file:
   char id[14]  "GLIZDA EPISOD"
   INT  version  10 (1.0)
   char name[26]
   INT num_maps
   num_maps * MAP_INFO
*/
#define EPISOD1_DATA "episod1.gep"
#define EPISOD2_DATA "episod2.gep"
#define EPISOD3_DATA "episod3.gep"
#define EPISOD4_DATA "episod4.gep"
#define EPISOD5_DATA "episod5.gep"
#define EPISOD1_TEXT "episod1.dat"
#define EPISOD2_TEXT "episod2.dat"
#define EPISOD3_TEXT "episod3.dat"
#define EPISOD4_TEXT "episod4.dat"
#define EPISOD5_TEXT "episod5.dat"

typedef struct EPISOD_INFO {
   char name[26];
   bool loaded;
   INT num_maps;
   MAP_INFO *maps;
} EPISOD_INFO;

extern EPISOD_INFO episod1;
extern EPISOD_INFO episod2;
extern EPISOD_INFO episod3;
extern EPISOD_INFO episod4;
extern EPISOD_INFO episod5;
extern EPISOD_INFO episod_custom;
extern DATAFILE *episod1_text;
extern DATAFILE *episod2_text;
extern DATAFILE *episod3_text;
extern DATAFILE *episod4_text;
extern DATAFILE *episod5_text;

int load_episod(EPISOD_INFO *episod, char *filename);

#define MAX_HIGHSCORES 10
typedef struct HISCORE_INFO {
   char name[11];                   // name of the player
   int level;                       //level
   int score;                        //score
} HISCORE_INFO;

//function prototypes
void Error(va_list arg_list, ...);  //print error message and exit; main.cc
void StartGlizda(void);             //load stuff and start graphics; main.cc
int editor_main(void);             //start editor
int episod_main(void);             //start episod editor
int glizda_main(void);             //start glizda game
void increment_timer(...);         // increment glizda_timer and global_timer
int reg_error_dialog(void);        // dispaly error message that this ver. is shareware
void exit_game(void);              // exit the whole system
int use_navigator(char *stream);
int help_main(void);                // display help for the game
void draw_custom_background(char *title);  // draws background for help and other menus

#define RANDOM(x) {(random() % x)}

// highscores stuff; definitions in helpgame.cc
void load_highscores(char *filename);
void save_highscores(char *filename);
bool is_highscore(int score);
int update_highscores(char *name, int level, int score);

extern char e_name[26];             // name for the current episod
extern char e_file_name[256];       // name for the current file name for the episod
extern int num_maps;                // number of maps in episod
extern MAP_INFO maps[MAX_MAPS];        // maps
extern HISCORE_INFO hi_scores[MAX_HIGHSCORES];
extern int show_background;         // used for slow machines; don't draw the background
                                    // underneath the map (+4-5fps)
extern int show_fog;                // don't draw the fog on the map (+6-8fps)

extern int glizda_timer;            // timer integer
extern int global_timer;            // timer integer
extern BITMAP *mapa;                // used as double buffer for drawing map
extern int sound_on;                // is sound on?
extern int music_on;                // is music on?
extern char high_scores_view_name[100]; // current name of episod for which
extern int high_scores_view_place;      // which highscore to hi-lite

#endif

