/****************************************************
 * Project:   Glizda Game
 * FILE:      agui.h
 * Author:    Andrew Deren
 * Date:      1/2/98
 * Length:    239
 ****************************************************/

#ifndef __AGUI_H
#define __AGUI_H

#include "glizda.h"

/**************************** procedures **************************/
//do the color selection dialog
int do_color_dialog(int tx = 0, int ty = 0, int c=0);
int input_box(char *title, char *message, char *input);

void textout_right(BITMAP *b, FONT* f, char *string, int x, int y, int color);

/**************************** frame_object ***********************/
//frame constants
#define NO_FRAME 0
#define PANEL_RAISED_FRAME 1
#define PANEL_SUNKEN_FRAME 2
#define PANEL_RIDGE_FRAME 3
#define PANEL_GROOVE_FRAME 4

class frame_object : public dialog_object {
protected:
   int type;      //type of frame
public:
   frame_object(int t) { SetFrameType(t);}   //constructor
   virtual void msg_draw(void);              //draw frame
   virtual void SetFrameType(int t) {type = t;}     //set new frame type
   virtual int GetFrameType(void) {return type;}    //got what is the frame
};
/*************************** label_object *************************/
enum ORIENTATION {LEFT_JUSTIFY, CENTER_JUSTIFY, RIGHT_JUSTIFY};
#define DEFAULT_ORIENTATION LEFT_JUSTIFY

class label_object : public text_object {
protected:
   char *string;
   int orientation;
public:
   label_object(char *text = NULL, int o = DEFAULT_ORIENTATION);
   ~label_object(void);
   virtual void msg_draw(void);
   virtual void set_text(char *text);
   virtual void set_orientation(int o = DEFAULT_ORIENTATION);
};


/***************************** bitmap_radio_object *******************/
class bitmap_radio_object : public radio_button_object {
protected:
   BITMAP *bitmap;   //bitmap to be displayed
public:
   bitmap_radio_object(BITMAP *b = NULL, int g = 1); //b is bitmap and g is group number
   virtual int want_focus(void) {return FALSE;}      //does not want focus
   virtual void msg_draw(void);                      //draw object
   virtual void msg_gotmouse(void) {redraw();}       //when got mouse the object
                                                     //is redrawn
   virtual void msg_lostmouse(void) {redraw();}
   virtual void set_bitmap(BITMAP *b) {bitmap = b;}  //change the bitmap
   virtual BITMAP *get_bitmap(void) {return bitmap;} //get the bitmap
};

/*************************** color_select_object *******************/
//draws 16x16 squares with all the colors
class color_select_object : public dialog_object {
protected:
   int current_color;   //currently selected color
   int mx, my;          //mouse locations
   char tcolor[4];      //text with current color
   text_object *t_object;      //pointer to text object that displayes current color
public:
   color_select_object(int c = 0);  //constructor; c is currently selected color
   virtual void msg_draw(void);     //draw object
   virtual void msg_click(void);    //handle click
   virtual int get_color(void) {return current_color;}   //get color
   virtual void set_color(int c) {current_color = c;}    //set current color

   //set text_object that will display which color is selected
   virtual void set_text_object(text_object *t) {t_object = t; t_object->set_text(tcolor);}
   //get text object
   virtual text_object *get_text_object(void) {return t_object;}
};

/******************************* map_object *************************/
class MapObject : public dialog_object {
protected:
   int mx, my;       //mouse x and y
   int current_x, current_y; //current square
   int grid_on;      //is grid on?
   int grid_color;   //color of grid
   BITMAP *map_bitmap;       //map bitmap used for drawing as double buffer
   label_object *location;
public:
   MapObject(void);
   ~MapObject(void);
   virtual void msg_draw(void);  //draw object
   virtual void msg_click(void); //handle click
   virtual bool msg_wantfocus(void) {return FALSE;}   //object does not want focus
   virtual void msg_gotmouse(void);         //when mouse enters object
   virtual void msg_lostmouse(void);        //when mouse leaves object
   virtual void msg_idle(void);             //msg idle
   virtual void GridOn(bool g) {grid_on = g;}     //set the grid
   virtual void DrawGrid(void);                   //draw grid
   virtual void SetTextObject(label_object *l) {location = l;}
   int get_gridcolor(void) {return grid_color;}
   void set_gridcolor(int g) {grid_color = g; redraw();}
};

/**************************** win_button_object **********************/
class win_button_object : public button_object {
protected:
   int (*new_click_proc)(void);
public:
   win_button_object(char *t, int sh, int e) : button_object(t, sh, e) {}
   win_button_object(char *t, int sh, int e, int (*proc)(void))
      : button_object(t, sh, e) {set_click_proc(proc);}
   virtual void msg_gotmouse(void) {redraw();}
   virtual void msg_lostmouse(void) {redraw();}
   virtual void msg_click(void);
   virtual void set_click_proc(int (*proc)(void)) {new_click_proc = proc;}
   virtual bool HasMouse(void) {
      if (mouse_x > x() && mouse_x < x2() && mouse_y > y() && mouse_y < y2())
         return TRUE;
      else return FALSE;
   }
};

/**************************** bitmap_button_object *****************/
class bitmap_button_object : public win_button_object {
protected:
   BITMAP *bitmap;
   int frame;
   char text[25];
   BITMAP *pop_up;
   BITMAP *pop_up_bg;
public:
   bitmap_button_object(BITMAP *b);
   bitmap_button_object(BITMAP* b, int (*proc)(void), char *t=NULL);
   void set_bitmap(BITMAP *b) {bitmap = b;}
   BITMAP *get_bitmap(void) {return bitmap;}
   virtual void msg_draw(void);
   char *get_text(void) {return text;}
   void set_text(char *new_text);
   virtual void msg_gotmouse(void);
   virtual void msg_lostmouse(void);
};

/**************************** font_button_object *****************/
class font_button_object : public win_button_object {
// fg holds color of the font when is not selected and not has mouse
// bg holds color of the font when is selected
// d1 holds color of the font when has mouse over
protected:
   FONT *button_font;
   char button_text[25];
   int col_has_mouse;
   int col_selected;
   int col_else;
public:
   font_button_object(char *t, int (*proc)(void), FONT *f=font);
   void set_font(FONT *f) {button_font = f;}
   void set_text(char *t) {if (t) strcpy(button_text, t);}
   char *get_text(void) {return button_text;}
   virtual void msg_draw(void);
};

/**************************** integer_text_object *******************/
class integer_text_object : public text_object {
protected:
   char text[15];
   int *integer;
public:
   integer_text_object(int *pointer):text_object(text) {
      set_pointer(pointer);
      sprintf(text, "%d", *integer);
   }
   virtual void set_pointer(int *pointer) {integer = pointer;}
   virtual void msg_draw(void) {
      sprintf(text, "%d", *integer);
      text_object::msg_draw();
   }
};
/****************************** texture_button_object ****************/
class texture_button_object : public win_button_object
{
protected:
   BITMAP *texture;
   char text[25];
   FONT *b_font;
public:
   texture_button_object(char *t, BITMAP *tex = NULL, FONT *f = font, int (*proc)(void)=NULL)
        : win_button_object(NULL, 0, 0, proc)
   {
      texture = tex;
      set_text(t);
      set_font(f);
   }
   BITMAP *get_texture(void) {return texture;}
   void set_texture(BITMAP *tex) {texture = tex;}
   void set_font(FONT *f) {b_font = f;}
   void set_text(char *t) {if (t) strcpy(text, t);}
   char *get_text(void) {return text;}
   virtual void msg_draw(void);
};
/******************************* trans_text_object ********************/
class texture_text_object : public text_object {
protected:
   FONT *object_font;
   BITMAP *texture;
public:
   texture_text_object(char *t, BITMAP *tex = NULL, FONT *f=font);
   void set_texture(BITMAP *tex) {texture = tex;}
   void set_font(FONT *f) {object_font = f;}
   virtual void change_text(char *t) {text = t; redraw();}
   virtual void msg_draw(void);
};
/***************************** frame_bitmap_object *******************/
class frame_bitmap_object : public dialog_object {
protected:
   BITMAP *frame;
public:
   frame_bitmap_object(BITMAP *f) : dialog_object() {
      set_frame(f);
   }
   virtual void set_frame(BITMAP *f) {frame =f ;}
   virtual void msg_draw(void) {
      stretch_sprite(screen, frame, x(), y(), w(), h());
      _redraw = FALSE;
   }
};
#endif
