// GISMO V2.3
// written by Karl-Wilhelm Haase
// copyright 2006
// car.nickel@freenet.de

# include "GI_graphics.h" 
# include "GI_utils.h"
# include "GI_ball.h" 
# include "GI_init.h"
# include "GI_finale.h"
# include "GI_checks.h"
# include "GI_gmeter.h"
# include "G.h"

void Finale()     
{      
		play_midi((MIDI *)data[Z_europe].dat, TRUE);
		clear_MBoard();
		if(Finale_Shapecrash())	
			{
			blit(screenbuffer1,screen,GMeter[0]+10,GMeter[1],GMeter[0]+10,GMeter[1],11,GMeter[3]);
			return;
			}
		if(Finale_Rockvanish())
			return;
		blit((BITMAP *)data[shape].dat,screen,64,0,BPX[BAX][1]+32,BPY[BAX][1],32,32);
		if(Finale_Exitwalk())   
			return;
		Finale_UFOstop();
}  

bool Finale_Shapecrash()
{
		int update;
		int action;
		BITMAP *buffer;
		buffer = create_bitmap(64,64); 
		
		clear(buffer3);
		
		for(int x=0;x<64;x++)
			for(int y=0;y<64;y++)
				if(getpixel(buffer2,x,y))
					putpixel(buffer3,x,y,41);
		
		blit(buffer2,buffer,0,0,0,0,64,64);
		
		DRAWALL=0;
		update=2;
		action=actionFinaleB;
		for(int i=0;i<50;i++)
			{
			if(i==20)
				{
				GOVER=1; 
				play_sample((SAMPLE *)data[Y_Rockvanish].dat, 255, 120,500, 1);
				update=update_shake;
				action=actionFinaleA;
				}
			if(i>20)
				for (int y=BAY;y!=0;y--)
					{
					for (int x=1; x<BAX+1;x++)
						{
						if (BPC[x][y]==1)
							masked_blit((BITMAP *)data[shape].dat,screenbuffer,489+rand()%10,41+rand()%10,1200-PX+BPX[x][y]+rand()%24,BPY[x][y]+rand()%24,10,10);
						update_Playfield(action,update);
						}
					if(key[KEY_ESC])
						{
						stop_sample((SAMPLE *)data[Y_Rockvanish].dat);
						destroy_bitmap(buffer);
						return 1;
						}
					wait(10);
					}
			if(i<20)
				wait(10);
			if(i%2)
				blit(buffer,buffer2,0,0,0,0,64,64);
			else
				blit(buffer3,buffer2,0,0,0,0,64,64);
		
			timer2=0;
			while(timer2<10)
				update_Playfield(action,update);
			}
		clear(buffer2);
		
		rectfill(screenbuffer,1200-PX+SHP.X,SHP.Y,1200-PX+SHP.X+64,SHP.Y+64,0);
		
		destroy_bitmap(buffer);
		return 0;
}




bool Finale_Rockvanish()
{
		bool flag=0;
		
		if(Blocks_crumble())
			flag=1;
		if(!flag && Blocks_crash())
			flag=1;
		stop_sample((SAMPLE *)data[Y_Rockvanish].dat);    
		return flag;
}

bool Finale_Exitwalk()
{
		int animphase=0; 
		int flag=0;
		int x=BAX; 
		
		DRAWALL=0;
		while (x>0)
			{ 
			if (BPC[x][1]==2)		
				{  
				BPC[x][1]=0;
				while (x!=BAX+1) 
					{  
					for (int i=0;i<32;i=i+4)
						{
						blit(animation,screenbuffer,animphase*32,walk*32,1200-PX+BPX[x][1]+i,BPY[x][1],32,32);
		
						if (++animphase==10) 
							animphase=0; 
						timer1=0;
						while(timer1<20)
							update_Playfield(actionFinaleC);
						if(key[KEY_ESC])
							return 1;
						if(i==8)
							{
							SHP.BX=x;
							SHP.BY=1;
							check_column();  
							}
						}
					x++;
					}
				x++;
				} 
			x--;
			}
		return 0;
}



void Finale_UFOstop()
{
		int fromX;
		int fromY;
		int toX;
		int toY;
		
		BITMAP *buffer;
		buffer = create_bitmap(800,600);
		
		clear(boing1);
		clear(boing);
		blit((BITMAP *)data[texts].dat,boing,0,165+language*30,0,70,160,30);
		blit (screen,buffer,0,0,0,0,800,600);
		
		fromX=700;
		fromY=rand()%300+300;
		toX=rand()%50+50;
		toY=250+rand()%100;
		if(moveto(buffer,fromX,fromY,toX,toY,0,400,0))
			{
			destroy_bitmap(buffer);
			return;
			}
		
		fromX=toX;
		fromY=toY;
		toX=200;
		toY=440;
		if(moveto(buffer,fromX,fromY,toX,toY,0,500,0))
			{
			destroy_bitmap(buffer);
			return;
			}
		
		for(int i=0;i<3;i++)		
			{
			animtimer=0;
			while(animtimer<100)
				{
				blit(buffer,screenbuffer,0,300,0,300,400,300);
				blit(screenbuffer,screenbuffer,900,PY,PX,PY,BAX*32,BAY*32);
				masked_blit((BITMAP *)data[ufo].dat,screenbuffer,210*i,0,toX,toY,210,100);
				wait(10,update_ufo);
				}
			}		
		
		fromX=toX;
		fromY=toY;
		toX=260;
		toY=-150;
		if(moveto(buffer,fromX,fromY,toX,toY,3,500,3))
			{
			destroy_bitmap(buffer);
			return;
			}
		
		for(int j=0;j<3;j++)
			{
			if(j!=1)
				play_sample((SAMPLE *)data[Y_Gismocry].dat, 255, 155,1500, 0);
			for(int i=0;i<4;i++)
				{
				animtimer=0;
				while(animtimer<50)
					{
					if(moveto(buffer,toX,toY,toX,toY,i,100,1))
						{
						destroy_bitmap(buffer);
						return;
						}
					}		
				}	
			}
		
		fromX=toX;
		fromY=toY;
		toX=180;
		toY=5;
		if(moveto(buffer,fromX,fromY,toX,toY,3,200,4))
			{
			destroy_bitmap(buffer);
			return;
			}
		
		fromX=toX;
		fromY=toY;
		toX=300;
		toY=50;
		if(moveto(buffer,fromX,fromY,toX,toY,3,400,4))
			{
			destroy_bitmap(buffer);
			return;
			}
		
		fromX=toX;
		fromY=toY;
		toX=180;
		toY=450;
		if(moveto(buffer,fromX,fromY,toX,toY,3,300,4))
			{
			destroy_bitmap(buffer);
			return;
			}
		
		animtimer=0;
		while(animtimer<200)
			{
			if(moveto(buffer,toX,toY,toX,toY,(3+(animtimer>100)),10,1))
				{
				destroy_bitmap(buffer);
				return;
				}
			wait(10,update_ufo);
			}
		
		fromX=toX;
		fromY=toY;
		toX=190+rand()%20;
		toY=350+rand()%60;
		if(moveto(buffer,fromX,fromY,toX,toY,4,800,3))
			{
			destroy_bitmap(buffer);
			return;
			}
		
		fromX=toX;
		fromY=toY;
		toX=-250;
		toY=rand()%400+200;
		moveto(buffer,fromX,fromY,toX,toY,4,200,2);
		
		animtimer=0;
		while(animtimer<300)
			{
			masked_blit(boing1,screenbuffer,0,0,920,100+animtimer*(600-100)/300,160,160);	
			blit(screenbuffer,screenbuffer,900,PY,PX,PY,BAX*32,BAY*32);
			wait(50,update_ufo);
			if(animtimer>100 && animtimer<250)
				{
				play_sample((SAMPLE *)data[Y_Rowdown].dat, 255, 155,500+animtimer, 0);
				}
			if(animtimer>200)
				GOVER=0;	
			}
		
		destroy_bitmap(buffer);
}
     

bool moveto(BITMAP *buffer, int fromX,int fromY,int toX, int toY,int anim, int time,int flag)
{

		char anima[]={lookUD,lookU,lookUD+1,lookU};
		static float win;
		static float d=20;
		
		if(!flag)
			{
			d=5;
			win=0;
			}
		
		timer2=0;
		while(timer2<time)
			{
			if((flag==3 && fromY+timer2*(toY-fromY)/time<140) || GOVER==2)
				{
				if(GOVER!=2)
					{
					for(int i=0;i<4;i++)
						play_sample((SAMPLE *)data[Y_Rowdown].dat, 255, 155,3000+i*1000, 0);
					GOVER=2;
					}
				clear(boing1);
				pivot_sprite (boing1,boing,80,80,80,80,itofix(win));
				win-=d;
				if(d>0)
					d-=(rand()%8+3)/1000.0;
				else
					d-=0.002;
				}
		
			blit(buffer,screenbuffer,0,0,0,0,800,600);
			blit(screenbuffer,screenbuffer,900,PY,PX,PY,BAX*32,BAY*32);
		
			if(flag==1 || flag==4)
				{
				if(flag==4)
					anim=3;
				masked_blit(animation,screenbuffer,0,anima[anim]*32,BPX[BAX][1],BPY[BAX][1],32,32);
				}
			if(key[KEY_ESC])
				{
				blit(buffer,screen,100,0,100,0,700,600);
				wait(100,2);
				return 1;
				}
			if(flag==4)
				anim=3;
		
			if(flag)
				masked_blit(boing1,screenbuffer,0,0,100,100,160,160);
			masked_blit((BITMAP *)data[ufo].dat,screenbuffer,anim*210,0,fromX-timer2*(fromX-toX)/time,fromY+timer2*(toY-fromY)/time,210,100);
			if(GOVER==2)
				{
				masked_blit((BITMAP *)data[ufo].dat,screenbuffer,1050,0,fromX-timer2*(fromX-toX)/time,fromY+timer2*(toY-fromY)/time+43,31,18);
				}
			wait(10,update_ufo);
		
			if(flag==2)
				play_Gismocry();
			} 
		
		
		return 0;
}	



bool Blocks_crumble()
{
		timer=0;
		while(timer<50)
			{
			for (int y=BAY;y!=0;y--)
				{
				for (int x=1; x<BAX+1;x++)
					{
					if (BPC[x][y]==1)
						masked_blit((BITMAP *)data[shape].dat,screenbuffer,489+rand()%10,41+rand()%10,1200-PX+BPX[x][y]+rand()%24,BPY[x][y]+rand()%24,10,10);
		
					if(key[KEY_ESC])
						return 1;
					}
				timer1=0;
				while(timer1<10)
					update_Playfield(actionFinaleB);
				}
			}
		return 0;
}        

bool Blocks_crash()
{       
		int a;
		
		for (int y=BAY;y!=0;y--)
			{
			for (int x=1; x<BAX+1;x++)
				{
				if (BPC[x][y]==1)
					{
					a =32;
					if (BPC[x][y+1])
						a=16;
					for(int i=0;i<a;i=i+2)
						{     
						masked_blit(screenbuffer,screenbuffer,1200-PX+BPX[x][y],BPY[x][y]+i,1200-PX+BPX[x][y],BPY[x][y]+i+2,32,2);
						rectfill(screenbuffer,1200-PX+BPX[x][y],BPY[x][y]+i,1200-PX+BPX[x][y]+32,BPY[x][y]+i+2,0);
						timer2=0;
						while(timer2<4)
							update_Playfield(actionFinaleC);
						}
					BPC[x][y]=0;	
					if (BPC[x][y+1])
						{
						SHP.BX=x;
						SHP.BY=y;
						column_setdown();  
						}
		
					if(key[KEY_ESC])
						return 1;
					} 
				}
			}        
return 0;
}
