// GISMO V2.3
// written by Karl-Wilhelm Haase
// copyright 2006
// car.nickel@freenet.de


#include "GI_init.h"
#include "GI_utils.h"
#include "GI_graphics.h"
#include "G.h"



bool init_all()
{	
    
		allegro_init(); 
		install_timer(); 
		install_keyboard(); 
		set_color_depth(8);
		
		settings_read();
		
		set_gfx_mode(GFX_AUTODETECT_FULLSCREEN,800,600,0,0);
		
		if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, "") ) 
			{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message("Error initialising sound system\n%s\n", allegro_error);
			return 1;
			}
		data = load_datafile("gismo.dat");    
		if(!data)
			{
			allegro_message("file not found: gismo.dat", allegro_error);
			return 1;
			}
		
		install_Timerfunctions(); 
		createbitmaps();                              
		mirror_anim();       
		configure_bitmaps();    
		
		fontB1 = (FONT*)data[fontA].dat;  
		fontL1 = (FONT*)data[fontB].dat;
		fontL2 = (FONT*)data[fontC].dat;      
		fontL3 = (FONT*)data[fontD].dat;  
		
		create_BlockposTab();       
		return 0;
}   



void install_Timerfunctions()  
{
		LOCK_VARIABLE(ShapeDown);
		LOCK_VARIABLE(timer1);
		LOCK_VARIABLE(timer2);
		LOCK_VARIABLE(updatetimer);
		LOCK_VARIABLE(waitT);
		LOCK_VARIABLE(animtimer);
		LOCK_VARIABLE(SetDelay);
		LOCK_VARIABLE(timer);
		LOCK_VARIABLE(leveltimer);
		
		LOCK_FUNCTION(TIMER1);  
		LOCK_FUNCTION(TIMER2); 
		LOCK_FUNCTION(TIMER3); 
		
		install_int(TIMER1,1); 
		install_int(TIMER2,100);
		install_int(TIMER3,5);
}

void TIMER1()
{
          timer1++; 
		waitT++;  
}                                           
END_OF_FUNCTION (TIMER1);   

   
                                        
void TIMER2()
{
		if (SetDelay) 
			SetDelay--;      
		timer++;                         
		
		if(GAMERUNNING)
			leveltimer++;
}  
END_OF_FUNCTION (TIMER2);  

void TIMER3()
{
		ShapeDown++;  
		timer2++;
		updatetimer++;	
		animtimer++;                          
}                                           
END_OF_FUNCTION (TIMER3);





void createbitmaps()	
{
		buffer2        =	create_bitmap(64,64); 
		buffer3        =	create_bitmap(64,64); 
		screenbuffer   =    create_bitmap(1400,800);
		screenbuffer1  =    create_bitmap(800,600);
		animation 	= 	create_bitmap(1600,2310);
		boing		= 	create_bitmap(160,160);
		boing1		= 	create_bitmap(160,160);
}

void destroybitmaps() 
{
		destroy_bitmap (buffer2); 
		destroy_bitmap (buffer3); 
		destroy_bitmap (screenbuffer);
		destroy_bitmap (screenbuffer1);
		destroy_bitmap (animation);
		destroy_bitmap (boing);
		destroy_bitmap (boing1);
}




void configure_bitmaps()
{
    		int bm[]={curtainT,shape,texts};
		
		for(int i=0;i<4;i++)
			for (int y=0;y<((BITMAP *)data[bm[i]].dat)->h;y++)      
				for(int x=0;x<((BITMAP *)data[bm[i]].dat)->w;x++) 
					{  
					if(getpixel((BITMAP *)data[bm[i]].dat, x, y)==16)
						putpixel((BITMAP *)data[bm[i]].dat,x,y,0);
		
					if (i==1)    
						if(getpixel((BITMAP *)data[bm[i]].dat, x, y)==44)
							putpixel((BITMAP *)data[bm[i]].dat,x,y,16);
					}
		
		for (int y=0;y<(animation->h);y++)      
			for(int x=0;x<(animation->w);x++) 
				{  
				if(getpixel(animation, x, y)==16)
					putpixel(animation,x,y,0);
				}
}



ANIMATION ANIM[] = { 
		0,	a_stand,		1,		12,  	1,   12, 		3,   0,
		2,	a_wave1,		1,		26,		11, 	18, 		5,	1,
		4,	a_wave2,		1,		26, 		6,	18, 		5,	1,
		6,	a_wait1,		1,		22,		2,	18,		3,	1,
		8,	a_wait2,		1,		45,		4,	45,		1,	0,
		10,	a_wait3,		1,		10,		3,	7,		10,	3,
		12,	a_lookU,		0,		2,		1,   2,		10,  10,
		14,	a_lookD,		0, 		6,		3,	4,		10,	10,
		16,	a_lookS,		0,		2, 		1,	2,		10,	10,
		18,	a_lookS1,		0,		2,		1,	2,		10,	10,
		20,  a_lookUD,		0,		2,		1,	2,		10,	10,
		22,  a_lookDD,		0,		2,		1,	2,		10,	10,
		24,	a_jump,		1, 		22,		5, 	19,  	5,	1,
		26,	a_turn,		1,		34,		9,	25, 		5,	2,
		28,	a_morph,		1,		35,		14,	23,		10,	1,
		30,	a_cheeky,		1,		38, 		16,	24, 		6,	1,
		32,	a_juggler,	1,		28, 		11,	16, 		10,	2,
		34,	a_ear1,		1,		34,		19,	26,		5,	1,
		36,	a_noBall,		1,		38,		15,	23,		8,	1,
		38,	a_knee,		1,		26,		10,	18,		15,	3,
		40,	a_ball,		1,		22,		5,	17,		15,	5,
		42,	a_bow,		1,		21, 		8,	17, 		3,	2,
		44,	a_walk,		0,		10,		1,	10,		10,	1,
		46,	a_headstand,	1, 		38,		13,	26,		5,	2,
		48,	a_hammer,		1,		22,		9,	14,		15,	5,
		50,	a_goodBy,		1,		39,		12,	26,		10,	5,
		52,	a_ear2,		1,		32,  	15,	20,		5,	2,
		54,	a_levi,		1,		50,		29,	32,		10,	3,
		56,	a_clap,		1,		32, 		9,	26,		5,	2,
		58,	a_change1,	1,		40,		0,	0,		1, 	0,
		60,	a_change2,	1,		40,		0,	0,		1,	0,
		62,	a_shake,		1,		30, 		7,	26,		1,	5,
		64,	a_wc,		1,		44,		21,	26,		10,	5,
		66,  a_whisper1,	1,		26,		11,	18,		10,	100,
		68,  a_whisper2,	1,		26,		11,	18,		10,	100,
		70, 	a_rain,		0,		21,		18,	21,		10,	10000,
		100,  0,			0,	0,	0,	0,	0,	0  
		};


void mirror_anim()
{    
		int i=0;
		
		BITMAP *buffer;
		
		buffer= create_bitmap(32,32);
		
		while(ANIM[i].sequence!=100)
			{
			if(ANIM[i].add)
				{
				blit((BITMAP *)data[a_stand].dat,animation,0,0,0,i*64,128,32);
				blit((BITMAP *)data[a_stand].dat,animation,0,0,32,i*64,128,32);
				blit(animation,animation,0,0,(ANIM[i].lengh-4)*32,i*64,128,32);
				}
			blit((BITMAP *)data[ANIM[i].name].dat,animation,0,0,128-128*(!ANIM[i].add),i*64,((BITMAP *)data[ANIM[i].name].dat)->w,((BITMAP *)data[ANIM[i].name].dat)->h);
		
			for(int j=0;j<ANIM[i].lengh+1;j++)
				{
				blit(animation,buffer,j*32,i*64,0,0,32,32);
				draw_sprite_h_flip(animation,buffer,j*32,i*64+32);
				}
			i++;
			}
		destroy_bitmap(buffer);
}


void build_Diamond()
{
		clear (buffer2);
		blit ((BITMAP *)data[shape].dat, buffer2,260,0,0,0,32,32);       
		SHP.C[0]=5;
		SHP.C[1]=0;
		SHP.C[2]=0;
}




 		
void create_PossibilityTab(bool f)
{
		int p1,p2,w1,w2;
		char w_value[]={20,10,15,0,0,15,10,0,0,0,0,0,0,0};
		static float w[15];
		
		if(f)
			{
			for(int i=0;i<14;i++)
			w[i]=w_value[i];
			}
		
		float wp[14];
		int G=400;
		float sum=0;
		int k;
		
		for(int i=0;i<14;i++)
			sum+=w[i];
		for(int i=0;i<14;i++)
			wp[i]=w[i]*G/sum;
		
		k=1;
		
		for(int i=0;i<400;i++)
			possTab[i]=0;
		
		for(int i=0;i<14;i++)
			{
			for(int j=0;j<wp[i];j++)
				{
				possTab[k]=i;
				k++;
				}	
			}
		possTab[0]=k-1;
		
		for(int i=0;i<500;i++)
			{
			p1=rand()%possTab[0]+1;
			p2=rand()%possTab[0]+1;
			w1=possTab[p1];
			w2=possTab[p2];
			possTab[p1]=w2;
			possTab[p2]=w1;
			} 
		
		if(w[0]>2)
			w[0]=w_value[0]-1*DAT.level;
		if(w[1]>2)
			w[1]=w_value[1]-1*DAT.level;
		w[2]=w_value[2]+0.5*DAT.level;
		w[3]=w_value[3]+1*DAT.level;
		w[4]=w_value[4]+1*DAT.level;
		w[5]=w_value[5]+0.5*DAT.level;
		if(w[6]>2)
			w[6]=w_value[6]-1*DAT.level;
		w[7]=w_value[7]+1*DAT.level;
		w[8]=w_value[8]+1*DAT.level;	
		w[9]=w_value[9]+1*DAT.level;	
		w[10]=w_value[10]+1*DAT.level;	
		w[11]=w_value[11]+0.3*DAT.level;	
		w[12]=w_value[12]+0.3*DAT.level;	
		w[13]=w_value[13]+0.3*DAT.level;

	

}



	 				
void create_BlockposTab()
{	
		for (int y=1;y<BAY+1;y++)
			{	
			for (int x=1;x<BAX+1;x++)
				{	
				BPX[x][y]= PX+(x-1)*32;
				BPY[x][y]= PY+(BAY-y)*32;	
				Bpy[x][y]=0;
				}
			}
}

 
void prints(int x,int y,int v)
{	 
		textprintf_ex(screen, font, x, y, 11,1,"%d  ",v);
}

void printf(int x,int y,float v)
{	 
		textprintf_ex(screen, font, x, y, 11,1,"%3f  ",v);
}

void show_Message(char *te ,int zeil)
{
		int col=-1;
		if(TUT)
			col=10;
		textout_centre_ex(screenbuffer,fontL1,te,MBoard[0]+(MBoard[2]/2),MBoard[1]+8+25*zeil,col,-1);
}

void show_MessageV(char *te ,int v,int zeil)
{
		textprintf_centre_ex(screenbuffer,fontL1,MBoard[0]+(MBoard[2]/2),MBoard[1]+13+25*zeil,-1,-1,te,v);
}


void play_Rowdown()
{
		play_sample((SAMPLE *)data[Y_Rowdown].dat, 255, 155,400, 0);
}

void play_Setheavy()
{
		play_sample((SAMPLE *)data[Y_Rowdown].dat, 255, 155,2000, 0);
}

void play_Setlow()
{
		play_sample((SAMPLE *)data[Y_Setlow].dat, 255, 155,2000, 0);
}

void playROT()
{
		play_sample((SAMPLE *)data[Y_Setlow].dat, 155, 155,1000, 0);
}    

void play_Gismocry()
{
	 	play_sample((SAMPLE *)data[Y_Gismocry].dat, 255, 155,1000, 0);
}    
      


void row_destroy(int row,int combo)
{  	
		bool shaker=0;
		
		int multiplier[]={1,1,2,3,3,6,4,10,5,15};
		char *t[]={
		"Hey!","you got a Row!","Rowscore: %d Points","Hey!","du hast eine Reihe!","Punktzahl fuer Reihe: %d Punkte",
		"Yeah!","a Double-Row!","Total Rowscore: %d Points","Hey!","eine Doppelreihe!","Gesamtpunkte Reihen: %d Punkte",
		"Incredible!","a Triple-Row!","Total Rowscore: %d Points","Unglaublich!","eine Dreierreihe!!","Gesamtpunkte Reihen: %d Punkte",
		"You are cheating!","a Quadruple-Row!","Total Rowscore: %d Points","Das ist nicht zu fassen!","eine Viererreihe!!","Gesamtpunkte Reihen: %d Punkte",
		"A","FIVE ROW COMBO!","Total Rowscore: %d Points","eine","Fnferreihe!!!","Gesamtpunkte Reihen: %d Punkte"
		};
		
		wait(200,2);
		blit(screenbuffer,screenbuffer1,1200,PY,PX,PY,BAX*32,BAY*32);
		
		for (int i=0;i<32;i++)
			{
			for(int k=0;k<500;k++)
				putpixel(screenbuffer1,BPX[1][row]+rand()%(BAX*32),BPY[1][row]+31-rand()%(33-i),0);    
		
			if(i==10 && !TUT)
				{
				clear_MBoard();
				for (int i=0;i<2;i++)
					show_Message(t[6*combo+language*3+i],1+i);
				show_MessageV(t[6*combo+language*3+2],RowScore*multiplier[combo*2+1],4);
				update_Score(1,0,multiplier[combo*2]*RowScore);
				}
		
			wait(40-i,update_rowdown);
		
			blit(screenbuffer,screenbuffer1,1200,PY,PX,PY+i,BAX*32,(BAY-row)*32);
			blit(screenbuffer,screenbuffer1,1200,PY+(BAY-row+1)*32,PX,PY+(BAY-row+1)*32,BAX*32,row*32);
			}
		
		blit(screenbuffer,screenbuffer,1200,PY,1200,PY+32,BAX*32,(BAY-row)*32);
		rectfill(screenbuffer,1200,PY,1200+BAX*32,PY+32,0);
		for (int y=row;y<BAY;y++)
			{
			for (int x =1;x<BAX+1;x++)
				{
				if ( BPC[x][y+1]) 
					{
					play_Rowdown();
					shaker=1;
					}
				BPC[x][y]=BPC[x][y+1];   
				animSEQ[x][y]=animSEQ[x][y+1];
				animPHA[x][y]=animPHA[x][y+1];
				animREP[x][y]=animREP[x][y+1];
				}
			}
		for(int x=1;x<BAX+1;x++)
			{
			BPC[x][BAY]=0;
			animSEQ[x][BAY]=rand()%18;
			animPHA[x][BAY]=0;
			animREP[x][BAY]=ANIM[animSEQ[x][BAY]/2].repeats-1;
			}
		
		timer1=0;
		while(timer1<400)
			{
			if (shaker)
				wait(20,6);		
			else
				wait(20,2);
			}	    
}	
  


void clear_Score()
{
		DAT.rows=0;	
		DAT.gismos=0;
		DAT.score=0;
		update_Score();
}



void update_Score(int RC, int GN, int SC)
{                   
		static bool flag=0;
		
		DAT.rows+=RC;
		DAT.gismos+=GN;
		DAT.score+=SC;
		
		clear_SBoard();
		clear_DBoard();
		
		char *t[]={"level","Level","rows","Reihen","gismos","Gismos"};
		int value[]={DAT.level,DBoard[1]+33,DAT.rows,DBoard[1]+43+DBoard[3]/4,DAT.gismos,DBoard[1]+33+2*DBoard[3]/4};
		
		for(int i=0;i<3;i++)
			{
			if(!flag)
				{
				textout_ex(screenbuffer,fontL2,t[i*2+language],DBoard[0]+30, value[i*2+1],-1,-1);
				textout_ex(screenbuffer1,fontL2,t[i*2+language],DBoard[0]+30, value[i*2+1],-1,-1);	
		
				drawing_mode(DRAW_MODE_COPY_PATTERN ,(BITMAP *)data[bar2].dat,0,0);
				rectfill(screenbuffer,630,226,731,236,0);
				rectfill(screenbuffer1,630,226,731,236,0);
				solid_mode();
				}
			textprintf_centre_ex(screenbuffer,fontL2,DBoard[0]+130, value[i*2+1],-1,-1,"%d",value[i*2]);
			}
		flag=1;
		textprintf_centre_ex(screenbuffer,fontB1,SBoard[0]+(SBoard[2]/2),SBoard[1]+ 96,-1,-1,"%d",DAT.score);
}


	
void wait(int t,int updateflag)
{
		waitT=0;
		while(waitT<t) 
			{
			if (updateflag)
				update_Playfield(0,updateflag);
			}
}	

			    



void change_Block()
{     
		blit((BITMAP *)data[shape].dat,(BITMAP *)data[shape].dat,blockstyle*32,32,32,0,32,32);
}         

void keys_reset()
{   
		KEYS[0]=82;
		KEYS[1]=83;
		KEYS[2]=85;
		KEYS[3]=17;
		KEYS[4]=23;
}

void settings_read()
{
		push_config_state();
		set_config_file("gismo.cfg");
		language=get_config_int("misc","language", 3);
		blockstyle=get_config_int("misc","blockstyle", 0);
		keyconfig(0);
		if (language <0 || language>3)
			language=3;
		pop_config_state();
}
		
void settings_write()
{
		push_config_state();
		set_config_file("gismo.cfg");
		set_config_int("misc","language", language);
		set_config_int("misc","blockstyle", blockstyle);
		keyconfig(1);
		pop_config_state();
}

void keyconfig(bool flag)
{
		//flag=0 -> read    flag=1 -> write
		
		char *ky[]={"left","right","down","turn_left","turn_right"};
		
		for (int i=0;i<5;i++)
			{
			if(!flag)
				KEYS[i]=get_config_int("keys", ky[i],KEYS[i]);
			else
				set_config_int("keys", ky[i],KEYS[i]);
			}
}
