// GISMO V2.3
// written by Karl-Wilhelm Haase
// copyright 2006
// car.nickel@freenet.de


#include "GI_graphics.h"
#include "GI_init.h"
#include "GI_utils.h"
#include "GI_ball.h"
#include "GI_shape.h"
#include "GI_finale.h"
#include "GI_checks.h"
#include "GI_tut.h"
#include "GI_gmeter.h"
#include "GI_menu.h"

void tutorial()
{
     	int pointer;
		int c=27;
		TUT=1;
		DAT.level=0;
		clear(buffer2);
		clear_Playfield();
		clear_SBoard();
		clear_MBoard();
		show(9999,0,0);   // read chapter first strings


		while(c==27)
			{
			clear_Gismometer();
			clear_MBoard();
			wait(500,2);
			clear_keybuf();
			GM.fuel=0;
			display_Diamond(0);
			pointer=tut_select();
		
			if(pointer<0)
				{
				TUT=0;
				clear_MBoard();
				diamondA=0;
				return;
				}    
		
	beg:
		
		
		
		
			GM.fuel=0;
			display_Diamond(0);
			switch(pointer+1)
				{
				case 1:          
					TUT=1;
					if(show(1,1,1)==27)
						break;
					if(show(1,1)==27)
						break;
					if(show(1,1)==27)
						break;
					if(show(0,1)==27)
						break;
					show(2,0);
					wait(500);
					if(falling_Blocks(3,1))
						break;
					if(show(1,1)==27)
						break;
					break;
		
				case 2:
					TUT=1;
					if(show(1,1,2)==27)
						break;
					show(1,0);
					wait(1000);
					if(falling_Blocks(3,2))
						break;
					if(show(0,1)==27)
						break;
					show(1,0);
					if(falling_Blocks(6,3))
						break;
					if(show(1,1)==27)
						break;
					if(show(0,1)==27)
						break;
					break;
		
				case 3:
					CHANGEALLOWED=1;
					show(0,0,3);
					wait(1000);
					if(falling_Blocks(3,4))
						break;
					show(1,0);
					if(falling_Blocks(2,4))
						break;
					show(1,0);
					if(falling_Blocks(3,4))
						break;
					for(int i=0;i<2;i++)
						{
						show(0,0);
						if (language)
							textout_centre_ex(screenbuffer,font," - Taste - ",MBoard[0]+(MBoard[2]/2),MBoard[1]+8*20,14,-1);
						else
							textout_centre_ex(screenbuffer,font," - any key - ",MBoard[0]+(MBoard[2]/2),MBoard[1]+8*20,14,-1);
						while(!keypressed())
						wait(30,2);
						}
					break;
		
				case 4:
					DRAWALL=0;
					TUT=1;
					CHANGEALLOWED=1;
					show(1,0,4);
					for (int x=1;x<BAX+1;x++)
						BPC[x][1]=2;
					redraw_Blocks();
					update_Playfield();
					wait(500);
					if(falling_Blocks(1,5))
						break;
					check_ball();
					DRAWALL=0;
					show(1,0);
					wait(1000,2);  
					clear_Gismometer();
					for (int x=1;x<BAX+1;x++)
						BPC[x][1]=2;
					redraw_Blocks();
					update_Playfield();
					if(falling_Blocks(1,5))
						break;
					check_ball();
					clear_Gismometer();
					if(show(1,1)==27)
						break;
					BPC[2][5]=3;
					BPC[BAX-1][5]=4;
					redraw_Blocks();
					update_Playfield();
					if(show(0,1)==27)
						break;
					if(show(0,1)==27)
						break;
					if(show(0,1)==27)
						break;
					clear_Playfield();
						BPC[4][1]=3;
					redraw_Blocks();
					update_Playfield();
					if(show(1,1)==27)
						break;
					clear_MBoard();
					TUT=3;
					check_ball();
					BPC[4][1]=3;
					redraw_Blocks();
					wait(500);
					update_Playfield();
					show(0,1);
					blit(screenbuffer,screen,MBoard[0],MBoard[1]+140,MBoard[0],MBoard[1]+140,MBoard[2]*16,10);
					check_ball();
					if(show(1,1)==27)
						break;
					for (int x=1;x<BAX;x++)
						BPC[x][1]=1;
					BPC[BAX][1]=2;
					BPC[BAX][2]=1;
					BPC[BAX-1][2]=1;
					BPC[BAX-2][2]=1;
					BPC[BAX][3]=1;
					BPC[BAX-2][3]=3;
					redraw_Blocks();
					update_Playfield();
					if(show(1,1)==27)
					break;
					clear_MBoard();
					check_ball();
					break;
		
				case 5:
					TUT=4;
					if(show(0,1,5)==27)
						break;
					BPC[2][1]=2;
					BPC[3][1]=2;
					BPC[2][2]=1;
					BPC[3][2]=1;
					BPC[3][3]=3;
					BPC[BAX][1]=2;     
					redraw_Blocks();
					wait(100);
					update_Playfield();
					if(show(1,1)==27)
						break;
					clear_MBoard();
					check_ball();
					if(show(1,1)==27)
						break;
					if(show(1,1)==27)
						break;
					if(show(1,1)==27)
						break;
					if(show(0,1)==27)
						break;
					if(show(0,1)==27)
						break;
					if(show(0,1)==27)
						break;
					clear_Gismometer();
					break;
		
				case 6:         
					TUT=4;
					show(1,0,6);
					wait(1000);
					clear_keybuf();
					for (int x=1;x<BAX+1;x++)
						BPC[x][1]=2;                     
					for (int x=1;x<BAX;x++)
						BPC[x][2]=1;       
					for (int x=1;x<BAX;x++)
						BPC[x][3]=2;       
					for (int x=1;x<BAX;x++)
						BPC[x][4]=1;   
					for (int x=1;x<BAX;x++)
						BPC[x][5]=2;
					for (int x=1;x<BAX-2;x++)
						BPC[x][6]=1;
					BPC[4][4]=2;
					BPC[2][2]=2;
					BPC[5][3]=1;
					BPC[3][1]=1;
					for (int y=6;y<11;y++)
						BPC[4][y]=1;   
					BPC[3][6]=2;
					BPC[5][3]=2;
					BPC[2][7]=4;
					redraw_Blocks();
					while(!keypressed())
						update_Playfield();
					check_ball();
					show(1,0);
					if(falling_Blocks(1,6))
						break;
					if(show(0,1)==27)
						break;
					rectfill(screen, PX, PY, PX+PW, PY+PH, 0);
					build_Shape(0);
					blit(buffer2,screen,0,0,PX+BAX*16-16,PY+100,32,32);
					clear (buffer2);
					if(show(0,1)==27)
						break;
					break;
						
				case 7:
					if(show(2,1,7)==27)
						break;
					if(show(0,1)==27)
						break;
					if(show(0,1)==27)
						break;
					break;
		
				case 8:
					if(show(2,1,8)==27)
						break;
					if(show(0,1)==27)
						break;
					if(show(2,1)==27)
						break;
					if(show(1,1)==27)
						break;
					if(show(1,1)==27)
						break;
					break;
				
				case 9:
					if(show(2,1,9)==27)
						break;
					if(show(0,1)==27)
						break;
					if(show(1,1)==27)
						break;
					if(show(2,1)==27)
						break;
					break;
				}
		clear_keybuf();
		clear_Playfield();
		c=EndOfChapter();
		
		if(c==32)
			goto beg;
		if(c!=27)
			{
			pointer++;
			if(pointer==9)
				{
				c=27;
				clear_MBoard();wait(500,2);
				}
			else
			goto beg;
			}
	}
}


int LFK()
{
		if(key[KEY_ESC])
			return 1;
		clear_keybuf();
		return 0;
}




int show(int zeil, bool f,int chap)
{
   
		static int number=0;
		static int chap_Beg[30];
		
		if (chap)
			{
			clear(buffer2);
			clear_Playfield();
			update_Playfield();
			clear_NBoard();
			clear_SBoard();
			number=chap_Beg[chap-1];
			}

   
		char *strE[]=  
		{    "Hello and Welcome","to the indroduction","of GISMO",".",               
		"Piece to piece, we will"," put all things together,","so you can enjoy the game",".", 
		"GISMO","is a game very similar to","TETRIS,","but there are some differences",".", 
		"You will recognize","the playfield to the left","and the little field at the","upper right corner, where the next","falling shape will be displayed",".",
		"Okay,","let's play a little",".", 
		"There is nothing to explain,","isn't it?","TETRIS greets",".",
		
		"*", 
		
		"Unlike TETRIS","we have only a 2x2-shape","that can hold 3 or 4 tiles",".", 
		"Let's look at this now!","","Look at the shapes","when they hit the ground!",".",  
		"Did you notice the behaviour of the", "shapetiles? They are not fixed!", "If one side of the shape is set", "the other side slides down", "till it sets too!","." ,
		"Let's look again!"," ", "6 blocks will fall",".",
		"It's fun!", "I could look for hours!", ".",
		"Okay! That was a joke!", "but I think","that the principle is clear", "", "Now, it will get interesting!",".",
		
		"*",
		
		"Now let me introduce","a little blue creature,","which is called","....","Gismo",".....",".",
		"Aren't they","lovely","and","sweet?",".",
		"so sweet...","","","so lovely...",".",
		"You should notice,","that these little sweet","lovely creatures","make it hard for you","to build rows and","keep the playfield clean!",".",
		"But, there is a possibility","to get rid of those","little, lovely, sweet creatures!","","Actually, there are two, but...",".",
		
		"*",
		
		"Let me introduce","","The Ball",".",
		"... Wooosh ... ","","and gone they are!","","Watch the replay!",".",  
		"Nice device","this ball,","isn't it",".",
		"There are two","kinds of the ball,","the Rightball","and","the Leftball",".",  
		"which is indicated by the arrow","inside the ball","and simply means","in what direction","the ball will roll first",".",
		"the ball follows a simple rule:","","change direction","one time on a row!",".", 
		"let's visualize this","","look at the ball","and press a key",".", 
		"we have a Rightball, what means that it","rolls first to the right till it bounces","against the wall; here it changes","direction and rolls to the left till it hit","the wall, and because it already changed"," its direction on this row, it dies",".",
		"like explained will the ball change","its direction one time per row","what the following demo","will show for clearness",".",  
		"Demo","","press a key!",".",
		
		"*",
		
		"There is an add to the","playfields right side","we now have to deal with!","",
		"It's called 'Gismometer'","and we will soon see why.",".",
		"Watch the Gismometer","while the demo runs!","","press a key!",".",
		"you will have noted that","the Gismometer was raised","every time a Gismo was","overrolled by the ball",".",
		"the value of the raise is","accumulate to the number","of overrolled Gismos",".",
		"that means that the second Gismo","counts two times the value","of one Gismo, the third Gismo","counts three times the","value of one Gismo and so on",".",
		"an example:","suppose one Gismo's value is 10","than the second Gismo counts: 10+10","what make a total of 30",
		"third Gismo counts: 10+10+10","with a total of 60",".",
		"so: the more Gismos are overrolled","by one ball, the higher is the","raise of the Gismometer","",
		"The same principle goes","for scoring too!",".",
		"Why that all?","What happens if the Gismometer","reaches its maximum?","","That's what the","next chapter is for!",".",
		
		"*",
		
		"OK!","Let's look what will happen if","the Gismometer is full!","","Press a key and watch!",".",
		"?????","","??????????","","??????",".",
		"Beautyful, wasn't it?","","Remember, I mentioned a second","method to get rid of these little","sweet Gismos, earlier!", "Now, that's it!",".",
		"each diamond will have a","random number from 2 to 4","shown inside, which indicates","the influence on the rows","beneath it!",".",
		
		"*",
		"key settings","(default)",".",
		"leftarrow  - shape left","rightarrow  - shape right","q - shape turns anticlockwise","w - shape turns clockwise","downarrow  - accelerates shapefall",".",
		"","p - pauses game","b - changes blockstyle","ESC - quits game",".",
		"*",
		
		"scoring",".",
		"overrolled Gismos (with one ball):","the first: 5 points","the second: 10 points","the third: 15 points","the fourth: 20 points ... and so on...",".",
		"Gismo cleared by the diamond:", "20 points each",".",
		"1 row: 10 points","2 row combo: 30 points","3 row combo: 60 points","4 row combo: 100 points",".",
		"bonus score:","2 row combo: level -1","8 Gismo combo: level -3","10 Gismo combo: +100 points",".",
		"*",
		"misc",".",
		"","the animations in the main menu when","selecting an item can be skipped by","pressing the number of the menu item;","e.g. KEY 1 for 'start game'",".",
		"KEY F12 quits from main menu","or while game runs to the desktop",".",
		
		"Have fun!",".",
		"*",
		"+",
     
		};    
     
     
		char *strD[]=  
		{    "Hallo und Willkommen","zur Vorstellung von","","GISMO",".",               
		"St%ck f%r St%ck","werden wir alles durchgehen,","so dass Du das Spiel","genie$en kannst.",".", 
		"GISMO","&hnelt dem Spiel","TETRIS,","aber es gibt ein paar Unterschiede!",".", 
		"Du kannst links das","Spielfeld und oben rechts davon","das kleine Feld, in dem der n&chste","fallende Block angezeigt wird,","erkennen.",".",
		"Gut,","lass uns etwas spielen!",".", 
		"Da gibt's nichts mehr","hinzuzuf%gen, oder?","TETRIS l&sst gr%$en!",".",
		
		"*", 
		
		"Anders als bei TETRIS","haben wir hier einen 2x2-Block,","der aus 3 oder 4 Einzelteilen","bestehen kann.",".", 
		"Lass uns das mal anschauen!","","Achte auf die Bl#cke,","wenn sie am Boden auftreffen!",".",  
		"Hast Du erkannt, wie sich die","Blockteile verhalten? Sie sind nicht","miteinander fixiert! Wenn eine","Seite des Blocks aufsetzt,","gleitet die andere Seite weiter ab,","bis auch sie aufsetzt!","." ,
		"Lass uns das nochmal anschauen!"," ", "6 Blocks werden herabfallen",".",
		"Macht Spass, oder?", "Ich k#nnte Stunden lang","zuschauen!", ".",
		"Okay! Das war ein Witz!", "Aber ich denke,","dass das Prinzip jetzt klar ist.", "", "Nun wird's interessant werden!",".",
		
		"*",
		
		"Nun m#chte ich eine kleine","blaue Kreatur vorstellen,","die","Gismo","genannt wird.",".",
		"Sind sie nicht","s%$","und","niedlich?",".",
		"soo s%%%$...","","","so niedlich...",".",
		"Du solltest erkennen,","dass diese s%$en, niedlichen","Dinger es dir ziemlich schwer","machen, Reihen zu bilden,","um das Spielfeld frei zu halten!",".",
		"","Aber, es gibt eine M#glichkeit sich","dieser kleinen, s%$en, niedlichen","Dinger zu entledigen!","Eigentlich gibt es zwei, aber...",".",
		
		"*",
		
		"Lass mich","den BALL","vorstellen!",".",
		"... Wooosh ... ","","und weg sind sie!","","Guck Dir die Wiederholung an!",".",  
		"Nettes Spielzeug","dieser Ball, oder?",".",
		"Es gibt zwei Arten","des Balls, und zwar","den Rechtsball","und","den Linksball",".",  
		"was durch den Pfeil im Innern","des Balls angezeigt wird,","und einfach angibt, in welche","Richtung der Ball zuerst rollen wird",".",
		"der Ball folgt einer einfachen","Regel:","","wechsle auf einer Reihe","einmal die Richtung!",".", 
		"Lass uns das mal verbildlichen.","","Achte auf den Ball","und dr%cke eine Taste!",".", 
		"Wir haben einen Rechtsball, was hei$t,","dass er zuerst nach rechts rollt, bis er an","die Wand prallt; jetzt wechselt er die",
		"Richtung und rollt nach links bis zur","Wand, und weil er schon einmal die Rich-","tung wechselte, geht ihm die Luft aus!",".",
		"Wie erkl&rt, wechselt der Ball","einmal auf jeder Reihe die Richtung,","was die folgende Demo","zur Verdeutlichung zeigt",".",  
		"Demo","","dr%cke eine Taste!",".",
		
		"*",
		
		"Auf der rechten Seite des Spielfeldes","gibt es einen Zusatz,","mit dem wir uns jetzt besch&ftigen!","",
		"Er wird 'Gismometer' genannt,","und wir werden gleich sehen warum.",".",
		"Achte auf den Gismometer","w&hrend die Demo l&uft!","","dr%cke eine Taste!",".",
		"Du wirst bemerkt haben, dass","sich der Gismometerstand jedes","Mal, wenn der Ball einen Gismo","%berrollte, erh#hte",".",
		"Der Wert der Erh#hung","ist akkumulativ zur Anzahl","an %berrollten Gismos",".",
		"was hei$t, dass der zweite Gismo","doppelt so viel z&hlt wie","ein Gismo, der dritte Gismo z&hlt","3 mal so viel wie ein Gismo usw.",".",
		"ein Beispiel:","angenommen ein Gismo z&hlt 10,","dann z&hlt der zweite: 10+10","was in der Summe 30 ergibt",
		"der dritte Gismo z&hlt: 10+10+10","was summasumarum 60 ergibt",".",
		"Also: je mehr Gismos von einem","Ball %berrollt werden, um so mehr","steigt der Stand im Gismometer","",
		"Das gleiche gilt auch f%r die","Punktvergabe!",".",
		"Wof%r das alles?","Was passiert, wenn der Gismometer","gef%llt ist?","","Das wird im n&chsten Kapitel","behandelt werden!",".",
		
		"*",
		
		"Gut,","lass uns schauen, was passiert,","wenn der Gismometer gef%llt ist!","","Dr%cke eine Taste und schau!",".",
		"?????","","??????????","","??????",".",
		"Sch#n, oder?","","Ich erw&hnte ja schon","eine weitere Methode, um sich","dieser s%$en Dinger zu entledigen!", "Nun, das ist sie!",".",
		"","Jeder Diamant hat eine Zahl zwischen","2 und 4 in sich, die angibt,","auf wie viele Reihen er einwirkt!",".",
		
		"*",
		
		"Tastenbelegung","(Voreinstellung)",".",
		"Cursor links  - Block nach links","Cursor rechts  - Block nach rechts","q - Block rotiert links","w - Block rotiert rechts","Ab-Pfeil  - erh#ht Fallgeschwindigkeit",".",
		"","p - Spiel pausieren","b - ver&ndert das Blockaussehen","ESC - beendet Spiel",".",
		"*",
		
		"Punktwertung",".",
		"%berrollte Gismos (mit einem Ball):","der Erste: 5 Punkte","der Zweite: 10 Punkte","der Dritte: 15 Punkte","der Vierte: 20 Punkte ... usw...",".",
		"Gismos vom Diamand weggeplopt:","20 Punkte pro Gismo",".",
		"1 Reihe: 10 Punkte","2 Reihen-Combo: 30 Punkte","3 Reihen-Combo: 60 Punkte","4 Reihen-Combo: 100 Punkte",".",
		"Bonuspunkte:","2 Reihen-Combo: Level -1","8 Gismo-Combo: Level -3","10 Gismo-Combo: +100 Punkte",".",
		
		"*",
		"sonstiges",".",
		"die Animation im Hauptmen%, wenn ein","Punkt angew&hlt wird, kann durch","Dr%cken der Nummer des Men%punktes","%bersprungen werden;","z.B Taste 1 f%r 'starte Spiel'",".",
		"Taste F12 beendet Programm sofort,","wenn im Hauptmen% oder w&hrend","eines Spiels gedr%ckt",".",
		"Viel Spa$!",".",
		"*",
		
		
		"+",

		};    
     
     
     
		if (zeil==9999)
			{
			chap=1;
			int i=0;
			do
				{
				if ((language && strD[i]=="*") || (!language && strE[i]=="*"))
					{
					chap_Beg[chap]=i+1;
					chap++;
					}
				i++;
				}
			while((language && strD[i]!="+") || (!language && strE[i]!="+"));
		
			return 0;
			}

  
   
		clear_MBoard();
		clear_keybuf();
		
		do      
			{
			if (language)
				show_Message(strD[number],zeil);
			else
				show_Message(strE[number],zeil);
		
			number++;zeil++;
			}
		while ((language && strD[number]!=".")||(!language && strE[number]!="."));
		
		number++;
		
		
		if (f)
			{
			if (language)
				textout_centre_ex(screenbuffer,font," - Taste - ",MBoard[0]+(MBoard[2]/2),MBoard[1]+8*20,14,-1);
			else
				textout_centre_ex(screenbuffer,font," - any Key - ",MBoard[0]+(MBoard[2]/2),MBoard[1]+8*20,14,-1);
			blit(screenbuffer,screen,MBoard[0],MBoard[1],MBoard[0],MBoard[1],MBoard[2],MBoard[3]);
			return (readkey()&255);
			}
		blit(screenbuffer,screen,MBoard[0],MBoard[1],MBoard[0],MBoard[1],MBoard[2],MBoard[3]);
}




int EndOfChapter()
{
		clear_keybuf();
		clear_MBoard();
		
		if (language)
			{
			textout_centre_ex(screenbuffer,fontL1,"ESC - zur%ck zum Tutorialmen%",MBoard[0]+(MBoard[2]/2),MBoard[1]+45,11,-1);
			textout_centre_ex(screenbuffer,fontL1,"Leertaste - wiederhole Kapitel",MBoard[0]+(MBoard[2]/2),MBoard[1]+75,11,-1);
			textout_centre_ex(screenbuffer,fontL1,"andere Taste - n&chstes Kapitel",MBoard[0]+(MBoard[2]/2),MBoard[1]+105,11,-1);
			}
		else
			{
			textout_centre_ex(screenbuffer,fontL1,"ESC - back to Tutorial Menu",MBoard[0]+(MBoard[2]/2),MBoard[1]+45,11,-1);
			textout_centre_ex(screenbuffer,fontL1,"SPACE - repeat chapter",MBoard[0]+(MBoard[2]/2),MBoard[1]+75,11,-1);
			textout_centre_ex(screenbuffer,fontL1,"any other Key - next chapter",MBoard[0]+(MBoard[2]/2),MBoard[1]+105,11,-1);
			}
		clear_Gismometer();
		wait(500,2);  
		int key = (readkey()&255);   
		
		return key;
}







int falling_Blocks(int NumberOfBlocks,int action)
{
    
    	int fl=0;
	int count=0;
     int Blockcount=NumberOfBlocks;
     bool ROTflag=0;
	int LRflag=0;
       
		for(int j=0;j<NumberOfBlocks;j++)
			{
			SHP.disconnect=0; 
			SHP.speed=4; 
			if(action==1)
				{
				for(int i=0;i<8;i++)
					SHP.C[i]=1;
				}
			if (action==2 )
				{
				SHP.C[0]=1;SHP.C[1]=0;SHP.C[2]=1;SHP.C[3]=1;
				SHP.C[4]=0;SHP.C[5]=1;SHP.C[6]=1;SHP.C[7]=1;
				}
		
			if (action==3)
				{
				SHP.speed=6;
				blit(screenbuffer1,screenbuffer,MBoard[0],MBoard[1]+140,MBoard[0],MBoard[1]+140,MBoard[2],20);
				if (language)
					textprintf_centre_ex(screenbuffer,fontL1,MBoard[0]+(MBoard[2]/2), MBoard[1]+140,30,-1,"noch fallende Blocks: %d",Blockcount--);
				else
					textprintf_centre_ex(screenbuffer,fontL1,MBoard[0]+(MBoard[2]/2), MBoard[1]+140,30,-1,"blocks to fall: %d",Blockcount--);
		
				if(TUT!=2) 
					{
					TUT=2;
					init_Shape(0);
					}
				else
					{
					for (int i=0;i<4;i++)  
						SHP.C[i]=SHP.C[i+4];
					}
				TUT=2;
				init_Shape(4);
				build_Shape(0);
				}
		
			if (action==4)
				{
				TUT=1;
				SHP.speed=2;
				SHP.C[0]=2;SHP.C[1]=1;SHP.C[2]=0;SHP.C[3]=1;
				SHP.C[4]=1;SHP.C[5]=0;SHP.C[6]=1;SHP.C[7]=2;
				}
			if (action==5)
				{
				SHP.speed=2;
				SHP.C[0]=3;SHP.C[1]=1;SHP.C[2]=0;SHP.C[3]=1;
				SHP.C[4]=0;SHP.C[5]=0;SHP.C[6]=0;SHP.C[7]=0;
				}
		
			if (action==6)
				{    
				SHP.speed=2;
				SHP.C[0]=5;SHP.C[1]=0;SHP.C[2]=0;SHP.C[3]=3;   
				build_Shape(0);
				}
		
			if (action!=3)
				build_Shape(0);
			init_Shape(4);
		
			SHP.BX= BAX/2; 
			SHP.BY = BAY;
			SHP.X= BPX[SHP.BX][SHP.BY]; 
			SHP.Y= BPY[SHP.BX][SHP.BY]; 
		
		
			do
				{
				if (LFK())
					return 1;
				int LRC=2;
				if ((action==3 || action==4) && (rand()%3==1))
				LRC=rand()%2+1;
		
				if((action==3 || action==4) && SHP.Y>120 && !ROTflag)
					{
					ROTflag=1;
						int RotC=rand()%3+1;
							for (int i=0; i<RotC;i++)
								{
								build_Shape(1,0);
								update_Playfield();
								wait(70);
								}
					}         
				LRC=1;        
				if (((SHP.Y>50 && LRflag==0) || (SHP.Y>130 && LRflag==1 && LRC))&& action!=5 && action!=6 )
					{
					if(LRflag)
						{
						LRC=1;
						if ((action==3 || action==4)  && (LRflag==1))
							{
							LRC=rand()%2;
							if (!LRC)
								LRflag=3;
							}
						}
					if(LRC)
						{
						LRflag++;
						switch (count)
							{
							case 0:
								Shape_LeftRight(1);
								break;
							case 1:
								Shape_LeftRight(-1);
								break;
							}
						}
					}
		
				Shape_LeftRight();  
				Shape_MoveDown();
		
				if (timer1>250 )         
					{
					timer1=0;                       
					build_Shape(0);
					}
				wait(5,2);
			}
		while (!Shape_CheckUnderground());
		
		
		if(++count>2)
			count=0;
		ROTflag=0;
		LRflag=0;
		}
		wait(100,2);
return 0;
}


int tut_select()
{
		int pointer=0;
		FONT *fo;
		char *t[]=  {
		"Indroduction",
		"Shape setdown",
		"Gismo appears",
		"the Ball",
		"the Gismometer",
		"the Diamond",
		"Keys",
		"Scoring",
		"misc",
		"Einf%hrung",
		"Blockverhalten",
		"Gismo",
		"der Ball",
		"der Gismometer",
		"der Diamant",
		"Tastenbelegung",
		"Punktwerte",
		"sonstiges",
		};
		
		
		while(1==1)
			{
			rectfill(screenbuffer, PX, PY, PX+PW-1, PY+PH-1, 0);
		
			for(int i=0;i<9;i++)
				{
				fo=fontL1;
				if (i==pointer)
					fo=fontL2;
				textout_centre_ex(screenbuffer,fo,t[language*9+i],CENTER,PY+20+i*30,-1,-1);
				}             
		
			if(language)
				textout_centre_ex(screenbuffer,fontL1,"ESC - zur%ck",CENTER,PY+360,14,-1); 
			else
				textout_centre_ex(screenbuffer,fontL1,"ESC - back",CENTER,PY+360,14,-1);  
			blit(screenbuffer,screen,PX,PY,PX,PY,PW,PH);
			wait(50);
			clear_keybuf();
		
			if(key[KEY_DOWN] && timer1>150)
				{
				menusound();
				if(++pointer>8)
					pointer=0;
				timer1=0;
				}
			if(key[KEY_UP] && timer1>150)
				{
				menusound();
				if(--pointer<0)
					pointer=8;
				timer1=0;
				}
			if (key[KEY_ESC])
				return -1;
			if(key[KEY_ENTER])
				return pointer;
			}
}






