// GISMO V2.3
// written by Karl-Wilhelm Haase
// copyright 2006
// car.nickel@freenet.de


# include "GI_init.h"
# include "GI_utils.h"
# include "GI_high.h"
# include "G.h"
# include "GI_graphics.h"
# include "GI_menu.h"




void select_language()
{
		int keypress;
		
		char *t[]={"Input will be saved, so","program will start next","time with chosen language.","To change language in the",
		"future, perhaps after a","german lesson, press F1-key","while intro runs!",
		"Eingabe wird gespeichert, so dass","das Programm beim n&chten Mal","direkt mit der gew&hlten Sprache",
		"gestartet wird. Um die Sprache","irgendwann, z.B. nach einem",
		"Englischkurs, zu &ndern, w&hrend","des Intros die Taste F1 dr%cken!"};
		
		
		change_Block();
		if(language==3)
			{
			clear(screen);
			textout_centre_ex(screen,fontL1,"please select language / bitte Sprache w&hlen",370,120,-1,-1);
			textout_centre_ex(screen,fontL2,"(e)nglish / (d)eutsch",370,180,-1,-1);
		
			for(int j=0;j<2;j++)
				for(int i=0;i<7;i++)
					textout_ex(screen,fontL1,t[i+7*j],120+j*280,260+i*20,-1,-1);
			fade_in(default_palette,1);        
			
			while (!key[KEY_E] && !key[KEY_D])
				{}
			language=-key[KEY_D];
		
			fade_out(1);
			clear_keybuf();
			}
}

void welcome()
{
		FONT *fo;
		BITMAP *titel;
		titel =create_bitmap(130,40); 
		clear(titel);
		char *t[]=  {
				"Welcome","to","!&#$%","","","written by","Karl-Wilhelm Haase","","with the","Allegro-Library","","] 2006",
				"Willkommen","zu","!&#$%","","","geschrieben von","Karl-Wilhelm Haase","","mit der","Allegro-Library","","] 2006"
					};
		
		rectfill(screenbuffer, PX, PY, PX+PW-1, PY+PH-1, 0);
		textout_ex(titel,fontB1,"!&#$%",0,0,-1,-1);
		for(int i=0;i<12;i++)
			{
			fo=fontL1;				
			if(i==2)
				fo=fontB1;
			if(i==6 || i==9)
				fo=fontL2;
			textout_centre_ex(screenbuffer,fo,t[language*12+i],PX+96,PY+30+i*30,-1,-1);
			}
		
		textout_centre_ex(screenbuffer,font,"version 2.3.1",PX+96,PY+140,12,-1);
		textout_centre_ex(screenbuffer,font,"version 2.3.1",PX+97,PY+140,14,-1);
		masked_stretch_blit ((BITMAP *)data[shape].dat,screenbuffer,452,0,32,32,GMeter[0]+2,GMeter[1]-28,24,24); 
		blit(screenbuffer,screenbuffer1,0,0,0,0,800,600);
		blit(screenbuffer,screen,0,0,0,0,800,600);	
		
		fade_in(default_palette,1);
		
		wait(1000);
		textout_centre_ex(screenbuffer1,fontB1,t[2],CENTER,PY+30+60,14,-1);
		int t1=400;
		timer2=0;
		while(timer2<t1)
			{
			blit(screenbuffer1,screenbuffer,80,0,80,0,600,200);
			masked_blit(titel,screenbuffer,0,5,131+timer2*(510-121)/t1,160-timer2*77/t1,130,35);
			blit(screenbuffer,screen,80,0,80,0,600,200);
			wait(10);
			}
		
		clear_Score();
		wait(2000,1);	
		destroy_bitmap(titel);
}

int startmenu()
{
		int keyinput;      
		int pointer=0;
		int pointer_old;
		bool flag=0;
		
		char *t[]=  {
			"Start game",
			"How to play",
			"Highscores",
			"Key settings",
			"Quit game",                     
			"starte Spiel",
			"Anleitung",
			"Bestenliste",
			"Tastenbelegung",
			"Spiel beenden"                     
				};
		
		animSEQ[1][1]=stand;
		animREP[1][1]=4;
		animPHA[1][1]=0;
		DRAWFLAG=0;
		do
			{
			if(LOUDNESS<255)
				{
				LOUDNESS+=5;
				set_volume(255,LOUDNESS);
				}
			clear_keybuf();
		
			rectfill(screenbuffer1, PX, PY, PX+PW-1, PY+PH-1, 0);
			for(int i=0;i<5;i++)
				textout(screenbuffer1,fontL1,t[language*5+i],PX+50,PY+30+i*(BAY*32/5),-1);
		
			if(animtimer>15)
				{
				gismoanimation();
				animtimer=0;
				}
		
			blit(animation,screenbuffer1,animPHA[1][1]*32,(animSEQ[1][1])*32,PX+10,PY+25+pointer*(BAY*32/5),32,32);    	
		
			pointer_old=pointer;
			if(key[KEY_1])
				{
				fade_out_Playfield(4);	
				return 1;
				}
			if(key[KEY_2])
				return 2;
			if(key[KEY_3])
				{
				fade_out_Playfield(1);	
				return 3;
				}
			if(key[KEY_4])
				{
				fade_out_Playfield(3);	
				return 4;
				}
			if(key[KEY_5] || key[KEY_ESC])
				return 5;  
			if(key[KEY_F12])
				{
				QUICKSHUTDOWN=1;
				return 1;
				}
			if(key[KEY_DOWN] && timer1>150)
				{
				menusound();
				if(++pointer>4)
					pointer=0;
				timer1=0;
				}
			if(key[KEY_UP] && timer1>150)
				{
				menusound();
				if(--pointer<0)
					pointer=4;
				timer1=0;
				}
		
			if(!flag)
				{
				fade_in_Playfield(1);
				flag=1;
				}
			wait(20,update_menue);
			}
		while (!key[KEY_ENTER] && !key[KEY_LEFT] && !key[KEY_RIGHT]);
		
		if (pointer==4)
			{
			for(int i=0;i<ANIM[goodBy/2].lengh;i++)
				{
				LOUDNESS-=1;
				set_volume(255,LOUDNESS);
				blit(animation,screenbuffer1,i*32,goodBy*32,PX+10,PY+25+pointer*(BAY*32/5),32,32);
				wait(100,update_menue);
				}
			wait(200,update_menue);
			return 5;
			}
		
		if(pointer==0)
			for(int i=0;i<ANIM[jump/2].lengh;i++)
				{
				blit(animation,screenbuffer1,i*32,jump*32,PX+10,PY+25+pointer*(BAY*32/5),32,32);
				wait(80,update_menue);
				}
		
		for(int j=0;j<2;j++)
			for(int i=0;i<ANIM[walk/2].lengh;i++)
				{
				if(pointer==0)
					{
					LOUDNESS-=10;
					set_volume(255,LOUDNESS);
					}
				blit(animation,screenbuffer1,i*32,walk*32,PX+10,PY+25+pointer*(BAY*32/5),32,32);
					if(j==1)
						{
						if(pointer==0)
							{
							wait(60,update_menue_start);
							fade_out_Playfield(50-i);
							blit(screenbuffer,screen,PX,PY,PX,PY,PW,PH);
							}
						else
							{
							fade_out_Playfield(25-i);
							if(j && i==5)
							DRAWFLAG=1;
							wait(80,update_menue);
							}
						}		
					else	
						wait(80,update_menue);
				}
		return pointer+1;     
}

void keysettings()
{
		int mem;
		int k;
		bool set=0;
		bool flag=0;
		int pointer=0;
		int no;
		
		char *m[]={
		"use up/down keys to select", 
		"press ENTER to activate",
		"press desired key",
		"",
		"F1 sets default keys",
		"ESC quits with changes",
		"benutze Auf/Ab-Tasten um zu w&hlen", 
		"dr%cke ENTER zum Aktivieren",
		"dr%cke gew%nschte Taste",
		"",
		"F1 setzt Voreinstellung",
		"ESC zur%ck"
		};
		
		char *t[]=  {
		"shape left",
		"shape right",
		"shape down",
		"turn left",
		"turn right",                     
		"double definition!",
		"not allowed!",
		"Block nach links",
		"Block nach rechts",
		"Block nach unten",
		"Block drehen links",
		"Block drehen rechts",
		"Doppelbelegung!",
		"nicht erlaubt!"                     
		};
		
		
		clear_keybuf();
		
		for (int i=0; i<6;i++)
			textout_centre_ex(screenbuffer,fontL1,m[i+6*language],MBoard[0]+(MBoard[2]/2),MBoard[1]+10+i*25,10,-1);
		
		while(1)
			{
			if(animtimer>15)
				{
				gismoanimation();
				animtimer=0;
				}
		
			rectfill(screenbuffer1, PX, PY, PX+PW, PY+PH, 0);
		
			for(int i=0;i<5;i++)
				{
				textout_centre_ex(screenbuffer1,fontL1,t[language*7+i],CENTER,PY+30+i*(BAY*30/5),-1,-1);
				textout_centre_ex(screenbuffer1,font,key_names[language*116+KEYS[i]],CENTER,PY+30+i*(BAY*30/5)+40,9,-1);
				}	
		
			if(set)
				masked_blit(animation,screenbuffer1,0,lookS1*32,PX+10,PY+50+pointer*(BAY*30/5),32,32);
			else
				masked_blit(animation,screenbuffer1,animPHA[1][1]*32,animSEQ[1][1]*32,PX+10,PY+50+pointer*(BAY*30/5),32,32);   
		
			if(!set && key[KEY_DOWN] && timer1>150)
				{
				menusound();
				if(++pointer>4)
					pointer=0;
				timer1=0;
				}
			if(!set && key[KEY_UP] && timer1>150)
				{
				menusound();
				if(--pointer<0)
					pointer=4;
				timer1=0;
				}  
			if(key[KEY_F1])
				{
				keys_reset();
				set=0;
				}
			if(key[KEY_ESC])
				{
				if (set)
					{
					KEYS[pointer]=mem; 
					set=0;
					wait(500,update_menue);
					}
				else
					{
					clear_MBoard();
					fade_out_Playfield(1);
					DRAWFLAG=0;
					return;
					}
				}
			if(set && keypressed())
				{
				k=readkey()>>8;
				if (k==16 || k==2 || (k>46 && k<59))
					{
					timer1=0;
					no=2;
					}
				for(int i=0; i<5;i++)
					if(k==KEYS[i])
						{
						timer1=0;
						no=1;
						}
					if(!no)
						{
						KEYS[pointer]=k;
						set=0;
						}
					wait(200,update_menue);
					clear_keybuf();
				}
		
			if(key[KEY_ENTER] && !set)
				{
				mem=KEYS[pointer];
				KEYS[pointer]=0;
				set=1;
				clear_keybuf();
				}
			if (no)
				{
				if(timer1<1000)
					{
					textout_centre_ex(screenbuffer1,fontL1,t[language*7+4+no],PX+96,PY+5,40,-1);
					textout_centre_ex(screenbuffer1,fontL1,t[language*7+4+no],PX+96,PY+420,40,-1);
					}
				else
					no=0;
				}	
		
			if(!flag)
				{
				fade_in_Playfield(1);
				flag=1;
				}		
		
			wait(10,update_menue);
		}
}

void menusound()
{
		play_sample((SAMPLE *)data[Y_Setlow].dat, 255, 150,3000, 0);
}

void gismoanimation()
{	
		int gismoAnim[]={stand,wave1,wave2,wait1,wait2,wait3,lookS,lookS1,lookU,lookD,lookUD,lookDD};
		
		if(++animPHA[1][1]==ANIM[animSEQ[1][1]/2].loopEnd && animREP[1][1])
			{
			animREP[1][1]--;
			animPHA[1][1]=ANIM[animSEQ[1][1]/2].loopStart;
			}
		if (animPHA[1][1]==ANIM[animSEQ[1][1]/2].lengh)
			{
			if(animSEQ[1][1]!=stand)
				animSEQ[1][1]=stand;
			else	
				animSEQ[1][1]=gismoAnim[rand()%12]+rand()%2;
		
			animPHA[1][1]=0;
			animREP[1][1]=rand()%(ANIM[animSEQ[1][1]/2].repeats)+ANIM[animSEQ[1][1]/2].repeatmin;
			}
}

