// GISMO V2.3
// written by Karl-Wilhelm Haase
// copyright 2006
// car.nickel@freenet.de

#include "GI_init.h"
#include "GI_utils.h" 
#include "GI_high.h" 
#include "GI_graphics.h" 
#include "G.h"

void Highs_show(int place)
{
    	
		bool flag=0;
		
		if(place>10)    
			play_midi((MIDI *)data[Z_rock].dat, TRUE);
		
		clear_keybuf();
		rectfill(screenbuffer1, PX, PY, PX+PW-1, PY+PH-1, 0);
		
		if (!place || place==100)
			{
			Highs_anim(place+1);
		
			for(int j=0;j<75;j++)
				{
				for (int i=1;i<11;i++)
					{
					textprintf_centre_ex(screenbuffer1,fontL1,PX+15,PY+25+38*i,16+i+j,-1,"%d",i);
					if(flag){wait(5,update_menue);}
						if (keypressed() && flag)
							{
							if(place==100)
								return;
							fade_out_Playfield(1);
							DRAWFLAG=0;
							return;     
							}
						textout_ex(screenbuffer1,fontL1,High_name[i],PX+35,PY+20+38*i,17+i+j,-1);
						if(flag)
							wait(5,update_menue);
							
						textprintf_centre_ex(screenbuffer1,fontL1,PX+155,PY+20+38*i,18+i+j,-1,"%d",High_score[i]);
						textprintf_ex(screenbuffer1,fontL3,PX+35,PY+20+38*i+25,8,-1,"L:%d",High_lev[i]);
						textprintf_ex(screenbuffer1,fontL3,PX+90,PY+20+38*i+25,8,-1,"R:%d",High_row[i]);
						textprintf_ex(screenbuffer1,fontL3,PX+140,PY+20+38*i+25,8,-1,"G:%d",High_gis[i]);
						textprintf_ex(screenbuffer1,fontL3,PX+35+1,PY+20+38*i+25+1,26,-1,"L:%d",High_lev[i]);
						textprintf_ex(screenbuffer1,fontL3,PX+90+1,PY+20+38*i+25+1,26,-1,"R:%d",High_row[i]);
						textprintf_ex(screenbuffer1,fontL3,PX+140+1,PY+20+38*i+25+1,26,-1,"G:%d",High_gis[i]);
						if(flag)
							wait(5,update_menue);
						Highs_anim(place);
					}
		
				DRAWFLAG=2;
				if(!flag)
					{
					fade_in_Playfield(1);
					flag=1;
					}
				}
			if(!place)
			fade_out_Playfield(1);
			if(place!=100)
				DRAWFLAG=0;
			}
		else
			{
			rectfill(screenbuffer, PX, PY, PX+PW-1, PY+PH-1, 0);
			for (int i=1;i<11;i++)
				{
				textprintf_centre_ex(screenbuffer,fontL1,PX+15,PY-5+40*i,4+6*(i==place),-1,"%d",i);
				wait(20);
				textout_ex(screenbuffer,fontL1,High_name[i],PX+35,PY-5+40*i,4+6*(i==place),-1);
				wait(20);
				textprintf_centre_ex(screenbuffer,fontL1,PX+155,PY-5+40*i,4+6*(i==place),-1,"%d",High_score[i]);
				wait(20,1);
				}
			}
}



void Highs_anim(int flag)
{
		
		static int animphase1;
		static int animphase2;
		static int animphase3;
		static int animseq1;
		static int animseq2;
		static int animseq3;
		
		if(flag==1 || flag==101)
			{
			animseq1=0;
			animseq2=0;
			animseq3=0;
			animphase1=0;
			animphase2=0;
			animphase3=0;
			return;
			}
		
		int seq1[]={bow,clap,turn,clap,turn,bow,jump,lookDD,20,27,29,27,29,20,22,500};
		int seq2[]={bow, clap,  clap+1, turn,clap+1, bow, jump,lookD,20,27,27,30,27,20,22,500};
		int seq3[]={wait1,lookD,lookDD,lookD,lookDD+1,wait1,lookD,wait1,10,25,25,25,15,20,22,500};
		
		if(animtimer>12 && animseq1!=7)
			{
			if(++animphase1==seq1[animseq1+8])
				{
				animphase1=0;
				animseq1++;	
				}
			if(++animphase2==seq2[animseq2+8])
				{
				animphase2=0;
				animseq2++;	
				}
			if(++animphase3==seq3[animseq3+8])
				{
				animphase3=0;
				animseq3++;	
				}
			animtimer=0;
			}
		
		if(flag>10)
			{
			blit(animation,screenbuffer1,animphase1*32,animseq1[seq1]*32,PX+20,PY+20,32,32);    
			blit(animation,screenbuffer1,animphase1*32,(animseq1[seq1]+1)*32,PX+(BAX*32)-52,PY+20,32,32); 
			blit(animation,screenbuffer1,animphase2*32,animseq2[seq2]*32,PX+80,PY+10,32,32);  
			}
		else
			blit(animation,screenbuffer1,0,animseq3[seq3]*32,PX+80,PY+10,32,32);  
}		

void Highs_reset()
{ 
		High_name[1]="Jumper ";
		High_name[2]="Cheeky ";
		High_name[3]="Lazy   ";
		High_name[4]="Longear";         
		High_name[5]="Dreamer";
		High_name[6]="Sporty ";
		High_name[7]="Dancer ";
		High_name[8]="Walker ";
		High_name[9]="Waver  ";         
		High_name[10]="Juggy  ";
		High_score[1]= 2000;
		High_score[2]= 1800;
		High_score[3]= 1600;
		High_score[4]= 1400;          
		High_score[5]= 1200;
		High_score[6]= 1000;
		High_score[7]= 800;
		High_score[8]= 600;
		High_score[9]= 400;          
		High_score[10]= 200;
		
		for(int i=1;i<11;i++)
			{
			High_lev[i]=0;
			High_gis[i]=0;
			High_row[i]=0;
			}
}


void Highs_save()  
{
		PACKFILE *datei;
		datei = pack_fopen ( "gismo.hgh","w"); 
		pack_putc(255,datei); 
		
		for(int z=1;z<11;z++)
			{
			pack_fputs (High_name[z],datei);
			pack_iputl(High_score[z],datei); 
			pack_iputw(High_lev[z],datei); 
			pack_iputw(High_gis[z],datei); 
			pack_iputw(High_row[z],datei); 
			}
		pack_fclose (datei);
} 


void Highs_load()  
{
		bool old=0;
		
		PACKFILE *datei;
		
		datei = pack_fopen ( "gismo.hgh","r"); 
		if (datei == NULL )  
			{
			Highs_reset();
			return;
			}
		if  (pack_getc(datei)!=255)
			{
			pack_fclose (datei);	
			old=1;
			datei = pack_fopen ( "gismo.hgh","r"); 
			}
		
		for(int i=1;i<11;i++)
			{
			for (int j =0;j<7;j++)
				d[i][j]=pack_getc(datei);
			High_name[i]=d[i];
			High_score[i]=pack_igetl (datei);
			if(!old)
				{
				High_lev[i]=pack_igetw(datei);
				High_gis[i]=pack_igetw(datei);
				High_row[i]=pack_igetw(datei);	
				}
			}
		
		pack_fclose (datei);
}


void Highs_check()
{
		int i;
		
		for ( i=1;i<11;i++)
			{
			if (DAT.score>High_score[i])
				break;
			}
		if(i<11)
			{
			for (int j=9;j>i-1;j--)
				{
				High_score[j+1]=High_score[j];
				High_name[j+1]=High_name[j];
				High_lev[j+1]=High_lev[j];
				High_gis[j+1]=High_gis[j];
				High_row[j+1]=High_row[j];
				}
			High_name[i]="       ";
			High_score[i]=DAT.score;
			High_lev[i]=DAT.level;
			High_gis[i]=DAT.gismos;
			High_row[i]=DAT.rows;
			Highs_show(i);
			Highs_input(i);
		
			Highs_load();
			}
		clear_MBoard();
		Highs_show(100);
}
		
void Highs_input(int place)
{
		char *t[]={"Congratulations!","You have a highscore,","please enter your name","Gratulation!","Du hast eine H#chstpunktzahl;","gib bitte Deinen Namen ein!"};
		char *key[] =
		{
		"A","B","C","D","E","F","G","H","I","J","K","L","M",
		"N","O","P","Q","R","S","T","U","V","W","X","Z","Y",
		"a","b","c","d","e","f","g","h","i","j","k","l","m",
		"n","o","p","q","r","s","t","u","v","w","x","z","y",
		"0","1","2","3","4","5","6","7","8","9","0",   
		"."," "
		};     
		
		char input[8]=".......";
		int a;
		int b;
		int i=0;
		
		while( a!=13)
			{
			clear_MBoard();                    
			for (int i=0;i<3;i++)
				show_Message(t[language*3+i],i+1);   
			textout_centre_ex(screenbuffer,fontL2,input,MBoard[0]+(MBoard[2]/2),MBoard[1]+120,-1,-1);
		
			while(!keypressed())
				wait(10,1);
			b=-1;
			a = (readkey()&255);      
		
			if (a==8 && i!=0)
				{
				if (i==6)
					input[6]='.';    
				b=63;
				i--;
				}
			if (a==32)
				b=64;
			if (a>96 && a<123)
				b=a-71;     
			if (a>47 && a<58)
				b=a+4;
			if (a>64 && a<91)
				b=a-65;   
			if (b>-1)  
				{
				input[i]=*key[b];
				if(b!=63)
					{
					if(++i>6)
						i=6;
					}
				}
			}  
		
		if (i==6 && input[6]!='.')
			i=7;
		
		for(i;i<7;i++)
			input[i]=' ';
		High_name[place]=input;
		Highs_save();
}

     
    
