// GISMO V2.3
// written by Karl-Wilhelm Haase
// copyright 2006
// car.nickel@freenet.de

#include "GI_graphics.h"
#include "GI_init.h"
#include "GI_utils.h"
#include "G.h"
#include "GI_gmeter.h"


void draw_GMeter()
{
		blit(screenbuffer1,screenbuffer,GMeter[0]+10,GMeter[1],GMeter[0]+10,GMeter[1],11,GMeter[3]);
}

void clear_Gismometer()
{
		GM.fuel=0;
		GM.fueldraw=0;
		GM.full=0;
}

void raise_Gismometer(int number)
{
		update_Gismometer(number);
}

void update_Gismometer(int GC)
{
		int fuelplus;
	
		if (DAT.level<20)
			fuelplus=30-(DAT.level/2);
		else
			fuelplus=20;
		
		for (int i=0;i<GC;i++)
			{ 
			if(GM.fuel<GMeterFuelMax+20)
				GM.fuel+=fuelplus;
			}  
}


unsigned char GMcol[]={4,12,41,39,38,32,  40,42,12,41,43,31  ,18,20,22,24,26,31};
unsigned char dif=80;


void display_GMeterfuel()
{
      
		int diff,add;	
		int h,r,c;
		int w;
		int w1;
		
		add=0;
		diff=GM.fuel-GM.fueldraw;
		
		if(diff>0)
			{
			add=1;
			if (diff>20)
				add=10;
			if (diff>50)
				add=15;
			}
		if(diff<0)
			{
			if (diff<-30)
				add=-10;
			else
				add=-1;		
			}
		GM.fueldraw+=add;
		if(GM.fueldraw>GMeterFuelMax)
			GM.fueldraw=GMeterFuelMax;
		
		if(GM.fueldraw==GMeterFuelMax &&!GM.full)
			{
			GM.full=1;
			diamondA=1;
			play_sample((SAMPLE *)data[Y_bell].dat, 255, 150,2000, 0);
			display_Diamond(1);
			return;     
			}
		
		w = GMeter[3]*GM.fueldraw/GMeterFuelMax;
		w1= GMeter[3]-w;
		
		draw_GMeter();
		
		blit(screenbuffer,screenbuffer,810,w1,GMeter[0]+10,GMeter[1]+w1,11,w);
		
		if(GM.fueldraw)
			{
			h=rand()%10+5;
		
			for(int i=0;i<h;i++)
				{
				r=h-(2*i);
				if(r<2)
					r=2;
				c=rand()%r;
				for(int j=0;j<c;j++)
				putpixel(screenbuffer,GMeter[0]+10+rand()%11,GMeter[1]+w1-i,GMcol[GOVER*12+rand()%5]);
				}
			}
}     



void colour_Gismometer()
{
	 	
		static int ctr;
		int coloff;
		int color;
		int r;
		
		coloff=0;
		
		if (GM.full)        
			{
			if(!(++ctr%2))
				display_Diamond(1); 	
			coloff=6;
			GM.gismo=0;
			}
		if (GOVER)
			{
			coloff=12;
			if(GM.fuel)
				{
				GM.fuel-=2;
				display_Diamond(0);
				}
			}
		
		if (GM.gismo)
			color=33; 
		else
			{
			r=rand()%1000;
			if(r>500)
				color=GMcol[0+coloff];
			if(r<501)
				color=GMcol[1+coloff];
			if(r<300)
				color=GMcol[2+coloff];
			if(r<200)
				color=GMcol[3+coloff];
			if(r<100)
				color=GMcol[4+coloff];
			if(r<3)
				color=GMcol[5+coloff];
			}
		
		if(TUT)
			GM.gismo=0;
		
		for(int i=0;i<dif;i++)
			putpixel(screenbuffer,rand()%11+810,rand()%(BAY*32),color);
		
		if(rand()%20==10)
			{
			if(rand()%5==1)
				{
				GMcol[0]=41;
				GMcol[2]=4;
				}
			else
				{
				GMcol[0]=4;
				GMcol[2]=41;
				}
			GMcol[4]=rand()%5+38;
			dif=rand()%100+80;
			}
}

