// GISMO V2.3
// written by Karl-Wilhelm Haase
// copyright 2006
// car.nickel@freenet.de


# include <allegro.h>
# include "GI_graphics.h" 
# include "GI_utils.h"
# include "GI_checks.h"  
# include "GI_finale.h"
# include "GI_init.h"
# include "GI_high.h"
# include "GI_shape.h"
# include "GI_menu.h"
# include "GI_intro.h"
# include "G.h"
# include "GI_gmeter.h"
# include "GI_types.h"
# include "GI_tut.h"






int main()                                              
{            
		int music=0;
		int start;
		
		QUICKSHUTDOWN=0;
		LOUDNESS=255;
		
		srand(time(NULL));	                           
		keys_reset();
		
		if(init_all())
			return 1;
		
		set_volume(255,255);

  		set_palette(black_palette);
		fade_out(64);
		clear(screen);
		
		select_language();
		intro();
		fade_out(5);
		
		GAMERUNNING=0;
		
		draw_Screen();  
		
		Highs_load();
		
		welcome();
		
		circlefill(screenbuffer1,830,30,30,12);
		circlefill(screenbuffer1,808,9,5,12);
		circlefill(screenbuffer1,857,7,5,12);
		circlefill(screenbuffer1,811,52,5,12);
		circlefill(screenbuffer1,848,52,5,12);
		
		backpicMenue(1);	
          
		while (start!=5 && !QUICKSHUTDOWN)
			{         
			set_volume(255,255);
			backpicGame(1);
			do
				{
				start=startmenu();
				clear_keybuf();
				switch (start)
					{
					case 2:
						tutorial();
						wait(500);
						clear_keybuf();
						break;
					case 3:
						Highs_show();
						clear_keybuf();
						break;
					case 4:
						keysettings();
						break;
					}
				}
			while(start!=1 && start!=5);
      
			if(start==1 && !QUICKSHUTDOWN)
				{
				stop_midi();
				clear_NBoard();
				clear_Playfield();
				clear_Gismometer();
				clear_Score();                
				if(!music)
					music=rand()%2+1;
				if(music==1)
					{
					play_midi((MIDI *)data[Z_kokomo].dat, TRUE);    
					music=2;
					}
				else
					{
					play_midi((MIDI *)data[Z_natural].dat, TRUE); 
					music=1;
					}
				LOUDNESS=255;
				set_volume(255,LOUDNESS);
				Shape_Loop();
				GAMERUNNING=0;
				}
		
			blit(screenbuffer1,screenbuffer,PX,PY,PX,PY,(BAX+2)*32,BAY*32);
			} 
     
		if(!QUICKSHUTDOWN)
			{	
			play_midi((MIDI *)data[Z_europe].dat, TRUE);
			for(int i=0;i<2;i++)
				{
				blit(screen,screenbuffer1,0,0,0,0,800,600);
				int t=2000;
				timer1=0;
				while(timer1<t)
					{
					stretch_blit(screenbuffer1,screenbuffer,0,0,800,600,timer1*(400.0/t),timer1*(110.0/t),800-timer1*(800.0/t),600-timer1*(600.0/t));
					blit(screenbuffer,screen,0,0,0,0,800,600);
					if(i)
						clear(screenbuffer);
					wait(50);
					}
				}
			clear_keybuf();
			extro();
			}
	
	
		settings_write();
		destroybitmaps();
		unload_datafile(data);
		return 0;   
}
END_OF_MAIN()




bool GAMERUNNING;
bool CHANGEALLOWED;
int LOUDNESS;
int TUT;
char DRAWFLAG;
bool DRAWALL;

GISMOMETER GM;
SHAPE SHP;
DATA DAT;

int SetDelay;

DATAFILE *data;

BITMAP *screenbuffer;
BITMAP *screenbuffer1;
BITMAP *buffer2;
BITMAP *buffer3;
BITMAP *animation;
BITMAP *boing;
BITMAP *boing1;


volatile int timer1;
volatile int timer2;
volatile int updatetimer;
volatile int ShapeDown;
volatile int timer;
volatile int animtimer;
volatile int waitT;
volatile int leveltimer;

FONT *fontB1;
FONT *fontL1;
FONT *fontL2;
FONT *fontL3;

int possTab[500];

short NBoard[]= {PX+BAX*32+100,PY-32+16,6*16,6*16};
short SBoard[]= {PX+BAX*32+100,166,13*16,11*16};  		
short DBoard[]= {SBoard[0]+224,SBoard[1],11*16,11*16};
short MBoard[]= {SBoard[0]+24,SBoard[1]+192,22*16,11*16};
short TBoard[]= {NBoard[0]+130,NBoard[1]+15,10*16,4*16};
short GMeter[]= {PX+(BAX+1)*32,PY,16,BAY*32};


int BPX[7][15];  
int BPY[7][15];   
int BPC[7][15];  
float Bpy[7][15];

int animSEQ[7][15];       
int animPHA[7][15];
int animREP[7][15];

char *High_name[12];
int High_score[12];
int High_lev[12];
int High_gis[12];
int High_row[12];

char d[12][15];


char STARTMSG;
int GOVER;
bool levelD;
bool scoreU;
bool diamondA;
bool rowD;
bool QUICKSHUTDOWN;
char language;
char blockstyle;

unsigned char KEYS[5];



char *key_names[] =
{
   "???",         "KEY_A",          "KEY_B",          "KEY_C",
   "KEY_D",          "KEY_E",          "KEY_F",          "KEY_G",
   "KEY_H",          "KEY_I",          "KEY_J",          "KEY_K",
   "KEY_L",          "KEY_M",          "KEY_N",          "KEY_O",
   "KEY_P",          "KEY_Q",          "KEY_R",          "KEY_S",
   "KEY_T",          "KEY_U",          "KEY_V",          "KEY_W",
   "KEY_X",          "KEY_Y",          "KEY_Z",          "KEY_0",
   "KEY_1",          "KEY_2",          "KEY_3",          "KEY_4",
   "KEY_5",          "KEY_6",          "KEY_7",          "KEY_8",
   "KEY_9",          "KEY_0_PAD",      "KEY_1_PAD",      "KEY_2_PAD",
   "KEY_3_PAD",      "KEY_4_PAD",      "KEY_5_PAD",      "KEY_6_PAD",
   "KEY_7_PAD",      "KEY_8_PAD",      "KEY_9_PAD",      "KEY_F1",
   "KEY_F2",         "KEY_F3",         "KEY_F4",         "KEY_F5",
   "KEY_F6",         "KEY_F7",         "KEY_F8",         "KEY_F9",
   "KEY_F10",        "KEY_F11",        "KEY_F12",        "KEY_ESC",
   "KEY_TILDE",      "KEY_MINUS",      "KEY_EQUALS",     "KEY_BACKSPACE",
   "KEY_TAB",        "KEY_OPENBRACE",  "KEY_CLOSEBRACE", "KEY_ENTER",
   "KEY_COLON",      "KEY_QUOTE",      "KEY_BACKSLASH",  "KEY_BACKSLASH2",
   "KEY_COMMA",      "KEY_STOP",       "KEY_SLASH",      "KEY_SPACE",
   "KEY_INSERT",     "KEY_DEL",        "KEY_HOME",       "KEY_END",
   "KEY_PGUP",       "KEY_PGDN",       "KEY_LEFT",       "KEY_RIGHT",
   "KEY_UP",         "KEY_DOWN",       "KEY_SLASH_PAD",  "KEY_ASTERISK",
   "KEY_MINUS_PAD",  "KEY_PLUS_PAD",   "KEY_DEL_PAD",    "KEY_ENTER_PAD",
   "KEY_PRTSCR",     "KEY_PAUSE",      "KEY_ABNT_C1",    "KEY_YEN",
   "KEY_KANA",       "KEY_CONVERT",    "KEY_NOCONVERT",  "KEY_AT",
   "KEY_CIRCUMFLEX", "KEY_COLON2",     "KEY_KANJI",
   "KEY_LSHIFT",     "KEY_RSHIFT",     "KEY_LCONTROL",   "KEY_RCONTROL",
   "KEY_ALT",        "KEY_ALTGR",      "KEY_LWIN",       "KEY_RWIN",
   "KEY_MENU",       "KEY_SCRLOCK",    "KEY_NUMLOCK",    "KEY_CAPSLOCK",
   "KEY_MAX",

	"???",         "A",          "B",          "C",
   "D",          "E",          "F",          "G",
   "H",          "I",          "J",          "K",
   "L",          "M",          "N",          "O",
   "P",          "Q",          "R",          "S",
   "T",          "U",          "V",          "W",
   "X",          "Z",          "Y",          "0",
   "1",          "2",          "3",          "4",
   "5",          "6",          "7",          "8",
   "9",          "0_NumPad",      "1_NumPad",      "2_NumPad",
   "3_NumPad",   "4_NumPad",      "5_NumPad",      "6_NumPad",
   "7_NumPad",   "8_NumPad",      "9_NumPad",      "F1",
   "F2",         "F3",         "F4",         "F5",
   "F6",         "F7",         "F8",         "F9",
   "F10",        "F11",        "F12",        "ESC",
   "Taste_TILDE",      "MINUS",      "Taste_=",     		"<-",
   "TAB",        	"(",  		"+", 		"Enter",
   ";",      "''",      	"#",  "Taste_BACKSLASH2",
   ", (Komma)",      ". (Punkt)",       "-",      "Leertaste",
   "Einfg",     "Entf",        "Pos 1",       "Ende",
   "Bild Auf",       "Bild Ab",       "Cursor Links",       "Cursor Rechts",
   "Cursor Auf",         "Cursor Ab",       "geteilt durch_NumPad",  "multipliziere_NumPad",
   "MINUS_NumPad",  "PLUS_NumPad",   	"Entf_NumPad",    "ENTER_NumPad",
   "Taste_PRTSCR",     "Taste_PAUSE",      "Taste_ABNT_C1",    "Taste_YEN",
   "Taste_KANA",       "Taste_CONVERT",    "Taste_NOCONVERT",  "Taste_AT",
   "Taste_CIRCUMFLEX", "Taste_COLON2",     "Taste_KANJI",
   "Taste_LSHIFT",     "Taste_RSHIFT",     "Strg links",   "Strg rechts",
   "Alt",        "Alt Gr",      "Taste_LWIN",       "Taste_RWIN",
   "Taste_MENU",       "Taste_SCRLOCK",    "Taste_NUMLOCK",    "Taste_CAPSLOCK",
   "Taste_MAX"
};





