// GISMO V2.3
// written by Karl-Wilhelm Haase
// copyright 2006
// car.nickel@freenet.de


#include "GI_graphics.h"
#include "GI_init.h"
#include "GI_utils.h"
#include "GI_ball.h"
#include "GI_checks.h"
#include "GI_finale.h"
#include "GI_shape.h"
#include "G.h"
#include "GI_menu.h"
#include "GI_gmeter.h"




int boarddata[]={  	NBoard[3],NBoard[2],NBoard[0],NBoard[1],
		SBoard[3],SBoard[2],SBoard[0],SBoard[1],
		DBoard[3],DBoard[2],DBoard[0],DBoard[1],
		MBoard[3],MBoard[2],MBoard[0],MBoard[1],
		TBoard[3],TBoard[2],TBoard[0],TBoard[1],
		};


void draw_Screen()
{
		draw_Background();
		draw_Boards();
		draw_Border();
		masked_stretch_blit((BITMAP *)data[HS].dat,screenbuffer,0,0,106,110,680,20,90,90);
		
		blit(screenbuffer,screen,0,0,0,0,800,600);
		blit(screenbuffer,screenbuffer1,0,0,0,0,800,600);
		
		display_Diamond(0);
}




void draw_Background()
{
		BITMAP *buffer;
		buffer=create_bitmap(70,70);
		rectfill(screenbuffer,0,0,800,600,236);
		
		blit((BITMAP *)data[background].dat,buffer,0,0,0,0,70 ,70);
		for (int j=0;j<640;j+=70-rand()%10)
			{
			for (int i=0;i<840;i+=70-rand()%10)
				rotate_sprite(screenbuffer,buffer, i-30,j-40,itofix(rand()%4+63)*(rand()%4));
			}
		destroy_bitmap (buffer);
}

void draw_Boards()
{
     
     for (int c=0;c<20;c+=4)
          {
          for (int j=0;j<boarddata[c];j=j+16)
               {
               for(int i=0;i<boarddata[c+1];i=i+16)
                    {
                    if(!i && !j)
                         {
                         masked_blit((BITMAP *)data[boards].dat,screenbuffer,0,80,boarddata[c+2],boarddata[c+3],16,16);
                         continue;
                         }
                    if(!i && j==(boarddata[c]-16))
                         {
                         masked_blit((BITMAP *)data[boards].dat,screenbuffer,0,96,boarddata[c+2]+(boarddata[c+1]-16),boarddata[c+3],16,16);
                         continue;
                         }
                    if(i==boarddata[c+1]-16 && !j)
                         {
                         masked_blit((BITMAP *)data[boards].dat,screenbuffer,0,112,boarddata[c+2],boarddata[c+3]+boarddata[c]-16,16,16);
                         continue;
                         } 
                    if(i==boarddata[c+1]-16 && j==(boarddata[c]-16))
                         {
                         masked_blit((BITMAP *)data[boards].dat,screenbuffer,0,128,boarddata[c+2]+boarddata[c+1]-16,boarddata[c+3]+boarddata[c]-16,16,16);
                         continue;
                         }           
                 
                    blit((BITMAP *)data[boards].dat,screenbuffer,0,rand()%5*16,boarddata[c+2]+i,boarddata[c+3]+j,16,16);
                    }
               }	 
          }
}



void draw_Border()
{
		int x=BPX[1][BAY]-32; 
		
		for (int i=x; i<x+(BAX+3)*32; i+=32)
			{
			for(int j=0;j<2;j++)
				{
				if(i==BPX[BAX][BAY]+64 && j==0)
					modifyBlock(1);
				else
					modifyBlock();
				if(i==BPX[1][BAY]-32)
					roundEdges(2*j);
				if(i==x+(BAX+2)*32)
					roundEdges(1+2*j);
				if(j)
					masked_blit(buffer2,screenbuffer,0,0,i,BPY[1][1]+32,32,32);
				else
					masked_blit(buffer2,screenbuffer,0,0,i,BPY[1][BAY]-32,32,32);
				}
			}
		
		int y=BPY[1][BAY]; 
		for (int i=y; i<y+BAY*32; i+=32)
			{
			modifyBlock();
			blit(buffer2,screenbuffer,0,0,BPX[1][1]-32,i,32,32);
			modifyBlock();
			blit(buffer2,screenbuffer,0,0,BPX[1][1]+BAX*32,i,32,32);
			modifyBlock(1);
			blit(buffer2,screenbuffer,0,0,BPX[1][1]+BAX*32+32,i,32,32);
			}
		
		for (int i=0;i<GMeter[3];i+=32)
			blit((BITMAP *)data[shape].dat,screenbuffer,199,0,GMeter[0]+7,GMeter[1]+i,16,32);  
		masked_blit((BITMAP *)data[shape].dat,screenbuffer,388,32,BPX[BAX][BAY]+64 ,38,32,32);
}


void modifyBlock(bool flag)
{
		for(int i=0;i<10000;i++)
			putpixel(buffer2,rand()%32,rand()%32,rand()%8+21);
		if(!flag)
			masked_stretch_blit((BITMAP *)data[shape].dat,buffer2,456,40,18,17,6+rand()%5,6+rand()%5,14+rand()%8,10+rand()%7);
}

void roundEdges(int edge)
{
		int var[]={0,0,16,0,0,16,16,16};
		
		for(int x1=16;x1>-1;x1--)
			for(int y1=16;y1>-1;y1--)
		if(getpixel((BITMAP *)data[shape].dat,490+var[edge*2]+x1,y1+var[edge*2+1])==40)
			putpixel(buffer2,x1+var[edge*2],y1+var[edge*2+1],0);
}



void clear_board(int n)
{
		blit(screenbuffer1,screenbuffer,boarddata[n*4+2],boarddata[n*4+3],boarddata[n*4+2],boarddata[n*4+3],boarddata[n*4+1],boarddata[n*4]);
}


void clear_NBoard()
{
		clear_board(0);
}

void clear_MBoard()
{
		clear_board(3);
}

void clear_SBoard()
{
		clear_board(1);
		masked_blit((BITMAP *)data[texts].dat,screenbuffer,0,language*30,SBoard[0]+33,SBoard[1]+35,160,30);
}



void clear_DBoard()
{
		clear_board(2);
}



void clear_Playfield()
{
		rectfill(screenbuffer, PX, PY, PX+PW-1, PY+PH-1, 0);
		rectfill(screenbuffer, 1200, PY, 1200+PW-1, PY+PH-1, 0);
		for (int y=1; y<BAY+1;y++)
			for (int x=1; x<BAX+1;x++)
				{
				BPC[x][y]=0;
				animREP[x][y]=0;
				}
}    


void display_Diamond(bool f)
{
		static int da=0;
		
		if (!f)
			masked_stretch_blit ((BITMAP *)data[shape].dat,screen,452,0,32,32,GMeter[0]+2,GMeter[1]-28,24,24); 
		else
			{
			masked_stretch_blit ((BITMAP *)data[shape].dat,screen,260+da*32,0,32,32,GMeter[0]+2,GMeter[1]-28,24,24); 
			if (++da>5)
				da=0;
			}
}


void backpicMenue(bool flag)
{
		static float posX[15];
		static float posY[15];
		static int r1[15];
		static float r2[15];
		static float d[15];
		static float velocity[15];
		static short z;
		
		if (flag)
			for(int i=0;i<14;i++)
				{
				posX[i]=0;
				DRAWALL=0;
				}
		
		rectfill(screenbuffer, 900, PY, 900+PW, PY+PH, 0);
		if(DRAWFLAG==2)
			for(int i=1;i<10;i++)
				rectfill(screenbuffer,900+5,PY+20+38*i,900+185,PY+25+38*i+35,17+i%2);
		z++;
		
		drawing_mode(DRAW_MODE_COPY_PATTERN ,(BITMAP *)data[curtainT].dat,timer1,0);
		for(int i=0;i<14;i++)
			{
			if (posX[i])
				circlefill(screenbuffer,900+posX[i],PY+posY[i],r2[i],0);
			}
		solid_mode();		
		
		for(int i=0;i<14;i++)
			{			
			if(posX[i])
				{
				if(d[i]<0)
					{
					for(int j=0;j<5;j++)
						circle(screenbuffer,900+posX[i],PY+posY[i],r2[i]-j,(40-(DRAWFLAG>0)*19)+j);
					posY[i]-=velocity[i];
		
					if (posX[i]-r2[i]>0 && posX[i]+r2[i]<BAX*32)	
						posX[i]+=(fixtof(fixsin(itofix(z+i*20))));
					r2[i]-=0.1;
					}
				else
					r2[i]+=d[i];
		
				if(r2[i]>r1[i] && d[i]>0)
					d[i]=-d[i];
		
				if(posY[i]<0 || r2[i]<-2)
					posX[i]=0;
				}
			else
				{
				if(rand()%300==1)
					{
					posX[i]=20+rand()%(BAX*32-40);
					posY[i]=rand()%(4*32)+10*32;
					velocity[i]=((rand()%30+10)/10.0);
					r1[i]=rand()%25+10;
					r2[i]=0;
					d[i]=(rand()%10+2)/10.0;
					}
				}
			}
}

void backpicGame(bool flag)
{
		static float posX[100];
		static int posY[100];
		static float velocity[100];
		static float r1[100];
		static float r2[100];
		static float r1d[100];
		static float r2d[100];
		static int ctr=0;
		
		int col[]={19,18,18,19,41,40,32,36};
		int coloff=0;
		static int number;
		static short z;
		
		
		if(flag)
			for(int i=0;i<100;i++)
				posX[i]=0;
		
		rectfill(screenbuffer, 900, PY, 900+PW, PY+PH, 0);
		
		if(TUT)
			return;
		
		if(GOVER)
			for(int i=0;i<3;i++)
				putpixel(screenbuffer,900+rand()%(8*32),PY+rand()%(14*32),20+rand()%30);
		z++;	
		
		if (GM.full)
			coloff=4;
		
		if(GOVER)
			{
			if(number<99 && ++ctr>15)
				{
				number++;	
				ctr=0;
				}
			}
		else
			number=10+ DAT.level*2;
		
		
		if(ctr && !GOVER)
			ctr--;
		for(int i=0;i<number;i++)
			{
			if(posX[i])
				{
				if(GOVER)
					{
					ellipsefill(screenbuffer,900+posX[i],PY+posY[i],r1[i],r2[i],timer%100+40);
					ellipsefill(screenbuffer,900+posX[i],PY+posY[i],r2[i],r1[i],timer%100);
					}
				else
					if ((GM.gismo || ctr) && !GM.full)
						{
						if(GM.gismo)
							ctr=100;
						GM.gismo=0;
						coloff=4;
						ellipse(screenbuffer,900+posX[i],PY+posY[i],r1[i],r2[i],col[rand()%4+coloff]);
						ellipse(screenbuffer,900+posX[i],PY+posY[i],r2[i],r1[i],col[rand()%4+coloff]);
						}
					else
						{
						ellipsefill(screenbuffer,900+posX[i],PY+posY[i],r1[i],r2[i],col[rand()%4+coloff]);
						ellipsefill(screenbuffer,900+posX[i],PY+posY[i],r2[i],r1[i],col[rand()%4+coloff]);
						}
				if (posX[i]-r1[i]>0 && posX[i]+r1[i]<BAX*32)	
					posX[i]+=fixtof(fixcos(itofix(z+i*10)));
		
				r1[i]+=r1d[i];
				if(r1[i]<0 || r1[i]>5)
					r1d[i]*=-1;
				r2[i]+=r2d[i];
				if(r2[i]<0 || r2[i]>5)
					r2d[i]*=-1;
		
				posY[i]+=velocity[i];
				if(posY[i]>32*BAY)
					posX[i]=0;
				}
			else
				{
				if(rand()%200==1)
					{
					posX[i]=rand()%(BAX*32);
					posY[i]=-10;
					velocity[i]=((rand()%30+10)/10.0);
					r1[i]=3;
					r2[i]=2;
					r1d[i]=(rand()%3+1)/20.0;
					r2d[i]=(rand()%3+1)/20.0;
					}
				}
			}
}






void update_Playfield(int actionflag,int updateflag)
{
		static int framecounter;
		static int UDP=0;
		static int msgYS;
		
		if(TUT)
			DRAWALL=1;
		
		if (updatetimer>3)
			{ 
			colour_Gismometer();
			framecounter++;
		
			if(updateflag==update_menue || updateflag==update_menue_start || updateflag==1)
				{
				if(updateflag!=1)
					{
					backpicMenue();
					blit(screenbuffer,screenbuffer,900,PY,PX,PY,BAX*32,BAY*32);
					masked_blit (screenbuffer1,screenbuffer,PX,PY,PX,PY,PW,PH);
					}
				if(updateflag != update_menue_start)
					blit (screenbuffer,screen,PX,PY,PX,PY,PW,PH);
				updatetimer=0;
				return;
				}
		
			backpicGame();
		
			if(updateflag==update_ufo)
				{
				textscrolling();
				blit(screenbuffer,screen,0,0,0,0,800,600);
				updatetimer=0;
				return;
				}
		
			display_GMeterfuel();
		
			if(updateflag!=update_pause && updateflag!=update_abort && !GM.full )
				{
				GM.fuel-= (0.01*DAT.level);
				if (GM.fuel<0)
					GM.fuel=0;
				}
		
			if(STARTMSG)
				{
				if (STARTMSG>1)
					blit(screenbuffer1,screenbuffer1,PX,PY,PX,PY+STARTMSG,BAX*32,BAY*32);
				masked_blit(screenbuffer1,screenbuffer,PX,PY,900,PY,BAX*32,BAY*32);
		
				if (++msgYS>300)
					STARTMSG=0;
				}
			else
				msgYS=0;
		
			blit(screenbuffer,screenbuffer,900,PY,PX,PY,BAX*32,BAY*32);
		
			if (updateflag==update_shake)
				{
				masked_blit(buffer2,screenbuffer,0,0,1200-PX+SHP.X,SHP.Y,64,64);
				masked_blit(screenbuffer,screenbuffer,1200+2,PY+2,PX+rand()%5,PY+rand()%5,BAX*32-4,BAY*32-4);
				}
			else
				if (updateflag==update_rowdown)
					masked_blit(screenbuffer1,screenbuffer,PX,PY,PX,PY,BAX*32,BAY*32);
				else
					{
					if (updateflag==update_pause || updateflag==update_abort)
						{
						masked_blit(screenbuffer,screenbuffer,600,650,400,650,200,200);
						masked_blit(buffer2,screenbuffer,0,0,1200-PX+SHP.X,SHP.Y,64,64);
						masked_blit(screenbuffer,screenbuffer,400,640,1200,PY+100,BAX*32,1600);
						}
					masked_blit(screenbuffer,screenbuffer,1200,PY,PX,PY,BAX*32,BAY*32);
		
					if(updateflag!=update_newshape && updateflag!=update_pause && updateflag!=update_abort)
						masked_blit(buffer2,screenbuffer,0,0,SHP.X,SHP.Y,64,64);
					}	
		
			if(!TUT)
				textscrolling();
		
			blit(screenbuffer,screen,PX,PY,PX,PY,BAX*32,BAY*32);
			blit(screenbuffer,screen,GMeter[0]+10,GMeter[1],GMeter[0]+10,GMeter[1],11,GMeter[3]);
		
			updatetimer=0;
			UDP=1;
			return;
			}
		
		
		if(UDP==1 && updateflag!=1)
			{
			for (int y=1;y<BAY+1;y++)
				{	
				for (int x=1;x<BAX+1;x++)
					{	
					if(Bpy[x][y])
						Bpy[x][y]-=4.1;
		
					if(Bpy[x][y]<0)
						{
						for(int i=0;i<BAY+1;i++)
							Bpy[x][i]=0;
						if(BPC[x][y]==1)
							play_Setheavy();
						else
							play_Setlow();   
						}	
					}
				}
		
			if (DRAWALL && updateflag!=3 && actionflag!=actionFinaleA && actionflag!=actionFinaleB && actionflag!=actionFinaleB )
				rectfill(screenbuffer, 1200, PY, 1200+PW, PY+PH, 0);
		
			redraw_Blocks(actionflag,updateflag);
		
			UDP=0;
			}
		
		
		if(framecounter>5 || updateflag==update_newshape)
			{
			if(leveltimer>10*leveluptime)
				{
				leveltimer=0;
				DAT.level++;
				create_PossibilityTab(0);
				DAT.levelups++;
				update_Score();
				}
		
			if(GAMERUNNING)
				{				
				drawing_mode(DRAW_MODE_COPY_PATTERN ,(BITMAP *)data[bar1].dat,0,0);
				rectfill(screenbuffer,631,227,631+(leveltimer*9.9/leveluptime),235,12);
				solid_mode();
				}
			blit(screenbuffer,screen,SBoard[0],SBoard[1],SBoard[0],SBoard[1],SBoard[2],SBoard[3]);
			blit(screenbuffer,screen,MBoard[0],MBoard[1],MBoard[0],MBoard[1],MBoard[2],MBoard[3]);
			blit(screenbuffer,screen,DBoard[0],DBoard[1],DBoard[0],DBoard[1],DBoard[2],DBoard[3]);
			blit(screenbuffer,screen,NBoard[0],NBoard[1],NBoard[0],NBoard[1],NBoard[2],NBoard[3]);
		
			framecounter=0;
			}
}

void textscrolling()
{			
		static int posY[5];
		
		if(levelD)
			{
			posY[0]=PY+450;
			levelD=0;
			}
		if (posY[0])
			{
			masked_blit((BITMAP *)data[texts].dat,screenbuffer,0,240+language*40,96,posY[0],160,40);
			posY[0]-=3;
			if(posY[0]<PY-60)
				posY[0]=0;
			}	
		
		if(diamondA)
			{
			posY[1]=PY+450;
			diamondA=0;
			}
		if (posY[1])
			{
			masked_blit((BITMAP *)data[texts].dat,screenbuffer,0,400+language*20,96,posY[1],160,20);
			posY[1]-=2;
			if(posY[1]<PY-60)
				posY[1]=0;
			}	
		
		if(GOVER==1 && !posY[2])
			posY[2]=PY+450;
			
		if (GOVER==1 && posY[2])
			{
			masked_blit((BITMAP *)data[texts].dat,screenbuffer,0,165+language*30,96,posY[2],160,30);
			posY[2]-= (posY[2]>PY+100);
			}	
		if(GOVER!=1)
			posY[2]=0;
		
		if(scoreU)
			{
			posY[3]=PY+450;
			scoreU=0;
			}
		if (posY[3])
			{
			masked_blit((BITMAP *)data[texts].dat,screenbuffer,0,320+language*40,96,posY[3],160,40);
			posY[3]-=3;
			if(posY[3]<PY-60)
				posY[3]=0;
			}	
		
		if(rowD)
			{
			posY[4]=PY+450;
			rowD=0;
			}
		if (posY[4])
			{
			masked_blit((BITMAP *)data[texts].dat,screenbuffer,0,440+language*40,96,posY[4],160,40);
			posY[4]-=3;
			if(posY[4]<PY-60)
				posY[4]=0;
			}	
}			
				


void redraw_Blocks(int actionflag,int updateflag)
{              
		int animFinaleB[]={lookS,lookS+1,lookU,lookD,lookUD,lookUD+1,lookDD,lookDD+1};
		int animPause[]={wait1,lookS,lookS1,lookU,wait3,lookD,wait2,stand,lookDD,lookDD,lookUD,lookUD};
		int animFinale[]={goodBy,wave1};
		
		static int doubleforbidden[BAY+1];
		
		bool animateGismos=0;
		
		for(int i=1;i<BAY;i++)
			{
		//	prints(10,10+i*15,doubleforbidden[i]);
			
			if(doubleforbidden[i])
				doubleforbidden[i]--;
			}
		
		
		
		if (animtimer>14) 
			{
			animateGismos=1;
			animtimer=0;
			}
		
		if(	DRAWALL || animateGismos)
			{
			for (int y=1; y<BAY+1;y++)
				{  
				for (int x=1; x<BAX+1;x++)
					{   
					if(animPHA[x][y]>99)
						{
						blit((BITMAP *)data[shape].dat,screenbuffer,160,0,1200-PX+BPX[x][y],BPY[x][y],32,32);
						for(int i=0;i<20;i++)
							putpixel(screenbuffer,1200-PX+BPX[x][y]+8+rand()%16,BPY[x][y]+8+rand()%16,rand()%16+16);
						if(--animPHA[x][y]==100)
							animPHA[x][y]=0;
						continue;
						}
		
					switch (BPC[x][y])
						{
						case 0: 
							if(actionflag==actionFinaleC && y!=1)
								blit((BITMAP *)data[shape].dat,screenbuffer,0,0,1200-PX+BPX[x][y],BPY[x][y]-Bpy[x][y],32,32);
							break;
						case 1:  
							{
							if(DRAWALL && actionflag!=actionFinaleB) 
								blit((BITMAP *)data[shape].dat,screenbuffer,32,0,1200-PX+BPX[x][y],BPY[x][y]-Bpy[x][y],32,32);
							break;
							}
						case 3:  
							blit((BITMAP *)data[shape].dat,screenbuffer,96,0,1200-PX+BPX[x][y],BPY[x][y],32,32);break;
						case 4:  
							blit((BITMAP *)data[shape].dat,screenbuffer,128,0,1200-PX+BPX[x][y],BPY[x][y],32,32);break;
						case 6:
							blit (animation,screenbuffer,544,rain,1200-PX+BPX[x][y],BPY[x][y],32,32);
							break;                                        
						case 2:
							{
							if (animateGismos && actionflag==actionFinaleA)
								{
								if(animSEQ[x][y]!=shake)
									{
									animSEQ[x][y]=shake;
									animPHA[x][y]=rand()%6;		
									}
								if(++animPHA[x][y]==ANIM[shake/2].loopEnd) 
									{
									animPHA[x][y]=ANIM[shake/2].loopStart+rand()%10;
									}
								}
						
							if (animateGismos && actionflag==actionFinaleB)
								{
								if(animSEQ[x][y]==shake)
									animPHA[x][y]=100;
								if(++animPHA[x][y]==ANIM[animSEQ[x][y]/2].loopEnd && animREP[x][y]) 
									{
									animREP[x][y]--;
									animPHA[x][y]=ANIM[animSEQ[x][y]/2].loopStart;
									}
		
								if (animPHA[x][y]>ANIM[animSEQ[x][y]/2].lengh-1) 
									{
									animSEQ[x][y]=animFinaleB[rand()%8];	
									animREP[x][y]=rand()%6+3;
									animPHA[x][y]=0;
									}
								}
		
							if (animateGismos && actionflag==actionFinaleC)
								{
								if(animSEQ[x][y]!=goodBy && animSEQ[x][y]!=(goodBy+1) && animSEQ[x][y]!=wave1 && animSEQ[x][y]!=wave1+1)
									{
									animSEQ[x][y]=animFinale[rand()%2]+rand()%2;
									animPHA[x][y]=rand()%3;		
									}
								if(++animPHA[x][y]==ANIM[animSEQ[x][y]/2].loopEnd)
									{
									animPHA[x][y]=ANIM[animSEQ[x][y]/2].loopStart;
									}
		
								}
		
							{ 
							if (animateGismos && !actionflag)
								{
								if(!CHANGEALLOWED && (animSEQ[x][y]==whisper1 || animSEQ[x][y]==whisper1+1 || animSEQ[x][y]==whisper2 || animSEQ[x][y]==whisper2+1))
									animREP[x][y]=0;
								if(++animPHA[x][y]==ANIM[animSEQ[x][y]/2].loopEnd && animREP[x][y] && (SHP.C[0]!=5 || (animSEQ[x][y]==rain || animSEQ[x][y]==rain+1)))
									{
									animREP[x][y]--;
									animPHA[x][y]=ANIM[animSEQ[x][y]/2].loopStart;
									}
								if (animPHA[x][y]==ANIM[animSEQ[x][y]/2].lengh) 
									{
									if(updateflag==update_pause)
										{
										animSEQ[x][y]=animPause[rand()%12]+rand()%2;	
										animREP[x][y]=rand()%(ANIM[animSEQ[x][y]/2].repeats)+ANIM[animSEQ[x][y]/2].repeatmin;
										animPHA[x][y]=0;
										}
									else
										if(updateflag==update_abort)
											{
											animSEQ[x][y]=wave1+rand()%2;	
											animREP[x][y]=rand()%(ANIM[animSEQ[x][y]/2].repeats)+ANIM[animSEQ[x][y]/2].repeatmin;
											animPHA[x][y]=0;
											}
										else
											if(!TUT && CHANGEALLOWED  &&  rand()%300==1)
												{
												animSEQ[x][y]=wc;	
												animREP[x][y]=rand()%(ANIM[wc/2].repeats)+ANIM[wc/2].repeatmin;
												animPHA[x][y]=0;
												}
											else
												{
												if(!TUT && CHANGEALLOWED && !doubleforbidden[y] && rand()%300==1 && x>1 && BPC[x-1][y]==2 && animSEQ[x-1][y]!=wc)
													{
													animSEQ[x-1][y]=change1;
													animSEQ[x][y]=change2;	
													animPHA[x-1][y]=0;
													animPHA[x][y]=0;
													animREP[x-1][y]=0;
													animREP[x][y]=0;
													doubleforbidden[y]=500;
													}
												else	
													if(!TUT && CHANGEALLOWED && !doubleforbidden[y] && rand()%300==2 && x>1 && BPC[x-1][y]==2 && animSEQ[x-1][y]!=wc)
														{
														animSEQ[x-1][y]=whisper1;
														animSEQ[x][y]=whisper2;	
														animPHA[x-1][y]=0;
														animPHA[x][y]=0;
														int r=rand()%10+5;
														animREP[x-1][y]=r;
														animREP[x][y]=r;
														doubleforbidden[y]=500;
														}
													else
														if(!TUT && CHANGEALLOWED && !doubleforbidden[y] && rand()%300==3 && x>1 && BPC[x-1][y]==2 && animSEQ[x-1][y]!=wc)
															{
															animSEQ[x][y]=whisper1+1;
															animSEQ[x-1][y]=whisper2+1;	
															animPHA[x-1][y]=0;
															animPHA[x][y]=0;
															int r=rand()%10+5;
															animREP[x-1][y]=r;
															animREP[x][y]=r;
															doubleforbidden[y]=500;
															}
														else
															{
															if(TUT)
																animSEQ[x][y]=rand()%24;
															else
																animSEQ[x][y]=rand()%(24+(DAT.levelups/2));
															
															if(animSEQ[x][y]>57)
																animSEQ[x][y]=rand()%57;
															if (SHP.C[0]==5 || !CHANGEALLOWED)
																{
																if(x<SHP.BX )
																	animSEQ[x][y]=lookUD;
																if(x>SHP.BX )
																	animSEQ[x][y]=lookUD+1;
																if(x==SHP.BX  )
																	animSEQ[x][y]=lookU;	
																if((x<SHP.BX && y==SHP.BY))
																	animSEQ[x][y]=lookS;
																if((x>SHP.BX && y==SHP.BY))
																	animSEQ[x][y]=lookS+1;
																if((x<SHP.BX && y>SHP.BY))
																	animSEQ[x][y]=lookDD;
																if((x>SHP.BX && y>SHP.BY))
																	animSEQ[x][y]=lookDD+1;
																animREP[x][y]=0;
																}
		
															if((animSEQ[x][y]==hammer && (BPC[x+1][y]!=1 || !CHANGEALLOWED)) || (animSEQ[x][y]==hammer+1 && (BPC[x-1][y]!=1 || !CHANGEALLOWED)))
																animSEQ[x][y]=rand()%48;
															animPHA[x][y]=0;
															animREP[x][y]=rand()%(ANIM[animSEQ[x][y]/2].repeats)+ANIM[animSEQ[x][y]/2].repeatmin;
															}
												}
									}
								}
						}
		
		blit (animation,screenbuffer,animPHA[x][y]*32,animSEQ[x][y]*32,1200-PX+BPX[x][y],BPY[x][y]-Bpy[x][y],32,32);
		
		}
		}
		}
		}
		}
}	



     



void curtain()
{
		char *t1[]={"%d points","%d Punkte"};
		int yb;
		int y1=SHP.BY-1;
		
		int a;
		int col;	
		
		set_volume(255,180);
		play_sample((SAMPLE *)data[Y_curtain].dat, 255, 155,2000, 1);
		DRAWALL=1;
		
		for(int i=0;i<(BAX+2)*32;i+=128)
			blit((BITMAP *)data[curtainT].dat,screenbuffer,0,0,i,650,128,SHP.C[3]*32);
		clear_MBoard();
		
		char *t[]={
		"No Gismo will be harmed","during the procedure!","Promised!",
		"kein Gismo wird w&hrend der","folgenden Prozedur gesch&digt!","Versprochen!"
		};
		
		if(!TUT)
			for(int i=0;i<3;i++)
				show_Message(t[language*3+i],2+i);
		
		SHP.C[2]=SHP.BY;
		
		yb=SHP.C[3]*32;
		if (y1-SHP.C[3]<1)
		yb=y1*32;
		
		
		for(int i=0;i<yb;i++)
			{
			masked_blit (screenbuffer,screenbuffer,0,650,1200-PX+BPX[1][y1],BPY[1][y1],BAX*32,i);
			build_Shape(0);
			for(int j=0;j<200;j++)
				putpixel(screenbuffer,rand()%250,rand()%90+650,getpixel(screenbuffer,rand()%250,rand()%90+650));
			wait(10,2);
			}
		
		int dg=0;
		
		timer=0;
		
		while(timer<70)
			{
			GM.fuel=(1000-timer*(1000.0/65.0));
			if(GM.fuel<0)
				GM.fuel=0;
			yb=SHP.C[3]*32;
			if (y1-SHP.C[3]<1)
				yb=y1*32;
			wait(10,2);
			masked_blit (screenbuffer,screenbuffer,0,650,1200-PX+BPX[1][y1],BPY[1][y1],BAX*32,yb);
			build_Shape(0);
			blit(buffer2,buffer3,0,0,0,0,32,32);
			clear(buffer2);
			if (timer>10)
				dg=(timer-10)/2;
			stretch_blit(buffer3,buffer2,0,0,32,32,dg/2,dg,32-dg,32-dg);
		
			for(int j=0;j<200;j++)
				{
				col=getpixel(screenbuffer,rand()%250,rand()%90+650);
				if (timer>50)
					if(rand()%timer>5)
						col=0;
				putpixel(screenbuffer,rand()%250,rand()%90+650,col);
				}
		
			blit(screenbuffer,screenbuffer,0,650,0,651,(BAX)*32,SHP.C[3]*32);
			blit(screenbuffer,screenbuffer,0,700,0,650,(BAX)*32,1);
		
			if (timer>20 && timer<22)
				{
				for (int i=y1; i>y1-SHP.C[3];i--)
					{  
					for (int j=1; j<BAX+1;j++)
						{
						if (BPC[j][i]==2 ) 
							{
							animSEQ[j][i]=rain+rand()%2;
							animPHA[j][i]=0;
							animREP[j][i]=10000;
							}	
						}
					}
				}  
			}     
		
		wait(800,2);
		
		stop_sample((SAMPLE *)data[Y_curtain].dat);
		set_volume(255,255);  
		
		a=0;
		for (int i=y1; i>y1-SHP.C[3];i--)
			{  
			for (int j=1; j<BAX+1;j++)
				{
				if (animSEQ[j][i]==rain || animSEQ[j][i]==rain+1) 
					{                              
					BPC[j][i]=0;
					a++;
					play_sample((SAMPLE *)data[Y_Ballplop].dat, 255, 155,3000, 0);
					if(!TUT)
						{
						clear_MBoard();
						textout_centre_ex(screenbuffer,fontL1,"--- plop ---",MBoard[0]+(MBoard[2]/2),MBoard[1]+40,-1,-1);
						textprintf_centre_ex(screenbuffer, fontL1, MBoard[0]+(MBoard[2]/2),MBoard[1]+70,-1,-1, t1[language], a*GismoCurtainScore);
						update_Score(0,1,GismoCurtainScore);
						}    
					SHP.BX=j;
					SHP.BY=i;
					check_column();
					wait(400,2);
					}
				}
			}
		
		GM.full=0;
		display_Diamond(0);
		check_row();
}


void column_setdown()
{
		for(int i=SHP.BY;i<BAY;i++)
			Bpy[SHP.BX][i]=32;
		
		for (int i=SHP.BY;i<BAY+1;i++)
			{ 
			BPC[SHP.BX][i]=BPC[SHP.BX][i+1];   
			animSEQ[SHP.BX][i]=animSEQ[SHP.BX][i+1];
			animPHA[SHP.BX][i]=animPHA[SHP.BX][i+1];
			animREP[SHP.BX][i]=animREP[SHP.BX][i+1];
			}			    	        
}


void fade_out_Playfield(int f)
{
		if(f==1 || f==3 )
			{
			for(int i=27;i>15;i--)
				{
				if(f==3  && i==20)
					DRAWFLAG=1;
				for(int x=0;x<PW;x++)
					for(int y=0;y<PH;y++)
						{
						if(getpixel(screenbuffer1,PX+x,PY+y))
							putpixel(screenbuffer1,PX+x,PY+y,i);
						}		
					wait(50,update_menue);
				}
			}
		
		if(f==2 || f==4)
			{
			for(int j=27;j>0;j-=1)
				{
				int i=j;
					if (j<16)	
						i=16;
					if(f==4)
						{
						wait(40,update_menue_start);
						}
					for(int x=0;x<PW;x++)
						for(int y=0;y<PH;y++)
							{
							if(getpixel(screenbuffer,PX+x,PY+y))
								putpixel(screenbuffer,PX+x,PY+y,i);
							}		
					if(f!=4)
						wait(50);
					blit(screenbuffer,screen,PX,PY,PX,PY,PW,PH);
				}
			}
		if(f>30)
			{
			for(int x=0;x<PW;x++)
				for(int y=0;y<PH;y++)
					{
					if(getpixel(screenbuffer,PX+x,PY+y))
						putpixel(screenbuffer,PX+x,PY+y,f-25);
					}		
			
			return;
			}
		
		
		if(f>10)
			{
			for(int x=0;x<PW;x++)
				for(int y=0;y<PH;y++)
					{
					if(getpixel(screenbuffer1,PX+x,PY+y))
						putpixel(screenbuffer1,PX+x,PY+y,f);
					}		
			}
}



void fade_in_Playfield(int f)
{
		if(f==1)
			{
			for(int i=16;i<24;i++)
				{
				for(int x=0;x<PW;x++)
					for(int y=0;y<PH;y++)
						{
						if(getpixel(screenbuffer1,PX+x,PY+y))
							putpixel(screenbuffer1,PX+x,PY+y,i);
						}		
					wait(50,update_menue);
				}
			}
}


