/**************************************************
 * Fruit Land                                     *
 *                                                *
 * Coding by: Arjan Bakker                        *
 * Bug fixing/Linux port: Georgi                  *
 **************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <allegro.h>

// Descriptors removed
// Changed by Georgi
// All filenames converted to lowcase

#define UP      1              //defines for directions OBJECTS
#define DOWN    2
#define LEFT    3
#define RIGHT   4

#define HI_ENTRIES 8           //number of entries in hiscore table
#define NAME_LENGTH 8+1        //length of names in hiscore table

BITMAP *intro;                 //storage for intro-screen
BITMAP *page;                  //temporary storage for next game-frame
BITMAP *shrink;                //temporary storage for shrinking the current frame
BITMAP *patterns;              //storage for patterns

RGB pal1[256];                 //storage for intro-screen palet
RGB pal2[256];                 //storage for in-game palet
RGB white={63,63,63};          //duh...black color
RGB black={0,0,0};             //white color

char levels[4736];             //storage space for 25 levels

char level_data[15*11];        //storage space for current level

typedef struct OBJECT
{
  int dx;       // x-coordinaat in level_data
  int dy;       // y-coordinaat in level_data
  int x;        // x-coordinaat on screen
  int y;        // y-coordinaat on screen
  int dir;      // direction
  int step;     // number of steps OBJECT has moved
  int l;        // l==1 -> valid data in OBJECT
  int sx;       // x-source data
  int sy;       // y-source data
} OBJECT;

/* define storage space for 16 OBJECTS
   object 0 = player
   object 1-4 = enemy
   object 5-14 = rocks
   object 15 = block */
OBJECT objects[16];

// default hiscore-table score entries
int hi_scores[HI_ENTRIES]={100000,90000,80000,70000,60000,50000,30000,100};
// default hiscore-table name entries
char hi_names[HI_ENTRIES][NAME_LENGTH]=
     {"ARJAN   ","ERWIN   ","KARIN   ","ADDY    ",
      "GERRY   ","BAS     ","TOM     ","LAURENS "};

//cheaters! these are all passwords
char passlist[4][7]={"QINFGF","RGWODA","TQVEAZ","OFCPMD"};

int time;         // available time in level
int score;        // current score
int level;        // current level
int lives;        // current no lives
int fruit;        // number of fruits left in level
int dead;         // is player dead or not?
int freeze_enemy; // number of frames enemies don't move

volatile int speed_counter;

void inc_speed()
{
  speed_counter++;
}
END_OF_FUNCTION(inc_speed);

//save hiscores to file
void save_hi_scores()
{
int c;
FILE *hiscores=fopen("fruit.hi","wb"); 
/* Changed by Georgi*/

  for (c=0;c!=HI_ENTRIES;c++)               
  {
    fwrite(hi_names[c],NAME_LENGTH,1,hiscores);   
    fwrite(&hi_scores[c],4,1,hiscores); 
  }
  fclose(hiscores);   
}

//load hi-scores
void init_hi_scores()
{
  if (exists("fruit.hi"))
  {
    int c;
    FILE *hiscores=fopen("fruit.hi","rb");
    for (c=0;c!=HI_ENTRIES;c++)   
    {
      fread(hi_names[c],NAME_LENGTH,1,hiscores); 
      fread(&hi_scores[c],4,1,hiscores);   
    }
    fclose(hiscores);                   
  }
  else
    save_hi_scores(); 
}

//print number on page
void print_number(int px,int py,int n,int s)  /* x,y,number,length */
{
int c;
  px=px+8*(s-1);      
  for (c=0;c!=s;c++) 
  {
    blit(patterns,page,(n%10)*8+48,8,px,py,8,8);
    n=n/10;            
    px=px-8;           
  }
}

//show the hiscore table
void show_hi_scores()
{
int c;

  rectfill(page,0,0,256,224,0); 
  textout_centre(page,font,"HI SCORES",128,40,255);

  for (c=0;c!=HI_ENTRIES;c++)     
  {
    textout_centre(page,font,hi_names[c],64,80+10*c,255); 
    print_number(144,80+10*c,hi_scores[c],8);           
  }

  vsync();
  set_color(255,&white);
  blit(page,screen,0,0,0,0,256,224);

  while(key[KEY_SPACE])
  {
  }

  while(!key[KEY_SPACE])
  {
  }
}

//graphics were taken from msx2-version of fruit land
//so transparancy needs to be fixed
void replace_bgcolor()
{
int sx,sy,p;

  p=getpixel(patterns,0,16);  
  for (sx=0;sx!=256;sx++)   
  {
    for (sy=32;sy!=128;sy++)
    {
      if (getpixel(patterns,sx,sy)==p)
        putpixel(patterns,sx,sy,0);  
    }
  }
}

//load all graphics and level-data
void init_gfx()
{
  FILE *levdat=fopen("fruit.dat","rb");
  fread(levels,1,4736,levdat);       
  fclose(levdat);                  

  set_color_depth(8);                  
  //setup screenmode with a weird size :)
  set_gfx_mode(GFX_AUTODETECT,256,224,256,224);
  page=create_bitmap(256,224);        
  shrink=create_bitmap(256,192);     
  intro=load_bmp("intro.bmp",pal1);   
  patterns=load_bmp("patterns.bmp",pal2); 
  replace_bgcolor();                    
}

//invert colors in rectangle
void xor_rect(BITMAP *bmp,int sx,int sy,int w,int h)
{
  xor_mode(TRUE);  
  rectfill(bmp,sx,sy,sx+w-1,sy+h-1,255);  
  solid_mode();     
}

//show intro-screen
void show_intro()
{
  set_palette(pal1);     

  set_color(255,&white);
  rectfill(intro,0,160,255,200,0); 

  //print all options in intro-screen
  textout_centre(intro,font,"START",128,170,255);
  textout_centre(intro,font,"PASSWORD",128,180,255);
  textout_centre(intro,font,"HI-SCORES",128,190,255);
  textout_centre(intro,font,"QUIT",128,200,255);

  //highlight START
  xor_rect(intro,80,169,96,10);

  vsync();
  clear(screen);
  blit(intro,screen,0,0,0,0,256,224);
}

//prints text on screen, uses font from patterns.bmp
void draw_text_out(BITMAP *bmp,int x,int y,char *s)
{
unsigned int c;
int sx,sy;

  for (c=0;c!=strlen(s);c++) 
  {
    if (s[c]==58)   
    {
      sx=128;       
      sy=8;
    }
    else
    {
      sx=(int)(s[c]-65)*8+48; 
      sy=0;
    }
    blit(patterns,bmp,sx,sy,x+c*8,y,8,8);  
  }
}

//draw all texts for player/level information
void draw_texts()
{
  draw_text_out(page,8,192,"SCORE:");
  draw_text_out(page,8,200,"TIME :");
  draw_text_out(page,176,192,"LEVEL:");
  draw_text_out(page,176,200,"LIVES:");
}

//draw the border around the level
void draw_border()
{
int x;
int y;

  for (x=8;x!=248;x=x+16)
  {
    blit(patterns,page,16,0,x,0,16,8);
    blit(patterns,page,16,8,x,184,16,8);
  }

  for (y=8;y!=184;y=y+16)
  {
    blit(patterns,page,0,0,0,y,8,16);
    blit(patterns,page,8,0,248,y,8,16);
  }

  blit(patterns,page,32,0,0,0,8,8);
  blit(patterns,page,40,0,0,184,8,8);
  blit(patterns,page,32,8,248,0,8,8);
  blit(patterns,page,40,8,248,184,8,8);
}

//draw the level
void draw_level()
{
int x;
int y;
int xx;
int yy;

  for (y=0;y!=11;y++)    
  {
    for (x=0;x!=15;x++)  
    {
       xx=level_data[y*15+x]%16;  
       yy=level_data[y*15+x]/16;  
       //blit pattern to page
       blit(patterns,page,xx*16,yy*16+16,x*16+8,y*16+8,16,16);
    }
  }
}

//print the entire level
void print_level()
{
  clear(page);
  draw_border();   
  draw_level();    
  draw_texts();    
  set_palette(pal2);
  set_color(0,&black);
  set_color(getpixel(patterns,133,39),&black);
  blit(page,screen,0,0,0,0,256,224);
}

//count the number of fruits in this level
void count_fruit()
{
int a;

  fruit=0;
  for (a=0;a!=15*11;a++)   
  {
    if (level_data[a]==4)  
      fruit++;
  }
}

//let the player select an option from the menu
int select_option()
{
int bary=169;
int option=0;

  while(!key[KEY_SPACE])
  {
    if (key[KEY_UP])     
    {
      vsync();
      xor_rect(screen,80,bary,96,10);   

      if (option>0)                 
      {
        option--;        
        bary=bary-10;
      }
      else
      {
        option=3;        
        bary=bary+30;
      }

      xor_rect(screen,80,bary,96,10);  

      while(key[KEY_UP]) 
      {
      }
    }
    if (key[KEY_DOWN])   
    {
      vsync();
      xor_rect(screen,80,bary,96,10);

      if (option<3)    
      {
        option++;                       
        bary=bary+10;
      }
      else
      {
        option=0;                      
        bary=bary-30;
      }

      xor_rect(screen,80,bary,96,10);   

      while(key[KEY_DOWN])              
      {
      }
    }
  }
  return option;
}

//draw a simple text box with a text
//textbox will be display on centre of screen
void draw_box_text(int x,int y,char *text)
{
unsigned int c;
int l;

  l=4*(strlen(text)+1);   
  rectfill(page,x-l-8,y,x+l+15,y+39,0);     
  blit(patterns,page,32,0,x-l-8,y,8,8);    
  blit(patterns,page,40,0,x-l-8,y+32,8,8);  
  blit(patterns,page,32,8,x+l+8,y,8,8);     
  blit(patterns,page,40,8,x+l+8,y+32,8,8); 
  blit(patterns,page,0,0,x-l-8,y+8,8,8);   
  blit(patterns,page,0,0,x-l-8,y+16,8,8);
  blit(patterns,page,0,0,x-l-8,y+24,8,8);
  blit(patterns,page,8,0,x+l+8,y+8,8,8); 
  blit(patterns,page,8,0,x+l+8,y+16,8,8);
  blit(patterns,page,8,0,x+l+8,y+24,8,8);

  for (c=0;c!=strlen(text)+2;c++)          
    blit(patterns,page,16,0,x-l+c*8,y,8,8);
  for (c=0;c!=strlen(text)+2;c++)          
    blit(patterns,page,16,8,x-l+c*8,y+32,8,8);
  for (c=0;c!=strlen(text);c++)           
    blit(patterns,page,(((int)text[c])-59)*8,0,x-l+c*8+8,y+16,8,8);
}

// print 'congratulations' message on screen
void congratulations()
{
  draw_box_text(128,80,"CONGRATULATIONS"); 
  vsync();
  blit(page,screen,0,0,0,0,256,224);      
  clear_keybuf();                        
  while(!keypressed());                   
  {}
}

void new_hi_score()
{
int c,p,x,y,s;
char string[NAME_LENGTH]; /* Changed by Georgi */
                /* old program fails here */
  strcpy(string,"AAAAAAAA");     

  if (score<hi_scores[HI_ENTRIES - 1])  
  {                                     
    show_hi_scores();                  
    return;                             
  }

  s=HI_ENTRIES - 1;     
  while(!(score<hi_scores[s]) && s >= 0)  
    s--;                       

  s++;       
  y=80+10*s; 
  if (s!=HI_ENTRIES - 1)         
  {
    for (p=HI_ENTRIES - 1;p!=s;p--)      
    {                                    
      hi_scores[p]=hi_scores[p-1];
      strcpy(hi_names[p],hi_names[p-1]);
    }
  }

  hi_scores[s]=score;          
  strcpy(hi_names[s],string);  

  rectfill(page,0,0,256,224,0); 
  textout_centre(page,font,"HI SCORES",128,40,255); 

  for (c=0;c!=HI_ENTRIES;c++)   
  {
    textout_centre(page,font,hi_names[c],64,80+10*c,255);
    print_number(144,80+10*c,hi_scores[c],8);  
  }

  vsync();
  set_color(255,&white);
  blit(page,screen,0,0,0,0,256,224);

  c=0;  
  x=32;
  xor_rect(screen,x,y,8,8); 
  while(!key[KEY_ENTER])
  {
    if (key[KEY_LEFT])
    {
      vsync();
      xor_rect(screen,x,y,8,8); 

      if (c==0) 
      {
        c=7; 
        x=x+56;
      }
      else
      {
        c--;
        x=x-8;
      }

      xor_rect(screen,x,y,8,8); 

      while(key[KEY_LEFT])
      {}
    }

    if (key[KEY_RIGHT]) 
    {
      vsync();
      xor_rect(screen,x,y,8,8);

      if (c==7)
      {
        c=0;
        x=32;
      }
      else
      {
        c++;
        x=x+8;
      }

      xor_rect(screen,x,y,8,8);

      while(key[KEY_RIGHT])
      {}
    }

    if (key[KEY_UP]) 
    {
      p=string[c]+1; 
      if (p==33)
        p=65;  
      if (p==91)
        p=32;  
      string[c]=p;  

      vsync();
      textout_centre(screen,font,string,64,y,255); 
      xor_rect(screen,x,y,8,8);

      while(key[KEY_UP])
      {}
    }

    if (key[KEY_DOWN]) 
    {
      p=string[c]-1; 
      if (p==31)   
        p=90;    
      if (p==64)  
        p=32;   
      string[c]=p;  

      vsync();
      textout_centre(screen,font,string,64,y,255); 
      xor_rect(screen,x,y,8,8);   

      while(key[KEY_DOWN])  
      {}
    }
  }

  strcpy(hi_names[s],string);      
  save_hi_scores();               
}

//game over message
void game_over()
{
  draw_box_text(128,80,"GAME OVER");  
  vsync();
  blit(page,screen,0,0,0,0,255,224); 
  clear_keybuf();          
  while(!keypressed());          
  {}
  new_hi_score();               
}

//let the user input a password
int enter_password()
{
char password[7]="AAAAAA"; //dummy password

int c;

  vsync();
  clear(screen);

  vsync();
  textout(screen,font,"ENTER PASSWORD",72,64,255); 
  textout(screen,font,password,102,96,255);       
  xor_rect(screen,102,96,8,8);                   

  c=0;
  while(!key[KEY_ENTER])
  {
    if (key[KEY_LEFT])
    {
      vsync();
      xor_rect(screen,102+c*8,96,8,8);

      if (c)
        c--;
      else
        c=5;

      xor_rect(screen,102+c*8,96,8,8);

      while(key[KEY_LEFT])
      {}
    }

    if (key[KEY_RIGHT])
    {
      vsync();
      xor_rect(screen,102+c*8,96,8,8);

      if (c==5)
        c=0;
      else
        c++;

      xor_rect(screen,102+c*8,96,8,8);

      while(key[KEY_RIGHT])
      {}
    }

    if (key[KEY_UP])
    {
      if (password[c]==90)
        password[c]=65;
      else
        password[c]++;

      vsync();
      textout(screen,font,password,102,96,255);
      xor_rect(screen,102+c*8,96,8,8);

      while(key[KEY_UP])
      {
      }
    }

    if (key[KEY_DOWN])
    {
      if (password[c]==65)
        password[c]=90;
      else
        password[c]--;

      vsync();
      textout(screen,font,password,102,96,255);
      xor_rect(screen,102+c*8,96,8,8);

      while(key[KEY_DOWN])
      {
      }
    }
  }

  c=0;
  while(c!=4 && strcmp(password,passlist[c])!=0) 
    c++;

  if (c==4)
  {
    textout(screen,font,"ERROR!",102,128,255);
    clear_keybuf();  
    while(!keypressed())  
    {}

    return 0; 
  }
  else
    return (c+1)*5+1;
}

//show password after completing
void show_password()
{
  if (level!=5 && level!=10 && level!=15 && level!=20)
    return;

  vsync();
  clear(screen);
  set_color(255,&white);
  textout_centre(screen,font,"PASSWORD:",128,64,255);
  textout_centre(screen,font,passlist[level/5-1],128,96,255);
  clear_keybuf();
  while(!keypressed());
  {
  }
}

void print_stats()
{
  print_number(64,192,score,8);
  print_number(64,200,time,4);
  print_number(232,192,level,2);
  print_number(232,200,lives,2);
}

void next_level()
{
  draw_box_text(128,80,"WELL DONE");
  vsync();
  blit(page,screen,64,80,64,80,128,40);

  while(time>0)
  {
    score=score+level*10;
    time=time-2;
    print_stats();
    vsync();
    blit(page,screen,0,192,0,192,256,24);
  }
  show_password();
  level++;
}

void check_overlap(int i)
{
int c,sx,sy,sx1,sy1,c1;

  if (i)
    c1=5;
  else
    c1=1;

  sx=objects[i].x;
  sy=objects[i].y;
  for (c=c1;c!=15;c++)
  {
    if (objects[c].l && objects[i].l)
    {
      sx1=objects[c].x;
      sy1=objects[c].y;
      if (ABS(sx1-sx)<13 && ABS(sy1-sy)<13)
      {
        if (!i)
          dead=1;
        else
        {
          score=score+500;
          objects[i].l=0;
        }
      }
    }
  }
}

void check_colission()
{
int e;
  for (e=0;e!=5;e++)
    check_overlap(e);
}

void wait_frame()
{
  while(!speed_counter)
  {
  }
  speed_counter=0;
}

void draw_lines(int nl)
{
int c,p,y1,y2;

  p=1;
  while(nl!=0)
  {
    p=p*2;
    nl--;
  }

  rectfill(shrink,0,0,255,96-(96/p),0);
  rectfill(shrink,0,95+(96/p),255,192,0);

  y1=96-(96/p);
  y2=96+(96/p);
  for (c=0;c<96;c=c+p)
  {
    blit(page,shrink,0,c,0,y1,256,2);
    blit(page,shrink,0,191-c,0,y2,256,2);
    y1++;
    y2--;
  }
  wait_frame();
  wait_frame();
  wait_frame();
  blit(shrink,screen,0,0,0,0,256,192);
}

void pause_game()
{
int c;
  for (c=0;c!=6;c++)
    draw_lines(c);

  clear(shrink);
  draw_text_out(shrink,108,90,"PAUSE");
  vsync();
  blit(shrink,screen,0,90,0,90,256,12);
  while(key[KEY_F1])
  {
  }

  while(!key[KEY_F1])
  {
  }

  for (c=5;c!=0;c--)
    draw_lines(c);

}

void init_level_data()
{
int a,c,d;
  a=(level-1)*(15*11+4);        /* calculate startadres level */

  /*stupid Binary Coded Decimal conversion */
  time=levels[a+1]&15 + ((levels[a+1]&240)>>4)*10;
  time=time+(levels[a]&15)*100 + ((levels[a]&240)>>4)*1000;
  time=time+time/2;            /* 50% extra time */
  a=a+4;
  for (c=0;c!=15*11;c++)
  {
    d=levels[a+c];
    if (d==15)
      d--;  /* here used to be another type of enemy */
    level_data[c]=d; /* copy level-data to temporary level */
  }
  a=a-2;
  level_data[levels[a]*15+levels[a+1]]=32;
}

void delete_objects()
{
int nc;

  for (nc=1;nc!=15;nc++)
  {
    if (objects[nc].l)
    {
      blit(patterns,page,0,16,objects[nc].x,objects[nc].y,16,16);
    }
  }
}

void print_objects()
{
int nc;

  for (nc=0;nc!=16;nc++)
  {
    if (objects[nc].l)
    {
      masked_blit(patterns,page,objects[nc].sx,objects[nc].sy,objects[nc].x,objects[nc].y,16,16);
    }
  }
}

void turn_screen()
{
int t;
int c;
int y;

  for (c=0;c!=6;c++)
    draw_lines(c);

  level_data[objects[0].dx+15*objects[0].dy]=0;
  for (y=0;y!=5;y++)
  {
    for (c=0;c!=15;c++)
    {
      t=level_data[y*15+c];
      level_data[y*15+c]=level_data[(10-y)*15+c];
      level_data[(10-y)*15+c]=t;
    }
  }

  for (c=0;c!=16;c++)
  {
    if (objects[c].l)
    {
      objects[c].dy=10-objects[c].dy;
      objects[c].y=176-objects[c].y;
      if (c<5 && objects[c].step && (objects[c].dir==UP || objects[c].dir==DOWN))
      {
        if (objects[c].dir==UP)
          objects[c].dir=DOWN;
        else
          objects[c].dir=UP;
      }
    }
  }

  draw_level();

  for (c=5;c!=15;c++)
  {
    if (objects[c].l && objects[c].dir==DOWN)
    {
      objects[c].dy--;
      objects[c].step=16-objects[c].step;
    }
  }

  for (c=5;c!=0;c--)
    draw_lines(c);
}

void teleport()
{
int c;
  level_data[objects[0].dx+objects[0].dy*15]=0;
  blit(patterns,page,0,16,objects[0].x,objects[0].y,16,16);
  c=0;
  while (level_data[c]!=6)
  {
    c++;
  }
  objects[0].dx=c%15;
  objects[0].dy=c/15;
  objects[0].x=(c%15)*16+8;
  objects[0].y=(c/15)*16+8;
  level_data[c]=0;
}

int search_rock(int xr,int yr)
{
int c;

  for (c=5; c!=15;c++)
  {
    if (objects[c].l && objects[c].dx==xr && objects[c].dy==yr)
      return c;
  }
  return 0;
}

void get_item()
{
int n;
  n=level_data[objects[0].dx+objects[0].dy*15];
  level_data[objects[0].dx+objects[0].dy*15]=0;

  switch (n)
  {
  case 1:
    score++;
    level_data[objects[0].dx+objects[0].dy*15]=0;
    break;
  case 4:
    fruit--;
    score=score+500;
    level_data[objects[0].dx+objects[0].dy*15]=0;
    break;
  case 5:
    score=score+100;
    level_data[objects[0].dx+objects[0].dy*15]=0;
    break;
  case 6:
    teleport();
    break;
  case 7:
    time=time+500;
    level_data[objects[0].dx+objects[0].dy*15]=0;
    break;
  case 8:
    turn_screen();
    break;
  case 9:
    lives++;
    level_data[objects[0].dx+objects[0].dy*15]=0;
    break;
  case 10:
    freeze_enemy=500;
    level_data[objects[0].dx+objects[0].dy*15]=0;
    break;
  case 12:
    dead=TRUE;
    break;
  default:
	break;
  }
}

void check_up()
{
int p;
  if (objects[0].dy==0)
    return;
  p=(int)level_data[objects[0].dx+(objects[0].dy-1)*15];
  if (p==2 || p==3)
    return;

  if (p==11)
  {
    if (objects[0].dy>1 && level_data[objects[0].dx-30+15*objects[0].dy]==0)
    {
      objects[15].l=1;
      objects[15].step=16;
      objects[15].dir=UP;
      objects[15].x=objects[0].x;
      objects[15].y=objects[0].y-16;
      level_data[objects[0].dx-30+15*objects[0].dy]=11;
    }
    else
      return;
  }

  objects[0].dir=UP;
  objects[0].step=16;
  objects[0].sx=-16;
  objects[0].sy=64;
}

void check_down()
{
int p;
  if (objects[0].dy==10)
    return;

  p=(int)level_data[objects[0].dx+(objects[0].dy+1)*15];
  if (p==2 || p==3)  /* bij omlaag gaan kan rots verschuiven niet */
    return;

  if (p==11)
  {
    if (objects[0].dy<9 && level_data[objects[0].dx+30+15*objects[0].dy]==0)
    {
      objects[15].l=1;
      objects[15].step=16;
      objects[15].dir=DOWN;
      objects[15].x=objects[0].x;
      objects[15].y=objects[0].y+16;
      level_data[objects[0].dx+30+15*objects[0].dy]=11;
    }
    else
      return;
  }

  objects[0].step=16;
  objects[0].dir=DOWN;
  objects[0].sx=-16;
  objects[0].sy=80;
}

void check_left()
{
int p;
int r;

  if (objects[0].dx==0)
    return;

  p=(int)level_data[objects[0].dx-1+15*objects[0].dy];
  if (p==2)
    return;
  if (p==3 && objects[0].dx>1)
  {
    if ((int)level_data[objects[0].dx-2+15*objects[0].dy]!=0)
      return;
    r=search_rock(objects[0].dx-1,objects[0].dy);
    if (objects[r].dy<10)
      if (level_data[objects[r].dx+15+15*objects[r].dy]==0)
        return;

    objects[r].step=16;
    objects[r].dir=LEFT;
    level_data[objects[0].dx-2+15*objects[0].dy]=255;//zorg dat vijand hier niet kan komen
  }

  if (p==3 && objects[0].dx==1)
    return;

  if (p==11)
  {
    if (objects[0].dx>1 && level_data[objects[0].dx-2+15*objects[0].dy]==0)
    {
      level_data[objects[0].dx-2+15*objects[0].dy]=11;
      objects[15].x=objects[0].x-16;
      objects[15].y=objects[0].y;
      objects[15].step=16;
      objects[15].dir=LEFT;
      objects[15].l=1;
    }
    else
      return;
  }
  if (p==80)
    return;

  if (objects[0].dy>0 && level_data[objects[0].dx-16+15*objects[0].dy]==80)
  {
    r=search_rock(objects[0].dx-1,objects[0].dy-1);
    if (objects[r].step)
      return;
  }

  objects[0].dir=LEFT;
  objects[0].step=16;
  objects[0].sx=-16;
  objects[0].sy=32;

}

void check_right()
{
int p;
int r;

  if (objects[0].dx==14)
    return;

  p=(int)level_data[objects[0].dx+1+15*objects[0].dy];
  if (p==2)
    return;

  if (p==3 && objects[0].dx<13)
  {
    if ((int)level_data[objects[0].dx+2+15*objects[0].dy]!=0)
      return;
    r=search_rock(objects[0].dx+1,objects[0].dy);
    if (objects[r].dy<10)
      if (level_data[objects[r].dx+15+15*objects[r].dy]==0)
        return;

    objects[r].step=16;
    objects[r].dir=RIGHT;
    level_data[objects[0].dx+2+15*objects[0].dy]=255;
  }

  if (p==3 && objects[0].dx==13)
    return;

  if (p==11)
  {
    if (objects[0].dx<13 && level_data[objects[0].dx+2+15*objects[0].dy]==0)
    {
      objects[15].l=1;
      objects[15].dir=RIGHT;
      objects[15].x=objects[0].x+16;
      objects[15].y=objects[0].y;
      objects[15].step=16;
      level_data[objects[0].dx+2+15*objects[0].dy]=11;
    }
    else
      return;
  }

  if (p==80)
    return;

  if (objects[0].dy>0 && level_data[objects[0].dx-14+objects[0].dy]==80)
  {
    r=search_rock(objects[0].dx+1,objects[0].dy-1);
    if (objects[r].step)
      return;
  }

  objects[0].dir=RIGHT;
  objects[0].step=16;
  objects[0].sx=-16;
  objects[0].sy=48;

}

void move_player()
{
  if (key[KEY_UP] && objects[0].dir==0)
    check_up();
  if (key[KEY_DOWN] && objects[0].dir==0)
    check_down();
  if (key[KEY_LEFT] && objects[0].dir==0)
    check_left();
  if (key[KEY_RIGHT] && objects[0].dir==0)
    check_right();
  if (key[KEY_ESC])
    dead=TRUE;

  if (objects[0].dir==0)
    return;

  objects[0].step--;
  if (objects[0].step&1)
    objects[0].sx=objects[0].sx+16;
  if (objects[0].dir==UP)
    objects[0].y--;
  if (objects[0].dir==DOWN)
    objects[0].y++;
  if (objects[0].dir==RIGHT)
    objects[0].x++;
  if (objects[0].dir==LEFT)
    objects[0].x--;

  if (objects[0].step==0)
  {
    if (objects[0].dir==UP)
    {
      objects[0].dy--;
    }
    if (objects[0].dir==DOWN)
    {
      objects[0].dy++;
    }
    if (objects[0].dir==LEFT)
    {
      objects[0].dx--;
    }
    if (objects[0].dir==RIGHT)
    {
      objects[0].dx++;
    }
    objects[0].dir=0;
    get_item();
  }
}

void move_rocks()
{
int r;
int d;
  for (r=5;r!=15;r++)
  {
    if (objects[r].l)        /* is there a rock */
    {
      if (objects[r].dir==0 && objects[r].dy<10)    /* rock already moving? */
      {
        d=level_data[objects[r].dx+15+15*objects[r].dy];
        if (d==0 || d==81) /* rock allowed to move? */
        {
          if (objects[r].l==2)
          {
            objects[r].step=16;
            objects[r].dir=DOWN;
            level_data[objects[r].dx+15*objects[r].dy]=80;
          }
          else
          {
            if (objects[r].dx==objects[0].dx && objects[r].dy==objects[0].dy-1)
            {
              objects[r].step=0;
            }
            else
            {
              objects[r].step=16;
              objects[r].dir=DOWN;
              objects[r].l=2;
              level_data[objects[r].dx+15*objects[r].dy]=80;
            }
          }
        }
      }

      if (objects[r].dir==0)
        objects[r].l=1;

      if (objects[r].dir==DOWN)
      {
        objects[r].y++;
        objects[r].step--;

        if (objects[r].step==0)
        {
          level_data[objects[r].dx+15*objects[r].dy]=0;
          objects[r].dy++;
          level_data[objects[r].dx+15*objects[r].dy]=3;
          objects[r].dir=0;
        }
      }

      if (objects[r].dir==LEFT)
      {
        objects[r].x--;
        objects[r].step--;
        if (objects[r].step==0)
        {
          objects[r].dir=0;
          level_data[objects[r].dx+15*objects[r].dy]=0;
          objects[r].dx--;
          level_data[objects[r].dx+15*objects[r].dy]=3;
        }
      }

      if (objects[r].dir==RIGHT)
      {
        objects[r].x++;
        objects[r].step--;
        if (objects[r].step==0)
        {
          objects[r].dir=0;
          level_data[objects[r].dx+15*objects[r].dy]=0;
          objects[r].dx++;
          level_data[objects[r].dx+15*objects[r].dy]=3;
        }
      }
    }
  }
}

void move_block()
{
  if (objects[15].step==0)
    objects[15].l=0;

  if (objects[15].l==1)
  {
    objects[15].step--;
    if (objects[15].dir==LEFT)
      objects[15].x--;
    if (objects[15].dir==RIGHT)
      objects[15].x++;
    if (objects[15].dir==UP)
      objects[15].y--;
    if (objects[15].dir==DOWN)
      objects[15].y++;
  }
}

void move_type_hor(int e) /* e=enemy number */
{
int posleft;
int posright;
int d;

  posleft=0;
  posright=0;
  if (objects[e].step==0)
  {
    objects[e].sx=112;
    d=level_data[objects[e].dx-1+15*objects[e].dy];
    if (objects[e].dx>0 && (d==0 || d==81))
      posleft=1;
    d=level_data[objects[e].dx+1+15*objects[e].dy];
    if (objects[e].dx<14 && (d==0 || d==81))
      posright=1;

    if (objects[e].dir==LEFT && posleft)
    {
      level_data[objects[e].dx-1+15*objects[e].dy]=81;
      objects[e].step=16;
    }
    if (objects[e].dir==RIGHT && posright)
    {
      objects[e].step=16;
      level_data[objects[e].dx+1+15*objects[e].dy]=81;
    }

    if (objects[e].step==0 && posright && objects[e].dir==LEFT)
    {
      objects[e].step=16;
      objects[e].dir=RIGHT;
      level_data[objects[e].dx+1+15*objects[e].dy]=81;
    }

    if (objects[e].step==0 && posleft && objects[e].dir==RIGHT)
    {
      objects[e].step=16;
      objects[e].dir=LEFT;
      level_data[objects[e].dx-1+15*objects[e].dy]=81;
    }
  }

  if (objects[e].step!=0);
  {
    objects[e].step--;
    if (objects[e].step&1)
      objects[e].sx=objects[e].sx+16;
    if (objects[e].dir==LEFT)
      objects[e].x--;
    if (objects[e].dir==RIGHT)
      objects[e].x++;

    if (objects[e].step==0)
    {
      level_data[objects[e].dx+15*objects[e].dy]=0;
      if (objects[e].dir==LEFT)
        objects[e].dx--;
      if (objects[e].dir==RIGHT)
        objects[e].dx++;
    }
  }
}

void move_type_ver(int e)
{
int posup;
int posdown;
int d;

  posup=0;
  posdown=0;
  if (objects[e].step==0)
  {
    objects[e].sx=112;
    d=level_data[objects[e].dx-15+objects[e].dy*15];
    if (objects[e].dy>0 && (d==0 || d==81))
      posup=1;
    d=level_data[objects[e].dx+15+objects[e].dy*15];
    if (objects[e].dy<10 && (d==0 || d==81))
      posdown=1;

    if (posup && objects[e].dir==UP)
    {
      level_data[objects[e].dx+15*objects[e].dy-15]=81;
      objects[e].step=16;
    }
    if (posdown && objects[e].dir==DOWN)
    {
      objects[e].step=16;
      level_data[objects[e].dx+15*objects[e].dy+15]=81;
    }

    if (objects[e].step==0 && objects[e].dir==DOWN && posup)
    {
      objects[e].dir=UP;
      objects[e].step=16;
      level_data[objects[e].dx+15*objects[e].dy-15]=81;
    }
    if (objects[e].step==0 && objects[e].dir==UP && posdown)
    {
      objects[e].dir=DOWN;
      objects[e].step=16;
      level_data[objects[e].dx+15*objects[e].dy+15]=81;
    }
  }

  if (objects[e].step!=0)
  {
    objects[e].step--;
    if (objects[e].step&1)
      objects[e].sx=objects[e].sx+16;
    if (objects[e].dir==UP)
      objects[e].y--;
    if (objects[e].dir==DOWN)
      objects[e].y++;

    if (objects[e].step==0)
    {
      level_data[objects[e].dx+15*objects[e].dy]=0;
      if (objects[e].dir==UP)
        objects[e].dy--;
      if (objects[e].dir==DOWN)
        objects[e].dy++;
    }
  }
}

void move_enemy()
{
  int c;

  if (freeze_enemy)
  {
    freeze_enemy--;
    return;
  }

  for (c=1;c!=5;c++)
  {
    if (objects[c].l==1)
      move_type_hor(c);
    if (objects[c].l==2)
      move_type_ver(c);
  }
}

void init_objects()
{
int c;
int cur_rock;
int cur_enemy;

/* reset object data */
  for (c=1;c!=16;c++)
  {
    objects[c].dx=0;
    objects[c].dy=0;
    objects[c].x=0;
    objects[c].y=0;
    objects[c].dir=0;
    objects[c].step=0;
    objects[c].l=0;
    objects[c].sx=0;
    objects[c].sy=0;
  }

  c=0;
  while(level_data[c]!=32)
  {
    c++;
  }
  objects[0].dx=c%15;
  objects[0].dy=c/15;
  objects[0].x=(c%15)*16+8;
  objects[0].y=(c/15)*16+8;
  objects[0].dir=0;
  objects[0].step=0;
  objects[0].l=1;
  objects[0].sx=0;
  objects[0].sy=48;
  level_data[c]=0;

  objects[15].sx=11*16;
  objects[15].sy=16;

  cur_rock=5;
  cur_enemy=1;

  for (c=0;c!=15*11;c++)
  {
    if (level_data[c]==3) /* initialise rock */
    {
      objects[cur_rock].dx=c%15;
      objects[cur_rock].dy=c/15;
      objects[cur_rock].x=(c%15)*16+8;
      objects[cur_rock].y=(c/15)*16+8;
      objects[cur_rock].l=1;
      objects[cur_rock].sx=48;
      objects[cur_rock].sy=16;
      cur_rock++;
    }
    if (level_data[c]==14) /* initialise enemy */
    {
      objects[cur_enemy].dx=c%15;
      objects[cur_enemy].dy=c/15;
      objects[cur_enemy].x=(c%15)*16+8;
      objects[cur_enemy].y=(c/15)*16+8;
      objects[cur_enemy].l=1;
      objects[cur_enemy].sy=32;
      if (objects[cur_enemy].dx>0 && level_data[c-1]==0)
        objects[cur_enemy].dir=LEFT;
      else
        objects[cur_enemy].dir=RIGHT;
      cur_enemy++;
    }
    if (level_data[c]==13)
    {
      objects[cur_enemy].dx=c%15;
      objects[cur_enemy].dy=c/15;
      objects[cur_enemy].x=(c%15)*16+8;
      objects[cur_enemy].y=(c/15)*16+8;
      objects[cur_enemy].l=2;
      objects[cur_enemy].sy=48;
      if (objects[cur_enemy].dy>0 && level_data[c-15]==0)
        objects[cur_enemy].dir=UP;
      else
        objects[cur_enemy].dir=DOWN;
      cur_enemy++;
    }
  }
}

int game()
{
int option,wait;

  level=0;
  lives=3;
  score=0;

  do
  {
    show_intro();
    clear_keybuf();
    while(keypressed()){}
    option=select_option();

    if (option==2)
      show_hi_scores();

    if (option==3)
      return 0;

    if (option==1)
      level=enter_password();
    if (!option)
      level=1;
  }
  while(!level);

  speed_counter=0;
  while(level!=26 && lives)
  {
    init_level_data();

    print_level();

    count_fruit();
    init_objects();
    dead=0;
    freeze_enemy=0;

    print_stats();
    wait=240;
    draw_box_text(128,80,"READY");
    vsync();
    blit(page,screen,0,60,0,60,256,164);
    clear_keybuf();
    while(wait && !keypressed())
    {
      vsync();
      wait--;
    }
    vsync();
    print_level();

    while(fruit!=0 && time!=0 && dead==0)
    {
      blit(patterns,page,0,16,objects[0].x,objects[0].y,16,16);
      move_player();
      delete_objects();
      move_rocks();
      check_colission();
      move_enemy();
      move_block();
      print_objects();
      time--;
      print_stats();

      blit(page,screen,0,0,0,0,256,224);
      wait_frame();
      if (key[KEY_F1])
        pause_game();
    }

  if (!time)
    dead=1;

  if (dead)
    lives--;
  if (!fruit)
    next_level();
  }

  if (!lives)
    game_over();
  if (level==26)
    congratulations();

  return 1;
}

int main()
{
  allegro_init();
  install_keyboard();
  init_gfx();
  init_hi_scores();

  LOCK_VARIABLE(speed_counter);
  LOCK_FUNCTION(inc_speed);

  install_int_ex(inc_speed,BPS_TO_TIMER(60));

  while(game() )
  {
  }

  allegro_exit();

  return 0;
}

END_OF_MAIN();
/* Added by Georgi */
