                        /*****     FRETRIS SOURCE CODE      *****/
                       /*****  2001 - Grumpy Gnome Software  *****/
                        /***  Website - www.grumpygnome.8m.com  ***/
                         /***   Feedback : frakilk@yahoo.com   ***/

                         
#include <allegro.h>
#include <stdio.h>
#include "highscore.h"
#include "display.h"
#include "global.h"




FILE *fpt; // needed for file operations

record highlist[5];

// lettters permitted in high score name entry
char letters[26] = {KEY_A, KEY_B, KEY_C, KEY_D, KEY_E, KEY_F, KEY_G, KEY_H, KEY_I, KEY_J,
                     KEY_K, KEY_L, KEY_M, KEY_N, KEY_O, KEY_P, KEY_Q, KEY_R, KEY_S, KEY_T,
                      KEY_U, KEY_V, KEY_W, KEY_X, KEY_Y, KEY_Z};

int user_key;  // holds value of a key pressed
char name[12] = {" "};  // holds high score name entry




/******************************************************************************************************/

// this function updates the high score data file
void write_highscores() {
  fpt = fopen("highscore.dat", "w");  // opens file for writing
  fwrite(highlist, sizeof(record), 5, fpt);   // writes "highlist" array out to file
                                              // in 5 segments which have same memory size
                                              // as the "record" struct
  fclose(fpt);  // stops operations on file
  }




/******************************************************************************************************/

// this function displays the contents of the high score data file
void display_highscores(BITMAP* buffer, DATAFILE* data) {
  int i = 0;
  int base_y = 240; // y position to start listing high score entries from
  fpt = fopen("highscore.dat", "r");  // opens file for reading
  fread(highlist, sizeof(record), 5, fpt);  // reads contents of file into
                                            // "highlist" array in 5 segments
                                            // which have same memory size
                                            // as the "record" struct
  for (i=0; i<5; i++) {   // lists high score entries on-screen
    textout(buffer, (FONT*)data[9].dat, highlist[i].high_name, 210, base_y+i*30, 17);
    textprintf(buffer, (FONT*)data[9].dat, 345, base_y+i*30, 17, "%lu", highlist[i].high_score);
    }
  fclose(fpt);  // stops operations on file
  }




/******************************************************************************************************/

// this function allows the player to enter his/her name for their high score
void highscore_entry(BITMAP* buffer, DATAFILE* data) {
  int i = 0;
  int name_index = 0;
  int key_pressed_flag = 0; // tells rest of code that a valid key has been pressed
  int end_name_entry = 0; // stops name entry
  name_index = 0;  // points to current position within "name"
  name[name_index] = '\0';  // sets the current position within "name" to the escape character
  while (!end_name_entry) {
    clear_keybuf();
    user_key = readkey();
    for (i=0; i<26; i++)  // checks for a valid key entry
      if ((user_key >> 8) == letters[i]) {
        key_pressed_flag = 1;
        break;
        }
    if ((key_pressed_flag == 1) && (name_index < 13)) {  // places key pressed value
                                                         // into "name"
      name[name_index] = user_key;
      name_index++;  // moves index forward
      name[name_index] = '\0';
      }
    if (((user_key >> 8) == KEY_BACKSPACE) && (name_index != 0)) {  // allows text to
                                                                    // be backspaced
      name_index--;
      name[name_index] = '\0';
      }
    if (((user_key >> 8) == KEY_ENTER) && (strlen(name) != 0)) end_name_entry = 1;
    vsync();
    draw_game_areas_2(160, 150, 300, 150);
    textout(buffer, (FONT*)data[9].dat, "CONGRATULATIONS YOU GOT", 187, 160, 104);
    textout(buffer, (FONT*)data[9].dat, "A HIGH SCORE", 245, 180, 104);
    textout(buffer, (FONT*)data[9].dat, "ENTER YOUR NAME:", 225, 200, 104);
    textout_centre(buffer, (FONT*)data[9].dat, name, 320, 240, 104);
    blit(buffer, screen, 0, 0, 0, 0, 640, 480);
    key_pressed_flag = 0;
    }
  enter_into_table();
  while (!KEY_ESC) { }
  }




/******************************************************************************************************/

// this function checks to see if the player has a high score
void check_highscore() {
  int i = 0;
  int stop_check_flag = 0;
  fpt = fopen("highscore.dat", "r"); // open file for writing
  fread(highlist, sizeof(record), 5, fpt);
  for (i=0; i<5; i++) {  // checks existing high score entries one by one
    if (stop_check_flag != 1)
      if (score > highlist[i].high_score) {  // if existing score is higher
                                             // than an existing entry
        stop_check_flag = 1;  // stops the check
        table_entry_flag = 1; // signifies that the current score has qualified
                              // for a place in the high score table
        }
    }
  fclose(fpt);  // stops operations on file
  }




/******************************************************************************************************/

// this function places the current score into the correct position in the high score table
void enter_into_table() {
  int i = 0;
  int j = 0;
  int outer_break = 0;
  fpt = fopen("highscore.dat", "w+");  // opens file for reading and writing
  fread(highlist, sizeof(record), 5, fpt);
  for (i=0; i<5; i++) {  // this for loop places current score in appropriate
                         // position in high score table
    if (score > highlist[i].high_score) {
      for (j=4; j>i; j--) {  // this for loop moves existing scores in the table
                             // down one place
        highlist[j].high_score = highlist[j-1].high_score;
        strcpy(highlist[j].high_name, highlist[j-1].high_name);
        }
      // next two lines places current score in table
      highlist[i].high_score = score;
      strcpy(highlist[i].high_name, name);
      outer_break = 1;  // break from outer loop
      break;
      }
    if (outer_break == 1) break;
    }
  fwrite(highlist, sizeof(record), 5, fpt);
  fclose(fpt);
  }   // stops operations on file
