                        /*****     FRETRIS SOURCE CODE      *****/
                       /*****  2001 - Grumpy Gnome Software  *****/
                        /***  Website - www.grumpygnome.8m.com  ***/
                         /***   Feedback : frakilk@yahoo.com   ***/


#include <allegro.h>
#include <stdio.h>  // needed for printf statement
#include "display.h"
#include "global.h"
#include "blocks.h"
#include "input.h"
#include "highscore.h"




BITMAP* buffer; // to allow double buffering
BITMAP* pattern; // to allow drawing of patterned drawing
DATAFILE *data; // to allow access to datafile
int menu_array[6] = {198, 228, 258, 288, 318, 348};  // y co-ordinates for menu pointer
int inner_menu_array[2] = {228, 258};  // y co-ordinates for options menu pointer
int menu_time = 0;
int menu_pointer_count = 0;




/******************************************************************************************************/

/* timer interrupt handler for menu pointer speed*/
void menu_timer() {
  menu_time++;
  }
END_OF_FUNCTION(menu_timer);




/******************************************************************************************************/

// this function initialises general display and sound requirements and also loads the data file
void display_init() {
  // initialize graphics
  if (set_gfx_mode(GFX_AUTODETECT, screen_width, screen_height, 0, 0) < 0) {
    printf("Error: Couldn't set video mode!\n");
    allegro_exit();
    }
  // loads data file
  data = load_datafile("gamedata.dat");              /* load datafile*/
    if (!data) {
      printf("Error: Couldn't find gamedata.dat\n");
      allegro_exit();
    }
  // installs sound capabilities
  if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {  // installs sound
        printf("Error: Couldn't setup sound!\n");
        allegro_exit();
   	  }
  buffer = create_bitmap(screen_width, screen_height); // bitmap used for double buffering
  clear(buffer);  // clears garbage from bitmap
  pattern = create_bitmap(64, 64);  // this bitmap is needed to generate the patterned
                                    // background in the actual game
  clear(pattern);  // clears garbage from bitmap
  text_mode(-1);  // sets text mode so that text displayed on the screen will
                  // have a transparent background
  blit(buffer, screen, 0, 0, 0, 0, screen_width, screen_height);  // displays buffer content on-screen
  }




/******************************************************************************************************/

// displays initial title screen
void title_screen_display_init() {
  LOCK_FUNCTION(menu_timer);  // locks memory for variable
  LOCK_VARIABLE(menu_time);
  install_int(menu_timer, 10);  // installs the timer
  solid_mode();  // turns off patterned mode
  set_palette(black_palette);
  start_game_flag = 0;
  game_end_flag = 0;
  clear_to_color(buffer, 16);
  rectfill(buffer, 20, 20, 620, 460, 15);
  draw_sprite(buffer,(BITMAP*)data[12].dat, 120, 80);  // displays game title
  blit(buffer, screen, 0, 0, 0, 0, screen_width, screen_height);
  fade_in((RGB*)data[13].dat, 3);  // fades in from black palette to palette in data file
  if (music_flag == 1) play_midi((MIDI*)data[18].dat, 1);  // starts MIDI tune
  rest(600);
  expand_menu_box();
  }




/******************************************************************************************************/

// the function handles the main menu and also calls up sub menus and screens
void title_screen_main_menu() {
  vsync();  // waits until next vertical retrace of screen
  clear_to_color(buffer, 16);
  rectfill(buffer, 20, 20, 620, 460, 15);
  draw_sprite(buffer,(BITMAP*)data[12].dat, 120, 80);
  rectfill(buffer, 200, 180, 410, 400, 0);
  textout(buffer, (FONT*)data[9].dat, "WWW.GRUMPYGNOME.8M.COM", 195, 420, 13);

  if ((key[KEY_UP]) || (key[KEY_DOWN])) {   // this if statement allows tighter control on
                                       // the up and down movement of the menu pointer
    if (menu_pointer_count == 0) {  // if up or down has just been pressed
      if (key[KEY_DOWN]) {
        if (menu_position == 5) menu_position = 0;  // if menu pointer is at bottom of
                                                    // menu, move to the top of menu
        else menu_position++;  // move menu pointer down
        }
      else if (key[KEY_UP]) {
        if (menu_position == 0) menu_position = 5;  // if menu pointer is at top of
                                                    // menu, move to the bottom of menu
        else menu_position--;  // move menu pointer up
        }
      }
    menu_pointer_count++;
    if (menu_pointer_count > 10) {  // if up or down is being held
      if (menu_time > 10) {
        menu_time = 0;
        if (key[KEY_DOWN]) {
          if (menu_position == 5) menu_position = 0;  // if menu pointer is at bottom of
                                                      // menu, move to the top of menu
          else menu_position++;  // move menu pointer down
          }
        else if (key[KEY_UP]) {
          if (menu_position == 0) menu_position = 5;  // if menu pointer is at top of
                                                      // menu, move to the bottom of menu
          else menu_position--;  // move menu pointer up
          }
        }
      if (menu_pointer_count > 200) menu_pointer_count = 10;  // prevents "menu_pointer_count"
                                                              // from getting too high
      }
    }

  if ((!key[KEY_UP]) && (!key[KEY_DOWN])) menu_pointer_count = 0;  // if up or down is not pressed

  draw_sprite(buffer, (BITMAP*)data[14].dat, 240, menu_array[menu_position]);
  title_screen_menu();
  blit(buffer, screen, 0, 0, 0, 0, screen_width, screen_height);
  if (key[KEY_ENTER]) {
    play_sample(data[16].dat, 255, 175, 1000, 0);  // play "menu select" sound effect
    switch(menu_position) {
      case 0: {   // if "menu_pointer" is at position 0
        if (music_flag == 1) stop_midi();
        start_game_flag = 1;
        fade_out(3);
        break;
        }
      case 1: {   // if "menu_pointer" is at position 1
        shrink_menu_box();
        options_screen();
        expand_menu_box();
        break;
        }
      case 2: {   // if "menu_pointer" is at position 2
        shrink_menu_box();
        highscore_screen();
        expand_menu_box();
        break;
        }
      case 3: {   // if "menu_pointer" is at position 3
        shrink_menu_box();
        credits_screen();
        expand_menu_box();
        break;
        }
      case 4: {   // if "menu_pointer" is at position 4
        shrink_menu_box();
        help_screen();
        expand_menu_box();
        break;
        }
      case 5: {   // if "menu_pointer" is at position 5
        if (music_flag == 1) stop_midi();
        start_game_flag = 1;
        game_end_flag = 1;
        exit_flag = 1;
        fade_out(3);  // fade to black
        break;
        }
      }
    }
  }




/******************************************************************************************************/

// creates menu on title screen
void title_screen_menu() {
  textout(buffer, (FONT*)data[9].dat, "START", 260, 200, 17);
  textout(buffer, (FONT*)data[9].dat, "OPTIONS", 260, 230, 17);
  textout(buffer, (FONT*)data[9].dat, "HIGHSCORES", 260, 260, 17);
  textout(buffer, (FONT*)data[9].dat, "CREDITS", 260, 290, 17);
  textout(buffer, (FONT*)data[9].dat, "HELP", 260, 320, 17);
  textout(buffer, (FONT*)data[9].dat, "EXIT", 260, 350, 17);
  }




/******************************************************************************************************/

// displays initial game area components
void game_area_display_init() {
  blit((BITMAP*)data[8].dat, pattern, 0, 0, 0, 0, 64, 64);
  drawing_mode(DRAW_MODE_COPY_PATTERN, pattern, 0, 0);  // sets drawing mode --
                               // in this case it sets a patterned drawing mode
  rectfill(buffer, 0, 0, screen_width, screen_height, 4);
  background_draw();
  text_write();
  blit(buffer, screen, 0, 0, 0, 0, screen_width, screen_height);
  fade_in((RGB*)data[0].dat, 3);
  if (music_flag == 1) play_midi((MIDI*)data[19].dat, 1);
  }




/******************************************************************************************************/

// shut down all display elements and also unloads the data file
void display_shutdown () {
  solid_mode();  // turns off patterned mode
  fade_out(5);
  // not necessary but good programming practice
  destroy_bitmap(buffer);
  destroy_bitmap(pattern);
  unload_datafile(data);
  }




/******************************************************************************************************/

// this function updates all the game area display elements
void display_update() {
  vsync();   // waits until next vertical retrace of screen
  background_draw();
  if (next_shape_flag == 1) next_shape_draw();  // draws shape into the next box
  blocks_draw();
  text_write();
  blit(buffer, screen, 0, 0, 0, 0, screen_width, screen_height);
  if (draw_gray_blocks == 1) {  // if game is over
    draw_gray_blocks = 0;
    if (table_entry_flag == 1) {  // if qualified for a high score
      highscore_entry(buffer, data);
      table_entry_flag = 0;
      }
    else while ((key[KEY_ESC] != 1) && (key[KEY_ENTER] != 1)) {}
    }
  }




/******************************************************************************************************/

// this function displays the background elements
void background_draw() {
  clear_to_color(buffer, 3);
  drawing_mode(DRAW_MODE_COPY_PATTERN, pattern, 0, 0);
  rectfill(buffer, 0, 0, screen_width, screen_height, 4);
  draw_game_areas(100, 100, 195, 285); // main game area
  draw_game_areas(400, 100, 60, 60);   // next block area
  draw_game_areas(400, 265, 150, 75);  // game info area
  }




/******************************************************************************************************/

// draws any blocks which are marked as used
void blocks_draw() {
  int i = 0;
  if (draw_gray_blocks == 1) {
    for(i=0; i<=max_blocks; i++)
      if (blocks[i].used == 1) {
        blit((BITMAP*)data[15].dat, buffer, 0, 0, blocks[i].x, blocks[i].y, 15, 15);
        }
    textout(buffer, (FONT*)data[9].dat, "GAME OVER", 260, 260, 33);
    }
  else {
    for(i=0; i<=max_blocks; i++)
      if (blocks[i].used == 1) {
        blit((BITMAP*)data[blocks[i].block_bitmap].dat, buffer, 0, 0, blocks[i].x, blocks[i].y, 15, 15);
        }
    }
  if (lines > old_lines) {
    play_sample(data[17].dat, 255, 1, 1000, 0);  // play "lines drop" sound effect
    old_lines = lines;
    }
  }




/******************************************************************************************************/

// displays text on the game area
void text_write() {
  textout(buffer, (FONT*)data[9].dat, "NEXT", 415, 155, 104);
  textprintf(buffer, (FONT*)data[9].dat, 415, 275, 104, "LINES: %d", lines);
  textprintf(buffer, (FONT*)data[9].dat, 415, 300, 104, "LEVEL: %d", level);
  textprintf(buffer, (FONT*)data[9].dat, 415, 325, 104, "SCORE: %lu", score);
  }




/******************************************************************************************************/

// draws shape contained within the "next" box
void next_shape_draw() {
  switch(next_shape) {
    case 1 : {
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 422, 110, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 437, 110, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 422, 125, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 437, 125, 15, 15);
      break;
      }
    case 2 : {
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 415, 110, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 430, 110, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 430, 125, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 445, 110, 15, 15);
      break;
      }
    case 3 : {
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 408, 118, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 423, 118, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 438, 118, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 453, 118, 15, 15);
      break;
      }
    case 4 : {
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 415, 125, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 430, 110, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 430, 125, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 445, 110, 15, 15);
      break;
      }
    case 5 : {
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 415, 110, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 430, 110, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 430, 125, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 445, 125, 15, 15);
      break;
      }
    case 6 : {
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 415, 110, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 430, 110, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 445, 125, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 445, 110, 15, 15);
      break;
      }
    case 7 : {
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 415, 110, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 430, 110, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 415, 125, 15, 15);
      blit((BITMAP*)data[next_shape].dat, buffer, 0, 0, 445, 110, 15, 15);
      break;
      }
    }
  }




/******************************************************************************************************/

// this functions displays the black areas within the game area.
// the black areas are composed of collections of black squares
void draw_game_areas(int start_x, int start_y, int width, int height) {
  int i = 0;
  int j = 0;
  for(i=start_x; i<=(start_x + width); i+=15)
    for(j=start_y; j<=(start_y + height); j+=15)
      blit((BITMAP*)data[10].dat, buffer, 0, 0, i, j, 15, 15);
  }




/******************************************************************************************************/
// this functions displays the background area behind the "quit y/n" question and
// the highscore name entry area.
void draw_game_areas_2(int start_x, int start_y, int width, int height) {
  int i = 0;
  int j = 0;
  for(i=start_x; i<=(start_x + width); i+=15)
    for(j=start_y; j<=(start_y + height); j+=15)
      blit((BITMAP*)data[3].dat, buffer, 0, 0, i, j, 15, 15);
  }





/******************************************************************************************************/

// displays the white flash which appears when a line is formed
void line_flash(int line_flash_array[]) {
  int i = 0;
  for (i=0; i<line_count; i++) {
    if (line_flash_array[i] == 1) // draws line flash where indicated by a 1 in the "line_flash_array"
       blit((BITMAP*)data[11].dat, screen, 0, 0, 100, line_array[i], 210, 15);
    }
  rest(100); // a small pause
  }




/******************************************************************************************************/

// displays and handles operations carried out within the options screen
void options_screen() {
  int inner_menu_position = 0;
  expand_menu_box();
  while (!key[KEY_ESC] && !key[KEY_ENTER]){
    textout(buffer, (FONT*)data[9].dat, "OPTIONS", 265, 190, 17);
    if (key[KEY_DOWN]) {
      if (inner_menu_position == 0) inner_menu_position = 1; // if menu pointer is at top of
                                                             // menu, move to the bottom of menu
      }
    else if (key[KEY_UP]) {
      if (inner_menu_position == 1) inner_menu_position = 0; // if menu pointer is at bottom of
                                                             // menu, move to the top of menu
      }
    draw_sprite(buffer, (BITMAP*)data[14].dat, 210, inner_menu_array[inner_menu_position]);
    textout(buffer, (FONT*)data[9].dat, "NEXT SHAPE", 230, inner_menu_array[0], 14);
    textout(buffer, (FONT*)data[9].dat, "MUSIC", 230, inner_menu_array[1], 14);
    blit(buffer, screen, 0, 0, 0, 0, screen_width, screen_height);

    if ((inner_menu_position == 0) && (key[KEY_LEFT] || key[KEY_RIGHT])) {
      if (next_shape_flag == 0) next_shape_flag = 1;
      else next_shape_flag = 0;
      rest(200);
    }

    if ((inner_menu_position == 1) && (key[KEY_LEFT] || key[KEY_RIGHT])) {
      if (music_flag == 0) {
        music_flag = 1;
        play_midi((MIDI*)data[18].dat, 1);
        }
      else {
        music_flag = 0;
        stop_midi();
        }
      rest(200);
      }

    vsync();  // waits until next vertical retrace of screen
    clear_to_color(buffer, 16);
    rectfill(buffer, 20, 20, 620, 460, 15);
    draw_sprite(buffer,(BITMAP*)data[12].dat, 120, 80);
    rectfill(buffer, 200, 180, 410, 400, 0);
    textout(buffer, (FONT*)data[9].dat, "WWW.GRUMPYGNOME.8M.COM", 195, 420, 13);
    if (next_shape_flag == 1) textout(buffer, (FONT*)data[9].dat, "ON", 370, inner_menu_array[0], 17);
    else textout(buffer, (FONT*)data[9].dat, "OFF", 370, inner_menu_array[0], 17);
    if (music_flag == 1) textout(buffer, (FONT*)data[9].dat, "ON", 370, inner_menu_array[1], 17);
    else textout(buffer, (FONT*)data[9].dat, "OFF", 370, inner_menu_array[1], 17);
    }
  shrink_menu_box();
  }




/******************************************************************************************************/

// displays the highscore screen
void highscore_screen() {
  expand_menu_box();
  textout(buffer, (FONT*)data[9].dat, "HIGHSCORES", 250, 190, 17);
  textout(buffer, (FONT*)data[9].dat, "Name", 210, 220, 7);
  textout(buffer, (FONT*)data[9].dat, "Score", 345, 220, 7);
  display_highscores(buffer, data);
  blit(buffer, screen, 0, 0, 0, 0, screen_width, screen_height);
  while (!key[KEY_ESC] && !key[KEY_ENTER]){}
  shrink_menu_box();
  }




/******************************************************************************************************/

// displays the highscore screen
void credits_screen() {
  expand_menu_box();
  textout(buffer, (FONT*)data[9].dat, "CREDITS", 260, 190, 17);
  textout(buffer, (FONT*)data[9].dat, "PROGRAMMING AND", 210, 230, 14);
  textout(buffer, (FONT*)data[9].dat, "GRAPHICS BY", 230, 250, 14);
  textout(buffer, (FONT*)data[9].dat, "FRANCIS KILKELLY", 210, 270, 17);
  textout(buffer, (FONT*)data[9].dat, "FRAKILK@YAHOO.COM", 210, 340, 13);
  blit(buffer, screen, 0, 0, 0, 0, screen_width, screen_height);
  while (!key[KEY_ESC] && !key[KEY_ENTER]){}
  shrink_menu_box();
  }




/******************************************************************************************************/

// displays the highscore screen
void help_screen() {
  expand_menu_box();
  textout(buffer, (FONT*)data[9].dat, "HELP", 280, 190, 17);
  textout(buffer, (FONT*)data[9].dat, "MOVEMENT", 210, 230, 14);
  textout(buffer, (FONT*)data[9].dat, "Arrow keys", 210, 250, 17);
  textout(buffer, (FONT*)data[9].dat, "ROTATION", 210, 280, 14);
  textout(buffer, (FONT*)data[9].dat, "J - Clockwise", 210, 300, 17);
  textout(buffer, (FONT*)data[9].dat, "K - Anticlockwise", 210, 320, 17);
  blit(buffer, screen, 0, 0, 0, 0, screen_width, screen_height);
  while (!key[KEY_ESC] && !key[KEY_ENTER]){}
  shrink_menu_box();
  }




/******************************************************************************************************/

// creates the expanding menu box
void expand_menu_box() {
  int i = 0;
  for(i=180; i<400; i+=10) {
    clear_to_color(buffer, 16);
    rectfill(buffer, 20, 20, 620, 460, 15);
    draw_sprite(buffer,(BITMAP*)data[12].dat, 120, 80);
    rectfill(buffer, 200, 180, 410, i, 0);  // expanding menu box created by drawing
                                            // rectangles of increasing heights
    textout(buffer, (FONT*)data[9].dat, "WWW.GRUMPYGNOME.8M.COM", 195, 420, 13);
    vsync();   // waits until next vertical retrace of screen
    blit(buffer, screen, 0, 0, 0, 0, screen_width, screen_height);
    }
  }




/******************************************************************************************************/

// creates the shrinking menu box
void shrink_menu_box() {
  int i = 0;
  for(i=400; i>180; i-=10) {    // this for loop creates the shrinking menu box on the credits screen
    clear_to_color(buffer, 16);
    rectfill(buffer, 20, 20, 620, 460, 15);
    draw_sprite(buffer,(BITMAP*)data[12].dat, 120, 80);
    rectfill(buffer, 200, 180, 410, i, 0);  // shrinking menu box created by drawing
                                            // rectangles of decreasing heights
    textout(buffer, (FONT*)data[9].dat, "WWW.GRUMPYGNOME.8M.COM", 195, 420, 13);
    vsync();   // waits until next vertical retrace of screen
    blit(buffer, screen, 0, 0, 0, 0, screen_width, screen_height);
    }
  }




/******************************************************************************************************/

// displays and handles choices made within the "quit y/n" pop up area
void quit_y_n() {
  char ans = ' ';
  while ((ans != 'y') && (ans != 'Y') && (ans != 'n') && (ans != 'N')) {
    draw_game_areas_2(235, 150, 150, 75);
    textout(buffer, (FONT*)data[9].dat, "QUIT Y/N", 271, 188, 104);
    vsync();   // waits until next vertical retrace of screen
    blit(buffer, screen, 0, 0, 0, 0, screen_width, screen_height);
    clear_keybuf();
    ans = readkey();
    }
  if ((ans == 'y') || (ans == 'Y')) {
    game_end_flag = 1;
    if (music_flag == 1) stop_midi();
    fade_out(3);
    }
  }




