#ifndef gf_included_blocks_h
#define gf_included_blocks_h

#include <allegro.h>
#include "global.h"

#define max_blocks 250

typedef struct BLOCK {
  int id;  // used to uniquely identify block
  int x;  // current x co-ordinate of block
  int y;  // current y co-ordinate of block
  int old_x;  // holds old x co-ordinate before action was applied to it
  int old_y;  // holds old y co-ordinate before action was applied to it
  int block_bitmap;  // index into datafile to access correct bitmap for block
  int used;  // indicates whether block is being used on-screen at the moment 
  } BLOCK;

BLOCK blocks[max_blocks];

void blocks_init();

#endif
