#include <stdlib.h>
#include <string.h>
#include "main.h"
#include "screen.h"
#include "menu.h"
#include "sfx.h"
#include "sfxplay.h"



// Remove this if it's unused
struct MENU_SYSTEM
{
	int filler;
};



MENU_SYSTEM *init_menu_system(void)
{
	MENU_SYSTEM *ms = malloc(sizeof(*ms));

	if (!ms)
		return NULL;

	return ms;
}



void shut_down_menu_system(MENU_SYSTEM *ms)
{
	free(ms);
}



struct MENU_DATA
{
	MENU_SYSTEM *ms;
	MENU_ENTRY *me;
	int focus;
};



MENU_DATA *wrap_menu_data(MENU_SYSTEM *ms, MENU_ENTRY *me, int focus)
{
	MENU_DATA *md = malloc(sizeof(*md));

	if (!md) {
		set_screen(0, 0, 0);
		allegro_message("Out of memory!\n");
		exit(1);
	}

	md->ms = ms;
	md->me = me;
	md->focus = focus;

	return md;
}



int unwrap_menu_data(MENU_DATA *md)
{
	int focus = md->focus;
	free(md);
	return focus;
}



void t_draw_menu(void *data)
{
	MENU_DATA *md = data;
	//MENU_SYSTEM *ms = md->ms;
	MENU_ENTRY *me = md->me;

	BITMAP *bmp = get_screen();

	int i;

	clear(bmp);

	sfx_poll();

	for (i = 0; me[i].draw; i++) {
		(*me[i].draw)(bmp, &me[i], i == md->focus);
		sfx_poll();
	}

	commit_screen();
}



static void update_menu_system(MENU_SYSTEM *ms)
{
	(void)ms;
}



int t_update_menu(void *data)
{
	MENU_DATA *md = data;
	MENU_SYSTEM *ms = md->ms;
	MENU_ENTRY *me = md->me;

	update_menu_system(ms);

	while (keypressed()) {
		int k = readkey();
		switch (k >> 8) {
			case KEY_ESC:
				return MK_END;
			case KEY_UP:
				{
					int oldfocus = md->focus;
					do {
						if (md->focus == 0)
							do md->focus++; while (me[md->focus].draw);
						md->focus--;
					} while (!me[md->focus].key);
					if (md->focus != oldfocus)
						sfx_play(sfx_menu_select, 1, 0, 1.0);
				}
				break;
			case KEY_DOWN:
				{
					int oldfocus = md->focus;
					do {
						md->focus++;
						if (!me[md->focus].draw)
							md->focus = 0;
					} while (!me[md->focus].key);
					if (md->focus != oldfocus)
						sfx_play(sfx_menu_select, 1, 0, 1.0);
				}
				break;
			default:
				{
					int rv = (*me[md->focus].key)(ms, &me[md->focus], k);
					if (rv) return rv;
				}
		}
	}

	return 0;
}



static unsigned char key_held[KEY_MAX];

static int key_detected;



static void keydetect_callback(int scancode)
{
	if (scancode & 0x80) {
		scancode &= 0x7F;
		if (scancode < KEY_MAX) key_held[scancode] = 0;
	} else if (scancode != KEY_PAUSE && !key_held[scancode]) {
		key_detected = scancode;
		keyboard_lowlevel_callback = NULL;
	}
}
END_OF_STATIC_FUNCTION(keydetect_callback);



void init_menu_module(void)
{
	LOCK_VARIABLE(key_held);
	LOCK_VARIABLE(key_detected);
	LOCK_FUNCTION(keydetect_callback);
}



void init_menu_keydetect(void)
{
	memcpy(key_held, (/* non-volatile */ void *)key, KEY_MAX);
	key_detected = 0;

	keyboard_lowlevel_callback = &keydetect_callback;
}



/* Special update function for use when detecting keys. Instead of testing
 * for keys as normal, this function treats all keys the same, with one
 * exception. Apart from Pause, for which the keyboard hardware cannot even
 * detect releases, any key pressed will cause this menu to end, returning
 * the scancode. The keyboard buffer is cleared just before returning. It is
 * likely that the caller will want to interpret KEY_ESC as an abort code and
 * use any other keys as normal.
 *
 * Note that the key function is never used, so the focus may be applied to a
 * non-option for display purposes.
 */
int update_menu_keydetect(void *data)
{
	MENU_DATA *md = data;
	MENU_SYSTEM *ms = md->ms;

	update_menu_system(ms);

	if (key_detected) {
		clear_keybuf();
		return key_detected;
	}

	return 0;
}

