#include "main.h"
#include "tconfig.h"
#include "timeloop.h"
#include "menu.h"
#include "menuproc.h"
#include "m_error.h"
#include "sfx.h"
#include "sfxplay.h"



void run_error_menu(MENU_SYSTEM *ms, char *str)
{
	MENU_ENTRY me[] = {
		/* draw            , x         , y                    , dp1                               , key     , k1    , kp1 */
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - FONT_H, str                               , &mk_exit, MK_END, NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1)         , "Press Enter or Space to continue", NULL    , 0     , NULL},
		{NULL              , 0         , 0                    , NULL                              , NULL    , 0     , NULL}
	};

	MENU_DATA *md;

	sfx_play(sfx_menu_error, 1, 0, 1.0);

	md = wrap_menu_data(ms, me, 0);
	timeloop(BPS_TO_TIMER(MENU_FPS), 10, &t_draw_menu, &t_update_menu, md);
	unwrap_menu_data(md);

	sfx_play(sfx_menu_enter, 1, 0, 1.0);
}

