#include <stdlib.h>
#include "mathpi.h"
#include "main.h"
#include "world.h"



#define BORDER_RADIUS 64



WORLD *create_world(void)
{
	WORLD *world = malloc(sizeof(*world));
	int x, y;
	int i, j;

	if (!world)
		return NULL;

	world->w = 16;
	world->h = 16;

	world->z = malloc((world->h+1) * sizeof(*world->z));
	if (!world->z) {
		free(world);
		return NULL;
	}

	world->z[0] = malloc((world->w+1) * (world->h+1) * sizeof(*world->z));
	if (!world->z[0]) {
		free(world->z);
		free(world);
		return NULL;
	}

	world->vtx = NULL;
	world->poly = NULL;
	world->tree = NULL;

	world->n_vtx = 4 + (world->w+1) * (world->h+1);
	world->vtx = malloc(world->n_vtx * sizeof(*world->vtx));
	if (!world->vtx) {
		destroy_world(world);
		return NULL;
	}

	world->n_poly = 1 + 2 * world->w * world->h;
	world->poly = malloc(world->n_poly * sizeof(*world->poly));
	if (!world->poly) {
		destroy_world(world);
		return NULL;
	}

	for (i = 0; i < world->n_poly; i++)
		world->poly[i].p = NULL;

	world->poly[0].n_vtx = 4;
	world->poly[0].p = malloc(4 * sizeof(*world->poly[i].p));
	if (!world->poly[0].p) {
		destroy_world(world);
		return NULL;
	}

	for (i = 1; i < world->n_poly; i++) {
		world->poly[i].n_vtx = 3;
		world->poly[i].p = malloc(3 * sizeof(*world->poly[i].p));
		if (!world->poly[i].p) {
			destroy_world(world);
			return NULL;
		}
	}

	world->tree = create_bsp_tree();
	if (!world->tree) {
		destroy_world(world);
		return NULL;
	}

	for (y = 0; y < world->h+1 - 1; y++)
		world->z[y+1] = world->z[y] + world->w+1;

	for (x = 0; x < world->w+1; x++)
		world->z[0][x] = 0;

	for (x = 0; x < world->w+1; x++)
		world->z[world->h][x] = 0;

	for (y = 1; y < world->h; y++) {
		world->z[y][0] = 0;
		world->z[y][world->w] = 0;
		for (x = 1; x < world->w; x++)
			world->z[y][x] = RND(1.0);
	}

	world->vtx[0].x = -BORDER_RADIUS;
	world->vtx[0].y = -BORDER_RADIUS;
	world->vtx[0].z = 0;
	world->vtx[1].x = -BORDER_RADIUS;
	world->vtx[1].y = world->h + BORDER_RADIUS;
	world->vtx[1].z = 0;
	world->vtx[2].x = world->w + BORDER_RADIUS;
	world->vtx[2].y = world->h + BORDER_RADIUS;
	world->vtx[2].z = 0;
	world->vtx[3].x = world->w + BORDER_RADIUS;
	world->vtx[3].y = -BORDER_RADIUS;
	world->vtx[3].z = 0;

	world->poly[0].texture = quicksand_texture;
	world->poly[0].p[0].vtx = &world->vtx[0];
	world->poly[0].p[1].vtx = &world->vtx[1];
	world->poly[0].p[2].vtx = &world->vtx[2];
	world->poly[0].p[3].vtx = &world->vtx[3];
	world->poly[0].p[0].u = -BORDER_RADIUS * sand_texture->w + 0.01;
	world->poly[0].p[0].v = -BORDER_RADIUS * sand_texture->h + 0.01;
	world->poly[0].p[1].u = -BORDER_RADIUS * sand_texture->w + 0.01;
	world->poly[0].p[1].v = (world->h + BORDER_RADIUS) * sand_texture->h - 0.01;
	world->poly[0].p[2].u = (world->w + BORDER_RADIUS) * sand_texture->w - 0.01;
	world->poly[0].p[2].v = (world->h + BORDER_RADIUS) * sand_texture->h - 0.01;
	world->poly[0].p[3].u = (world->w + BORDER_RADIUS) * sand_texture->w - 0.01;
	world->poly[0].p[3].v = -BORDER_RADIUS * sand_texture->h + 0.01;
	prepare_polygon(&world->poly[0]);
	add_to_bsp_tree(world->tree, &world->poly[0], NULL);

	i = 4;
	for (y = 0; y < world->h+1; y++) {
		for (x = 0; x < world->w+1; x++) {
			world->vtx[i].x = x;
			world->vtx[i].y = y;
			world->vtx[i].z = world->z[y][x];
			i++;
		}
	}

	i = 1;
	j = 4;
	for (y = 0; y < world->h; y++) {
		for (x = 0; x < world->w; x++) {
			world->poly[i].texture = sand_texture;
			world->poly[i].p[0].vtx = &world->vtx[j];
			world->poly[i].p[1].vtx = &world->vtx[j+(world->w+1)];
			world->poly[i].p[2].vtx = &world->vtx[j+(world->w+1)+1];
			world->poly[i].p[0].u = 0.01;
			world->poly[i].p[0].v = 0.01;
			world->poly[i].p[1].u = 0.01;
			world->poly[i].p[1].v = sand_texture->h - 0.01;
			world->poly[i].p[2].u = sand_texture->w - 0.01;
			world->poly[i].p[2].v = sand_texture->h - 0.01;
			prepare_polygon(&world->poly[i]);
			add_to_bsp_tree(world->tree, &world->poly[i], NULL);
			i++;
			world->poly[i].texture = sand_texture;
			world->poly[i].p[0].vtx = &world->vtx[j+(world->w+1)+1];
			world->poly[i].p[1].vtx = &world->vtx[j+1];
			world->poly[i].p[2].vtx = &world->vtx[j];
			world->poly[i].p[0].u = sand_texture->w - 0.01;
			world->poly[i].p[0].v = sand_texture->h - 0.01;
			world->poly[i].p[1].u = sand_texture->w - 0.01;
			world->poly[i].p[1].v = 0.01;
			world->poly[i].p[2].u = 0.01;
			world->poly[i].p[2].v = 0.01;
			prepare_polygon(&world->poly[i]);
			add_to_bsp_tree(world->tree, &world->poly[i], NULL);
			i++;
			j++;
		}
		j++;
	}

	finalise_bsp_tree(world->tree, 0);

	return world;
}



void destroy_world(WORLD *world)
{
	destroy_bsp_tree(world->tree);

	if (world->z) {
		if (world->z[0]) free(world->z[0]);
		free(world->z);
	}

	if (world->vtx) free(world->vtx);

	if (world->poly) {
		int i;

		for (i = 0; i < world->n_poly; i++)
			free(world->poly[i].p);

		free(world->poly);
	}

	free(world);
}



void draw_world(BITMAP *bmp, MATRIX_f *camera, float xc, float yc, float zc, WORLD *world)
{
	int i;

	for (i = 0; i < world->n_vtx; i++)
		draw_prepare_vertex(camera, &world->vtx[i]);

	draw_prepare_bsp_tree(camera, world->tree);

	set_projection_viewport(0, 0, bmp->w, bmp->h);

	draw_bsp_tree(bmp, camera, xc, yc, zc, world->tree);
}



float get_ground_height(WORLD *world, float x, float y, int *outside)
{
	double xw, yw;
	float xf = modf(x, &xw);
	float yf = modf(y, &yw);
	int xi = xw, yi = yw;

	float tl, br;

	/* Fractional part is negative if x,y are, but xi,yi may still be 0. */
	if (xf < 0 || xi >= world->w || yf < 0 || yi >= world->h) {
		if (outside) *outside = 1;
		return 0;
	}

	if (outside) *outside = 0;

	tl = world->z[yi][xi];
	br = world->z[yi+1][xi+1];

	if (yf > xf) {
		float bl = world->z[yi+1][xi];
		tl -= bl;
		br -= bl;
		yf = 1 - yf;
		return bl + tl*yf + br*xf;
	} else {
		float tr = world->z[yi][xi+1];
		tl -= tr;
		br -= tr;
		xf = 1 - xf;
		return tr + tl*xf + br*yf;
	}
}

