// *******************************************
// File:        main
// Author:      el Hamil, elhamil@hotmail.com
// Environment: Dev-C++, Allegro 4, DirectX 8, win98

// Desc:        Cute particle effects,
//              and an orgy in magic numbers: Um, 5.7 seems about right, let's use it...

// Created:     2003-07-12, started out as a non-interactive firework thing
// Updates:
// 2003-07-13, made an ikaruga-style game beacuse clicking is more fun than just watching
// 2003-07-14, added game over-screen and some polish
// *******************************************

#include <allegro.h>
#include <winalleg.h>
#include <windows.h>

#include <iostream>
#include <math.h>

using namespace std;


// different types of particles
enum {TYPE_INACTIVE, TYPE_ROCKET, TYPE_GOOD, TYPE_EVIL};

class CParticle
{
public:
	int type;
	float x, y;
	float dx, dy;
	float velocity;
	int angle;
	int angle2; // angle in the YZ plane, i think
	int data0, data1; // these can be used for different things depending on type... however, data0 is often used as "lifetime"-counter
	int color;
};


BITMAP* virscr = 0;


int colordepth = 16;
const int SCREENW = 640;
const int SCREENH = 480;
const int SCREENW_HALF = 320;
const int SCREENH_HALF = 240;
const float GRAVITATION = 0.01;
const int TICKS_BETWEEN_UPDATES = 25;
const int CLICK_RADIUS = 4000;

const int maxParticles = 4096;
int activeParticles = 0;
CParticle* particle = 0;

const int nrAngles = 256;
float costable[nrAngles];
float sintable[nrAngles];


int playGameOnce();


int main(int argc, char* argv[])
{
	// command line configuration
	int fullscreen = 0;
	for (int i = 1; i < argc; i++)
	{
		if (!strcmp(argv[i], "full"))
			fullscreen = 1;
		if (!strcmp(argv[i], "15"))
			colordepth = 15;
		if (!strcmp(argv[i], "32"))
			colordepth = 32;
	}


	if (allegro_init() != 0)
	{
		cout << "allegro_init() failed" << endl;
		exit(1);
	}

	if (install_keyboard() != 0)
	{
		cout << "install_keyboard() failed" << endl;
		exit(1);
	}

	if (install_mouse() == -1)
	{
		cout << "install_mouse() failed" << endl;
		exit(1);
	}

	set_color_depth(colordepth);

	int result = -1;
	if (fullscreen)
		result = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, SCREENW, SCREENH, 0, 0);
	else
		result = set_gfx_mode(GFX_AUTODETECT_WINDOWED, SCREENW, SCREENH, 0, 0);
	if (result < 0)
	{
		cout << "set_gfx_mode() failed" << endl;
		exit(1);
 	}

	virscr = create_bitmap(SCREENW, SCREENH);
	if (!virscr)
	{
		cout << "create_bitmap() failed" << endl;
		exit(1);
 	}


	srand(GetTickCount());


	for (int i = 0; i < nrAngles; i++)
	{
		float radian = (i * 2 * M_PI) / nrAngles;
		costable[i] = cos(radian);
		sintable[i] = sin(radian);
	}


	particle = new CParticle[maxParticles];

	int programRunning = 1;
	while (programRunning)
	{
		programRunning = playGameOnce();
	}

	delete[] particle;
	particle = 0;


	destroy_bitmap(virscr);

	return 0;
}

END_OF_MAIN();


void launchNewRocket(CParticle* par, int type)
{
	par->y = SCREENH; // the rockets start at the bottom of the screen
	par->x = (rand() % (SCREENW - 200)) + 100;
	par->velocity = 5 + (rand() % 100) / (float)100;
	par->dy = -par->velocity;
	par->dx = ((rand() % 100) - 50) / (float)200;
	par->type = TYPE_ROCKET;
	par->data0 = (rand() % 10) + 50;
	par->data1 = type; // data1 stores what kind of explosion the rocket will create
	if (type == TYPE_GOOD)
	{
		par->color = makecol(255,127,0);
	}
	else if (type == TYPE_EVIL)
	{
		par->color = makecol(0,127,255);
	}
}


void explodeRocket(CParticle* par)
{
	if (par->data1 == TYPE_GOOD)
	{
		int nrToCreate = 100;
		for (int j = 0; j < maxParticles; j++)
		{
			if (nrToCreate && particle[j].type == TYPE_INACTIVE)
			{
				nrToCreate--;
				particle[j].type = par->data1;
				particle[j].x = par->x;
				particle[j].y = par->y;
				particle[j].angle = (nrToCreate * nrAngles) / 100;
				particle[j].angle2 = rand() % nrAngles;
				particle[j].velocity = 6;
				particle[j].dx = costable[particle[j].angle] * particle[j].velocity;
				particle[j].dy = sintable[particle[j].angle] * particle[j].velocity;
				particle[j].data0 = 0;
				particle[j].data1 = 0;
				particle[j].color = par->color;
			}
		}
	}

	if (par->data1 == TYPE_EVIL)
	{
		int nrToCreate = 96;
		int nrAsdf = 32;
		unsigned char angle = rand() % nrAngles;
		for (int j = 0; j < maxParticles; j++)
		{
			if (nrToCreate && particle[j].type == TYPE_INACTIVE)
			{
				nrToCreate--;
				particle[j].type = par->data1;
				particle[j].x = par->x;
				particle[j].y = par->y;
				if (nrAsdf)
				{
					nrAsdf--;
					particle[j].angle = (nrAsdf * nrAngles) / 32;
					particle[j].velocity = 5.7;
				}
				else
				{
					particle[j].angle = angle;
					particle[j].velocity = (nrToCreate * (float)5.7) / 64;
					angle += 10;
				}
				particle[j].dx = costable[particle[j].angle] * particle[j].velocity;
				particle[j].dy = sintable[particle[j].angle] * particle[j].velocity;
				particle[j].data0 = 0;
				particle[j].data1 = 0;
				particle[j].color = par->color;
    		}
		}
	}

	par->type = TYPE_INACTIVE;
}


int playGameOnce() // returns 1 if you want to play again, or 0 if you want to quit
{
	clear_to_color(virscr, makecol(0, 0, 0));

	for (int i = 0; i < maxParticles; i++)
	{
		particle[i].type = TYPE_INACTIVE;
	}

	int timeToLaunch = 0;
	int timeBetweenLaunches = 30;
	int mouseButtonState = 0;

	int maxChains = 0;
	int nrChains = 0;
	int energy = 3;
	int chainColor = TYPE_GOOD;
	int chain123 = 0;
	int nrLives = 4;

	int gameRunning = 1;

	int lastTick = GetTickCount();

	while (gameRunning)
	{

		// simple timing: lock the main loop to a fixed speed
		// slower computers will get slowdowns, faster computers will Sleep() in the name of multitasking
		int thisTick = GetTickCount();
		int deltaTick = thisTick - lastTick;
		textprintf(virscr, font, 0,0, makecol(255,255,255), "frametime %d ", deltaTick);
		int sleeptime = TICKS_BETWEEN_UPDATES - deltaTick;
		if (sleeptime < 0)
			sleeptime = 0;
		Sleep(sleeptime);
		textprintf(virscr, font, 0,16, makecol(255,255,255), "sparetime %d ", sleeptime);
		lastTick = thisTick + sleeptime;


		// input
		if (key[KEY_ESC] || key[KEY_Q] || key[KEY_X])
			gameRunning = 0;

		if (mouse_b)
		{
			if (mouseButtonState < 2)
				mouseButtonState++;
			// state 1 means you just clicked
			// state 2 means you are holding the button down
			// this is very useful
		}
		else
  			mouseButtonState = 0;


		if (nrLives <= 0)
		{
			// draw game over-screen
			textprintf_centre(virscr, font, SCREENW_HALF,SCREENH_HALF-20, makecol(255,255,255), "K.O.!!");
			textprintf_centre(virscr, font, SCREENW_HALF,SCREENH_HALF-10, makecol(255,255,255), "The big chain is at %d", maxChains);
			textprintf_centre(virscr, font, SCREENW_HALF,SCREENH_HALF, makecol(255,255,255), "See you next mission");

			// frenetic button masher protection
			if (nrLives > -30) // thirty frames that you cannot click
				nrLives--;
			else
				if (mouseButtonState == 1)
					gameRunning = 0;
		}
		else
		{
			// do game stuff

			int launchNewType = TYPE_INACTIVE; // launch a rocket this frame?

			if (timeToLaunch <= 0)
			{
				timeToLaunch = (rand() % timeBetweenLaunches) + timeBetweenLaunches;
				if (rand() % 2)
					launchNewType = TYPE_GOOD;
				else
					launchNewType = TYPE_EVIL;
			}
			timeToLaunch--;


			// big particle update loop
			activeParticles = 0;
			int closestIndex = -1;
			int closestDistance = SCREENW * SCREENH;
			for (int i = 0; i < maxParticles; i++)
			{
				CParticle* par = particle + i;

				if (par->type == TYPE_INACTIVE)
				{
					if (launchNewType != TYPE_INACTIVE)
					{
						launchNewRocket(particle + i, launchNewType);
						launchNewType = TYPE_INACTIVE;
					}

					continue;
				}

				activeParticles++;


				// the only physics update common to all particle types:
				par->x += par->dx;
				par->y += par->dy;

				// now do different things for all particle types:

				if (par->type == TYPE_ROCKET)
				{
					par->dy += 0.04; // rockets have a different gravitation... how very realistic

					if (par->y > SCREENH + 1)
					{
						if (nrLives)
							nrLives--;
						textout_centre(virscr, font, "MISS!!", (int)par->x, SCREENH-9, makecol(255,0,0));
						par->type = TYPE_INACTIVE;
					}

					circle(virscr, (int)par->x, (int)par->y, 2, par->color);

					// shoot rockets: find the rocket closest to the mouse pointer using pythagorathing
					if (mouseButtonState == 1 && par->type == TYPE_ROCKET)
					{
						int dx = (int)(mouse_x - par->x);
						int dy = (int)(mouse_y - par->y);
						if (dx < 0) dx = -dx;
						if (dy < 0) dy = -dy;
						int distance = dx * dx + dy * dy;
						if (distance < closestDistance)
						{
							closestDistance = distance;
							closestIndex = i;
						}
					}
				}
				else if (par->type == TYPE_GOOD)
				{
					par->velocity *= 0.95;
					float screenvelocity = sintable[par->angle2] * par->velocity;

					par->dx = costable[par->angle] * screenvelocity;
					par->dy = sintable[par->angle] * screenvelocity + par->data0 * GRAVITATION;

					// the particles get smaller and smaller as time passes
					putpixel(virscr, (int)par->x, (int)par->y, par->color);
					if (par->data0 < 20)
					{
						putpixel(virscr, (int)par->x + 1, (int)par->y, par->color);
						if (par->data0 < 15)
						{
							putpixel(virscr, (int)par->x, (int)par->y + 1, par->color);
							if (par->data0 < 10)
								putpixel(virscr, (int)par->x + 1, (int)par->y + 1, par->color);
						}
					}

					par->data0++;
					if (par->data0 > 34)
						par->type = TYPE_INACTIVE;
					// hmm, it is probably very unoptimized to store the individual lifetime of each particle,
					// when in fact the entire explosion has the exact same lifetime. but i'm not in an optimizing mood...
				}
				else if (par->type == TYPE_EVIL)
				{
					par->velocity *= 0.95;
					float screenvelocity = par->velocity;

					par->dx = costable[par->angle] * screenvelocity;
					par->dy = sintable[par->angle] * screenvelocity + par->data0 * GRAVITATION;

					putpixel(virscr, (int)par->x, (int)par->y, par->color);
					if (par->data0 < 20)
					{
						putpixel(virscr, (int)par->x + 1, (int)par->y, par->color);
						if (par->data0 < 15)
						{
							putpixel(virscr, (int)par->x, (int)par->y + 1, par->color);
							if (par->data0 < 10)
								putpixel(virscr, (int)par->x + 1, (int)par->y + 1, par->color);
						}
					}

					par->data0++;
					if (par->data0 > 34)
						par->type = TYPE_INACTIVE;
				}

			}

			textprintf(virscr, font, 0,32, makecol(255,255,255), "particles %d ", activeParticles);


			// shoot rockets
			if (closestIndex != -1 && closestDistance <= CLICK_RADIUS)
			{
				if (chain123 != 0 && chainColor != particle[closestIndex].data1)
				{
					chain123 = 0;
					nrChains = 0;
				}
				chainColor = particle[closestIndex].data1;
				chain123++;
				explodeRocket(particle + closestIndex);
			}

		} // end if (nrLives)


		// draw chain-counter
		int color = makecol(0,127,255);
		if (chainColor == TYPE_GOOD)
			color = makecol(255,127,0);
		if (chain123 > 0)
			circlefill(virscr, 13, SCREENH - 21, 10, color);
		if (chain123 > 1)
			circlefill(virscr, 36, SCREENH - 21, 10, color);
		if (chain123 > 2)
			circlefill(virscr, 59, SCREENH - 21, 10, color);
		textprintf(virscr, font, 0,SCREENH-9, makecol(255,255,255), "chains %d / %d", nrChains, maxChains);


		if (chain123 == 3)
		{
			chain123 = 0;
			nrChains++;

			if (nrChains > maxChains)
			{
				maxChains = nrChains;
				if (timeBetweenLaunches > 8)
					timeBetweenLaunches--;
			}
		}

		// draw life energy
		if (nrLives > 0)
		{
			for (int i = 0; i < nrLives; i++)
			{
				int x = SCREENW - 17 - i * 28;
   				circlefill(virscr, x - 6, 11, 6, makecol(255,0,0));
   				circlefill(virscr, x + 6, 11, 6, makecol(255,0,0));
				triangle(virscr, x - 12, 13, x + 12, 13, x, 25, makecol(255,0,0));
			}

			textprintf_right(virscr, font, SCREENW, SCREENH-9, makecol(255,255,255), "freeware");
		}
		else
			textprintf_right(virscr, font, SCREENW, SCREENH-9, makecol(255,255,255), "el Hamil");


		// draw mouse pointer
		hline(virscr, mouse_x - 5, mouse_y, mouse_x + 5, makecol(255,255,255));
		vline(virscr, mouse_x, mouse_y - 5, mouse_y + 5, makecol(255,255,255));


		blit(virscr, screen, 0,0, 0,0, SCREENW, SCREENH);


		// blur the screen and fade to black
		if (colordepth == 32)
		{
			for (int y = 0; y < SCREENH; y++)
			{
				int r2 = 0;
				int g2 = 0;
				int b2 = 0;
				long* p = (long*)(virscr->line[y]);
				for (int x = 1; x < SCREENW; x++)
				{
					if (*p || *(p-1))
					{
						int r = getr32(*p) * 3;
						int g = getg32(*p) * 3;
						int b = getb32(*p) * 3;

						// weighted average: (this pixel * 0.75) + (the other pixel * 0.25)
						r2 = (r + r2) >> 2;
						g2 = (g + g2) >> 2;
						b2 = (b + b2) >> 2;

						*p = makecol32(r2, g2, b2);

						// actually, multiply the other pixel with 0.75 to make things darker
						r2 = r >> 2;
						g2 = g >> 2;
						b2 = b >> 2;
					}
					p++;
				}
			}
		}
		else
		{
			for (int y = 0; y < SCREENH; y++)
			{
				int r2 = 0;
				int g2 = 0;
				int b2 = 0;
				short* p = (short*)(virscr->line[y]);
				for (int x = 1; x < SCREENW; x++)
				{
					if (*p || *(p-1))
					{
						int r = getr(*p) * 3;
						int g = getg(*p) * 3;
						int b = getb(*p) * 3;

						// weighted average: (this pixel * 0.75) + (the other pixel * 0.25)
						r2 = (r + r2) >> 2;
						g2 = (g + g2) >> 2;
						b2 = (b + b2) >> 2;

						*p = makecol(r2, g2, b2);

						// actually, multiply the other pixel with 0.75 to make things darker
						r2 = r >> 2;
						g2 = g >> 2;
						b2 = b >> 2;
					}
					p++;
				}
			}
		} // end if (colordepth)


	} // end while (gameRunning)


	if (nrLives <= 0)
		return 1; // this is very silly... it shouldn't return 1 if you clicked ESC

	return 0;
}

